/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.suppplement;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.fpm.business.dataproc.openapi.model.BalanceQueryAvailableResult;
import kd.tmc.fpm.business.dataproc.openapi.model.BalanceQueryParam;
import kd.tmc.fpm.business.dataproc.openapi.model.BalanceQueryResult;
import kd.tmc.fpm.business.dataproc.query.impl.BalanceQueryServiceImpl;
import kd.tmc.fpm.business.domain.enums.BillStatus;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.controller.IFundSystemController;
import kd.tmc.fpm.business.mvc.controller.impl.IFundSystemControllerImpl;
import kd.tmc.fpm.business.service.dimension.ICustomDimSeqService;
import kd.tmc.fpm.business.service.dimension.impl.CustomDimSeqServiceImpl;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.common.helper.FpmPageCacheHelper;
import kd.tmc.fpm.common.helper.ModelHelper;
import kd.tmc.fpm.common.property.SupplementBillProp;
import kd.tmc.fpm.common.utils.DateTimeUtil;
import kd.tmc.fpm.listener.TmcBaseBeforeF7SelectListener;
import org.apache.commons.lang3.StringUtils;

public class SupplementBillPlugin
extends AbstractTmcBillEdit {
    private IFundSystemController fundSystemController;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        if (null != parentView) {
            String systemId = parentView.getPageCache().get("LIST_SELECTED_SYSTEM_CACHE_KEY");
            if (systemId == null) {
                return;
            }
            if (systemId.contains("[")) {
                String[] modelIdArr = systemId.replace("[", "").replace("]", "").split(",");
                systemId = modelIdArr[0].trim();
            }
            if (!StringUtils.isNumeric((CharSequence)systemId)) {
                return;
            }
            this.getModel().setValue("system", (Object)Long.valueOf(systemId));
            QFilter qFilter = new QFilter("bodysystem", "=", (Object)Long.valueOf(systemId)).and("dimtype", "=", (Object)DimensionType.ORG.getNumber()).and("isleaf", "=", (Object)"1").and(ModelHelper.getOrgAuthFilter((String)this.getView().getFormShowParameter().getAppId(), (String)"fpm_supplement_bill"));
            List orgIdList = QueryServiceHelper.queryPrimaryKeys((String)"fpm_member", (QFilter[])new QFilter[]{qFilter}, null, (int)-1);
            String orgId = parentView.getPageCache().get("LIST_SELECTED_ORG_CACHE_KEY");
            if (orgId != null) {
                if (orgId.contains("[")) {
                    String[] modelIdArr = systemId.replace("[", "").replace("]", "").split(",");
                    orgId = modelIdArr[0].trim();
                }
                Long orgIdFromCache = null;
                if (StringUtils.isNumeric((CharSequence)orgId)) {
                    orgIdFromCache = Long.valueOf(orgId);
                }
                if (orgIdFromCache != null && orgIdList.size() != 0 && orgIdList.contains(orgIdFromCache)) {
                    this.getModel().setValue("reportorg", (Object)orgIdFromCache);
                } else {
                    this.getModel().setValue("reportorg", orgIdList.get(0));
                }
            } else if (orgIdList.size() != 0) {
                this.getModel().setValue("reportorg", orgIdList.get(0));
            }
        }
        this.getModel().setValue("registrantiondate", (Object)DateTimeUtil.getCurrentDate());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initAllFieldsName();
        this.initFieldValues();
    }

    private void initAllFieldsName() {
        DynamicObject system = (DynamicObject)this.getModel().getValue("system");
        if (EmptyUtil.isEmpty((DynamicObject)system)) {
            return;
        }
        FundPlanSystem fundPlanSystem = this.getOrCreateSystemController().loadSystem(Long.valueOf(system.getLong("id")));
        this.presetDimensionVisible(fundPlanSystem);
        this.presetCustomDimensionVisible(fundPlanSystem);
        this.presetDetailField(fundPlanSystem);
    }

    private void initFieldValues() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status != OperationStatus.ADDNEW) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"reportorg"});
        } else {
            this.getModel().setValue("registrantiondate", (Object)DateTimeUtil.getCurrentDate());
        }
    }

    public void initialize() {
        super.initialize();
        SupplementBillProp.F7_LIST.forEach(key -> ((BasedataEdit)this.getControl((String)key)).addBeforeF7SelectListener(this.getBeforeF7SelectListener()));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.registerCustomerControl();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (op.getOperateKey()) {
            case "balancequery": {
                this.planBalanceQueryAndUpdate();
                break;
            }
            case "savewithoutmsg": {
                if (!args.getOperationResult().isSuccess()) break;
                args.getOperationResult().setShowMessage(false);
                break;
            }
            case "save": {
                if (!args.getOperationResult().isSuccess()) break;
                this.initFieldValues();
                break;
            }
        }
    }

    private void planBalanceQueryAndUpdate() {
        OperationResult operationResult;
        String status = (String)this.getModel().getValue("billstatus");
        if (BillStatus.STAGE.getNumber().equals(status) && !(operationResult = this.getView().invokeOperation("savewithoutmsg")).isSuccess()) {
            return;
        }
        DynamicObject system = (DynamicObject)this.getModel().getValue("system");
        long systemId = system.getLong("id");
        BalanceQueryServiceImpl balanceQueryService = new BalanceQueryServiceImpl();
        BalanceQueryParam balanceQueryParam = new BalanceQueryParam();
        balanceQueryParam.setBizBillNo((String)this.getModel().getValue("billno"));
        balanceQueryParam.setAccurate(Boolean.TRUE.booleanValue());
        String systemNumber = system.getString("number");
        balanceQueryParam.setBodySysNumber(systemNumber);
        String orgNumber = ((DynamicObject)this.getModel().getValue("reportorg")).getString("number");
        balanceQueryParam.setReportOrgNumber(orgNumber);
        balanceQueryParam.setBizObjectNo("fpm_supplement_bill");
        FpmOperateResult listFpmOperateResult = balanceQueryService.queryAvailableBalance(balanceQueryParam);
        if (!listFpmOperateResult.isSuccess()) {
            this.getView().showTipNotification((String)listFpmOperateResult.getMessageList().get(0));
            return;
        }
        List resultData = (List)listFpmOperateResult.getData();
        QFilter qFilter = new QFilter("dimtype", "=", (Object)"Currency");
        qFilter.and("bodysystem", "=", (Object)systemId);
        DynamicObjectCollection currencyMemberColl = QueryServiceHelper.query((String)"fpm_member", (String)"id,number", (QFilter[])new QFilter[]{qFilter});
        Map currencyDynamicObjectMap = currencyMemberColl.stream().collect(Collectors.toMap(dy -> dy.getString("number"), Function.identity(), (k1, k2) -> k1));
        Map<Long, BalanceQueryAvailableResult> availableBalanceMap = resultData.stream().collect(Collectors.toMap(BalanceQueryResult::getEntryId, balanceQueryResult -> (BalanceQueryAvailableResult)balanceQueryResult.getBalanceQueryAvailableResultList().get(0), (k1, k2) -> k1));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            Long entryId = (Long)dynamicObject.getPkValue();
            if (!availableBalanceMap.containsKey(entryId)) continue;
            BalanceQueryAvailableResult balanceQueryAvailableResult = availableBalanceMap.get(entryId);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"planbalance", (Object)balanceQueryAvailableResult.getMinAvailableAmt(), (int)i);
            DynamicObject currencyObj = (DynamicObject)currencyDynamicObjectMap.get(balanceQueryAvailableResult.getCurrencyNum());
            DynamicObject newObj = TmcDataServiceHelper.newDynamicObject((String)"fpm_member");
            newObj.set("id", currencyObj.get("id"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"plancurrency", (Object)newObj, (int)i);
        }
    }

    private BeforeF7SelectListener getBeforeF7SelectListener() {
        return new TmcBaseBeforeF7SelectListener(){

            @Override
            protected TmcBaseBeforeF7SelectListener.QFilterResult getCustomQFilter(BeforeF7SelectEvent beforeF7SelectEvent) {
                BasedataEdit basedataEdit = (BasedataEdit)beforeF7SelectEvent.getSource();
                String key = basedataEdit.getKey();
                if (!SupplementBillPlugin.this.checkBeforeBuildF7Filter()) {
                    beforeF7SelectEvent.setCancel(true);
                    return null;
                }
                DynamicObject system = (DynamicObject)SupplementBillPlugin.this.getModel().getValue("system");
                switch (key) {
                    case "reportorg": {
                        return 1.qFilterResultBuilder().qFilter(new QFilter("bodysystem", "=", system.getPkValue()).and("dimtype", "=", (Object)DimensionType.ORG.getNumber()).and(ModelHelper.getOrgAuthFilter((String)SupplementBillPlugin.this.getView().getFormShowParameter().getAppId(), (String)"fpm_supplement_bill"))).build();
                    }
                    case "subject": {
                        return 1.qFilterResultBuilder().qFilter(new QFilter("bodysystem", "=", system.getPkValue()).and("dimtype", "=", (Object)DimensionType.SUBJECTS.getNumber())).build();
                    }
                    case "company": {
                        return 1.qFilterResultBuilder().qFilter(new QFilter("bodysystem", "=", system.getPkValue()).and("dimtype", "=", (Object)DimensionType.COMPANY.getNumber())).build();
                    }
                    case "settlement": {
                        return 1.qFilterResultBuilder().qFilter(new QFilter("bodysystem", "=", system.getPkValue()).and("dimtype", "=", (Object)DimensionType.SETTLEMENT_TYPE.getNumber())).build();
                    }
                }
                return 1.qFilterResultBuilder().build();
            }
        };
    }

    private void registerCustomerControl() {
        Map customControlDimensionMap = (Map)FpmPageCacheHelper.getCacheData((IFormView)this.getView(), (String)"CACHE_CUSTOMER_CONTROL_DIMENSION_MAP", Map.class);
        if (customControlDimensionMap == null) {
            return;
        }
        DynamicObject bodySystem = (DynamicObject)this.getModel().getValue("system");
        for (Map.Entry entry : customControlDimensionMap.entrySet()) {
            String controlName = (String)entry.getKey();
            Dimension dimension = (Dimension)entry.getValue();
            BasedataEdit baseDataEdit = (BasedataEdit)this.getControl(controlName);
            baseDataEdit.addBeforeF7SelectListener(item -> {
                ListShowParameter showParameter = (ListShowParameter)item.getFormShowParameter();
                QFilter qFilter = new QFilter("dimension", "=", (Object)dimension.getId()).and("bodysystem", "=", bodySystem.getPkValue()).and("enable", "=", (Object)"1");
                showParameter.getListFilterParameter().setFilter(qFilter);
            });
        }
    }

    private boolean checkBeforeBuildF7Filter() {
        DynamicObject system = (DynamicObject)this.getModel().getValue("system");
        if (EmptyUtil.isEmpty((DynamicObject)system)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u8ba1\u5212\u4f53\u7cfb\u3002", (String)"SupplementBillPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void presetDimensionVisible(FundPlanSystem fundPlanSystem) {
        List dimList = fundPlanSystem.getDimList();
        Optional<Dimension> companyDimOptional = dimList.stream().filter(dimension -> dimension.getDimType().isCompany()).findAny();
        Optional<Dimension> settlementDimOptional = dimList.stream().filter(dimension -> dimension.getDimType().isSettlementType()).findAny();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.getView().setVisible(Boolean.valueOf(companyDimOptional.isPresent()), new String[]{"company"});
        entryGrid.getView().setVisible(Boolean.valueOf(settlementDimOptional.isPresent()), new String[]{"settlement"});
    }

    private void presetCustomDimensionVisible(FundPlanSystem fundPlanSystem) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.getView().setVisible(Boolean.FALSE, new String[]{"custom1", "custom2", "custom3"});
        List customDimensionList = fundPlanSystem.getDimList().stream().filter(dimension -> dimension.getDimType().isCustomDim()).collect(Collectors.toList());
        if (customDimensionList.size() == 0) {
            return;
        }
        HashMap<String, Dimension> customControlDimensionMap = new HashMap<String, Dimension>(3);
        ICustomDimSeqService iCustomDimSeqService = (ICustomDimSeqService)FpmServiceFactory.getBizService(ICustomDimSeqService.class);
        Map customDimSeqMap = iCustomDimSeqService.loadCustomDimSeqMap(fundPlanSystem.getId());
        for (Dimension dimension2 : customDimensionList) {
            Integer storeSeq = (Integer)customDimSeqMap.get(dimension2.getId());
            String prop = (String)CustomDimSeqServiceImpl.SUPPLEMENT_BILL_CUSTOM_PROP_MAP.get(storeSeq);
            customControlDimensionMap.put(prop, dimension2);
            entryGrid.getView().setVisible(Boolean.TRUE, new String[]{prop});
            BasedataEdit basedataEdit = (BasedataEdit)entryGrid.getView().getControl(prop);
            basedataEdit.setCaption(new LocaleString(dimension2.getName()));
            basedataEdit.setDisplayName(new LocaleString(dimension2.getName()));
        }
        FpmPageCacheHelper.setCacheData((IFormView)this.getView(), (String)"CACHE_CUSTOMER_CONTROL_DIMENSION_MAP", customControlDimensionMap);
    }

    private void presetDetailField(FundPlanSystem fundPlanSystem) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        Map dimensionMap = fundPlanSystem.getDetailDimList().stream().collect(Collectors.toMap(Dimension::getNumber, Function.identity()));
        for (Map.Entry entry : SupplementBillProp.ENTRY_DETAIL_DIMENSION_NUMBER_MAP.entrySet()) {
            String prop = (String)entry.getKey();
            String dimensionNumber = (String)entry.getValue();
            if (!dimensionMap.containsKey(dimensionNumber)) continue;
            Dimension dimension = (Dimension)dimensionMap.get(dimensionNumber);
            FieldEdit fieldEdit = (FieldEdit)entryGrid.getView().getControl(prop);
            fieldEdit.setCaption(new LocaleString(dimension.getName()));
            fieldEdit.setDisplayName(new LocaleString(dimension.getName()));
        }
    }

    private IFundSystemController getOrCreateSystemController() {
        if (null == this.fundSystemController) {
            this.fundSystemController = new IFundSystemControllerImpl();
        }
        return this.fundSystemController;
    }
}

