/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.template;

import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fpm.business.domain.enums.DetailDataType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateLayout;
import kd.tmc.fpm.common.enums.DetailDimTypeEnum;
import kd.tmc.fpm.common.enums.DetailTemplateColDimTypeEnum;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.TemplateDimBDTypeEnum;
import kd.tmc.fpm.common.enums.TemplateUsesEnum;
import kd.tmc.fpm.common.enums.TreeDataSelectedType;
import kd.tmc.fpm.common.result.TreeDataSelectedReturnData;
import kd.tmc.fpm.formplugin.helper.DimMemberHelper;
import kd.tmc.fpm.formplugin.template.TemplateManageBasePlugin;

public class DetailTemplateManagePlugin
extends TemplateManageBasePlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"colmembertext"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("colmembertext".equals(key)) {
            Object modelId = ((DynamicObject)this.getModel().getValue("model")).getPkValue();
            DynamicObject dimObj = (DynamicObject)this.getModel().getValue("dimbd");
            DynamicObjectCollection memberColl = (DynamicObjectCollection)this.getModel().getValue("colmember");
            List<Object> selectedIdList = memberColl.stream().map(i -> i.get("fbasedataid.id")).collect(Collectors.toList());
            DimsionEnums dimEnum = DimsionEnums.getDimsionByNumber((String)dimObj.getString("basedata"));
            DimMemberHelper.buildMemberTreeCustomF7(dimEnum, Long.valueOf(modelId.toString()), (AbstractFormPlugin)this, "colmembertext", selectedIdList, null, TreeDataSelectedType.NOTREESTRU, (Long)dimObj.getPkValue());
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("colmembertext".equals(actionId)) {
            TreeDataSelectedReturnData returnData = (TreeDataSelectedReturnData)closedCallBackEvent.getReturnData();
            this.fillMemberInfo(returnData);
        }
        this.afterClosedCallBack(closedCallBackEvent);
    }

    public void updateRowDim(List<TemplateLayout.LayoutInfo> layoutInfoList, List<TemplateDim> dimList) {
    }

    public void updateColDim(List<TemplateLayout.LayoutInfo> layoutInfoList, List<TemplateDim> dimList) {
        this.getModel().deleteEntryData("colentry");
        List sortedDimList = dimList.stream().sorted(Comparator.comparingInt(TemplateDim::getSequence)).collect(Collectors.toList());
        DynamicObject bodySys = (DynamicObject)this.getModel().getValue("model");
        QFilter filter = new QFilter("bodysys", "=", bodySys.getPkValue()).and("detaildimtype", "=", (Object)DetailDimTypeEnum.PLAN_AMOUNT.getValue());
        DynamicObject dynamicObject = TmcDataServiceHelper.loadSingle((String)"fpm_detailplanfields", (String)"id", (QFilter[])new QFilter[]{filter});
        for (TemplateDim templateDim : sortedDimList) {
            if (!templateDim.isDetailDim() && !templateDim.isVisible()) continue;
            int newEntryRow = this.getModel().createNewEntryRow("colentry");
            this.getModel().setValue("colselect", (Object)true, newEntryRow);
            if (templateDim.isDetailDim()) {
                this.getModel().setValue("colselect", (Object)templateDim.isVisible(), newEntryRow);
                this.getModel().setValue("dimbdtype", (Object)TemplateDimBDTypeEnum.DETAILPLAN.getValue(), newEntryRow);
            } else {
                this.getModel().setValue("dimbdtype", (Object)TemplateDimBDTypeEnum.DIM.getValue(), newEntryRow);
            }
            this.getModel().setValue("dimbd", (Object)templateDim.getDimensionId(), newEntryRow);
            this.getModel().setValue("dimid", (Object)templateDim.getDimensionId(), newEntryRow);
            this.getModel().setValue("expand", (Object)templateDim.isExpand(), newEntryRow);
            this.getModel().setValue("coldimtype", (Object)(templateDim.isDetailDim() ? DetailTemplateColDimTypeEnum.DETAIL.getValue() : DetailTemplateColDimTypeEnum.MAIN.getValue()), newEntryRow);
            if (templateDim.isExpand()) {
                List expandMembers = templateDim.getMemberScope();
                if (expandMembers != null && expandMembers.size() > 0) {
                    this.getModel().setValue("expandmemberids", (Object)expandMembers.toArray(), newEntryRow);
                    DynamicObjectCollection memberColl = (DynamicObjectCollection)this.getModel().getValue("expandmemberids", newEntryRow);
                    List selectedNameList = memberColl.stream().map(i -> i.getString("fbasedataid.name")).collect(Collectors.toList());
                    this.getModel().setValue("expandmembertext", (Object)String.join((CharSequence)",", selectedNameList), newEntryRow);
                } else {
                    this.getModel().setValue("expandmembertext", (Object)ResManager.loadKDString((String)"\u7f16\u62a5\u65f6\u786e\u8ba4", (String)"DimLayoutPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), newEntryRow);
                    this.getModel().setValue("colmembertext", (Object)"", newEntryRow);
                }
            } else {
                this.getModel().setValue("expandmembertext", (Object)"", newEntryRow);
                List memberScope = templateDim.getMemberScope();
                if (memberScope != null) {
                    this.getModel().setValue("colmember", (Object)memberScope.toArray(), newEntryRow);
                    DynamicObjectCollection value = (DynamicObjectCollection)this.getModel().getValue("colmember", newEntryRow);
                    List collect = value.stream().map(e -> e.getString("fbasedataid.name")).collect(Collectors.toList());
                    this.getModel().setValue("colmembertext", (Object)String.join((CharSequence)",", collect), newEntryRow);
                }
            }
            DynamicObject dimObj = (DynamicObject)this.getModel().getValue("dimbd", newEntryRow);
            if (!templateDim.isDetailDim()) {
                if (DimsionEnums.PERIOD.getNumber().equals(dimObj.get("basedata"))) {
                    if (!templateDim.isExpand()) {
                        this.getModel().setValue("colmembertext", (Object)ResManager.loadKDString((String)"\u7f16\u62a5\u65f6\u786e\u8ba4", (String)"DimLayoutPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), newEntryRow);
                    }
                    this.getView().setEnable(Boolean.valueOf(false), newEntryRow, new String[]{"colmembertext"});
                }
            } else if (Objects.equals(dynamicObject.getPkValue(), dimObj.getPkValue())) {
                Optional<TemplateDim> first = sortedDimList.stream().filter(TemplateDim::isExpand).findFirst();
                if (first.isPresent()) {
                    this.getModel().setValue("colselect", (Object)false, newEntryRow);
                } else {
                    this.getModel().setValue("colselect", (Object)true, newEntryRow);
                }
                this.getView().setEnable(Boolean.valueOf(false), newEntryRow, new String[]{"colselect"});
            }
            this.getView().setEnable(Boolean.valueOf(Objects.equals(templateDim.getDimType(), DimensionType.SUBJECTS)), newEntryRow, new String[]{"subjectflowtotal"});
            this.getModel().setValue("subjectflowtotal", (Object)templateDim.isSubjectFlowTotal(), newEntryRow);
            this.getView().setEnable(Boolean.valueOf(templateDim.getDetailDataType() == DetailDataType.AMOUNT), newEntryRow, new String[]{"totalrow"});
            this.getModel().setValue("totalrow", (Object)templateDim.isTotalRow(), newEntryRow);
        }
        this.getView().updateView("colentry");
    }

    private void fillMemberInfo(TreeDataSelectedReturnData returnData) {
        if (returnData != null) {
            List selectedPkList = returnData.getRightTreeIdSet().stream().map(e -> Long.valueOf(e)).collect(Collectors.toList());
            this.getModel().setValue("colmember", (Object)selectedPkList.toArray());
            DynamicObjectCollection memberColl = (DynamicObjectCollection)this.getModel().getValue("colmember");
            List selectedNameList = memberColl.stream().map(i -> i.getString("fbasedataid.name")).collect(Collectors.toList());
            this.getModel().setValue("colmembertext", (Object)String.join((CharSequence)",", selectedNameList));
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if ("colmembertext".equals(name) && changeSet[0].getNewValue() != null && "".equals(changeSet[0].getNewValue())) {
            this.getModel().setValue("colmember", null);
        } else if ("colselect".equals(name)) {
            DynamicObject colentry = changeSet[0].getDataEntity();
            if (colentry.getDynamicObject("dimbd") != null && colentry.getString("dimbdtype") != null) {
                DynamicObject dimbd = TmcDataServiceHelper.loadSingle((Object)colentry.getDynamicObject("dimbd").getPkValue(), (String)colentry.getString("dimbdtype"));
                if (DetailDimTypeEnum.CONNTERPARTY_TYPE.getValue().equals(dimbd.getString("detaildimtype"))) {
                    Optional<Integer> selectedNameList = this.getModel().getEntryEntity("colentry").stream().filter(v -> DetailDimTypeEnum.COUNTERPARTY_NAME.getName().equals(v.getString("dimbd.name"))).map(v -> v.getInt("seq")).findFirst();
                    selectedNameList.ifPresent(integer -> this.getModel().setValue("colselect", changeSet[0].getNewValue(), integer - 1));
                } else if (DetailDimTypeEnum.COUNTERPARTY_NAME.getValue().equals(dimbd.getString("detaildimtype"))) {
                    Optional<Integer> selectedNameList = this.getModel().getEntryEntity("colentry").stream().filter(v -> DetailDimTypeEnum.CONNTERPARTY_TYPE.getName().equals(v.getString("dimbd.name"))).map(v -> v.getInt("seq")).findFirst();
                    selectedNameList.ifPresent(integer -> this.getModel().setValue("colselect", changeSet[0].getNewValue(), integer - 1));
                }
            }
        } else if ("totalrow".equals(name)) {
            this.handleSubjectFlowTotal();
        }
    }

    private void handleSubjectFlowTotal() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("colentry");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        boolean enableTotal = entryEntity.stream().anyMatch(item -> item.getBoolean("totalrow"));
        if (!enableTotal) {
            for (int i = 0; i < this.getModel().getEntryRowCount("colentry"); ++i) {
                this.getModel().setValue("subjectflowtotal", (Object)false, i);
            }
            return;
        }
        DynamicObjectCollection collection = (DynamicObjectCollection)this.getModel().getValue("colentry");
        List subjectMemberObjs = collection.stream().filter(item -> Objects.nonNull(item.getDynamicObject("dimbd"))).filter(item -> "fpm_dimension".equals(item.getDynamicObject("dimbd").getDataEntityType().getName())).filter(item -> DimsionEnums.SUBJECT.getNumber().equals(item.getDynamicObject("dimbd").getString("basedata"))).map(item -> item.getDynamicObjectCollection("colmember")).flatMap(Collection::stream).collect(Collectors.toList());
        long subjectFlowCount = subjectMemberObjs.stream().map(item -> item.get("fbasedataid.flow")).distinct().count();
        long currencyCount = collection.stream().filter(item -> Objects.nonNull(item.getDynamicObject("dimbd"))).filter(item -> "fpm_dimension".equals(item.getDynamicObject("dimbd").getDataEntityType().getName())).filter(item -> DimsionEnums.CURRENCY.getNumber().equals(item.getDynamicObject("dimbd").getString("basedata"))).map(item -> item.getDynamicObjectCollection("colmember")).flatMap(Collection::stream).count();
        if (currencyCount * subjectFlowCount > 20L) {
            for (int i = 0; i < this.getModel().getEntryRowCount("colentry"); ++i) {
                this.getModel().setValue("subjectflowtotal", (Object)false, i);
            }
            return;
        }
        for (int i = 0; i < this.getModel().getEntryRowCount("colentry"); ++i) {
            DynamicObject rowDim = this.getModel().getEntryRowEntity("colentry", i);
            if (!Objects.equals(rowDim.getString("dimbdtype"), TemplateDimBDTypeEnum.DIM.getValue())) {
                this.getModel().setValue("subjectflowtotal", (Object)false, i);
                continue;
            }
            if (!Objects.equals(rowDim.getDynamicObject("dimbd").getString("number"), DimsionEnums.SUBJECT.getNumber())) {
                this.getModel().setValue("subjectflowtotal", (Object)false, i);
                continue;
            }
            boolean subjectExpend = rowDim.getBoolean("expand");
            if (subjectExpend) {
                this.getModel().setValue("subjectflowtotal", (Object)false, i);
                break;
            }
            this.getModel().setValue("subjectflowtotal", (Object)true, i);
            break;
        }
    }

    public void updateAccountSetting(ReportTemplate template) {
    }

    protected void afterClosedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        switch (closedCallBackEvent.getActionId()) {
            case "dimlayoutop": {
                this.setEnableForOrg();
                break;
            }
        }
    }

    @Override
    protected void afterInitTemplate() {
        super.afterInitTemplate();
        this.setEnableForOrg();
    }

    private void setEnableForOrg() {
        String templateUse = (String)this.getModel().getValue("templateuses");
        if (!Objects.equals(templateUse, TemplateUsesEnum.SUMMARY.getValue())) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("colentry");
        Optional<DynamicObject> first = entryEntity.stream().filter(dy -> Objects.equals(dy.getString("dimbdtype"), TemplateDimBDTypeEnum.DIM.getValue())).filter(dy -> Objects.equals(dy.getDynamicObject("dimbd").getString("number"), DimsionEnums.ORG.getNumber())).findFirst();
        if (!first.isPresent()) {
            return;
        }
        DynamicObject dynamicObject = first.get();
        String description = ResManager.loadKDString((String)"\u7f16\u62a5\u65f6\u786e\u8ba4", (String)"DetailTemplateManagePlugin_01", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        int index = dynamicObject.getInt("seq") - 1;
        this.getModel().setValue("colmembertext", (Object)description, index);
        this.getView().setEnable(Boolean.FALSE, index, new String[]{"colmembertext"});
        this.getView().updateView("colentry");
    }
}

