/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.template;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimLocation;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.TemplateType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateLayout;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.helper.DimLayoutHelper;
import kd.tmc.fpm.business.mvc.converter.MemberConverterFactory;
import kd.tmc.fpm.business.mvc.converter.TemplateVOConverter;
import kd.tmc.fpm.business.mvc.converter.member.IMemberConverter;
import kd.tmc.fpm.common.enums.AuxiliaryFieldTypeEnum;
import kd.tmc.fpm.common.enums.AuxiliaryFieldUseTypeEnum;
import kd.tmc.fpm.common.enums.DimensionMemberScopeEnum;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.RowColType;
import kd.tmc.fpm.common.enums.TemplateUsesEnum;
import kd.tmc.fpm.common.enums.TreeDataSelectedCascadeType;
import kd.tmc.fpm.common.enums.TreeDataSelectedType;
import kd.tmc.fpm.common.enums.WaysEnum;
import kd.tmc.fpm.common.result.TreeDataSelectedReturnData;
import kd.tmc.fpm.formplugin.helper.SumPlanHelper;
import kd.tmc.fpm.formplugin.template.TemplateManageBasePlugin;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class FixTemplateManagePlugin
extends TemplateManageBasePlugin {
    private static final String DIMMEMBER = "lv%s%sdimmember";
    private static final String DIMCONTAINER = "lv%s%sdimcontainer";
    private static final String SUBTOTAL = "lv%s%ssubtotal";

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"lv1coldimmembertext", "lv2coldimmembertext", "lv3coldimmembertext", "lv1rowdimmembertext", "lv2rowdimmembertext"});
        this.initF7();
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "setsubjectprop": {
                this.showSubjectSettingInfoPage();
                break;
            }
            case "newentry": 
            case "deleteentry": {
                final DynamicObject dataEntity = this.getModel().getDataEntity(true);
                List<String> names = new ArrayList<String>(){
                    {
                        this.add(DimLayoutHelper.getDimessionMemberType((DimLocation)DimLocation.ROW, (int)1, (DynamicObject)dataEntity));
                        this.add(DimLayoutHelper.getDimessionMemberType((DimLocation)DimLocation.ROW, (int)2, (DynamicObject)dataEntity));
                    }
                };
                names = names.stream().filter(EmptyUtil::isNoEmpty).collect(Collectors.toList());
                if (!names.contains(DimsionEnums.PERIOD.getNumber())) break;
                this.disableOfPeriod();
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("lv1rowdimmembertext".equals(name) || "lv2rowdimmembertext".equals(name) || "lv1coldimmembertext".equals(name) || "lv2coldimmembertext".equals(name) || "lv3coldimmembertext".equals(name)) {
            DimLocation dim = null;
            int level = 1;
            String actualPropKey = "";
            switch (name) {
                case "lv1rowdimmembertext": {
                    dim = DimLocation.ROW;
                    actualPropKey = "lv1rowdimmember";
                    break;
                }
                case "lv2rowdimmembertext": {
                    dim = DimLocation.ROW;
                    level = 2;
                    actualPropKey = "lv2rowdimmember";
                    break;
                }
                case "lv1coldimmembertext": {
                    dim = DimLocation.COL;
                    actualPropKey = "lv1coldimmember";
                    break;
                }
                case "lv2coldimmembertext": {
                    dim = DimLocation.COL;
                    level = 2;
                    actualPropKey = "lv2coldimmember";
                    break;
                }
                case "lv3coldimmembertext": {
                    dim = DimLocation.COL;
                    level = 3;
                    actualPropKey = "lv3coldimmember";
                    break;
                }
            }
            this.initSubjectSetting(dim, level);
            ChangeData[] changeSet = e.getChangeSet();
            Object newValue = changeSet[0].getNewValue();
            if (StringUtils.isNotEmpty((CharSequence)actualPropKey) && (newValue == null || StringUtils.isEmpty((CharSequence)newValue.toString()))) {
                this.getModel().setValue(actualPropKey, null);
            }
        }
        if ("isshowcombine".equals(name)) {
            ChangeData[] changeSet = e.getChangeSet();
            Boolean showCombine = (Boolean)changeSet[0].getNewValue();
            this.updateCombine(showCombine);
        }
        this.afterPropertyChanged(e);
    }

    private void updateCombine(Boolean showCombine) {
        boolean existLevelDim = DimLayoutHelper.isIncludeDimOfLvNum((DynamicObject)this.getModel().getDataEntity(true), (DimLocation)DimLocation.COL, (Integer)2);
        if (showCombine.booleanValue() && existLevelDim) {
            EntryGrid grid = (EntryGrid)this.getControl("colentryentity");
            for (Control ctrl : grid.getControls()) {
                if (!ctrl.getKey().equals("isdistinguish")) continue;
                ctrl.getView().setVisible(Boolean.valueOf(true), new String[]{"isdistinguish"});
                break;
            }
        } else {
            EntryGrid grid = (EntryGrid)this.getControl("colentryentity");
            for (Control ctrl : grid.getControls()) {
                if (!ctrl.getKey().equals("isdistinguish")) continue;
                ctrl.getView().setVisible(Boolean.valueOf(false), new String[]{"isdistinguish"});
                break;
            }
        }
        this.disableOfPeriod();
        this.getView().updateView("colentryentity");
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("lv1coldimmembertext".equals(key) || "lv2coldimmembertext".equals(key) || "lv3coldimmembertext".equals(key) || "lv1rowdimmembertext".equals(key) || "lv2rowdimmembertext".equals(key)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            Object modelId = ((DynamicObject)this.getModel().getValue("model")).getPkValue();
            String dimType = "";
            String dimMemberPropName = "";
            Long dimensionId = 0L;
            switch (key) {
                case "lv1coldimmembertext": {
                    dimType = DimLayoutHelper.getDimessionMemberType((DimLocation)DimLocation.COL, (int)1, (DynamicObject)dataEntity);
                    dimMemberPropName = "lv1coldimmember";
                    dimensionId = DimLayoutHelper.getDimessionId((DimLocation)DimLocation.COL, (int)1, (DynamicObject)dataEntity);
                    break;
                }
                case "lv2coldimmembertext": {
                    dimType = DimLayoutHelper.getDimessionMemberType((DimLocation)DimLocation.COL, (int)2, (DynamicObject)dataEntity);
                    dimMemberPropName = "lv2coldimmember";
                    dimensionId = DimLayoutHelper.getDimessionId((DimLocation)DimLocation.COL, (int)2, (DynamicObject)dataEntity);
                    break;
                }
                case "lv3coldimmembertext": {
                    dimType = DimLayoutHelper.getDimessionMemberType((DimLocation)DimLocation.COL, (int)3, (DynamicObject)dataEntity);
                    dimMemberPropName = "lv3coldimmember";
                    dimensionId = DimLayoutHelper.getDimessionId((DimLocation)DimLocation.COL, (int)3, (DynamicObject)dataEntity);
                    break;
                }
                case "lv1rowdimmembertext": {
                    dimType = DimLayoutHelper.getDimessionMemberType((DimLocation)DimLocation.ROW, (int)1, (DynamicObject)dataEntity);
                    dimMemberPropName = "lv1rowdimmember";
                    dimensionId = DimLayoutHelper.getDimessionId((DimLocation)DimLocation.ROW, (int)1, (DynamicObject)dataEntity);
                    break;
                }
                case "lv2rowdimmembertext": {
                    dimType = DimLayoutHelper.getDimessionMemberType((DimLocation)DimLocation.ROW, (int)2, (DynamicObject)dataEntity);
                    dimMemberPropName = "lv2rowdimmember";
                    dimensionId = DimLayoutHelper.getDimessionId((DimLocation)DimLocation.ROW, (int)2, (DynamicObject)dataEntity);
                }
            }
            DynamicObjectCollection memberColl = (DynamicObjectCollection)this.getModel().getValue(dimMemberPropName);
            List<Object> selectedIdList = memberColl.stream().map(i -> i.get("fbasedataid.id")).collect(Collectors.toList());
            DimsionEnums dimEnum = DimsionEnums.getDimsionByNumber((String)dimType);
            TreeDataSelectedCascadeType treeDataSelectedCascadeType = null;
            TreeDataSelectedType treeDataSelectedType = TreeDataSelectedType.NOTREESTRU;
            if (DimsionEnums.SUBJECT == dimEnum) {
                treeDataSelectedCascadeType = TreeDataSelectedCascadeType.HALFCASCADE_TOPARENT;
                treeDataSelectedType = TreeDataSelectedType.DEFAULT;
            }
            this.showMemberTreeCustomF7(dimEnum, key, selectedIdList, treeDataSelectedCascadeType, treeDataSelectedType, dimensionId);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("lv1coldimmembertext".equals(actionId) || "lv2coldimmembertext".equals(actionId) || "lv3coldimmembertext".equals(actionId) || "lv1rowdimmembertext".equals(actionId) || "lv2rowdimmembertext".equals(actionId)) {
            TreeDataSelectedReturnData returnData = (TreeDataSelectedReturnData)closedCallBackEvent.getReturnData();
            this.fillMemberInfo(returnData, actionId);
        } else if ("accountsetting_closecallback".equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            String accountSettingStr = (String)closedCallBackEvent.getReturnData();
            List accountSettings = (List)JSON.parseObject((String)accountSettingStr, (TypeReference)new TypeReference<List<TemplateAccountSetting>>(){}, (Feature[])new Feature[0]);
            ReportTemplate reportTemplate = new ReportTemplate();
            reportTemplate.setAccountSettings(accountSettings);
            this.getOrCreateController().updateAccountSetting(reportTemplate);
        }
        this.afterClosedCallBack(closedCallBackEvent);
    }

    public void updateRowDim(List<TemplateLayout.LayoutInfo> layoutInfoList, List<TemplateDim> dimList) {
        if (null == dimList) {
            return;
        }
        String entityName = "rowentryentity";
        this.getModel().deleteEntryData(entityName);
        this.getModel().batchCreateNewEntryRow(entityName, 1);
        List dims = dimList.stream().sorted(Comparator.comparingInt(TemplateDim::getLevel)).collect(Collectors.toList());
        for (int index = 0; index < dims.size(); ++index) {
            TemplateDim dimession = (TemplateDim)dims.get(index);
            int level = dimession.getLevel();
            String dimMemberAttr = String.format(DIMMEMBER, level, DimLocation.ROW.getNumber().toLowerCase());
            this.getModel().setValue(dimMemberAttr, (Object)dimession.getMemberScope().toArray(new Object[0]), 0);
            DynamicObjectCollection memberColl = (DynamicObjectCollection)this.getModel().getValue(dimMemberAttr);
            List selectedNameList = memberColl.stream().map(i -> i.getString("fbasedataid.name")).collect(Collectors.toList());
            String dimMemberTextAttr = String.join((CharSequence)"", String.format(DIMMEMBER, level, DimLocation.ROW.getNumber().toLowerCase()), "text");
            this.getModel().setValue(dimMemberTextAttr, (Object)String.join((CharSequence)",", selectedNameList), 0);
            if (1 >= level) continue;
            String subTotalAttr = String.format(SUBTOTAL, level, DimLocation.ROW.getNumber().toLowerCase());
            this.getModel().setValue(subTotalAttr, (Object)dimession.isIncludeSum(), 0);
        }
        Optional<TemplateLayout.LayoutInfo> first = layoutInfoList.stream().filter(item -> item.getLevel() == 2).findFirst();
        if (first.isPresent()) {
            TemplateLayout.LayoutInfo layoutInfo = first.get();
            DynamicObjectCollection layOutEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("layoutentry");
            Optional<DynamicObject> first1 = layOutEntry.stream().filter(item -> layoutInfo.getDimensionId().equals(item.getLong("layoutdim.id"))).findFirst();
            if (first1.isPresent()) {
                String subTotalAttr;
                DynamicObject level2Obj = first1.get();
                if (level2Obj.getString("layoutdim.basedata").equals(DimsionEnums.SUBJECT.getNumber())) {
                    subTotalAttr = String.format(SUBTOTAL, 2, DimLocation.ROW.getNumber().toLowerCase());
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{subTotalAttr});
                } else {
                    subTotalAttr = String.format(SUBTOTAL, 2, DimLocation.ROW.getNumber().toLowerCase());
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{subTotalAttr});
                }
            }
        }
        this.getView().updateView(entityName);
    }

    public void updateColDim(List<TemplateLayout.LayoutInfo> layoutInfoList, List<TemplateDim> dimList) {
        if (null == dimList) {
            return;
        }
        if (0 == dimList.size()) {
            this.getModel().setValue("lv1coldimmember", null, 0);
            this.getModel().setValue("lv2coldimmember", null, 0);
            this.getModel().setValue("lv1coldimmembertext", null, 0);
            this.getModel().setValue("lv2coldimmembertext", null, 0);
            this.getModel().setValue("lv2colsubtotal", (Object)false, 0);
            this.getModel().setValue("lv3coldimmembertext", null, 0);
            this.getModel().setValue("lv3colsubtotal", (Object)false, 0);
            this.getModel().setValue("notename", null, 0);
            this.getModel().setValue("isdistinguish", (Object)false, 0);
            this.getModel().setValue("isshowcombine", (Object)false, 0);
            this.getModel().setValue("isshownote", (Object)false, 0);
            return;
        }
        List templateDims = dimList.stream().filter(EmptyUtil::isNoEmpty).sorted(Comparator.comparingInt(TemplateDim::getLevel)).collect(Collectors.toList());
        for (TemplateDim templateDim : templateDims) {
            int level = templateDim.getLevel();
            String dimMemberAttr = String.format(DIMMEMBER, level, DimLocation.COL.getNumber().toLowerCase());
            this.getModel().setValue(dimMemberAttr, (Object)templateDim.getMemberScope().toArray(new Object[0]), 0);
            DynamicObjectCollection memberColl = (DynamicObjectCollection)this.getModel().getValue(dimMemberAttr);
            List selectedNameList = memberColl.stream().map(i -> i.getString("fbasedataid.name")).collect(Collectors.toList());
            String dimMemberTextAttr = String.join((CharSequence)"", String.format(DIMMEMBER, level, DimLocation.COL.getNumber().toLowerCase()), "text");
            this.getModel().setValue(dimMemberTextAttr, (Object)String.join((CharSequence)",", selectedNameList), 0);
            if (1 >= level) continue;
            String subTotalAttr = String.format(SUBTOTAL, level, DimLocation.COL.getNumber().toLowerCase());
            this.getModel().setValue(subTotalAttr, (Object)templateDim.isIncludeSum(), 0);
        }
    }

    @Override
    public void updateDimLayout(List<TemplateLayout.LayoutInfo> layoutInfoList, ReportTemplate template) {
        EntryGrid grid;
        super.updateDimLayout(layoutInfoList, template);
        if (null == layoutInfoList || null == template) {
            return;
        }
        this.initRowOrColDimLayout(template.getDimLayout().getRowLayout(), DimLocation.ROW);
        this.initRowOrColDimLayout(template.getDimLayout().getColLayout(), DimLocation.COL);
        this.getModel().setValue("isshowcombine", (Object)template.isShowcombine(), 0);
        this.getModel().setValue("isdistinguish", (Object)template.isDistinguish(), 0);
        this.getModel().setValue("isshownote", (Object)template.isRemarkVisible(), 0);
        this.getModel().setValue("notename", (Object)template.getRemarkName(), 0);
        this.getModel().setValue("remarkfield", (Object)template.getRemarkFieldList().toArray(new Long[0]));
        this.disableOfPeriod();
        Boolean showCombine = (Boolean)this.getModel().getValue("isshowcombine");
        boolean existLevelDim = DimLayoutHelper.isIncludeDimOfLvNum((DynamicObject)this.getModel().getDataEntity(true), (DimLocation)DimLocation.COL, (Integer)2);
        if (showCombine.booleanValue() && existLevelDim) {
            grid = (EntryGrid)this.getControl("colentryentity");
            for (Control ctrl : grid.getControls()) {
                if (!ctrl.getKey().equals("isdistinguish")) continue;
                ctrl.getView().setVisible(Boolean.valueOf(true), new String[]{"isdistinguish"});
                break;
            }
        } else {
            grid = (EntryGrid)this.getControl("colentryentity");
            for (Control ctrl : grid.getControls()) {
                if (!ctrl.getKey().equals("isdistinguish")) continue;
                ctrl.getView().setVisible(Boolean.valueOf(false), new String[]{"isdistinguish"});
                break;
            }
        }
        this.getView().updateView("colentryentity");
        boolean isEnable = DimLayoutHelper.isIncludeDimOfLvNum((DynamicObject)this.getModel().getDataEntity(true), (DimLocation)DimLocation.ROW, (Integer)2);
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"newentry", "deleteentry", "moveentryup", "moveentrydown"});
        this.setSumReportOrgRequiredIfNeed();
    }

    public void updateAccountSetting(ReportTemplate template) {
        List accountSettings = template.getAccountSettings();
        this.getModel().deleteEntryData("subjectsetentry");
        if (accountSettings.size() > 0) {
            this.getModel().batchCreateNewEntryRow("subjectsetentry", accountSettings.size());
        }
        int row = 0;
        for (TemplateAccountSetting accountSetting : accountSettings) {
            this.getModel().setValue("subject", (Object)accountSetting.getAccountMemId(), row);
            this.getModel().setValue("reportways", (Object)accountSetting.getInputType().getNumber(), row);
            this.getModel().setValue("formula", (Object)accountSetting.getFormula(), row);
            this.getModel().setValue("subtemplate", (Object)accountSetting.getChildTemplateId(), row);
            this.getModel().setValue("hideinreport", (Object)accountSetting.isHideInReport(), row);
            ++row;
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setSumReportOrgRequiredIfNeed();
    }

    @Override
    public void refreshReport(ReportTemplate reportTemplate, Long reportTypeId) {
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("sumreportorg");
        Long sumOrgId = EmptyUtil.isEmpty((DynamicObject)dynamicObject) ? Long.valueOf(0L) : (Long)dynamicObject.getPkValue();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("layoutentry");
        String orgColType = entryEntity.stream().filter(dy -> Objects.equals(dy.getDynamicObject("layoutdim").getString("number"), DimsionEnums.ORG.getNumber())).map(dy -> dy.getString("dimtype")).findFirst().get();
        if (!Objects.equals(orgColType, RowColType.PAGE.getValue()) && EmptyUtil.isEmpty((Long)sumOrgId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u603b\u7f16\u62a5\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a", (String)"FixTemplateManagePlugin_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getOrCreateController().refreshReport(reportTemplate, reportTypeId, sumOrgId);
    }

    private void initRowOrColDimLayout(List<TemplateLayout.LayoutInfo> layoutInfoList, DimLocation location) {
        String entityName = DimLocation.ROW.getNumber().equals(location.getNumber()) ? "rowentryentity" : (DimLocation.COL.getNumber().equals(location.getNumber()) ? "colentryentity" : "pagedimentry");
        EntryGrid grid = this.getEntryGridAndInitVisible(location, entityName);
        layoutInfoList.stream().filter(layoutInfo -> layoutInfo.getDimLocation() == location).filter(item -> item.getLevel() >= 2).forEach(layoutInfo -> {
            String subTotalAttr = String.format(SUBTOTAL, layoutInfo.getLevel(), DimLocation.COL.getNumber().toLowerCase());
            this.getView().setVisible(Boolean.TRUE, new String[]{subTotalAttr});
        });
        layoutInfoList = layoutInfoList.stream().sorted(Comparator.comparingInt(TemplateLayout.LayoutInfo::getLevel)).collect(Collectors.toList());
        for (TemplateLayout.LayoutInfo layoutInfo2 : layoutInfoList) {
            Integer level = layoutInfo2.getLevel();
            DynamicObject member = TmcDataServiceHelper.loadSingle((String)"fpm_dimension", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)layoutInfo2.getDimensionId())});
            String attr = String.format(DIMMEMBER, level, location.getNumber().toLowerCase(Locale.ENGLISH));
            String attrText = String.join((CharSequence)"", String.format(DIMMEMBER, level, location.getNumber().toLowerCase(Locale.ENGLISH)), "text");
            FieldEdit fieldEdit = (FieldEdit)this.getControl(attr);
            fieldEdit.setCaption(new LocaleString(member.getString("name")));
            FieldEdit fieldEditText = (FieldEdit)this.getControl(attrText);
            fieldEditText.setCaption(new LocaleString(member.getString("name")));
            for (Control ctrl : grid.getControls()) {
                if (!ctrl.getKey().equals(attr) && !ctrl.getKey().equals(attrText)) continue;
                ctrl.getView().setVisible(Boolean.valueOf(true), new String[]{attr, attrText});
            }
        }
        this.getView().updateView(entityName);
    }

    private EntryGrid getEntryGridAndInitVisible(DimLocation location, String entityName) {
        EntryGrid grid = (EntryGrid)this.getControl(entityName);
        String attr1 = String.format(DIMMEMBER, 1, location.getNumber().toLowerCase(Locale.ENGLISH));
        String attrText1 = String.join((CharSequence)"", String.format(DIMMEMBER, 1, location.getNumber().toLowerCase(Locale.ENGLISH)), "text");
        String attr2 = String.format(DIMMEMBER, 2, location.getNumber().toLowerCase(Locale.ENGLISH));
        String attrText2 = String.join((CharSequence)"", String.format(DIMMEMBER, 2, location.getNumber().toLowerCase(Locale.ENGLISH)), "text");
        String attr3 = String.format(DIMMEMBER, 3, location.getNumber().toLowerCase(Locale.ENGLISH));
        String attrText3 = String.join((CharSequence)"", String.format(DIMMEMBER, 3, location.getNumber().toLowerCase(Locale.ENGLISH)), "text");
        String subtotal2 = String.format(SUBTOTAL, 2, location.getNumber().toLowerCase(Locale.ENGLISH));
        String subtotal3 = location == DimLocation.COL ? String.format(SUBTOTAL, 3, location.getNumber().toLowerCase(Locale.ENGLISH)) : "";
        for (Control ctrl : grid.getControls()) {
            if (ctrl.getKey().equals(attr1) || ctrl.getKey().equals(attrText1)) {
                ctrl.getView().setVisible(Boolean.valueOf(false), new String[]{attr1, attrText1});
            }
            if (ctrl.getKey().equals(attr2) || ctrl.getKey().equals(attrText2)) {
                ctrl.getView().setVisible(Boolean.valueOf(false), new String[]{attr2, attrText2, subtotal2});
            }
            if (!ctrl.getKey().equals(attr3) && !ctrl.getKey().equals(attrText3)) continue;
            ctrl.getView().setVisible(Boolean.valueOf(false), new String[]{attr3, attrText3, subtotal3});
        }
        return grid;
    }

    private void showSubjectSettingInfoPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fpm_accountpropsetting");
        showParameter.setAppId("fpm");
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "accountsetting_closecallback"));
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        ReportTemplate reportTemplate = TemplateVOConverter.convertManageDataToTemplate((DynamicObject)this.getModel().getDataEntity(true));
        params.put(ReportTemplate.class.getName(), JSON.toJSONString((Object)reportTemplate));
        params.put("ismaintable", this.getModel().getValue("ismaintable"));
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
    }

    private void initF7() {
        Long sysid = Optional.of(this.getModel().getValue("model")).map(o -> {
            DynamicObject sysBody = (DynamicObject)o;
            return sysBody.getLong("id");
        }).orElseGet(() -> 0L);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        BasedataEdit lv1rowmember = (BasedataEdit)this.getControl("lv1rowdimmember");
        lv1rowmember.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            String dimType = DimLayoutHelper.getDimessionMemberType((DimLocation)DimLocation.ROW, (int)1, (DynamicObject)dataEntity);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setCustomParam("dimtype", (Object)dimType);
            showParameter.setCustomParam("modelId", (Object)sysid);
            QFilter filter = new QFilter("bodysystem", "=", (Object)sysid);
            filter.and("dimtype", "=", (Object)dimType);
            showParameter.getListFilterParameter().setFilter(filter);
        });
        BasedataEdit lv2rowmember = (BasedataEdit)this.getControl("lv2rowdimmember");
        lv2rowmember.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            String dimType = DimLayoutHelper.getDimessionMemberType((DimLocation)DimLocation.ROW, (int)2, (DynamicObject)dataEntity);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setCustomParam("dimtype", (Object)dimType);
            showParameter.setCustomParam("modelId", (Object)sysid);
            QFilter filter = new QFilter("bodysystem", "=", (Object)sysid);
            filter.and("dimtype", "=", (Object)dimType);
            showParameter.getListFilterParameter().setFilter(filter);
        });
        BasedataEdit lv1colmember = (BasedataEdit)this.getControl("lv1coldimmember");
        lv1colmember.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            String dimType = DimLayoutHelper.getDimessionMemberType((DimLocation)DimLocation.COL, (int)1, (DynamicObject)dataEntity);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setCustomParam("dimtype", (Object)dimType);
            showParameter.setCustomParam("modelId", (Object)sysid);
            QFilter filter = new QFilter("bodysystem", "=", (Object)sysid);
            filter.and("dimtype", "=", (Object)dimType);
            showParameter.getListFilterParameter().setFilter(filter);
        });
        BasedataEdit lv2colmember = (BasedataEdit)this.getControl("lv2coldimmember");
        lv2colmember.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            String dimType = DimLayoutHelper.getDimessionMemberType((DimLocation)DimLocation.COL, (int)2, (DynamicObject)dataEntity);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.setCustomParam("dimtype", (Object)dimType);
            showParameter.setCustomParam("modelId", (Object)sysid);
            QFilter filter = new QFilter("bodysystem", "=", (Object)sysid);
            filter.and("dimtype", "=", (Object)dimType);
            showParameter.getListFilterParameter().setFilter(filter);
        });
        BasedataEdit remarkFieldBd = (BasedataEdit)this.getControl("remarkfield");
        remarkFieldBd.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            QFilter qFilter = new QFilter("bodysys", "=", (Object)sysid).and("enable", "=", (Object)"1").and("usetype", "=", (Object)AuxiliaryFieldUseTypeEnum.PLAN.getValue()).and("type", "!=", (Object)AuxiliaryFieldTypeEnum.ADJUST_REASON.getValue());
            formShowParameter.getListFilterParameter().setFilter(qFilter);
        });
        this.initSummaryOrg(sysid);
    }

    private void initSummaryOrg(Long sysId) {
        BasedataEdit sumReportOrg = (BasedataEdit)this.getControl("sumreportorg");
        sumReportOrg.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            FpmOperateResult<Set<Long>> optionalOrgMember = this.getOptionalOrgMember(sysId);
            if (!optionalOrgMember.isSuccess()) {
                this.getView().showTipNotification(optionalOrgMember.getMessageList().stream().collect(Collectors.joining(";")));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ListFilterParameter listFilterParameter = formShowParameter.getListFilterParameter();
            listFilterParameter.setFilter(new QFilter("id", "in", optionalOrgMember.getData()).and("bodysystem", "=", (Object)sysId));
        });
    }

    private FpmOperateResult<Set<Long>> getOptionalOrgMember(Long sysId) {
        DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)this.getModel().getValue("reporttype");
        List<Long> objectList = dynamicObjectCollection.stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).map(id -> (Long)id).collect(Collectors.toList());
        Set<Long> auditOrgIdSet = SumPlanHelper.getAllAuditOrgBySysId(sysId, objectList);
        DynamicObject dynamicObject = this.getModel().getEntryEntity("layoutentry").stream().filter(dy -> Objects.equals(dy.getDynamicObject("layoutdim").getString("number"), DimsionEnums.ORG.getNumber())).findFirst().get();
        String memberScope = dynamicObject.getString("memberscope");
        if (StringUtils.equals((CharSequence)memberScope, (CharSequence)DimensionMemberScopeEnum.FIXED_MEMBER.getValue())) {
            String dimType = dynamicObject.getString("dimtype");
            RowColType rowColType = RowColType.get((String)dimType);
            String dimMemberProp = "";
            int level = -1;
            Set<Long> fixedMemberRange = Collections.emptySet();
            switch (rowColType) {
                case PAGE: {
                    DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("pagedimentry");
                    fixedMemberRange = entryEntity.stream().filter(entry -> Objects.equals(entry.getDynamicObject("pagedim").getString("number"), DimsionEnums.ORG.getNumber())).flatMap(entry -> entry.getDynamicObjectCollection("pagedimmember").stream()).map(dy -> dy.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).map(id -> (Long)id).collect(Collectors.toSet());
                    break;
                }
                case COL: {
                    level = dynamicObject.getInt("dimlevel");
                    dimMemberProp = this.getMemberPropNameByLevel(level, DimLocation.COL);
                    DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("colentryentity");
                    if (CollectionUtils.isEmpty((Collection)entryEntity)) break;
                    fixedMemberRange = ((DynamicObject)entryEntity.get(0)).getDynamicObjectCollection(dimMemberProp).stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).map(id -> (Long)id).collect(Collectors.toSet());
                    break;
                }
                case ROW: {
                    level = dynamicObject.getInt("dimlevel");
                    dimMemberProp = level == 1 ? "lv1rowdimmember" : "lv2rowdimmember";
                    DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("rowentryentity");
                    if (CollectionUtils.isEmpty((Collection)entryEntity)) break;
                    fixedMemberRange = ((DynamicObject)entryEntity.get(0)).getDynamicObjectCollection(dimMemberProp).stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).map(id -> (Long)id).collect(Collectors.toSet());
                }
            }
            if (EmptyUtil.isEmpty(fixedMemberRange)) {
                return FpmOperateResult.error((String)ResManager.loadKDString((String)"\u3010%s\u3011\u7f16\u62a5\u4e3b\u4f53\u6210\u5458\u8303\u56f4\u4e3a\u3010\u56fa\u5b9a\u6210\u5458\u3011\uff0c\u8bf7\u9009\u62e9\u7ef4\u5ea6\u6210\u5458\u8303\u56f4", (String)"FixTemplateManagePlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[]{rowColType.getName()}));
            }
            return FpmOperateResult.success(SumPlanHelper.getCommonUpperAndIntersectAllAudit(sysId, auditOrgIdSet, fixedMemberRange));
        }
        return FpmOperateResult.success(auditOrgIdSet);
    }

    private void initSubjectSettingEntryInfo() {
        Pair pair = DimLayoutHelper.memberOfPosition((DynamicObject)this.getModel().getDataEntity(true), (String)DIMMEMBER, (DimsionEnums)DimsionEnums.SUBJECT);
        ArrayList subjectIds = new ArrayList(10);
        DynamicObjectCollection rowEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection((String)pair.getRight());
        for (DynamicObject entry : rowEntrys) {
            DynamicObjectCollection dimMembers = entry.getDynamicObjectCollection((String)pair.getLeft());
            List memberIds = dimMembers.stream().map(o -> o.getDynamicObject("fbasedataid")).map(o -> o.getLong("id")).collect(Collectors.toList());
            subjectIds.addAll(memberIds);
        }
        String prop = String.join((CharSequence)",", "id", "formulavalue", "ways", "isleaf", String.join((CharSequence)".", "parent", "id"));
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"fpm_member", (String)prop, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)subjectIds.toArray())}, (String)"sortcode");
        Map accountMemsMap = queryResult.stream().collect(Collectors.toMap(k -> k.getLong("id"), Function.identity()));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("subjectsetentry");
        Map<Object, DynamicObject> subjectOldSetMap = Collections.emptyMap();
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntity)) {
            subjectOldSetMap = entryEntity.stream().filter(dy -> Objects.nonNull(dy.getDynamicObject("subject"))).collect(Collectors.toMap(dy -> dy.getDynamicObject("subject").getPkValue(), Function.identity(), (a, b) -> a));
        }
        this.getModel().deleteEntryData("subjectsetentry");
        int size = queryResult.size();
        if (0 < size) {
            this.getModel().batchCreateNewEntryRow("subjectsetentry", size);
            int row = 0;
            Object templateUse = this.getModel().getValue("templateuses");
            boolean isSum = Objects.equals(templateUse, TemplateUsesEnum.SUMMARY.getValue());
            for (DynamicObject subjectObj : queryResult) {
                this.getModel().setValue("subject", (Object)subjectObj.getLong("id"), row);
                this.getModel().setValue("formula", (Object)subjectObj.getString("formulavalue"), row);
                String ways = subjectObj.getString("ways");
                if (Objects.equals(ways, WaysEnum.DETAILED_REPORT.getValue()) && isSum) {
                    ways = WaysEnum.MANUAL_INPUT.getValue();
                }
                this.getModel().setValue("reportways", (Object)ways, row);
                this.getModel().setValue("isleaf", (Object)false, row);
                ++row;
            }
            this.getView().updateView("subjectsetentry");
        }
        DynamicObjectCollection entryS = this.getModel().getDataEntity().getDynamicObjectCollection("subjectsetentry");
        int rowIndex = 0;
        for (DynamicObject entry : entryS) {
            Optional<DynamicObject> first;
            String ways = entry.getString("reportways");
            if (!ReportInputType.FORMULA.getNumber().equals(ways)) {
                this.getModel().setValue("formula", null, rowIndex);
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"formula"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"formula"});
            }
            if (ReportInputType.DETAIL_INPUT.getNumber().equals(ways)) {
                this.getView().setEnable(Boolean.valueOf(true), rowIndex, new String[]{"subtemplate"});
            } else {
                this.getModel().setValue("subtemplate", null, rowIndex);
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"subtemplate"});
            }
            DynamicObject accountObj = entry.getDynamicObject("subject");
            DynamicObject accountMemFromDB = (DynamicObject)accountMemsMap.get(accountObj.getPkValue());
            Object parentId = accountMemFromDB.get(String.join((CharSequence)".", "parent", "id"));
            if (parentId != null && (first = entryS.stream().filter(item -> item.getString(String.join((CharSequence)".", "subject", "id")).equals(parentId.toString())).findFirst()).isPresent()) {
                this.getModel().setValue("pid", first.get().get("id"), rowIndex);
            }
            ++rowIndex;
        }
        boolean isMainTable = this.getModel().getDataEntity(true).getBoolean("ismaintable");
        List<String> specialInputTypes = Arrays.asList(ReportInputType.SUMMARY.getNumber(), ReportInputType.FORMULA.getNumber());
        Map subjectEntryMap = entryS.stream().filter(item -> Objects.nonNull(item.getDynamicObject("subject"))).collect(Collectors.toMap(k -> k.getDynamicObject("subject").getLong("id"), Function.identity(), (a, b) -> a));
        Map entryKeyMap = entryS.stream().filter(item -> !EmptyUtil.isEmpty((Object)item.get("pid"))).collect(Collectors.toMap(k -> k.get("pid"), Function.identity(), (a, b) -> a));
        Set<Object> pidSet = entryKeyMap.keySet();
        rowIndex = 0;
        for (DynamicObject entry : entryS) {
            boolean newSubjectSetting;
            boolean hadPid = pidSet.contains(entry.getPkValue());
            DynamicObject accountObj = entry.getDynamicObject("subject");
            DynamicObject accountMemFromDB = (DynamicObject)accountMemsMap.get(accountObj.getPkValue());
            if (!hadPid && !accountMemFromDB.getBoolean("isleaf") && specialInputTypes.contains(accountMemFromDB.getString("ways")) || !isMainTable && ReportInputType.DETAIL_INPUT.getNumber().equals(accountMemFromDB.getString("ways"))) {
                this.getModel().setValue("reportways", (Object)ReportInputType.MANUAL_INPUT.getNumber(), rowIndex);
            }
            if (hadPid) {
                this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{"reportways"});
            }
            List<Long> accountMemIds = entryS.stream().map(item -> item.getLong("subject.id")).collect(Collectors.toList());
            String formula = entry.getString("formula");
            if (StringUtils.isNotEmpty((CharSequence)formula)) {
                formula = this.filterNotExistSubject(formula, accountMemIds);
                this.getModel().setValue("formula", (Object)formula, rowIndex);
            }
            Object subjectId = accountObj.getPkValue();
            this.getModel().setValue("formula", this.getValueOrDefault(subjectOldSetMap, subjectId, "formula", entry), rowIndex);
            this.getModel().setValue("reportways", this.getValueOrDefault(subjectOldSetMap, subjectId, "reportways", entry), rowIndex);
            this.getModel().setValue("subtemplate", this.getValueOrDefault(subjectOldSetMap, subjectId, "subtemplate", entry), rowIndex);
            Object parentId = accountMemFromDB.get(String.join((CharSequence)".", "parent", "id"));
            DynamicObject parentSubject = (DynamicObject)subjectEntryMap.get(parentId);
            boolean bl = newSubjectSetting = !subjectOldSetMap.containsKey(subjectId);
            if (newSubjectSetting && Objects.nonNull(parentSubject)) {
                boolean hide = parentSubject.getBoolean("hideinreport");
                this.getModel().setValue("hideinreport", (Object)hide, rowIndex);
            } else {
                String valueFromF7 = entry.getString("hideinreport");
                DynamicObject dynamicObject = subjectOldSetMap.get(subjectId);
                if (Objects.nonNull(dynamicObject)) {
                    this.getModel().setValue("hideinreport", (Object)dynamicObject.getBoolean("hideinreport"), rowIndex);
                } else {
                    this.getModel().setValue("hideinreport", (Object)valueFromF7, rowIndex);
                }
            }
            ++rowIndex;
        }
    }

    private Object getValueOrDefault(Map<Object, DynamicObject> subjectOldSetMap, Object subjectId, String prop, DynamicObject entry) {
        String valueFromF7 = entry.getString(prop);
        if (CollectionUtils.isEmpty(subjectOldSetMap)) {
            return valueFromF7;
        }
        if (!subjectOldSetMap.containsKey(subjectId)) {
            return valueFromF7;
        }
        DynamicObject dynamicObject = subjectOldSetMap.get(subjectId);
        String reportWaysFromF7 = entry.getString("reportways");
        String oldReportWays = dynamicObject.getString("reportways");
        if (WaysEnum.FORMULA_TERM.getValue().equals(reportWaysFromF7) && WaysEnum.FORMULA_TERM.getValue().equals(oldReportWays)) {
            return valueFromF7;
        }
        Object oldValue = dynamicObject.get(prop);
        return Optional.ofNullable(oldValue).orElse(valueFromF7);
    }

    private void initSubjectSetting(DimLocation location, int level) {
        String subjectName = DimLayoutHelper.getDimessionMemberType((DimLocation)location, (int)level, (DynamicObject)this.getModel().getDataEntity(true));
        if (DimsionEnums.SUBJECT.getNumber().equals(subjectName)) {
            this.initSubjectSettingEntryInfo();
        }
    }

    private void disableOfPeriod() {
        Pair pair = DimLayoutHelper.memberOfPosition((DynamicObject)this.getModel().getDataEntity(true), (String)DIMMEMBER, (DimsionEnums)DimsionEnums.PERIOD);
        if (null != pair) {
            DynamicObjectCollection entrys = this.getModel().getEntryEntity((String)pair.getRight());
            FieldEdit fieldEdit = (FieldEdit)this.getControl(String.join((CharSequence)"", (CharSequence)pair.getLeft(), "text"));
            String title = String.format(ResManager.loadKDString((String)"%s (\u7f16\u62a5\u65f6\u786e\u8ba4)", (String)"FixTemplateManagePlugin_01", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), DimsionEnums.PERIOD.getName());
            fieldEdit.setCaption(new LocaleString(title));
            for (int index = 0; index < entrys.size(); ++index) {
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{String.join((CharSequence)"", (CharSequence)pair.getLeft(), "text")});
            }
        }
    }

    private void fillMemberInfo(TreeDataSelectedReturnData returnData, String actionId) {
        if (returnData != null) {
            String dimMemberPropName = "";
            switch (actionId) {
                case "lv1coldimmembertext": {
                    dimMemberPropName = "lv1coldimmember";
                    break;
                }
                case "lv2coldimmembertext": {
                    dimMemberPropName = "lv2coldimmember";
                    break;
                }
                case "lv3coldimmembertext": {
                    dimMemberPropName = "lv3coldimmember";
                    break;
                }
                case "lv1rowdimmembertext": {
                    dimMemberPropName = "lv1rowdimmember";
                    break;
                }
                case "lv2rowdimmembertext": {
                    dimMemberPropName = "lv2rowdimmember";
                    break;
                }
            }
            TemplateType templateType = TemplateType.getByNumber((String)this.getModel().getDataEntity().getString("templatetype"));
            boolean mainTable = this.getModel().getDataEntity().getBoolean("ismaintable");
            Set rightTreeIdSet = returnData.getRightTreeIdSet();
            DynamicObject[] subjectMembers = BusinessDataServiceHelper.load((Object[])rightTreeIdSet.stream().map(Long::parseLong).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_member"));
            IMemberConverter subjectConverter = MemberConverterFactory.createMemberConverterByDimType((DimensionType)DimensionType.SUBJECTS);
            List dimMembers = subjectConverter.convertToMemberTree(Arrays.asList(subjectMembers));
            ArrayList<DimMember> errorSelect = new ArrayList<DimMember>();
            this.checkErrorSelect(dimMembers, errorSelect);
            if (!CollectionUtils.isEmpty(errorSelect)) {
                if (TemplateType.FIXED == templateType && !mainTable) {
                    List<String> errMsgList = errorSelect.stream().map(item -> String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u975e\u53f6\u5b50\u8282\u70b9\u8ba1\u5212\u79d1\u76ee\u4e0d\u53ef\u4f5c\u4e3a\u672b\u7ea7\u586b\u62a5\u9879\uff0c\u8bf7\u786e\u8ba4\u5de6\u4fa7\u5df2\u9009\u7684\u975e\u53f6\u5b50\u8282\u70b9\u201c%s\u201d\u4e0b\u7684\u672b\u7ea7\u586b\u62a5\u79d1\u76ee\u3002", (String)"FixTemplateManagePlugin_03", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), item.getName())).collect(Collectors.toList());
                    this.showErrMessage(errMsgList);
                    return;
                }
                if (TemplateType.DETAIL == templateType) {
                    List<String> errMsgList = errorSelect.stream().map(item -> String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u975e\u53f6\u5b50\u8282\u70b9\u8ba1\u5212\u79d1\u76ee\u201c%s\u201d\u4e0d\u53ef\u4f5c\u4e3a\u672b\u7ea7\u660e\u7ec6\u586b\u62a5\u9879\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"FixTemplateManagePlugin_04", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), item.getName())).collect(Collectors.toList());
                    this.showErrMessage(errMsgList);
                    return;
                }
            }
            DynamicObjectCollection memberColl = (DynamicObjectCollection)this.getModel().getValue(dimMemberPropName);
            List selectedPkList = returnData.getRightTreeIdSet().stream().map(Long::valueOf).collect(Collectors.toList());
            this.getModel().setValue(dimMemberPropName, (Object)selectedPkList.toArray());
            List selectedNameList = memberColl.stream().map(i -> i.getString("fbasedataid.name")).collect(Collectors.toList());
            this.getModel().setValue(actionId, (Object)String.join((CharSequence)",", selectedNameList));
        }
    }

    public void checkErrorSelect(List<DimMember> dimMembers, List<DimMember> errorDim) {
        if (CollectionUtils.isEmpty(dimMembers)) {
            return;
        }
        for (DimMember dimMember : dimMembers) {
            boolean errorSelect;
            boolean bl = errorSelect = !dimMember.isLeaf() && CollectionUtils.isEmpty((Collection)dimMember.getChildren());
            if (errorSelect) {
                errorDim.add(dimMember);
                continue;
            }
            this.checkErrorSelect(dimMember.getChildren(), errorDim);
        }
    }

    private String filterNotExistSubject(String formula, List<Long> accountIds) {
        String newFormula = formula;
        if (EmptyUtil.isEmpty((String)formula)) {
            return "";
        }
        Set<String> subjectIds = this.getSubjectIdByFormula(formula);
        for (String subjectId : subjectIds) {
            if (accountIds.contains(Long.valueOf(subjectId))) continue;
            newFormula = newFormula.replace(String.format("-[%s]", subjectId), "");
            newFormula = newFormula.replace(String.format("+[%s]", subjectId), "");
            newFormula = newFormula.replace(String.format("[%s]+", subjectId), "");
            newFormula = newFormula.replace(String.format("[%s]-", subjectId), "");
            newFormula = newFormula.replace(String.format("[%s]", subjectId), "");
        }
        return newFormula;
    }

    private Set<String> getSubjectIdByFormula(String formula) {
        String[] expressUnits;
        HashSet<String> subjectIds = new HashSet<String>();
        String isDigitalRegex = "^[0-9]*$";
        String isDoubleBracketRegex = "^(\\[)[0-9]*(\\])$";
        String regex = "\\+|\\-";
        for (String expressUnit : expressUnits = formula.split(regex)) {
            boolean isDoubleBracket;
            boolean isDigit = expressUnit.matches(isDigitalRegex);
            if (isDigit || !(isDoubleBracket = expressUnit.matches(isDoubleBracketRegex))) continue;
            subjectIds.add(Optional.ofNullable(expressUnit).map(o -> o.replaceAll("\\[|]", "")).orElseGet(() -> ""));
        }
        return subjectIds;
    }

    protected void afterClosedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "dimlayoutop": {
                if (Objects.isNull(closedCallBackEvent.getReturnData())) break;
                this.setEnableForOrg();
                break;
            }
        }
    }

    protected void afterPropertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        switch (property.getName()) {
            case "sumreportorg": {
                this.refreshReport();
            }
        }
    }

    private void refreshReport() {
        ReportTemplate reportTemplate = TemplateVOConverter.convertManageDataToTemplate((DynamicObject)this.getModel().getDataEntity(true));
        DynamicObject dynamicObject = (DynamicObject)this.getModel().getValue("viewreporttype");
        this.refreshReport(reportTemplate, EmptyUtil.isEmpty((DynamicObject)dynamicObject) ? null : (Long)dynamicObject.getPkValue());
    }

    private void setSumReportOrgRequiredIfNeed() {
        DimLocation[] values = DimLocation.values();
        boolean show = false;
        block0: for (DimLocation dimLocation : values) {
            if (dimLocation == DimLocation.PAGE) continue;
            for (int level = 1; level <= 3; ++level) {
                String dimType = DimLayoutHelper.getDimessionMemberType((DimLocation)dimLocation, (int)level, (DynamicObject)this.getModel().getDataEntity());
                show = Objects.equals(dimType, DimsionEnums.ORG.getNumber());
                if (show) break block0;
            }
        }
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("sumreportorg");
        basedataEdit.setMustInput(show);
        this.getView().setVisible(Boolean.valueOf(show), new String[]{"sumreportorg"});
        if (!show) {
            return;
        }
        Object value = this.getModel().getValue("sumreportorg");
        if (EmptyUtil.isNoEmpty((Object)value)) {
            return;
        }
        DynamicObject model = (DynamicObject)this.getModel().getValue("model");
        if (EmptyUtil.isEmpty((DynamicObject)model)) {
            return;
        }
        String orgId = String.join((CharSequence)".", "org", "id");
        DynamicObject dynamicObject = TmcDataServiceHelper.loadSingle((Object)model.getPkValue(), (String)"fpm_bodysysmanage", (String)orgId);
        DynamicObject orgMember = TmcDataServiceHelper.loadSingle((String)"fpm_member", (String)"id", (QFilter[])new QFilter[]{new QFilter("sourceid", "=", (Object)dynamicObject.getLong(orgId)).and("dimtype", "=", (Object)DimsionEnums.ORG.getNumber()).and("bodysystem", "=", model.getPkValue())});
        if (EmptyUtil.isNoEmpty((DynamicObject)orgMember)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"sumreportorg", (Object)orgMember.getPkValue());
            this.getView().updateView("sumreportorg");
        }
    }

    @Override
    protected void afterInitTemplate() {
        super.afterInitTemplate();
        this.setEnableForOrg();
    }

    private void setEnableForOrg() {
        String description;
        int level;
        String templateUse = (String)this.getModel().getValue("templateuses");
        if (!Objects.equals(templateUse, TemplateUsesEnum.SUMMARY.getValue())) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("layoutentry");
        DynamicObject dynamicObject = entryEntity.stream().filter(dy -> Objects.equals(dy.getDynamicObject("layoutdim").getString("number"), DimsionEnums.ORG.getNumber())).findFirst().get();
        String dimType = dynamicObject.getString("dimtype");
        DimLocation dimLocation = DimLocation.getByNumber((String)dimType);
        String propName = "";
        String entryName = "";
        switch (dimLocation) {
            case ROW: {
                level = dynamicObject.getInt("dimlevel");
                propName = String.join((CharSequence)"", this.getMemberPropNameByLevel(level, DimLocation.ROW), "text");
                entryName = "rowentryentity";
                break;
            }
            case COL: {
                level = dynamicObject.getInt("dimlevel");
                propName = String.join((CharSequence)"", this.getMemberPropNameByLevel(level, DimLocation.COL), "text");
                entryName = "colentryentity";
                break;
            }
            case PAGE: {
                propName = "pagedimmembertext";
                entryName = "pagedimentry";
                level = 0;
                break;
            }
            default: {
                level = -1;
            }
        }
        if (level < 0 || StringUtils.isEmpty((CharSequence)propName)) {
            return;
        }
        boolean mainTable = this.getModel().getDataEntity().getBoolean("ismaintable");
        String memberScope = dynamicObject.getString("memberscope");
        DimensionMemberScopeEnum memberScopeEnum = DimensionMemberScopeEnum.getDimensionMemberScopeEnumByValue((String)memberScope);
        if (Objects.isNull(memberScopeEnum)) {
            memberScopeEnum = DimensionMemberScopeEnum.SUM_NODE_THIS_LEVEL;
            this.getModel().setValue("memberscope", (Object)memberScopeEnum.getValue(), dynamicObject.getInt("seq") - 1);
        }
        Boolean enable = mainTable && memberScopeEnum == DimensionMemberScopeEnum.FIXED_MEMBER ? Boolean.TRUE : Boolean.FALSE;
        String string = description = memberScopeEnum == DimensionMemberScopeEnum.FIXED_MEMBER ? "" : memberScopeEnum.getName();
        if (!mainTable) {
            description = ResManager.loadKDString((String)"\u6cbf\u7528\u4e3b\u8868", (String)"FixTemplateManagePlugin_02", (String)"tmc-fpm-formplugin", (Object[])new Object[0]);
        }
        if (level == 0) {
            DynamicObjectCollection pageEntryEntity = this.getModel().getEntryEntity("pagedimentry");
            DynamicObject orgDy = pageEntryEntity.stream().filter(dy -> Objects.equals(dy.getDynamicObject("pagedim").getString("number"), DimsionEnums.ORG.getNumber())).findFirst().get();
            int index = orgDy.getInt("seq") - 1;
            Object value = this.getModel().getValue(propName, index);
            if (EmptyUtil.isEmpty((Object)value) && EmptyUtil.isNoEmpty((String)description)) {
                this.getModel().setValue(propName, (Object)description, index);
            }
            this.getView().setEnable(enable, index, new String[]{propName});
        } else {
            Object value = this.getModel().getValue(propName, 0);
            if (EmptyUtil.isEmpty((Object)value) && EmptyUtil.isNoEmpty((String)description)) {
                this.getModel().setValue(propName, (Object)description, 0);
            }
            this.getView().setEnable(enable, 0, new String[]{propName});
        }
        this.getView().updateView(entryName);
    }

    private String getMemberPropNameByLevel(int level, DimLocation dimLocation) {
        return String.format(DIMMEMBER, level, dimLocation.getNumber().toLowerCase(Locale.ENGLISH));
    }
}

