/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.template;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.TemplateSmartGetValSetType;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.model.template.TemplateBaseInfo;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.domain.model.template.TemplateLayout;
import kd.tmc.fpm.business.domain.model.template.TemplateReportType;
import kd.tmc.fpm.business.mvc.controller.ITemplateManageController;
import kd.tmc.fpm.business.mvc.controller.impl.TemplateManageController;
import kd.tmc.fpm.business.mvc.converter.TemplateVOConverter;
import kd.tmc.fpm.business.mvc.converter.utils.TypeEnumUtil;
import kd.tmc.fpm.business.mvc.view.ITemplateManageView;
import kd.tmc.fpm.business.spread.command.generator.InitialToolbarAndRightKeyItemGenerator;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.enums.BeginOrEndMarkEnum;
import kd.tmc.fpm.common.enums.DimensionMemberScopeEnum;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.RowColType;
import kd.tmc.fpm.common.enums.TemplateTypeEnum;
import kd.tmc.fpm.common.enums.TemplateUsesEnum;
import kd.tmc.fpm.common.enums.TreeDataSelectedCascadeType;
import kd.tmc.fpm.common.enums.TreeDataSelectedType;
import kd.tmc.fpm.common.result.TreeDataSelectedReturnData;
import kd.tmc.fpm.formplugin.domain.TemplateBaseInfoReturnData;
import kd.tmc.fpm.formplugin.helper.DimMemberHelper;
import kd.tmc.fpm.spread.plugin.AbstractSpreadPlugin;
import kd.tmc.fpm.spread.utils.ExcelUtils;
import kd.tmc.fpm.spread.widget.CellArea;
import kd.tmc.fpm.spread.widget.core.Book;
import kd.tmc.fpm.spread.widget.core.Sheet;
import kd.tmc.fpm.spread.widget.style.AreasStyle;
import org.apache.commons.lang3.StringUtils;

public abstract class TemplateManageBasePlugin
extends AbstractSpreadPlugin
implements ITemplateManageView {
    private ITemplateManageController controller;

    protected String getSpreadKey() {
        return "reportdata";
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"pagedimmembertext"});
        this.addItemClickListeners(new String[]{"toolbar"});
        this.initViewReportTypeF7();
        this.initDefaultDisplayMemberF7();
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter sp = this.getView().getFormShowParameter();
        OperationStatus status = sp.getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.createNewTemplate();
        } else if (OperationStatus.EDIT.equals((Object)status) || OperationStatus.VIEW.equals((Object)status)) {
            Long templateId = (Long)sp.getCustomParam("templateId");
            this.loadTemplate(templateId);
            if (this.getModel().getDataEntity(true).getBoolean("releasestatus")) {
                DynamicObject model = this.getModel().getDataEntity(true).getDynamicObject("model");
                DynamicObjectCollection modelReportTypeColl = model.getDynamicObjectCollection("applyrereportentry");
                DynamicObjectCollection reportTypeList = this.getModel().getDataEntity(true).getDynamicObjectCollection("reporttype");
                List reportPeriods = reportTypeList.stream().map(item -> item.getLong("fbasedataid.id")).collect(Collectors.toList());
                List unEnableList = modelReportTypeColl.stream().filter(item -> reportPeriods.contains(item.getLong("rerporttype.id")) && !"enable".equals(item.get("rereporttypestatus"))).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(unEnableList)) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u53d1\u5e03\uff0c\u5f15\u7528\u7684\u7f16\u62a5\u7c7b\u578b\u5df2\u5728\u4f53\u7cfb%s\u4e2d\u7981\u7528\u3002\u5982\u9700\u7ee7\u7eed\u4f7f\u7528\u6b64\u6a21\u677f\uff0c\u8bf7\u590d\u5236\u540e\u5728\u6a21\u677f\u57fa\u672c\u4fe1\u606f\u4e2d\u8fdb\u884c\u8c03\u6574\u3002", (String)"TemplateManageBasePlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), model.get("name")));
                }
            }
        }
        DynamicObjectCollection doc = this.getView().getModel().getDataEntity(true).getDynamicObjectCollection("reporttype");
        if (null != doc && doc.size() > 0) {
            this.getView().getModel().setValue("viewreporttype", ((DynamicObject)doc.get(0)).get("fbasedataid.id"));
        }
        this.afterInitTemplate();
        super.afterCreateNewData(e);
        new InitialToolbarAndRightKeyItemGenerator().generatorChain(this.getSpreadCommandInvoker()).execCommand();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        if ("pagedimmembertext".equals(fieldKey)) {
            if (newValue == null || StringUtils.isEmpty((CharSequence)newValue.toString())) {
                this.getModel().setValue("pagedimmember", null);
            }
        } else if ("viewreporttype".equals(fieldKey)) {
            ReportTemplate reportTemplate = TemplateVOConverter.convertManageDataToTemplate((DynamicObject)this.getModel().getDataEntity(true));
            DynamicObject periodType = (DynamicObject)newValue;
            this.getOrCreateController().refreshReport(reportTemplate, periodType != null ? Long.valueOf(periodType.getPkValue().toString()) : null);
        } else if ("pagedimmember".equals(fieldKey)) {
            DynamicObjectCollection dimMemberCollection = (DynamicObjectCollection)newValue;
            if (CollectionUtils.isEmpty((Collection)dimMemberCollection)) {
                this.getModel().setValue("defaultdisplaymember", null);
                return;
            }
            List ids = dimMemberCollection.stream().map(o -> o.getDynamicObject("fbasedataid")).map(o -> o.getLong("id")).collect(Collectors.toList());
            DynamicObject defaultDisplayMember = (DynamicObject)this.getModel().getValue("defaultdisplaymember");
            if (defaultDisplayMember != null && !ids.contains((Long)defaultDisplayMember.getPkValue())) {
                this.getModel().setValue("defaultdisplaymember", null);
            }
        }
    }

    public void updatePageDim(List<TemplateLayout.LayoutInfo> layoutInfoList, List<TemplateDim> dimList) {
        this.getModel().deleteEntryData("pagedimentry");
        for (TemplateLayout.LayoutInfo layoutInfo : layoutInfoList) {
            Optional<TemplateDim> first;
            if (!layoutInfo.isVisible()) continue;
            int newEntryRow = this.getModel().createNewEntryRow("pagedimentry");
            this.getModel().setValue("pagedim", (Object)layoutInfo.getDimensionId(), newEntryRow);
            if (dimList != null && dimList.size() > 0 && (first = dimList.stream().filter(e -> e.getDimensionId().equals(layoutInfo.getDimensionId())).findFirst()).isPresent()) {
                TemplateDim templateDim = first.get();
                List memberScope = templateDim.getMemberScope();
                if (memberScope != null) {
                    this.getModel().setValue("pagedimmember", (Object)memberScope.toArray(), newEntryRow);
                    DynamicObjectCollection value = (DynamicObjectCollection)this.getModel().getValue("pagedimmember", newEntryRow);
                    List collect = value.stream().map(e -> e.getString("fbasedataid.name")).collect(Collectors.toList());
                    this.getModel().setValue("pagedimmembertext", (Object)String.join((CharSequence)",", collect), newEntryRow);
                }
                if (templateDim.getDefaultDisplayMember() != null) {
                    this.getModel().setValue("defaultdisplaymember", (Object)templateDim.getDefaultDisplayMember(), newEntryRow);
                }
            }
            String templateUse = (String)this.getModel().getValue("templateuses");
            DynamicObject dimObj = (DynamicObject)this.getModel().getValue("pagedim", newEntryRow);
            if ((!Objects.equals(templateUse, TemplateUsesEnum.PLANING.getValue()) || !DimsionEnums.ORG.getNumber().equals(dimObj.get("basedata"))) && !DimsionEnums.PERIOD.getNumber().equals(dimObj.get("basedata"))) continue;
            this.getModel().setValue("pagedimmembertext", (Object)ResManager.loadKDString((String)"\u7f16\u62a5\u65f6\u786e\u8ba4", (String)"DimLayoutPlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), newEntryRow);
        }
        this.getView().updateView("pagedimentry");
    }

    public void updateDimLayout(List<TemplateLayout.LayoutInfo> layoutInfoList, ReportTemplate template) {
        this.getModel().deleteEntryData("layoutentry");
        for (TemplateLayout.LayoutInfo layoutInfo : layoutInfoList) {
            int newEntryRow = this.getModel().createNewEntryRow("layoutentry");
            this.getModel().setValue("layoutdim", (Object)layoutInfo.getDimensionId(), newEntryRow);
            this.getModel().setValue("dimtype", (Object)RowColType.valueOf((String)layoutInfo.getDimLocation().name()).getValue(), newEntryRow);
            this.getModel().setValue("dimlevel", (Object)layoutInfo.getLevel(), newEntryRow);
            this.getModel().setValue("isopen", (Object)layoutInfo.isExpand(), newEntryRow);
            this.getModel().setValue("iscontaintotal", (Object)layoutInfo.isIncludeSum(), newEntryRow);
            if (layoutInfo.getExpandMembers() != null) {
                this.getModel().setValue("expandmember", (Object)layoutInfo.getExpandMembers().toArray(), newEntryRow);
            }
            this.getModel().setValue("dimhide", (Object)(!layoutInfo.isVisible() ? 1 : 0), newEntryRow);
            this.getModel().setValue("dimhide", (Object)(!layoutInfo.isVisible() ? 1 : 0), newEntryRow);
            this.getModel().setValue("memberscope", (Object)TypeEnumUtil.getNumberOrDefault((ITypeEnum)layoutInfo.getScopeType()), newEntryRow);
            this.getModel().setValue("filterdim", (Object)layoutInfo.isFilterDim(), newEntryRow);
        }
        this.getView().updateView("layoutentry");
    }

    public void updateReport(Book book) {
        if (null == book) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65e0\u5b9a\u5236\u6a21\u677f\u6570\u636e\uff0c\u65e0\u6cd5\u9884\u89c8\u3002", (String)"TemplateManageBasePlugin_0", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            return;
        }
        Sheet sheet = book.getSheet();
        List cells = sheet.getCellList();
        String rowStr = this.getView().getPageCache().get("book_pagecache_row");
        String colStr = this.getView().getPageCache().get("book_pagecache_col");
        if (null != rowStr && null != colStr) {
            int i;
            int maxRowCnt = Integer.parseInt(rowStr);
            int maxColCnt = Integer.parseInt(colStr);
            ArrayList<Integer> rows = new ArrayList<Integer>(maxRowCnt);
            ArrayList<Integer> cols = new ArrayList<Integer>(maxColCnt);
            for (i = 0; i < maxRowCnt; ++i) {
                rows.add(i);
            }
            for (i = 0; i < maxColCnt; ++i) {
                cols.add(i);
            }
            this.getSpreadCommandInvoker().deleteRowCol(rows, cols);
        }
        Integer maxRow = sheet.getRows().size();
        Integer maxCol = sheet.getCols().size();
        this.getView().getPageCache().put("book_pagecache_row", maxRow.toString());
        this.getView().getPageCache().put("book_pagecache_col", maxCol.toString());
        this.getSpreadCommandInvoker().appendRowCols(sheet.getRows().size(), sheet.getCols().size());
        this.getSpreadCommandInvoker().updateCellValue2(sheet.getCellList());
        List spanCells = cells.stream().filter(Objects::nonNull).filter(o -> o.getColSpan() != 0 || o.getRowSpan() != 0).collect(Collectors.toList());
        List spanCellAreas = spanCells.stream().filter(Objects::nonNull).map(o -> new CellArea(ExcelUtils.converCoord((int)o.getCol(), (int)o.getRow(), (int)(o.getRowSpan() - 1), (int)(o.getColSpan() - 1)))).collect(Collectors.toList());
        this.getSpreadCommandInvoker().setSpan(spanCellAreas);
        List lst = book.getSheet().getCellList().stream().filter(Objects::nonNull).filter(o -> Objects.nonNull(o.getStyleInfo())).collect(Collectors.toList());
        List areasStyles = lst.stream().filter(Objects::nonNull).map(o -> {
            AreasStyle as = new AreasStyle();
            CellArea ca = new CellArea(ExcelUtils.converCoord((int)o.getCol(), (int)o.getRow(), (int)(o.getRowSpan() - 1), (int)(o.getColSpan() - 1)));
            as.setRange(Collections.singletonList(ca));
            as.setStyle(o.getStyleInfo());
            return as;
        }).collect(Collectors.toList());
        this.getSpreadCommandInvoker().setCellStyle(areasStyles);
        this.getSpreadCommandInvoker().setColsAutoFit(sheet.getCols());
        this.getSpreadCommandInvoker().setRowsAutoFit(sheet.getRows());
        this.getSpreadCommandInvoker().lockSheets(Collections.singletonList("Sheet1"));
    }

    public void hideRows(Set<Integer> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        this.controlEmptyRow(false, this.getSpreadCommandInvoker(), new ArrayList<Integer>(rows));
    }

    public void updateBaseInfo(ReportTemplate template) {
        List userIdList;
        TemplateSmartGetValSetType smartGetValSetType;
        this.getModel().setValue("id", (Object)template.getId());
        this.getModel().setValue("model", (Object)template.getSystemId());
        this.getModel().setValue("number", (Object)template.getNumber());
        this.getModel().setValue("name", template.getMultiLanguageName());
        this.getModel().setValue("templatetype", (Object)TemplateTypeEnum.valueOf((String)template.getTemplateType().name()).getValue());
        this.getModel().setValue("ismaintable", (Object)template.isMainTable());
        this.getModel().setValue("startcell", (Object)template.getStartLocation());
        this.getModel().setValue("maxnum", (Object)template.getMaxLineCount());
        this.getModel().setValue("amountunit", (Object)AmountUnitEnum.valueOf((String)template.getAmountUnit().name()).getValue());
        this.getModel().setValue("enable", (Object)template.isEnable());
        this.getModel().setValue("isincludesum", (Object)template.isDetailIncludeSum());
        this.getModel().setValue("comment", (Object)template.getDescription());
        this.getModel().setValue("creator", (Object)template.getCreatorId());
        this.getModel().setValue("releasestatus", (Object)template.isRelease());
        this.getModel().setValue("effectivedate", (Object)template.getEffectiveDate());
        this.getModel().setValue("templateuses", (Object)TypeEnumUtil.getNumberOrDefault((ITypeEnum)template.getTemplateUse()));
        List statAnalysisTemplateList = template.getStatAnalysisTemplateList();
        if (EmptyUtil.isNoEmpty((Object)statAnalysisTemplateList)) {
            this.getModel().setValue("statanalysistemplate", (Object)statAnalysisTemplateList.stream().map(ReportTemplate::getId).toArray());
        } else {
            this.getModel().setValue("statanalysistemplate", null);
        }
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getModel().setValue("creator", (Object)RequestContext.get().getUserId());
        }
        List reportTypeList = template.getReportTypeList();
        this.getModel().deleteEntryData("reporttypeentry");
        if (!CollectionUtils.isEmpty((Collection)reportTypeList)) {
            for (TemplateReportType templateReportType : reportTypeList) {
                int newEntryRow = this.getModel().createNewEntryRow("reporttypeentry");
                this.getModel().setValue("e_reporttype", (Object)templateReportType.getReportTypeId(), newEntryRow);
                if (!CollectionUtils.isEmpty((Collection)templateReportType.getReferencePosTypeS())) {
                    this.getModel().setValue("refrencepos", (Object)String.join((CharSequence)",", templateReportType.getReferencePosTypeS().stream().map(item -> item.getNumber()).collect(Collectors.toList())), newEntryRow);
                }
                this.getModel().setValue("newreferencepos", (Object)templateReportType.getReferencePosIds().toArray(new Long[0]), newEntryRow);
                this.getModel().setValue("auxiliaryfield", (Object)templateReportType.getAuxiliaryFieldIds().toArray(new Long[0]), newEntryRow);
                this.getModel().setValue("consultseat", (Object)TypeEnumUtil.getNumberOrDefault((ITypeEnum)templateReportType.getConsultSeatType()), newEntryRow);
                this.getModel().setValue("e_refrenceorg", (Object)templateReportType.getReferenceReportTypeId(), newEntryRow);
                this.getModel().setValue("periodnum", (Object)templateReportType.getPeriodNum(), newEntryRow);
            }
            List collect = reportTypeList.stream().map(TemplateReportType::getReportTypeId).collect(Collectors.toList());
            this.getModel().setValue("reporttype", (Object)collect.toArray());
        }
        if ((smartGetValSetType = template.getSmartGetValSetType()) != null) {
            this.getModel().setValue("smartgetvalset", (Object)smartGetValSetType.getNumber());
        }
        if (!CollectionUtils.isEmpty((Collection)(userIdList = template.getUserIdList()))) {
            this.getModel().setValue("user", (Object)userIdList.toArray());
        }
    }

    public void showErrMessage(List<String> errMessageList) {
        if (!CollectionUtils.isEmpty(errMessageList)) {
            if (errMessageList.size() > 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6709\u591a\u6761\u9519\u8bef\u6d88\u606f\u9700\u8981\u786e\u8ba4\u3002", (String)"TemplateManageBasePlugin_2", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), errMessageList.stream().reduce((a, b) -> a + '\n' + b).orElseGet(() -> ""), MessageTypes.Default);
            } else if (errMessageList.size() == 1) {
                this.getView().showErrorNotification(errMessageList.get(0));
            }
        }
    }

    public void showSuccessMessage(String successMsg) {
        if (successMsg != null) {
            this.getView().showSuccessNotification(successMsg);
        }
    }

    public IPageCache getCache() {
        return this.getView().getPageCache();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (key = op.getOperateKey()) {
            case "saveandview": 
            case "releasecheckop": {
                this.checkSubjectScope(args);
                break;
            }
        }
    }

    private void checkSubjectScope(BeforeDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        String skipCheck = this.getPageCache().get("skipCheck");
        if (Objects.nonNull(skipCheck) && Boolean.parseBoolean(skipCheck.toString())) {
            this.getPageCache().remove("skipCheck");
            if (StringUtils.equals((CharSequence)"releasecheckop", (CharSequence)key)) {
                this.getView().invokeOperation("releaseop");
            }
            return;
        }
        String opKey = key;
        if (StringUtils.equals((CharSequence)"releasecheckop", (CharSequence)key)) {
            opKey = "releaseop";
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        boolean mainTable = dataEntity.getBoolean("ismaintable");
        String templateUse = dataEntity.getString("templateuses");
        boolean isPlan = StringUtils.equals((CharSequence)templateUse, (CharSequence)TemplateUsesEnum.PLANING.getValue());
        if (!mainTable || !isPlan) {
            this.getPageCache().put("skipCheck", "true");
            this.getView().invokeOperation(opKey);
            return;
        }
        long bodySystemId = dataEntity.getLong("model.id");
        String number = dataEntity.getString("number");
        List templateAccountSettings = TemplateVOConverter.convertSetting((DynamicObject)dataEntity);
        if (EmptyUtil.isEmpty((Collection)templateAccountSettings)) {
            this.getPageCache().put("skipCheck", "true");
            this.getView().invokeOperation(opKey);
            return;
        }
        String prop = String.join((CharSequence)",", "id", "name", "number", "beginorendmark", "ways");
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"fpm_member", (String)prop, (QFilter[])new QFilter[]{new QFilter("bodysysmanage", "=", (Object)bodySystemId), new QFilter("enable", "=", (Object)"1")});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)queryResult)) {
            this.getPageCache().put("skipCheck", "true");
            this.getView().invokeOperation(opKey);
            return;
        }
        Map<Long, String> subjectIdMap = queryResult.stream().filter(item -> {
            boolean begin = BeginOrEndMarkEnum.isBegin((String)item.getString("beginorendmark"));
            boolean formula = ReportInputType.isFormula((String)item.getString("ways"));
            return begin || formula;
        }).collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getString("number") + v.getString("name")));
        if (EmptyUtil.isEmpty(subjectIdMap)) {
            this.getPageCache().put("skipCheck", "true");
            this.getView().invokeOperation(opKey);
            return;
        }
        Set subjectIdSet = templateAccountSettings.stream().map(TemplateAccountSetting::getAccountMemId).collect(Collectors.toSet());
        StringBuilder errorMsg = new StringBuilder();
        for (Map.Entry<Long, String> entry : subjectIdMap.entrySet()) {
            if (subjectIdSet.contains(entry.getKey())) continue;
            errorMsg.append(entry.getValue()).append("\u3001");
        }
        if (errorMsg.length() == 0) {
            this.getPageCache().put("skipCheck", "true");
            this.getView().invokeOperation(opKey);
            return;
        }
        errorMsg.deleteCharAt(errorMsg.length() - 1);
        String msg = String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u7f16\u5236\u4e3b\u8868\u6a21\u677f\u201c%1$s\u201d\u4e2d\u7f3a\u5c11\u53ef\u7528\u72b6\u6001\u4e0b\u7684\u671f\u521d\u6216\u516c\u5f0f\u9879\u8ba1\u5212\u79d1\u76ee\u6210\u5458\u201c%2$s\u201d\uff0c\u5c06\u4f1a\u5f71\u54cd\u6c47\u603b\u7ec4\u7ec7\u4e0b\u8fd9\u4e9b\u8ba1\u5212\u79d1\u76ee\u6c47\u603b\u6570\u636e\u7684\u8ba1\u7b97\u51c6\u786e\u6027\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u5f53\u524d\u64cd\u4f5c\u3002", (String)"TemplateManageBasePlugin_8", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), number, errorMsg);
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(key, (IFormPlugin)this));
        args.setCancel(true);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("baseinfoop".equals(operateKey)) {
            this.showTemplateBaseInfoPage();
        } else if ("dimlayoutop".equals(operateKey)) {
            this.showDimLayoutPage(TemplateVOConverter.convertToDimLayoutModel((DynamicObject)this.getModel().getDataEntity()));
        } else if ("saveandview".equals(operateKey)) {
            ReportTemplate template = TemplateVOConverter.convertManageDataToTemplate((DynamicObject)this.getModel().getDataEntity(true));
            this.getOrCreateController().saveTemplate(template);
        } else if ("releaseop".equals(operateKey)) {
            ReportTemplate template = TemplateVOConverter.convertManageDataToTemplate((DynamicObject)this.getModel().getDataEntity(true));
            this.getOrCreateController().releaseTemplate(template);
        } else if ("cancelrelease".equals(operateKey)) {
            long templateId = this.getModel().getDataEntity(true).getLong("id");
            if (templateId == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u672a\u53d1\u5e03\uff0c\u65e0\u6cd5\u64a4\u9500\u53d1\u5e03\u3002", (String)"TemplateManageBasePlugin_3", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            } else {
                DynamicObject dbData = TmcDataServiceHelper.loadSingle((Object)templateId, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_template"));
                OperationResult cancelrelease = TmcOperateServiceHelper.execOperate((String)"cancelrelease", (String)"fpm_executeplan", (DynamicObject[])new DynamicObject[]{dbData}, (OperateOption)OperateOption.create());
                if (cancelrelease.isSuccess()) {
                    this.getModel().setValue("releasestatus", (Object)"0");
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("baseinfoop".equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            TemplateBaseInfoReturnData returnData = (TemplateBaseInfoReturnData)closedCallBackEvent.getReturnData();
            TemplateBaseInfo baseInfo = returnData.getTemplateBaseInfo();
            ReportTemplate reportTemplate = TemplateVOConverter.convertManageDataToTemplate((DynamicObject)this.getModel().getDataEntity(true));
            this.getOrCreateController().updateBaseInfo(reportTemplate, baseInfo);
        } else if ("dimlayoutop".equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            TemplateLayout returnData = (TemplateLayout)closedCallBackEvent.getReturnData();
            ReportTemplate reportTemplate = TemplateVOConverter.convertManageDataToTemplate((DynamicObject)this.getModel().getDataEntity(true));
            this.getOrCreateController().updateDimLayout(reportTemplate, returnData);
        } else if ("pagedimmembertext".equals(actionId)) {
            TreeDataSelectedReturnData returnData = (TreeDataSelectedReturnData)closedCallBackEvent.getReturnData();
            this.fillMemberInfo(returnData);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "saveandview": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                this.getPageCache().put("skipCheck", "true");
                this.getView().invokeOperation(callBackId);
                break;
            }
            case "releasecheckop": {
                if (!MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) break;
                this.getView().invokeOperation("releaseop");
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("btnnewtest".equals(itemKey)) {
            this.createNewTemplate();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("pagedimmembertext".equals(key)) {
            DynamicObject dimObj = (DynamicObject)this.getModel().getValue("pagedim");
            Object templateType = this.getModel().getValue("templatetype");
            DynamicObjectCollection memberColl = (DynamicObjectCollection)this.getModel().getValue("pagedimmember");
            List<Object> selectedIdList = memberColl.stream().map(i -> i.get("fbasedataid.id")).collect(Collectors.toList());
            DimsionEnums dimEnum = DimsionEnums.getDimsionByNumber((String)dimObj.getString("basedata"));
            TreeDataSelectedCascadeType treeDataSelectedCascadeType = null;
            TreeDataSelectedType treeDataSelectedType = TreeDataSelectedType.NOTREESTRU;
            if (DimsionEnums.SUBJECT == dimEnum && TemplateTypeEnum.FIXED.getValue().equals(templateType)) {
                treeDataSelectedCascadeType = TreeDataSelectedCascadeType.HALFCASCADE_TOPARENT;
                treeDataSelectedType = TreeDataSelectedType.DEFAULT;
            }
            this.showMemberTreeCustomF7(dimEnum, key, selectedIdList, treeDataSelectedCascadeType, treeDataSelectedType, (Long)dimObj.getPkValue());
        }
    }

    public void refreshReport(ReportTemplate reportTemplate, Long reportTypeId) {
        this.getOrCreateController().refreshReport(reportTemplate, reportTypeId);
    }

    protected void createNewTemplate() {
        ITemplateManageController contr = this.getOrCreateController();
        FormShowParameter sp = this.getView().getFormShowParameter();
        Object templateIdObj = sp.getCustomParam("templateId");
        if (templateIdObj != null) {
            contr.copyTemplate(((Long)templateIdObj).longValue());
            return;
        }
        JSONObject baseInfoJson = (JSONObject)sp.getCustomParam(TemplateBaseInfo.class.getName());
        if (baseInfoJson == null) {
            throw new IllegalArgumentException();
        }
        TemplateBaseInfo baseInfo = (TemplateBaseInfo)JSONObject.parseObject((String)JSON.toJSONString((Object)baseInfoJson), TemplateBaseInfo.class);
        contr.newTemplate(baseInfo);
    }

    protected void loadTemplate(Long templateId) {
        this.getOrCreateController().loadTemplate(templateId.longValue());
    }

    protected ITemplateManageController getOrCreateController() {
        if (this.controller == null) {
            this.controller = new TemplateManageController((ITemplateManageView)this);
        }
        return this.controller;
    }

    private void showTemplateBaseInfoPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fpm_templatebaseinfo");
        showParameter.setAppId("fpm");
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setCustomParam("source", (Object)TemplateManageBasePlugin.class.getName());
        showParameter.setCustomParam(TemplateBaseInfo.class.getName(), (Object)TemplateVOConverter.convertToBaseInfoModel((DynamicObject)this.getModel().getDataEntity(true)));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "baseinfoop"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    protected void showDimLayoutPage(TemplateLayout layout) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("fpm_dimlayout");
        showParameter.setAppId("fpm");
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setCustomParam(TemplateLayout.class.getName(), (Object)JSON.toJSONString((Object)layout));
        showParameter.setCustomParam("modelId", ((DynamicObject)this.getModel().getValue("model")).getPkValue());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "dimlayoutop"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.beforeShowDimLayoutPage(showParameter);
        this.getView().showForm(showParameter);
    }

    protected void beforeShowDimLayoutPage(FormShowParameter showParameter) {
        showParameter.getCustomParams().put("templateUses", this.getModel().getValue("templateuses"));
        showParameter.getCustomParams().put("maintable", this.getModel().getValue("ismaintable"));
    }

    private void fillMemberInfo(TreeDataSelectedReturnData returnData) {
        if (returnData != null) {
            List selectedPkList = returnData.getRightTreeIdSet().stream().map(e -> Long.valueOf(e)).collect(Collectors.toList());
            this.getModel().setValue("pagedimmember", (Object)selectedPkList.toArray());
            DynamicObjectCollection memberColl = (DynamicObjectCollection)this.getModel().getValue("pagedimmember");
            List selectedNameList = memberColl.stream().map(i -> i.getString("fbasedataid.name")).collect(Collectors.toList());
            this.getModel().setValue("pagedimmembertext", (Object)String.join((CharSequence)",", selectedNameList));
            this.getView().updateView("pagedimentry");
        }
    }

    private void initDefaultDisplayMemberF7() {
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("defaultdisplaymember");
        IDataModel model = this.getModel();
        DynamicObject modelValue = (DynamicObject)model.getValue("model");
        basedataEdit.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            int entryCurrentRowIndex = model.getEntryCurrentRowIndex("pagedimentry");
            DynamicObjectCollection entryEntity = model.getEntryEntity("pagedimentry");
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(entryCurrentRowIndex);
            DynamicObject dimension = dynamicObject.getDynamicObject("pagedim");
            String dimType = dimension.getString("basedata");
            String dimName = dimension.getString("name");
            List idList = dynamicObject.getDynamicObjectCollection("pagedimmember").stream().map(o -> o.getDynamicObject("fbasedataid")).map(o -> o.getLong("id")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(idList)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c%s\u201d\u7ef4\u5ea6\u7684\u6210\u5458\u3002", (String)"TemplateManageBasePlugin_6", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), dimName));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter filter = new QFilter("bodysystem", "=", modelValue.getPkValue());
            filter.and(new QFilter("id", "in", idList));
            filter.and(new QFilter("dimtype", "=", (Object)dimType));
            showParameter.getListFilterParameter();
            showParameter.setCaption(ResManager.loadKDString((String)"\u9ed8\u8ba4\u663e\u793a\u6210\u5458", (String)"TemplateManageBasePlugin_7", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
            showParameter.getListFilterParameter().setFilter(filter);
        });
    }

    protected void initViewReportTypeF7() {
        BasedataEdit viewReportType = (BasedataEdit)this.getControl("viewreporttype");
        viewReportType.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            DynamicObjectCollection reportType = (DynamicObjectCollection)this.getModel().getDataEntity(true).get("reporttypeentry");
            List idList = reportType.stream().map(o -> o.getDynamicObject("e_reporttype")).map(o -> o.getLong("id")).collect(Collectors.toList());
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", idList));
        });
    }

    protected void showMemberTreeCustomF7(DimsionEnums dimEnum, String prop, List<Object> selectedIdList, TreeDataSelectedCascadeType treeDataSelectedCascadeType, TreeDataSelectedType treeDataSelectedType) {
        this.showMemberTreeCustomF7(dimEnum, prop, selectedIdList, treeDataSelectedCascadeType, treeDataSelectedType, 0L);
    }

    protected void showMemberTreeCustomF7(DimsionEnums dimEnum, String prop, List<Object> selectedIdList, TreeDataSelectedCascadeType treeDataSelectedCascadeType, TreeDataSelectedType treeDataSelectedType, Long dimensionId) {
        Object modelId = ((DynamicObject)this.getModel().getValue("model")).getPkValue();
        if (this.showOrgMemberByDimLocation(dimEnum, prop, selectedIdList, treeDataSelectedCascadeType, treeDataSelectedType)) {
            return;
        }
        DimMemberHelper.buildMemberTreeCustomF7(dimEnum, Long.valueOf(modelId.toString()), (AbstractFormPlugin)this, prop, selectedIdList, treeDataSelectedCascadeType, treeDataSelectedType, dimensionId);
    }

    protected boolean showOrgMemberByDimLocation(DimsionEnums dimEnum, String prop, List<Object> selectedIdList, TreeDataSelectedCascadeType treeDataSelectedCascadeType, TreeDataSelectedType treeDataSelectedType) {
        String templateUse = (String)this.getModel().getValue("templateuses");
        if (!Objects.equals(templateUse, TemplateUsesEnum.SUMMARY.getValue()) || dimEnum != DimsionEnums.ORG) {
            return false;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("layoutentry");
        DynamicObject dy = entryEntity.stream().filter(dynamicObject -> Objects.equals(dynamicObject.getDynamicObject("layoutdim").getString("number"), dimEnum.getNumber())).findFirst().get();
        Long modelId = (Long)((DynamicObject)this.getModel().getValue("model")).getPkValue();
        String memberScope = dy.getString("memberscope");
        if (Objects.equals(memberScope, DimensionMemberScopeEnum.FIXED_MEMBER.getValue())) {
            DimMemberHelper.buildMemberTreeCustomF7(DimMemberHelper.memberTreeCustomParamBuilder().filterDisable(true).modelId(modelId).dimensionId((Long)dy.getDynamicObject("layoutdim").getPkValue()).plugin((AbstractFormPlugin)this).dimensionEnum(dimEnum).key(prop).treeDataSelectedCascadeType(treeDataSelectedCascadeType).treeDataSelectedType(treeDataSelectedType).selectedIds(selectedIdList).build());
        }
        return true;
    }

    protected void afterInitTemplate() {
    }
}

