/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.tree;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.formplugin.template.dimmember.TreeDataSelectedPlugin;

public class OrgSysImportPlugin
extends TreeDataSelectedPlugin {
    private static final String COMBOFIELD = "combofield";
    private static final String CAPORGTREETYPE = "08";
    private static final String CAPORGTREEVIEW = "08";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"baritemconfirm", "baritemcancel"});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("baritemconfirm".equals(key)) {
            this.getView().invokeOperation("confirmop");
        } else if ("baritemcancel".equals(key)) {
            this.getView().close();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        if (COMBOFIELD.equals(fieldKey)) {
            this.refreshLeftTreeData();
            this.refreshRightTreeData();
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        this.initCombo();
        super.afterCreateNewData(e);
    }

    private void initCombo() {
        String modelId = this.getView().getFormShowParameter().getCustomParam("bodysystem").toString();
        DynamicObject tBasedataBiz = BusinessDataServiceHelper.loadSingle((String)"fpm_dimension", (String)"basedatabiz", (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", (Object)Long.valueOf(modelId)).and(new QFilter("basedata", "=", (Object)DimsionEnums.ORG.getNumber()))});
        QFilter qFilter = tBasedataBiz != null && tBasedataBiz.getDynamicObject("basedatabiz") != null && tBasedataBiz.getDynamicObject("basedatabiz").getString("fnumber") != null ? new QFilter("treetype", "=", (Object)tBasedataBiz.getDynamicObject("basedatabiz").getString("fnumber")) : new QFilter("treetype", "=", (Object)"08");
        DynamicObjectCollection relcaporgviews = QueryServiceHelper.query((String)"bos_org_viewschema", (String)"id,number,name,isdefault", (QFilter[])new QFilter[]{qFilter}, (String)"isdefault desc");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(relcaporgviews.size());
        ComboItem selectedItem = null;
        ComboItem comboItem = null;
        for (DynamicObject relcaporgview : relcaporgviews) {
            comboItem = new ComboItem();
            comboItem.setValue(relcaporgview.getString("number"));
            comboItem.setCaption(new LocaleString(relcaporgview.getString("name")));
            comboItems.add(comboItem);
            if (selectedItem != null || !relcaporgview.getBoolean("isdefault")) continue;
            selectedItem = comboItem;
        }
        ComboEdit combofield = (ComboEdit)this.getControl(COMBOFIELD);
        combofield.setComboItems(comboItems);
        if (selectedItem != null) {
            this.getModel().setValue(COMBOFIELD, (Object)selectedItem.getValue());
        }
    }

    @Override
    protected QFilter getLeftQFilter() {
        String viewNumber = this.getModel().getValue(COMBOFIELD).toString();
        if (viewNumber == null || viewNumber.length() < 1) {
            viewNumber = "08";
        }
        QFilter qFilter = new QFilter("view.number", "=", (Object)viewNumber);
        qFilter.and(super.getLeftQFilter());
        return qFilter;
    }
}

