/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.formplugin.tree;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.FlowType;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.common.enums.DimsionEnums;
import kd.tmc.fpm.common.enums.WaysEnum;
import kd.tmc.fpm.common.result.TreeDataSelectedNode;
import kd.tmc.fpm.common.result.TreeDataSelectedReturnData;
import kd.tmc.fpm.formplugin.tree.DimSysImportPlugin;

public class SubjectSysImportEditPlugin
extends DimSysImportPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (operateKey.equals("confirmop")) {
            TreeDataSelectedReturnData returnData = this.getSelectedReturnData();
            List<DynamicObject> subjectDyList = this.nodeToDynamicObjectList(returnData);
            String modelId = this.getView().getFormShowParameter().getCustomParam("bodysystem").toString();
            String dimIdStr = (String)this.getView().getFormShowParameter().getCustomParam("dimensionId");
            QFilter qFilter = new QFilter("bodysystem", "=", (Object)Long.valueOf(modelId)).and("dimtype", "=", (Object)DimsionEnums.SUBJECT.getNumber()).and("dimension", "=", (Object)Long.valueOf(dimIdStr));
            DynamicObjectCollection dbSubjectDyColl = QueryServiceHelper.query((String)"fpm_member", (String)String.join((CharSequence)",", "id", "parent.id", "flow"), (QFilter[])qFilter.toArray());
            subjectDyList.addAll((Collection<DynamicObject>)dbSubjectDyColl);
            Map accountMemberMap = subjectDyList.stream().collect(Collectors.toMap(key -> key.getLong("id"), Function.identity(), (a, b) -> a));
            Map<Long, List<Object>> parent2AccountMemberMap = subjectDyList.stream().filter(subject -> EmptyUtil.isNoEmpty((Long)subject.getLong("parent.id"))).collect(Collectors.groupingBy(key -> ((DynamicObject)key).getLong("parent.id")));
            boolean isInvalidFlowType = subjectDyList.stream().anyMatch(dataEntity -> this.isInvalidFlowTypeByParentSubject((DynamicObject)dataEntity, accountMemberMap));
            boolean bl = isInvalidFlowType = isInvalidFlowType || subjectDyList.stream().anyMatch(dataEntity -> this.isInvalidFlowTypeBySubSubject((DynamicObject)dataEntity, parent2AccountMemberMap));
            if (isInvalidFlowType) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u4e0b\u7ea7\u79d1\u76ee\u7684\u6d41\u5411\u4e0d\u80fd\u76f8\u53cd\uff0c\u8bf7\u4fee\u6539", (String)"SubjectSysImportEditPlugin_1", (String)"tmc-fpm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    private List<DynamicObject> nodeToDynamicObjectList(TreeDataSelectedReturnData returnData) {
        DynamicObject parent;
        Long realId;
        ArrayList<DynamicObject> newMemberList = new ArrayList<DynamicObject>(0);
        List tRightNodeList = returnData.getRightNodeList().stream().filter(TreeDataSelectedNode::isNew).collect(Collectors.toList());
        if (tRightNodeList.size() < 1) {
            return newMemberList;
        }
        String dimNumber = this.getView().getFormShowParameter().getCustomParam("number").toString();
        String dimIdStr = (String)this.getView().getFormShowParameter().getCustomParam("dimensionId");
        DimsionEnums dimEnums = DimsionEnums.getDimsionByNumber((String)dimNumber);
        String metadata = dimEnums.getMetadata();
        String modelId = this.getView().getFormShowParameter().getCustomParam("bodysystem").toString();
        DynamicObject bodySysManager = BusinessDataServiceHelper.newDynamicObject((String)"fpm_bodysysmanage");
        bodySysManager.set("id", (Object)Long.valueOf(modelId));
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"cas_fundflowitem", (String)"id,direction", (QFilter[])new QFilter[]{new QFilter("id", "in", tRightNodeList.stream().map(item -> Long.valueOf(item.getId())).collect(Collectors.toList()))});
        Map tFundFlowMap = queryResult.stream().collect(Collectors.toMap(item -> item.getString("id"), Function.identity(), (key1, key2) -> key2));
        long[] newIDArr = DB.genLongIds((String)EntityMetadataCache.getDataEntityType((String)metadata).getAlias(), (int)tRightNodeList.size());
        Deque newIdQueue = Arrays.stream(newIDArr).boxed().collect(Collectors.toCollection(LinkedList::new));
        HashMap<Long, Long> realIdMap = new HashMap<Long, Long>(newIdQueue.size());
        for (TreeDataSelectedNode tRightNode : tRightNodeList) {
            DynamicObject treeMem = BusinessDataServiceHelper.newDynamicObject((String)metadata);
            realId = (Long)newIdQueue.poll();
            treeMem.set("id", (Object)realId);
            realIdMap.put(Long.valueOf(tRightNode.getId()), realId);
            treeMem.set("number", (Object)tRightNode.getNumber());
            treeMem.set("name", (Object)tRightNode.getName());
            treeMem.set("fullname", (Object)tRightNode.getName());
            treeMem.set("enable", (Object)BaseEnableEnum.ENABLE.getValue());
            treeMem.set("masterid", (Object)Long.valueOf(tRightNode.getId()));
            treeMem.set("bodysystem", (Object)bodySysManager);
            treeMem.set("dimtype", (Object)dimEnums.getNumber());
            treeMem.set("serial", (Object)System.nanoTime());
            treeMem.set("level", (Object)tRightNode.getLevel());
            treeMem.set("isleaf", (Object)tRightNode.isLeaf());
            if (tRightNode.getParentId() != null && tRightNode.getParentId().length() > 0) {
                parent = BusinessDataServiceHelper.newDynamicObject((String)metadata);
                parent.set("id", (Object)Long.valueOf(tRightNode.getParentId()));
                treeMem.set("parent", (Object)parent);
                treeMem.set("sourceparentid", (Object)Long.valueOf(tRightNode.getParentId()));
            }
            treeMem.set("sourceid", (Object)Long.valueOf(tRightNode.getId()));
            treeMem.set("dimension", (Object)Long.valueOf(dimIdStr));
            treeMem.set("bodysysmanage", (Object)bodySysManager);
            DynamicObject fundflowitem = (DynamicObject)tFundFlowMap.get(tRightNode.getId());
            if (fundflowitem != null) {
                treeMem.set("flow", (Object)fundflowitem.getString("direction"));
            }
            if (tRightNode.isLeaf()) {
                treeMem.set("ways", (Object)WaysEnum.MANUAL_INPUT.getValue());
            } else {
                treeMem.set("ways", (Object)WaysEnum.SUMMARY_ITEM.getValue());
            }
            newMemberList.add(treeMem);
        }
        ArrayList<DynamicObject> updateMemberList = new ArrayList(newMemberList.size());
        for (DynamicObject newMember : newMemberList) {
            realId = (Long)realIdMap.get(newMember.getLong("parent.id"));
            if (realId != null) {
                parent = BusinessDataServiceHelper.newDynamicObject((String)metadata);
                parent.set("id", (Object)realId);
                newMember.set("parent", (Object)parent);
            }
            updateMemberList.add(newMember);
        }
        updateMemberList = updateMemberList.stream().sorted(Comparator.comparingInt(v -> v.getInt("level"))).collect(Collectors.toList());
        return updateMemberList;
    }

    private boolean isInvalidFlowTypeByParentSubject(DynamicObject subjectMember, Map<Long, Object> accountMemberMap) {
        String flow = subjectMember.getString("flow");
        HashSet<Long> checkedSubjectIdSet = new HashSet<Long>(8);
        Long currParentId = subjectMember.getLong("parent.id");
        while (EmptyUtil.isNoEmpty((Long)currParentId) && !checkedSubjectIdSet.contains(currParentId)) {
            Long nextParentId = null;
            if (accountMemberMap.containsKey(currParentId)) {
                String parentFlow;
                Object parentSubjectObj = accountMemberMap.get(currParentId);
                if (parentSubjectObj instanceof DynamicObject) {
                    parentFlow = ((DynamicObject)parentSubjectObj).getString("flow");
                    nextParentId = ((DynamicObject)parentSubjectObj).getLong("parent.id");
                } else {
                    parentFlow = ((AccountMember)parentSubjectObj).getFlowType().getNumber();
                    nextParentId = ((AccountMember)parentSubjectObj).getParentId();
                }
                if (FlowType.isOppositeFlowType((String)flow, (String)parentFlow)) {
                    return true;
                }
                checkedSubjectIdSet.add(currParentId);
            }
            currParentId = nextParentId;
        }
        return false;
    }

    private boolean isInvalidFlowTypeBySubSubject(DynamicObject subjectMember, Map<Long, List<Object>> parent2AccountMemberMap) {
        Long currSubjectId;
        String flow = subjectMember.getString("flow");
        Long subjectId = subjectMember.getLong("id");
        HashSet<Long> checkedSubjectIdSet = new HashSet<Long>(8);
        ArrayDeque<Long> stack = new ArrayDeque<Long>(10);
        stack.push(subjectId);
        while (!stack.isEmpty() && !checkedSubjectIdSet.contains(currSubjectId = (Long)stack.pop())) {
            checkedSubjectIdSet.add(currSubjectId);
            if (!parent2AccountMemberMap.containsKey(currSubjectId)) continue;
            List<Object> subSubjectList = parent2AccountMemberMap.get(currSubjectId);
            for (Object subSubject : subSubjectList) {
                String subSubjectFlow;
                Long subSubjectId;
                if (subSubject instanceof DynamicObject) {
                    subSubjectId = ((DynamicObject)subSubject).getLong("id");
                    subSubjectFlow = ((DynamicObject)subSubject).getString("flow");
                } else {
                    subSubjectId = ((AccountMember)subSubject).getId();
                    subSubjectFlow = ((AccountMember)subSubject).getFlowType().getNumber();
                }
                if (FlowType.isOppositeFlowType((String)flow, (String)subSubjectFlow)) {
                    return true;
                }
                stack.push(subSubjectId);
            }
        }
        return false;
    }
}

