/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.utils.control;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ControlWayUtil {
    public static Tuple<Boolean, String> checkBeforeEnable(Object pkId) {
        DynamicObject[] dynamicObjects = TmcDataServiceHelper.loadFromCache((Object[])new Object[]{pkId}, (String)"fpm_controlwayconfig").values().toArray(new DynamicObject[0]);
        DynamicObject dynamicObject = dynamicObjects[0];
        DynamicObjectCollection orgColl = dynamicObject.getDynamicObjectCollection("entryentity");
        return ControlWayUtil.checkIfExist(dynamicObject, orgColl);
    }

    public static Tuple<Boolean, String> checkBeforeSave(DynamicObject dataEntity, DynamicObjectCollection orgColl) {
        Tuple result = new Tuple((Object)Boolean.TRUE, null);
        boolean enable = dataEntity.getBoolean("enable");
        if (!enable) {
            return result;
        }
        return ControlWayUtil.checkIfExist(dataEntity, orgColl);
    }

    public static DynamicObjectCollection queryControlWay(Object systemId, DynamicObjectCollection orgColl) {
        QFilter orgFilter;
        if (EmptyUtil.isEmpty((DynamicObjectCollection)orgColl)) {
            orgFilter = new QFilter("entryentity.entry_reportorg", "=", null);
        } else {
            List orgPkIdList = orgColl.stream().map(dynamicObject -> dynamicObject.get("entry_reportorg.id")).collect(Collectors.toList());
            orgFilter = new QFilter("entryentity.entry_reportorg", "in", orgPkIdList);
        }
        String selectFields = String.join((CharSequence)",", "id", "number");
        QFilter qFilter = new QFilter("enable", "=", (Object)"1").and(new QFilter("bodysys", "=", systemId)).and(orgFilter);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_controlwayconfig", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        return query;
    }

    public static List<Object> getNeedDisablePkIdList(Object pkId) {
        DynamicObject[] dynamicObjects = TmcDataServiceHelper.loadFromCache((Object[])new Object[]{pkId}, (String)"fpm_controlwayconfig").values().toArray(new DynamicObject[0]);
        DynamicObject dynamicObject = dynamicObjects[0];
        DynamicObjectCollection orgColl = dynamicObject.getDynamicObjectCollection("entryentity");
        return ControlWayUtil.getNeedDisablePkIdList(dynamicObjects[0], orgColl);
    }

    public static List<Object> getNeedDisablePkIdList(DynamicObject dataEntity, DynamicObjectCollection orgColl) {
        DynamicObject bodySys = dataEntity.getDynamicObject("bodysys");
        DynamicObjectCollection query = ControlWayUtil.queryControlWay(bodySys.getPkValue(), orgColl);
        return query.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
    }

    public static Tuple<Boolean, String> checkIfExist(DynamicObject dataEntity, DynamicObjectCollection orgColl) {
        Tuple result = new Tuple((Object)Boolean.TRUE, null);
        String number = dataEntity.getString("number");
        DynamicObject bodySys = dataEntity.getDynamicObject("bodysys");
        DynamicObjectCollection objectCollection = dataEntity.getDynamicObjectCollection("reporttype");
        Map reportTypeMap = objectCollection.stream().map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid")).collect(Collectors.toMap(dynamicObject -> dynamicObject.getPkValue(), Function.identity()));
        DynamicObjectCollection query = ControlWayUtil.queryControlWay(bodySys.getPkValue(), orgColl);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)query)) {
            return result;
        }
        if (query.size() != 0 && StringUtils.equals((CharSequence)((DynamicObject)query.get(0)).getString("number"), (CharSequence)number)) {
            return result;
        }
        DynamicObject[] load = TmcDataServiceHelper.loadFromCache((Object[])query.stream().map(dy -> dy.getLong("id")).toArray(), (String)"fpm_controlwayconfig").values().toArray(new DynamicObject[0]);
        Object existsReportTypeId = Arrays.stream(load).flatMap(dynamicObject -> dynamicObject.getDynamicObjectCollection("reporttype").stream()).map(dynamicObject -> dynamicObject.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).filter(reportTypeMap::containsKey).findFirst().orElse(0L);
        if (EmptyUtil.isEmpty((Object)existsReportTypeId)) {
            return result;
        }
        return new Tuple((Object)Boolean.FALSE, (Object)ControlWayUtil.attemptMsg(orgColl, load, number, (DynamicObject)reportTypeMap.get(existsReportTypeId)));
    }

    public static String attemptMsg(DynamicObjectCollection orgColl, DynamicObject[] load, String number, DynamicObject existReportType) {
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)orgColl)) {
            List objectList = orgColl.stream().map(dynamicObject -> dynamicObject.get("entry_reportorg.id")).collect(Collectors.toList());
            DynamicObject existObj = Arrays.stream(load).filter(obj -> !StringUtils.equals((CharSequence)number, (CharSequence)obj.getString("number"))).filter(dynamicObject -> dynamicObject.getDynamicObjectCollection("reporttype").stream().map(reportDy -> reportDy.getDynamicObject("fbasedataid")).map(DataEntityBase::getPkValue).collect(Collectors.toSet()).contains(existReportType.getPkValue())).filter(dynamicObject -> dynamicObject.getDynamicObjectCollection("entryentity").stream().map(entry -> entry.getDynamicObject("entry_reportorg")).anyMatch(reportOrg -> objectList.contains(reportOrg.getPkValue()))).findFirst().get();
            return String.format(ResManager.loadKDString((String)"\u7f16\u62a5\u4e3b\u4f53\u3010%1$s\u3011\u7f16\u62a5\u7c7b\u578b\u3010%2$s\u3011\u5df2\u5b58\u5728\u53ef\u7528\u7684\u63a7\u5236\u7b56\u7565\u3010%3$s\u3011\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u7ee7\u7eed\uff0c\u786e\u5b9a\u540e\u4f1a\u5c06\u5386\u53f2\u7684\u63a7\u5236\u7b56\u7565\u81ea\u52a8\u7981\u7528", (String)"ControlWayConfigEdit_11", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), existObj.getDynamicObjectCollection("entryentity").stream().map(dynamicObject -> dynamicObject.getDynamicObject("entry_reportorg")).filter(dynamicObject -> objectList.contains(dynamicObject.getPkValue())).map(dynamicObject -> dynamicObject.getString("name")).collect(Collectors.joining(",")), existReportType.getString("name"), existObj.getString("number"));
        }
        return String.format(ResManager.loadKDString((String)"\u7f16\u62a5\u7c7b\u578b\u3010%1$s\u3011\u5df2\u5b58\u5728\u53ef\u7528\u7684\u63a7\u5236\u7b56\u7565\u3010%2$s\u3011\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u7ee7\u7eed\uff0c\u786e\u5b9a\u540e\u4f1a\u5c06\u5386\u53f2\u7684\u63a7\u5236\u7b56\u7565\u81ea\u52a8\u7981\u7528", (String)"ControlWayConfigEdit_10", (String)"tmc-fpm-formplugin", (Object[])new Object[0]), existReportType.getString("name"), load[0].getString("number"));
    }
}

