/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.utils.report;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.mq.TMCMQPublisher;
import kd.tmc.fpm.business.mq.TMCMQSendDTO;
import kd.tmc.fpm.business.utils.ListHelper;
import kd.tmc.fpm.common.enums.MQBusinessTypeEnum;
import kd.tmc.fpm.common.enums.OrgReportTypeCycleEnum;

public class ReportPrepareHelper {
    public static void generateHistoryReport(ListSelectedRowCollection returnData, Long reportPrepareId, IFormView iFormView) {
        if (EmptyUtil.isEmpty((Collection)returnData)) {
            return;
        }
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"fpm_reportpreparation", (String)"bodysysmanage", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reportPrepareId)});
        if (dynamicObject == null) {
            return;
        }
        String historyPeriodMemberIds = returnData.stream().map(ListSelectedRow::getPrimaryKeyValue).map(Object::toString).collect(Collectors.joining(","));
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("reportPrepareId", reportPrepareId.toString());
        params.put("historyPeriodMemberIds", historyPeriodMemberIds);
        String content = SerializationUtils.toJsonString(params);
        ReportPrepareHelper.publishGenReport(content);
        iFormView.showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5f00\u59cb\u6267\u884c\u751f\u6210\u8d44\u91d1\u8ba1\u5212\u5355\u636e\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u3002", (String)"ReportPreparationGenMqService_1", (String)"tmc-fpm-business", (Object[])new Object[0]));
    }

    private static void publishGenReport(Object content) {
        TMCMQPublisher tmcmqPublisher = new TMCMQPublisher();
        TMCMQSendDTO tmcmqSendDTO = new TMCMQSendDTO();
        tmcmqSendDTO.setAppId("fpm");
        tmcmqSendDTO.setBusinessType(MQBusinessTypeEnum.GEN_FIXED_FREQ_REPORT);
        tmcmqSendDTO.setMsgContent(content);
        tmcmqSendDTO.setTopicName("fpm.fpm_queue");
        tmcmqPublisher.sendMsg(tmcmqSendDTO);
    }

    public static Date getCurrentAndBeforeDate(Long systemId, Long reportTypeId, String reportTypePeriodType) {
        List list = ListHelper.asList((Object[])new String[]{reportTypePeriodType});
        if (Objects.equals(OrgReportTypeCycleEnum.WEEK.getValue(), reportTypePeriodType)) {
            list.add(PeriodType.YEAR_WEEK.getNumber());
        }
        Date currentDate = DateUtils.getCurrentDate();
        QFilter qFilter = new QFilter("bodysystem", "=", (Object)systemId).and("reporttype", "=", (Object)reportTypeId).and("periodtype", "in", (Object)list).and("enddate", ">=", (Object)currentDate).and("startdate", "<=", (Object)currentDate);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_member", (String)"enddate", (QFilter[])new QFilter[]{qFilter}, (String)"enddate", (int)1);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)query)) {
            return currentDate;
        }
        DynamicObject dynamicObject = (DynamicObject)query.get(0);
        return dynamicObject.getDate("enddate");
    }
}

