/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.utils.system;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fpm.common.helper.ModelHelper;

public class DefaultModelHelper {
    public static Long getBaseDataDefaultSystemId() {
        return DefaultModelHelper.getDefaultSystemIfExist(ModelHelper.getAuthModelId());
    }

    public static Long getAnalysisReportDefaultSystemId(String appId, String entityId) {
        List systemIdList = ModelHelper.getSystemAuthScopeWithCheckManager((String)appId, (String)entityId);
        return DefaultModelHelper.getDefaultSystemIfExist(systemIdList);
    }

    public static Long getDefaultSystemIfExist(List<Long> systemIds) {
        Long result = null;
        if (systemIds.size() > 0) {
            Long defaultSystemId = DefaultModelHelper.queryDefaultSystemId();
            result = defaultSystemId != null && systemIds.contains(defaultSystemId) ? defaultSystemId : systemIds.get(0);
        }
        return result;
    }

    public static Long queryDefaultSystemId() {
        Long userId = RequestContext.get().getCurrUserId();
        QFilter qFilter = new QFilter("user.id", "=", (Object)userId);
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"fpm_default_system", (String)"defaultsystemid", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObject == null) {
            return null;
        }
        return dynamicObject.getLong("defaultsystemid");
    }

    public static void save(Long systemId) {
        if (DefaultModelHelper.existDefaultSystemId()) {
            DefaultModelHelper.update(systemId);
        } else {
            DefaultModelHelper.insert(systemId);
        }
    }

    private static void insert(Long systemId) {
        Long userId = RequestContext.get().getCurrUserId();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"fpm_default_system");
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)entityType);
        dynamicObject.set("user", (Object)userId);
        dynamicObject.set("defaultsystemid", (Object)systemId);
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set("creator", (Object)userId);
        dynamicObject.set("modifier", (Object)userId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    private static void update(Long systemId) {
        Long userId = RequestContext.get().getCurrUserId();
        QFilter qFilter = new QFilter("user.id", "=", (Object)userId);
        String selectFields = String.join((CharSequence)",", "defaultsystemid", "id", "modifier", "modifytime");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"fpm_default_system", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        dynamicObject.set("defaultsystemid", (Object)systemId);
        dynamicObject.set("modifier", (Object)userId);
        dynamicObject.set("modifytime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
    }

    public static boolean existDefaultSystemId() {
        Long userId = RequestContext.get().getCurrUserId();
        QFilter qFilter = new QFilter("user.id", "=", (Object)userId);
        return QueryServiceHelper.exists((String)"fpm_default_system", (QFilter[])new QFilter[]{qFilter});
    }
}

