/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.common.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.orm.query.QFilter;

public class FpmHelper {
    public static QFilter getQFilterByKey(List<QFilter> qFilterList, String key) {
        for (QFilter qFilter : qFilterList) {
            ArrayList<QFilter> allDataList = new ArrayList<QFilter>(16);
            FpmHelper.getAllQFilter(qFilter, allDataList);
            Optional<QFilter> first = allDataList.stream().filter(item -> item.getProperty().equals(key)).findFirst();
            if (!first.isPresent()) continue;
            return first.get();
        }
        return null;
    }

    public static QFilter containQFilterByKey(List<QFilter> qFilterList, String key) {
        for (QFilter qFilter : qFilterList) {
            ArrayList<QFilter> allDataList = new ArrayList<QFilter>(16);
            FpmHelper.getAllQFilter(qFilter, allDataList);
            Optional<QFilter> first = allDataList.stream().filter(item -> item.getProperty().contains(key)).findFirst();
            if (!first.isPresent()) continue;
            return first.get();
        }
        return null;
    }

    public static QFilter getQFilterByKeyAndCp(List<QFilter> qFilterList, String key, String cp) {
        for (QFilter qFilter : qFilterList) {
            ArrayList<QFilter> allDataList = new ArrayList<QFilter>(16);
            FpmHelper.getAllQFilter(qFilter, allDataList);
            Optional<QFilter> first = allDataList.stream().filter(item -> item.getProperty().equals(key) && item.getCP().equals(cp)).findFirst();
            if (!first.isPresent()) continue;
            return first.get();
        }
        return null;
    }

    public static void getAllQFilter(QFilter qFilter, List<QFilter> qFilterList) {
        qFilterList.add(qFilter);
        List nests = qFilter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            QFilter filter = nest.getFilter();
            FpmHelper.getAllQFilter(filter, qFilterList);
        }
    }

    public static void getAllQFilterByKey(QFilter qFilter, String key, List<QFilter> qFilterList) {
        if (qFilter.getProperty().equals(key)) {
            qFilterList.add(qFilter);
        }
        List nests = qFilter.getNests(true);
        for (QFilter.QFilterNest nest : nests) {
            QFilter filter = nest.getFilter();
            if (filter.getProperty().equals(key)) {
                qFilterList.add(filter);
            }
            FpmHelper.getAllQFilterByKey(filter, key, qFilterList);
        }
    }

    public static Set<String> getEntryPropertyS(String entryName, String entry) {
        return FpmHelper.getEntryPropertyS(entryName, Collections.singletonList(entry)).get(entry);
    }

    public static Map<String, Set<String>> getEntryPropertyS(String entryName, List<String> entrys) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(entrys.size());
        Map allEntities = EntityMetadataCache.getDataEntityType((String)entryName).getAllEntities();
        for (String entry : entrys) {
            Set propSet = ((EntityType)allEntities.get(entry)).getFields().values().stream().map(d -> entry + "." + d.getName()).collect(Collectors.toSet());
            map.put(entry, propSet);
        }
        return map;
    }
}

