/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.common.trace.impl;

import java.util.Map;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;
import kd.tmc.fpm.common.trace.ITicker;
import kd.tmc.fpm.common.trace.Tick;

public class FpmTraceSpan
implements IFpmTraceSpan {
    private static final ThreadLocal<FpmTraceSpan> CURR = new ThreadLocal();
    private String name;
    private IFpmTracer tracer;
    private FpmTraceSpan parent;
    private ITicker ticker;
    private long startTime;
    private long totalCost;
    private boolean isRunning;

    public FpmTraceSpan(IFpmTracer tracer, String name) {
        this.tracer = tracer;
        this.name = name;
        this.startTime = System.nanoTime();
        this.ticker = ITicker.getInstance();
        FpmTraceSpan parent = CURR.get();
        if (parent != null) {
            this.parent = parent;
        }
        CURR.set(this);
        this.isRunning = true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addTag(String tag) {
        if (!this.ticker.isRunning()) {
            this.ticker.start();
        }
        this.ticker.tick(tag);
    }

    @Override
    public Map<String, Tick> getTickInfo() {
        return this.ticker.getTickInfo();
    }

    @Override
    public long getTotalCost() {
        return this.totalCost;
    }

    @Override
    public IFpmTraceSpan getParent() {
        return this.parent;
    }

    @Override
    public void close() {
        if (!this.isRunning) {
            return;
        }
        if (this.ticker.isRunning()) {
            this.ticker.stop();
        }
        this.totalCost = System.nanoTime() - this.startTime;
        this.tracer.report(this);
        CURR.set(this.parent);
        this.isRunning = false;
    }
}

