/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.common.trace.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.tmc.fpm.common.trace.ITicker;
import kd.tmc.fpm.common.trace.Tick;

public class Ticker
implements ITicker {
    private Map<String, Tick> tickMap = new HashMap<String, Tick>();
    private boolean running;
    private String currKey;

    @Override
    public Map<String, Tick> getTickInfo() {
        return Collections.unmodifiableMap(this.tickMap);
    }

    @Override
    public void start() {
        this.running = true;
    }

    @Override
    public void tick(String key) {
        if (!this.running) {
            throw new IllegalStateException("Ticker is not running.");
        }
        this.running = true;
        Tick tick = this.getTick(key);
        if (this.currKey != null && !this.currKey.equals(key)) {
            this.getTick(this.currKey).pause();
            tick.start();
        } else if (!tick.isRunning()) {
            tick.start();
        } else {
            tick.tick();
        }
        this.currKey = key;
    }

    @Override
    public void stop() {
        if (!this.running) {
            throw new IllegalStateException("Ticker is not running.");
        }
        this.running = false;
        if (this.currKey != null) {
            Tick tick = this.getTick(this.currKey);
            tick.pause();
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    private Tick getTick(String key) {
        return this.tickMap.computeIfAbsent(key, o -> new Tick());
    }
}

