/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.common.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.spring.PropertyPreFilters;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;

public class FpmSerializeUtil {
    private static final Log logger = LogFactory.getLog(FpmSerializeUtil.class);

    public static String serialize(Object obj) {
        try {
            return SerializationUtils.serializeToBase64((Object)obj);
        }
        catch (Exception e) {
            logger.warn("serialize error: " + e.getMessage(), (Throwable)e);
            return JSON.toJSONString((Object)obj, (SerializerFeature[])FpmSerializeUtil.getSerializeFeature());
        }
    }

    public static String serializeJson(Object obj) {
        return JSON.toJSONString((Object)obj, (SerializerFeature[])FpmSerializeUtil.getSerializeFeature());
    }

    public static String serialize(Object obj, String[] excludeProperties) {
        PropertyPreFilters filters = new PropertyPreFilters();
        PropertyPreFilters.MySimplePropertyPreFilter excludeFilter = filters.addFilter();
        excludeFilter.addExcludes(excludeProperties);
        return JSON.toJSONString((Object)obj, (SerializeFilter)excludeFilter, (SerializerFeature[])FpmSerializeUtil.getSerializeFeature());
    }

    public static <T> T deserialize(String serializeStr, Class<T> clz) {
        if (EmptyUtil.isEmpty((String)serializeStr)) {
            return null;
        }
        try {
            return (T)SerializationUtils.deSerializeFromBase64((String)serializeStr);
        }
        catch (Exception e) {
            logger.warn("deserialize error: " + e.getMessage(), (Throwable)e);
            return (T)JSON.parseObject((String)serializeStr, clz, (Feature[])new Feature[]{Feature.SupportAutoType});
        }
    }

    public static <T> T deserializeJson(String serializeStr, Class<T> clz) {
        return (T)JSON.parseObject((String)serializeStr, clz, (Feature[])new Feature[]{Feature.SupportAutoType});
    }

    public static <T> T deepCopy(T bean, Class<T> clazz) {
        return FpmSerializeUtil.deserialize(FpmSerializeUtil.serialize(bean), clazz);
    }

    public static <T> List<T> deserializeList(String serializeStr, Class<T> clz) {
        try {
            return (List)SerializationUtils.deSerializeFromBase64((String)serializeStr);
        }
        catch (Exception e) {
            logger.warn("deserializeList error: " + e.getMessage(), (Throwable)e);
            return JSON.parseArray((String)serializeStr, clz);
        }
    }

    private static SerializerFeature[] getSerializeFeature() {
        return new SerializerFeature[]{SerializerFeature.IgnoreNonFieldGetter, SerializerFeature.WriteClassName, SerializerFeature.NotWriteRootClassName};
    }

    static {
        ParserConfig.getGlobalInstance().setAutoTypeSupport(true);
    }
}

