/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.common.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.utils.StringUtils;

public class NumberUtils {
    public static BigDecimal ONE_HUNDRED = new BigDecimal("100");

    public static boolean checkNumberAndKeyword(String number) {
        return NumberUtils.checkNumber(number) && NumberUtils.checkKeyword(number);
    }

    public static boolean checkNumber(String number) {
        if (!StringUtils.isEmpty((CharSequence)number)) {
            String regEx = number.length() == 1 ? "^[a-zA-Z0-9]" : "^[a-zA-Z0-9](?!.*?\\.\\.)[-a-zA-Z0-9_.]+$";
            Pattern pattern = Pattern.compile(regEx);
            Matcher matcher = pattern.matcher(number);
            return matcher.matches();
        }
        return false;
    }

    public static boolean checkKeyword(String number) {
        return Arrays.stream(new String[]{"all", "none", "other"}).noneMatch(number::equalsIgnoreCase);
    }

    public static boolean lessThan(BigDecimal a, BigDecimal b) {
        return a.compareTo(b) < 0;
    }

    public static boolean equals(BigDecimal a, BigDecimal b) {
        return a.compareTo(b) == 0;
    }

    public static boolean equalsZero(BigDecimal a) {
        return a.compareTo(BigDecimal.ZERO) == 0;
    }

    public static boolean notEquals(BigDecimal a, BigDecimal b) {
        return a.compareTo(b) != 0;
    }

    public static boolean greaterThan(BigDecimal a, BigDecimal b) {
        return a.compareTo(b) > 0;
    }

    public static boolean greaterEqualsThan(BigDecimal a, BigDecimal b) {
        return a.compareTo(b) > -1;
    }

    public static boolean lessEqualsThan(BigDecimal a, BigDecimal b) {
        return a.compareTo(b) < 1;
    }

    public static boolean lessThan(Long a, Long b) {
        return a.compareTo(b) < 0;
    }

    public static boolean equals(Long a, Long b) {
        return a.compareTo(b) == 0;
    }

    public static boolean equalsZero(Long a) {
        return a.compareTo(0L) == 0;
    }

    public static boolean notEquals(Long a, Long b) {
        return a.compareTo(b) != 0;
    }

    public static boolean greaterThan(Long a, Long b) {
        return a.compareTo(b) > 0;
    }

    public static boolean greaterEqualsThan(Long a, Long b) {
        return a.compareTo(b) > -1;
    }

    public static boolean lessEqualsThan(Long a, Long b) {
        return a.compareTo(b) < 1;
    }

    public static boolean lessThan(Integer a, Integer b) {
        return a.compareTo(b) < 0;
    }

    public static boolean equals(Integer a, Integer b) {
        return a.compareTo(b) == 0;
    }

    public static boolean equalsZero(Integer a) {
        return a.compareTo(0) == 0;
    }

    public static boolean notEquals(Integer a, Integer b) {
        return a.compareTo(b) != 0;
    }

    public static boolean greaterThan(Integer a, Integer b) {
        return a.compareTo(b) > 0;
    }

    public static boolean greaterEqualsThan(Integer a, Integer b) {
        return a.compareTo(b) > -1;
    }

    public static boolean lessEqualsThan(Integer a, Integer b) {
        return a.compareTo(b) < 1;
    }

    public static boolean isSamePositive(BigDecimal a, BigDecimal b) {
        return NumberUtils.greaterEqualsThan(a, BigDecimal.ZERO) && NumberUtils.greaterEqualsThan(b, BigDecimal.ZERO);
    }

    public static boolean isOnePlusAndOneMinus(BigDecimal a, BigDecimal b) {
        return NumberUtils.greaterThan(a, BigDecimal.ZERO) && NumberUtils.lessThan(b, BigDecimal.ZERO) || NumberUtils.lessThan(a, BigDecimal.ZERO) && NumberUtils.greaterThan(b, BigDecimal.ZERO);
    }

    public static boolean isNumber(Object value) {
        if (value == null) {
            return false;
        }
        return org.apache.commons.lang3.math.NumberUtils.isCreatable((String)value.toString());
    }

    public static BigDecimal getIntegerPart(BigDecimal amt) {
        return amt.setScale(0, RoundingMode.DOWN);
    }
}

