/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.util.StringUtils;
import kd.tmc.fpm.business.cache.IFpmPageCacheService;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;
import kd.tmc.fpm.common.utils.FpmSerializeUtil;
import org.apache.commons.collections.CollectionUtils;

public class FpmPageCacheService
implements IFpmPageCacheService,
Serializable {
    private String pageId;
    private transient Map<String, String> cacheMap = new HashMap<String, String>(16);
    private transient Set<String> changeSet = new HashSet<String>();
    private transient Set<String> removedKeys = new HashSet<String>();
    private transient String regionKey;
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("fpm-pageCache");

    public FpmPageCacheService(String pageId) {
        this.pageId = pageId;
        this.regionKey = CacheKeyUtil.getAcctId() + ".fpmPageCache." + this.pageId;
    }

    @Override
    public String getPageId() {
        return this.pageId;
    }

    @Override
    public void put(String key, String value) {
        this.putToLocalMap(key, value);
    }

    @Override
    public String get(String key) {
        if (this.cacheMap.containsKey(key)) {
            return this.cacheMap.get(key);
        }
        if (this.removedKeys.contains(key)) {
            return "";
        }
        String value = (String)cache.get(this.regionKey, key);
        this.cacheMap.put(key, value);
        return value;
    }

    @Override
    public void addList(String key, String[] value) {
        this.putToLocalMap(key, FpmSerializeUtil.serialize((Object)value));
    }

    @Override
    public String[] getList(String key) {
        if (this.cacheMap.containsKey(key)) {
            return FpmSerializeUtil.deserializeList((String)this.cacheMap.get(key), String.class).toArray(new String[0]);
        }
        String valueStr = (String)cache.get(this.regionKey, key);
        if (StringUtils.isEmpty((String)valueStr)) {
            return new String[0];
        }
        this.cacheMap.put(key, valueStr);
        List valueArr = FpmSerializeUtil.deserializeList((String)valueStr, String.class);
        return valueArr.toArray(new String[0]);
    }

    @Override
    public List<String[]> getList(List<String> keyS) {
        ArrayList<String[]> result = new ArrayList<String[]>(keyS.size());
        ArrayList<String> needLoadKeyS = new ArrayList<String>(keyS);
        for (String key : keyS) {
            if (!this.cacheMap.containsKey(key)) continue;
            result.add(FpmSerializeUtil.deserializeList((String)this.cacheMap.get(key), String.class).toArray(new String[0]));
            needLoadKeyS.remove(key);
        }
        List valueArr = cache.get(this.regionKey, needLoadKeyS.toArray(new String[0]));
        for (int i = 0; i < valueArr.size(); ++i) {
            result.add(FpmSerializeUtil.deserializeList((String)((String)valueArr.get(i)), String.class).toArray(new String[0]));
            this.cacheMap.put((String)needLoadKeyS.get(i), (String)valueArr.get(i));
        }
        return result;
    }

    @Override
    public void remove(String key) {
        this.removeLocalMap(key);
    }

    @Override
    public void remove(String[] keyS) {
        if (keyS == null || keyS.length == 0) {
            return;
        }
        for (String key : keyS) {
            this.remove(key);
        }
    }

    @Override
    public void batchCommit() {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan(this.getClass().getSimpleName());){
            span.addTag("Delete redisKey, size = " + this.removedKeys.size());
            if (CollectionUtils.isNotEmpty(this.removedKeys)) {
                cache.remove(this.regionKey, this.removedKeys.toArray(new String[0]));
            }
            if (CollectionUtils.isNotEmpty(this.changeSet)) {
                HashMap<String, String> changeMap = new HashMap<String, String>(16);
                for (String cacheKey : this.changeSet) {
                    changeMap.put(cacheKey, this.cacheMap.get(cacheKey));
                }
                Long totalLen = changeMap.values().stream().map(o -> o.length()).reduce(Math::addExact).orElse(0L);
                span.addTag("put" + totalLen / 1024L + "kb");
                cache.put(this.regionKey, changeMap, CacheKeyUtil.getPageCacheKeyTimeout(), TimeUnit.SECONDS);
            }
            this.removedKeys.clear();
            this.changeSet.clear();
        }
    }

    @Override
    public void removeAll() {
        cache.remove(this.regionKey);
        this.changeSet.clear();
        this.cacheMap.clear();
        this.removedKeys.clear();
    }

    @Override
    public void putDistValue(String key, String value) {
        cache.put(this.regionKey, key, (Object)value);
    }

    private <T> void putToLocalMap(String key, String value) {
        if (value == null) {
            this.removeLocalMap(key);
        } else if (!value.equals(this.cacheMap.get(key))) {
            this.cacheMap.put(key, value);
            this.changeSet.add(key);
            this.removedKeys.remove(key);
        }
    }

    public void removeLocalMap(String keyName) {
        this.cacheMap.remove(keyName);
        this.changeSet.remove(keyName);
        this.removedKeys.add(keyName);
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }
}

