/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.cache.data;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.common.enums.CellDimTypeEnum;
import kd.tmc.fpm.spread.widget.CellTypeEnum;
import kd.tmc.fpm.spread.widget.DisplayTypeEnum;
import kd.tmc.fpm.spread.widget.core.Cell;
import kd.tmc.fpm.spread.widget.style.CellStyleInfo;

public class CacheCell
extends Cell {
    public static final String PROP_DATA_ID = "dataId";
    public static final String PROP_VALUE = "value";
    public static final String PROP_CELL_TYPE = "cellType";
    public static final String PROP_WIDGET_VALUE = "widgetValue";
    public static final String PROP_SUMMARY = "summary";
    public static final String PROP_CELLDIMTYPE = "cellDimType";
    public static final String PROP_CELLSTYLEMARK = "cellStyleMark";
    public static final String PROP_SOURCEIDLIST = "sourceIdList";
    private Map<String, Object> valueMap = new HashMap<String, Object>(8);

    public static List<String> getFixReportCachePropList() {
        return Arrays.asList(PROP_DATA_ID, PROP_SOURCEIDLIST, PROP_CELL_TYPE, PROP_VALUE, PROP_SUMMARY, PROP_CELLDIMTYPE, PROP_CELLSTYLEMARK);
    }

    public static List<String> getDetailReportCachePropList() {
        return Arrays.asList(PROP_DATA_ID, PROP_SOURCEIDLIST, PROP_CELL_TYPE, PROP_VALUE, PROP_SUMMARY, PROP_WIDGET_VALUE, PROP_CELLDIMTYPE, PROP_CELLSTYLEMARK);
    }

    public static Object getCellValue(Cell cell, String prop) {
        switch (prop) {
            case "dataId": {
                return cell.getDataId();
            }
            case "value": {
                return cell.getValue();
            }
            case "cellType": {
                return cell.getCellType();
            }
            case "widgetValue": {
                return cell.getWidgetValue();
            }
            case "summary": {
                return cell.isSummary();
            }
            case "cellDimType": {
                return cell.getCellDimType();
            }
            case "cellStyleMark": {
                return cell.getCellStyleMark();
            }
            case "sourceIdList": {
                return cell.getSourceIdList();
            }
        }
        throw new IllegalArgumentException("Property " + prop + " not found");
    }

    public static void setCellValue(CacheCell cell, String prop, Object value) {
        switch (prop) {
            case "dataId": {
                if (value == null) break;
                cell.setDataId(value);
                break;
            }
            case "value": {
                cell.setValue(value);
                break;
            }
            case "cellType": {
                cell.setCellType((CellTypeEnum)value);
                break;
            }
            case "widgetValue": {
                cell.setWidgetValue(value);
                break;
            }
            case "summary": {
                cell.setSummary((Boolean)value);
                break;
            }
            case "cellDimType": {
                cell.setCellDimType((CellDimTypeEnum)value);
                break;
            }
            case "cellStyleMark": {
                cell.setCellStyleMark(value.toString());
                break;
            }
            case "sourceIdList": {
                cell.setSourceIdList((List)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Property " + prop + " not found");
            }
        }
    }

    public Object getPropValue(String prop) {
        return this.valueMap.get(prop);
    }

    public void setPropValue(String prop, Object value) {
        this.valueMap.put(prop, value);
    }

    public void setRowAndCol(int row, int col) {
        throw new UnsupportedOperationException();
    }

    public int getRow() {
        return super.getRow();
    }

    public void setRow(int row) {
        super.setRow(row);
    }

    public int getCol() {
        return super.getCol();
    }

    public void setCol(int col) {
        super.setCol(col);
    }

    public int getRowSpan() {
        return super.getRowSpan();
    }

    public void setRowSpan(int rowSpan) {
        super.setRowSpan(rowSpan);
    }

    public int getColSpan() {
        return super.getColSpan();
    }

    public void setColSpan(int colSpan) {
        super.setColSpan(colSpan);
    }

    public Object getDisplayValue() {
        Object displayValue = super.getDisplayValue();
        if (EmptyUtil.isEmpty((Object)displayValue)) {
            displayValue = this.getValue();
        }
        return displayValue;
    }

    public void setDisplayValue(Object displayValue) {
        super.setDisplayValue(displayValue);
    }

    public Object getNewValue() {
        return super.getNewValue();
    }

    public void setNewValue(Object newValue) {
        super.setNewValue(newValue);
    }

    public CellTypeEnum getCellType() {
        Object cellType = this.getPropValue(PROP_CELL_TYPE);
        if (cellType == null) {
            return null;
        }
        for (CellTypeEnum value : CellTypeEnum.values()) {
            if (!Objects.equals(cellType, value.ordinal())) continue;
            return value;
        }
        return null;
    }

    public void setCellType(CellTypeEnum cellType) {
        this.setPropValue(PROP_CELL_TYPE, cellType.ordinal());
    }

    public CellStyleInfo getStyleInfo() {
        return super.getStyleInfo();
    }

    public void setStyleInfo(CellStyleInfo styleInfo) {
        super.setStyleInfo(styleInfo);
    }

    public int getLevel() {
        throw new UnsupportedOperationException();
    }

    public void setLevel(int level) {
        throw new UnsupportedOperationException();
    }

    public Object getWidgetValue() {
        return this.getPropValue(PROP_WIDGET_VALUE);
    }

    public void setWidgetValue(Object widgetValue) {
        this.setPropValue(PROP_WIDGET_VALUE, widgetValue);
    }

    public Boolean isLock() {
        throw new UnsupportedOperationException();
    }

    public String getFormula() {
        throw new UnsupportedOperationException();
    }

    public void setFormula(String formula) {
        throw new UnsupportedOperationException();
    }

    public void setLock(Boolean lock) {
        throw new UnsupportedOperationException();
    }

    public DisplayTypeEnum getDisplayType() {
        throw new UnsupportedOperationException();
    }

    public void setDisplayType(DisplayTypeEnum displayType) {
        throw new UnsupportedOperationException();
    }

    public Object getValue() {
        Object propValue = this.getPropValue(PROP_VALUE);
        if (propValue instanceof Long && this.getPropValue(PROP_CELL_TYPE).equals(CellTypeEnum.DATE.ordinal())) {
            propValue = new Date((Long)propValue);
        }
        return propValue;
    }

    public void setValue(Object value) {
        if (value == null && this.getCellType() == CellTypeEnum.AMOUNT) {
            value = BigDecimal.ZERO;
        }
        this.setPropValue(PROP_VALUE, value);
    }

    public boolean isSummary() {
        Object summary = this.getPropValue(PROP_SUMMARY);
        return Objects.equals(1, summary);
    }

    public void setSummary(boolean summary) {
        this.setPropValue(PROP_SUMMARY, summary ? 1 : 0);
    }

    public CellDimTypeEnum getCellDimType() {
        Object cellDimType = this.getPropValue(PROP_CELLDIMTYPE);
        if (cellDimType == null) {
            return null;
        }
        for (CellDimTypeEnum value : CellDimTypeEnum.values()) {
            if (!Objects.equals(value.ordinal(), cellDimType)) continue;
            return value;
        }
        return null;
    }

    public void setCellDimType(CellDimTypeEnum cellDimType) {
        this.setPropValue(PROP_CELLDIMTYPE, cellDimType.ordinal());
    }

    public Object getDataId() {
        Object dataId = this.getPropValue(PROP_DATA_ID);
        return dataId;
    }

    public void setDataId(Object dataId) {
        this.setPropValue(PROP_DATA_ID, dataId);
    }

    public String getCellStyleMark() {
        return this.getPropValue(PROP_CELLSTYLEMARK).toString();
    }

    public void setCellStyleMark(String cellStyleMark) {
        this.setPropValue(PROP_CELLSTYLEMARK, cellStyleMark);
    }

    public List<Long> getSourceIdList() {
        return (List)this.getPropValue(PROP_SOURCEIDLIST);
    }

    public void setSourceIdList(List<Long> sourceIdList) {
        this.setPropValue(PROP_SOURCEIDLIST, sourceIdList);
    }
}

