/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.openapi.balancequery.factory;

import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.tmc.fpm.business.dataproc.openapi.model.AvailableReportData;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.model.control.ControlStrategyDetail;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.report.ReportData;

public class AvailableReportDataFactory {
    public static AvailableReportData getAvailableReportData(ReportData reportData, FundPlanSystem fundPlanSystem, ControlStrategyDetail controlStrategyDetail) {
        Dimension metricDim = fundPlanSystem.getMainDimensionByDimType(DimensionType.METRIC);
        Optional<MetricMember> first = metricDim.getAllDimMemberList().stream().map(MetricMember.class::cast).filter(metric -> metric.getTemplateMetricType() == TemplateMetricType.AVAILABLEAMT).findFirst();
        if (!first.isPresent()) {
            String message = String.format(ResManager.loadKDString((String)"\u4f53\u7cfb\u3010%1$s\u3011\u6ca1\u6709\u53ef\u7528\u989d\u5ea6\u7684\u5ea6\u91cf\u6307\u6807\u3002", (String)"AbstractBalanceQueryResultGenerator_0", (String)"tmc-fpm-business", (Object[])new Object[0]), fundPlanSystem.getName());
            throw new KDBizException(message);
        }
        return AvailableReportDataFactory.getAvailableReportData(reportData, first.get().getValStr(), controlStrategyDetail);
    }

    public static AvailableReportData getAvailableReportData(ReportData reportData, String formula, ControlStrategyDetail controlStrategyDetail) {
        AvailableReportData availableReportData = new AvailableReportData(reportData, formula);
        if (Objects.nonNull(controlStrategyDetail) && Objects.nonNull(controlStrategyDetail.getControlIntensity())) {
            Object dimValByDimType = reportData.getDimValByDimType(DimensionType.SUBJECTS);
            if (Objects.equals(controlStrategyDetail.getSubjectId(), dimValByDimType)) {
                availableReportData.setCoefficient(controlStrategyDetail.getControlCoefficient());
            }
        }
        return availableReportData;
    }
}

