/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.openapi.balancequery.generator.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.openapi.balancequery.factory.AvailableReportDataFactory;
import kd.tmc.fpm.business.dataproc.openapi.balancequery.generator.impl.AmountUnitConverterAvailableAmtCalculate;
import kd.tmc.fpm.business.dataproc.openapi.balancequery.generator.impl.DimensionInfoCacheManager;
import kd.tmc.fpm.business.dataproc.openapi.model.BalanceQueryAvailableResult;
import kd.tmc.fpm.business.dataproc.openapi.model.BalanceQueryDetailInfo;
import kd.tmc.fpm.business.dataproc.openapi.model.BalanceQueryResult;
import kd.tmc.fpm.business.dataproc.openapi.model.BalanceQueryResultDetail;
import kd.tmc.fpm.business.dataproc.openapi.model.DetailFieldDim;
import kd.tmc.fpm.business.dataproc.openapi.model.OptionDim;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.BillMatchRule;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.ReportPeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.mvc.converter.control.IConverter;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import kd.tmc.fpm.common.helper.StringHelper;

public class BalanceResultConverter
implements IConverter<List<BalanceQueryResult>, List<BalanceQueryDetailInfo>> {
    private ControlContext controlContext;
    private DimensionInfoCacheManager dimensionInfoCacheManager;
    AmountUnitConverterAvailableAmtCalculate amountUnitConverterAvailableAmtCalculate;
    private static final Log logger = LogFactory.getLog(BalanceResultConverter.class);

    public BalanceResultConverter(ControlContext controlContext) {
        this.controlContext = controlContext;
        this.dimensionInfoCacheManager = new DimensionInfoCacheManager();
        this.amountUnitConverterAvailableAmtCalculate = new AmountUnitConverterAvailableAmtCalculate();
    }

    @Override
    public List<BalanceQueryResult> convert(List<BalanceQueryDetailInfo> balanceQueryDetailInfoList) {
        HashMap<Long, BalanceQueryResult> balanceQueryResultMap = new HashMap<Long, BalanceQueryResult>(16);
        HashMap<BalanceQueryResult, Map> balanceQueryAvailableResultMap = new HashMap<BalanceQueryResult, Map>(16);
        for (BalanceQueryDetailInfo balanceQueryDetailInfo : balanceQueryDetailInfoList) {
            ControlExecuteParam controlExecuteParam = balanceQueryDetailInfo.getControlExecuteParam();
            List<ReportData> matchedReportDataList = balanceQueryDetailInfo.getMatchedReportDataList();
            if (EmptyUtil.isEmpty(matchedReportDataList)) {
                logger.warn("\u8d70\u5230\u8fd9\u91cc\u662f\u6709\u95ee\u9898\u7684\uff0c\u6ca1\u6709\u6570\u636e\u662f\u4e00\u5b9a\u4f1a\u62a5\u9519\u7684\u3002\u53c2\u6570\uff1a{}", (Object)controlExecuteParam);
                continue;
            }
            BillBizInfo billBizInfo = controlExecuteParam.getBillBizInfo();
            BillMatchRule matchRule = controlExecuteParam.getMatchRule();
            String mappingEntryNumber = matchRule.getMappingEntryNumber();
            String entityType = matchRule.getEntityType();
            Long key = this.getKey(billBizInfo);
            ReportData reportData = matchedReportDataList.get(0);
            FundPlanSystem system = this.controlContext.getSystem(balanceQueryDetailInfo.getSystemId());
            Dimension dimension = this.dimensionInfoCacheManager.getDimension(system, DimensionType.CURRENCY);
            Long currencyId = (Long)reportData.getDimValByDimensionId(dimension.getId());
            DimMember currencyMember = this.dimensionInfoCacheManager.getDimMember(dimension, currencyId);
            BalanceQueryResult balanceQueryResult = balanceQueryResultMap.computeIfAbsent(key, k -> {
                BalanceQueryResult result = new BalanceQueryResult();
                if (!Objects.equals(mappingEntryNumber, entityType)) {
                    result.setEntryId(billBizInfo.getEntryId());
                    result.setBizBillEntryName(mappingEntryNumber);
                }
                return result;
            });
            if (Objects.isNull(balanceQueryResult.getBalanceQueryAvailableResultList())) {
                balanceQueryResult.setBalanceQueryAvailableResultList(new ArrayList<BalanceQueryAvailableResult>(4));
            }
            List<BalanceQueryAvailableResult> balanceQueryAvailableResultList = balanceQueryResult.getBalanceQueryAvailableResultList();
            Map systemBalanceQueryAvailableResultMap = balanceQueryAvailableResultMap.computeIfAbsent(balanceQueryResult, k -> new HashMap(8));
            BalanceQueryAvailableResult balanceQueryAvailableResult = systemBalanceQueryAvailableResultMap.computeIfAbsent(balanceQueryDetailInfo.getSystemId(), k -> {
                BalanceQueryAvailableResult availableResult = new BalanceQueryAvailableResult();
                availableResult.setBodySysName(system.getName());
                availableResult.setBodySysNum(system.getNumber());
                availableResult.setCurrencyNum(currencyMember.getNumber());
                availableResult.setCurrencyName(currencyMember.getName());
                balanceQueryAvailableResultList.add(availableResult);
                return availableResult;
            });
            balanceQueryAvailableResult.updateAvailableAmt(balanceQueryDetailInfo.getAvailableAmt());
            balanceQueryAvailableResult.setOverage(balanceQueryAvailableResult.isOverage() || balanceQueryDetailInfo.isOverage());
            balanceQueryResult.setOverage(balanceQueryResult.isOverage() || balanceQueryDetailInfo.isOverage());
            this.fillDetail(balanceQueryResult, balanceQueryDetailInfo);
        }
        return new ArrayList<BalanceQueryResult>(balanceQueryResultMap.values());
    }

    private Long getKey(BillBizInfo billBizInfo) {
        Long entryId = billBizInfo.getEntryId();
        return EmptyUtil.isNoEmpty((Long)entryId) ? entryId : billBizInfo.getBillId();
    }

    private void fillDetail(BalanceQueryResult balanceQueryResult, BalanceQueryDetailInfo balanceQueryDetailInfo) {
        List<ReportData> matchedReportDataList = balanceQueryDetailInfo.getMatchedReportDataList();
        FundPlanSystem system = this.controlContext.getSystem(balanceQueryDetailInfo.getSystemId());
        Map periodTypeMap = system.getReportTypeList().stream().collect(Collectors.toMap(ReportPeriodType::getReportPeriodId, Function.identity(), (a, b) -> a));
        for (ReportData reportData : matchedReportDataList) {
            BalanceQueryResultDetail balanceQueryResultDetail = new BalanceQueryResultDetail();
            balanceQueryResult.addBalanceQueryResultDetail(balanceQueryResultDetail);
            balanceQueryResultDetail.setBodySysNum(system.getNumber());
            balanceQueryResultDetail.setBodySysName(system.getName());
            balanceQueryResultDetail.setAvailableAmt(this.amountUnitConverterAvailableAmtCalculate.calculate(AvailableReportDataFactory.getAvailableReportData(reportData, this.controlContext.getSystem(balanceQueryDetailInfo.getSystemId()), balanceQueryDetailInfo.getControlStrategyDetail())));
            List<TemplateDim> dimList = reportData.getDimList();
            List<Object> dataDimValList = reportData.getDimValList();
            ArrayList<OptionDim> optionDimList = new ArrayList<OptionDim>(2);
            ArrayList<DetailFieldDim> detailFieldDimList = new ArrayList<DetailFieldDim>(2);
            balanceQueryResultDetail.setOptionDimList(optionDimList);
            balanceQueryResultDetail.setDetailFieldDimList(detailFieldDimList);
            block9: for (int i = 0; i < dimList.size(); ++i) {
                TemplateDim templateDim = dimList.get(i);
                DimensionType dimType = templateDim.getDimType();
                Dimension dimension = this.dimensionInfoCacheManager.getDimension(system, templateDim.getDimensionId());
                Object val = dataDimValList.get(i);
                switch (dimType) {
                    case ORG: {
                        DimMember orgMember = this.dimensionInfoCacheManager.getDimMember(dimension, (Long)val);
                        balanceQueryResultDetail.setReportOrgNum(orgMember.getNumber());
                        balanceQueryResultDetail.setReportOrgName(orgMember.getName());
                        continue block9;
                    }
                    case PERIOD: {
                        DimMember periodMember = this.dimensionInfoCacheManager.getDimMember(dimension, (Long)val);
                        balanceQueryResultDetail.setPeriodNum(periodMember.getNumber());
                        balanceQueryResultDetail.setPeriodName(periodMember.getName());
                        continue block9;
                    }
                    case SUBJECTS: {
                        DimMember subjectMember = this.dimensionInfoCacheManager.getDimMember(dimension, (Long)val);
                        balanceQueryResultDetail.setSubjectNum(subjectMember.getNumber());
                        balanceQueryResultDetail.setSubjectName(subjectMember.getName());
                        continue block9;
                    }
                    case CURRENCY: {
                        DimMember currencyMember = this.dimensionInfoCacheManager.getDimMember(dimension, (Long)val);
                        balanceQueryResultDetail.setCurrencyNum(currencyMember.getNumber());
                        balanceQueryResultDetail.setCurrencyName(currencyMember.getName());
                        continue block9;
                    }
                    case COMPANY: 
                    case CUSTOM: 
                    case SETTLEMENT_TYPE: {
                        if (!EmptyUtil.isNoEmpty((Object)val)) continue block9;
                        DimMember dimMember = this.dimensionInfoCacheManager.getDimMember(dimension, (Long)val);
                        OptionDim optionDim = new OptionDim();
                        optionDim.setOptionDimNumber(dimension.getNumber());
                        optionDim.setOptionDimName(dimension.getName());
                        optionDim.setMemberName(dimMember.getName());
                        optionDim.setMemberNumber(dimMember.getNumber());
                        optionDimList.add(optionDim);
                        continue block9;
                    }
                    case DETAILDIM: {
                        if (!EmptyUtil.isNoEmpty((Object)val)) continue block9;
                        DetailFieldDim detailFieldDim = new DetailFieldDim();
                        detailFieldDim.setDetailFieldDimName(dimension.getName());
                        detailFieldDim.setDetailFieldDimNumber(dimension.getNumber());
                        detailFieldDim.setDetailFieldValue(StringHelper.getStringValue((Object)val));
                        detailFieldDimList.add(detailFieldDim);
                        continue block9;
                    }
                }
            }
            Dimension periodDim = this.dimensionInfoCacheManager.getDimension(system, DimensionType.PERIOD);
            PeriodMember periodMember = (PeriodMember)this.dimensionInfoCacheManager.getDimMember(periodDim, reportData.getReportPeriodId());
            ReportPeriodType reportPeriodType = (ReportPeriodType)periodTypeMap.get(periodMember.getPeriodTypeId());
            balanceQueryResultDetail.setReportTypeName(reportPeriodType.getName());
            balanceQueryResultDetail.setReportTypeNumber(reportPeriodType.getNumber());
            balanceQueryResultDetail.setPlanAmt(reportData.getPlanAmt());
            balanceQueryResultDetail.setLockAmt(reportData.getLockAmt());
            balanceQueryResultDetail.setActAmt(reportData.getActAmt());
        }
    }
}

