/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.openapi.balancequery.generator.impl;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.openapi.balancequery.generator.impl.AbstractBalanceQueryResultGenerator;
import kd.tmc.fpm.business.dataproc.openapi.model.AvailableInfo;
import kd.tmc.fpm.business.dataproc.openapi.model.BalanceQueryDetailInfo;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlStrategyDetail;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.index.BitMap;
import kd.tmc.fpm.business.domain.model.index.generate.QueryIndexInfoMapGenerator;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.utils.DimensionInfoHelper;
import kd.tmc.fpm.business.utils.ListHelper;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class OverageBalanceQueryResultGenerator
extends AbstractBalanceQueryResultGenerator {
    public OverageBalanceQueryResultGenerator(AbstractBalanceQueryResultGenerator abstractBalanceQueryResultGenerator) {
        super(abstractBalanceQueryResultGenerator);
    }

    @Override
    public List<BalanceQueryDetailInfo> generate() {
        List<BalanceQueryDetailInfo> balanceQueryDetailInfoList = super.generate();
        if (EmptyUtil.isEmpty(balanceQueryDetailInfoList)) {
            return balanceQueryDetailInfoList;
        }
        BitMap<Long, AvailableInfo> minAvailableBitMap = this.getMinAvailableBitMap(balanceQueryDetailInfoList);
        Set<AvailableInfo> availableInfos = minAvailableBitMap.values();
        Map<DimensionInfoBean, List<AvailableInfo>> availableDimInfoMap = availableInfos.stream().collect(Collectors.groupingBy(AvailableInfo::getDimensionInfoBean));
        Map<Long, QueryIndexInfo> queryIndexInfoMap = balanceQueryDetailInfoList.stream().map(BalanceQueryDetailInfo::getQueryIndexInfo).filter(Objects::nonNull).map(QueryIndexInfo::getDataMap).filter(Objects::nonNull).map(Map::values).flatMap(Collection::stream).collect(Collectors.groupingBy(ReportData::getSystemId)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> QueryIndexInfoMapGenerator.buildReportDataIndex((List)entry.getValue(), this.controlContext.getSystem(((ReportData)((List)entry.getValue()).get(0)).getSystemId()))));
        for (BalanceQueryDetailInfo balanceQueryDetailInfo : balanceQueryDetailInfoList) {
            Long entryId = this.getEntryId(balanceQueryDetailInfo);
            Set<Long> keys = ListHelper.asSet(balanceQueryDetailInfo.getSystemId(), entryId);
            AvailableInfo one = minAvailableBitMap.findOne(keys);
            if (one == null) {
                throw new KDBizException("keys:" + keys + "bitMap is not init");
            }
            DimensionInfoBean dimensionInfoBean = one.getDimensionInfoBean().copy();
            if (!Objects.equals(dimensionInfoBean, balanceQueryDetailInfo.getControlDimensionInfoBean())) continue;
            BigDecimal executeActAmount = balanceQueryDetailInfo.getControlExecuteParam().getExecuteActAmount().negate();
            balanceQueryDetailInfo.setOverage(one.isOverage(balanceQueryDetailInfo.getControlExecuteParam().getExecuteActAmount()));
            List<AvailableInfo> availableInfoList = availableDimInfoMap.get(dimensionInfoBean);
            availableInfoList.forEach(availableInfo -> availableInfo.updateRemainAvailableAmt(executeActAmount));
            ControlStrategyDetail controlStrategyDetail = balanceQueryDetailInfo.getControlStrategyDetail();
            if (Objects.isNull(controlStrategyDetail)) continue;
            Long subjectId = controlStrategyDetail.getSubjectId();
            FundPlanSystem system = this.controlContext.getSystem(balanceQueryDetailInfo.getSystemId());
            Dimension subjectDim = this.dimensionInfoCacheManager.getDimension(system, DimensionType.SUBJECTS);
            DimMember dimMember = this.dimensionInfoCacheManager.getDimMember(subjectDim, subjectId);
            QueryIndexInfo queryIndexInfo = queryIndexInfoMap.get(system.getId());
            if (Objects.isNull(queryIndexInfo)) continue;
            while (EmptyUtil.isNoEmpty((Object)(dimMember = dimMember.getParent()))) {
                List<AvailableInfo> parentAvailableInfoList;
                DimensionInfoBean subjectParentDimensionInfo = this.getSubjectParentDimensionInfo(balanceQueryDetailInfo, subjectDim, dimMember, queryIndexInfo);
                if (subjectParentDimensionInfo == null || EmptyUtil.isEmpty(parentAvailableInfoList = availableDimInfoMap.get(subjectParentDimensionInfo))) continue;
                parentAvailableInfoList.forEach(availableInfo -> availableInfo.updateRemainAvailableAmt(executeActAmount));
            }
        }
        return balanceQueryDetailInfoList;
    }

    private DimensionInfoBean getSubjectParentDimensionInfo(BalanceQueryDetailInfo balanceQueryDetailInfo, Dimension subjectDim, DimMember dimMember, QueryIndexInfo<Object, ReportData> queryIndexInfo) {
        ReportData reportData = balanceQueryDetailInfo.getControlExecuteParam().getReportData();
        DimensionInfoBean dimensionInfoBeanByFilter = DimensionInfoHelper.getDimensionInfoBeanByFilter(reportData, td -> td.getDimType().isSystemDim());
        dimensionInfoBeanByFilter.replaceValueIfContains(subjectDim.getId(), (Object)dimMember.getId());
        List<ReportData> reportDataList = queryIndexInfo.findList(dimensionInfoBeanByFilter);
        if (EmptyUtil.isEmpty(reportDataList)) {
            return null;
        }
        List<ReportData> mainReportDataList = this.mainReportData(reportDataList);
        if (mainReportDataList.size() == 1) {
            return dimensionInfoBeanByFilter;
        }
        if (EmptyUtil.isEmpty(mainReportDataList)) {
            mainReportDataList = reportDataList;
        }
        DimensionInfoBean controlDimensionInfoBean = balanceQueryDetailInfo.getControlDimensionInfoBean();
        List controlDimensionIdList = controlDimensionInfoBean.getDimensionIdList();
        HashSet controlDimensionIds = new HashSet(controlDimensionIdList);
        if (mainReportDataList.size() > 1) {
            ReportData rd = mainReportDataList.get(0);
            DimensionInfoBean currentOptionalDimInfo = DimensionInfoHelper.getDimensionInfoBeanByFilter(rd, td -> !td.getDimType().isSystemDim() && controlDimensionIds.contains(td.getDimensionId()));
            List currentDimensionIdList = currentOptionalDimInfo.getDimensionIdList();
            if (currentDimensionIdList.size() + 4 == controlDimensionIdList.size()) {
                return controlDimensionInfoBean;
            }
            FundPlanSystem system = this.controlContext.getSystem(balanceQueryDetailInfo.getSystemId());
            DimensionInfoBean dimensionInfoBean = new DimensionInfoBean();
            List memberIdList = controlDimensionInfoBean.getMemberIdList();
            for (int i = 0; i < controlDimensionIdList.size(); ++i) {
                Dimension dimension = this.dimensionInfoCacheManager.getDimension(system, (Long)controlDimensionIdList.get(i));
                if (dimension.getDimType().isSystemDim()) {
                    dimensionInfoBean.addDimensionInfo(dimension.getId(), memberIdList.get(i));
                    continue;
                }
                if (!currentDimensionIdList.contains(dimension.getId())) continue;
                dimensionInfoBean.addDimensionInfo(dimension.getId(), memberIdList.get(i));
            }
            return dimensionInfoBean;
        }
        throw new KDBizException("parent subject\uff1a" + dimMember.getParentId() + " dimensionInfo large then child subject \uff1a" + dimMember.getId() + "reportDataId:" + reportData.getId());
    }

    private Long getEntryId(BalanceQueryDetailInfo balanceQueryDetailInfo) {
        BillBizInfo billBizInfo = balanceQueryDetailInfo.getControlExecuteParam().getBillBizInfo();
        Long entryId = billBizInfo.getEntryId();
        if (EmptyUtil.isEmpty((Long)entryId)) {
            entryId = billBizInfo.getBillId();
        }
        return entryId;
    }

    private BitMap<Long, AvailableInfo> getMinAvailableBitMap(List<BalanceQueryDetailInfo> balanceQueryDetailInfoList) {
        BitMap<Long, AvailableInfo> availableInfoBitMap = new BitMap<Long, AvailableInfo>(balanceQueryDetailInfoList.size());
        for (BalanceQueryDetailInfo balanceQueryDetailInfo : balanceQueryDetailInfoList) {
            Long entryId = this.getEntryId(balanceQueryDetailInfo);
            Set<Long> keys = ListHelper.asSet(balanceQueryDetailInfo.getSystemId(), entryId);
            AvailableInfo one = availableInfoBitMap.findOne(keys);
            if (one == null) {
                one = new AvailableInfo(balanceQueryDetailInfo.getControlDimensionInfoBean(), entryId, balanceQueryDetailInfo.getAvailableAmt());
                availableInfoBitMap.addValue(keys, one);
                continue;
            }
            one.updateMinAvailableAmt(balanceQueryDetailInfo);
        }
        return availableInfoBitMap;
    }
}

