/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.openapi.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.tmc.fpm.business.domain.model.control.ControlStrategy;
import kd.tmc.fpm.business.domain.model.control.ControlStrategyDetail;
import kd.tmc.fpm.business.domain.model.index.generate.bean.QueryIndexInfo;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class BalanceQueryDetailInfo {
    private Long systemId;
    private Long reportPeriodId;
    private List<ReportData> matchedReportDataList;
    private BigDecimal availableAmt;
    private DimensionInfoBean dimensionInfoBean;
    private DimensionInfoBean controlDimensionInfoBean;
    private ControlExecuteParam controlExecuteParam;
    private ControlStrategy controlStrategy;
    private QueryIndexInfo<Long, ReportData> queryIndexInfo;
    private final Set<Long> reportDataIds;
    private Long completeParentSubjectId;
    private ControlStrategyDetail controlStrategyDetail;
    private boolean overage;

    public BalanceQueryDetailInfo(ControlExecuteParam controlExecuteParam) {
        this.controlExecuteParam = controlExecuteParam;
        ReportData reportData = controlExecuteParam.getReportData();
        this.systemId = reportData.getSystemId();
        this.reportPeriodId = reportData.getReportPeriodId();
        this.availableAmt = BigDecimal.ZERO;
        this.matchedReportDataList = new ArrayList<ReportData>(16);
        this.dimensionInfoBean = controlExecuteParam.getDimensionInfoBean().copy();
        this.reportDataIds = new HashSet<Long>(8);
    }

    public boolean isOverage() {
        return this.overage;
    }

    public Long getSystemId() {
        return this.systemId;
    }

    public void setSystemId(Long systemId) {
        this.systemId = systemId;
    }

    public Long getReportPeriodId() {
        return this.reportPeriodId;
    }

    public void setReportPeriodId(Long reportPeriodId) {
        this.reportPeriodId = reportPeriodId;
    }

    public List<ReportData> getMatchedReportDataList() {
        return this.matchedReportDataList;
    }

    public void setMatchedReportDataList(List<ReportData> matchedReportDataList) {
        this.matchedReportDataList = matchedReportDataList;
    }

    public BigDecimal getAvailableAmt() {
        return this.availableAmt;
    }

    public void setAvailableAmt(BigDecimal availableAmt) {
        this.availableAmt = availableAmt;
    }

    public DimensionInfoBean getDimensionInfoBean() {
        return this.dimensionInfoBean;
    }

    public void setDimensionInfoBean(DimensionInfoBean dimensionInfoBean) {
        this.dimensionInfoBean = dimensionInfoBean;
    }

    public Long getReportOrgId() {
        return this.controlExecuteParam.getReportOrgId();
    }

    public Long getSubjectId() {
        return this.controlExecuteParam.getSubjectId();
    }

    public ControlExecuteParam getControlExecuteParam() {
        return this.controlExecuteParam;
    }

    public void setControlExecuteParam(ControlExecuteParam controlExecuteParam) {
        this.controlExecuteParam = controlExecuteParam;
    }

    public Long getReportTypeId() {
        return this.controlExecuteParam.getReportTypeId();
    }

    public ControlStrategy getControlStrategy() {
        return this.controlStrategy;
    }

    public void setControlStrategy(ControlStrategy controlStrategy) {
        this.controlStrategy = controlStrategy;
    }

    public boolean addMatchedReportData(ReportData reportData) {
        boolean result = this.reportDataIds.add(reportData.getId());
        if (result) {
            this.matchedReportDataList.add(reportData);
        }
        return result;
    }

    public void updateAvailableAmt(BigDecimal availableAmt) {
        this.availableAmt = this.availableAmt.add(availableAmt);
    }

    public QueryIndexInfo<Long, ReportData> getQueryIndexInfo() {
        return this.queryIndexInfo;
    }

    public void setQueryIndexInfo(QueryIndexInfo<Long, ReportData> queryIndexInfo) {
        this.queryIndexInfo = queryIndexInfo;
    }

    public boolean hasControlStrategy() {
        return Objects.nonNull(this.controlStrategy);
    }

    public Long getCompleteParentSubjectId() {
        return this.completeParentSubjectId;
    }

    public void setCompleteParentSubjectId(Long completeParentSubjectId) {
        this.completeParentSubjectId = completeParentSubjectId;
    }

    public ControlStrategyDetail getControlStrategyDetail() {
        return this.controlStrategyDetail;
    }

    public void setControlStrategyDetail(ControlStrategyDetail controlStrategyDetail) {
        this.controlStrategyDetail = controlStrategyDetail;
    }

    public List<ReportData> getMatchedSameReportDataAll() {
        List<ReportData> matchedSameReportDataList = this.controlExecuteParam.getMatchedSameReportDataList();
        ArrayList<ReportData> reportDataList = new ArrayList<ReportData>(matchedSameReportDataList);
        reportDataList.add(this.controlExecuteParam.getReportData());
        return reportDataList;
    }

    public DimensionInfoBean getControlDimensionInfoBean() {
        return this.controlDimensionInfoBean;
    }

    public void setControlDimensionInfoBean(DimensionInfoBean controlDimensionInfoBean) {
        this.controlDimensionInfoBean = controlDimensionInfoBean;
    }

    public void setOverage(boolean overage) {
        this.overage = overage;
    }
}

