/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.IControlDataQueryService;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryObject;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryService;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.MemberType;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.mvc.converter.ReportPoConverter;
import kd.tmc.fpm.business.mvc.converter.TemplatePOConverter;
import kd.tmc.fpm.business.mvc.repository.impl.DetailPlanFieldsRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.common.helper.FpmHelper;

public class ControlDataQueryService
implements IControlDataQueryService {
    private static final Map<String, String> MAINDIM_ENTRY_MAPPING_MAP = new HashMap<String, String>();
    private static final Map<String, String> DETAILDIM_ENTRY_MAPPING_MAP = new HashMap<String, String>();
    private static final Map<String, String> TYPE_MAPPING_MAP = new HashMap<String, String>();
    private static Log logger;

    @Override
    public List<ReportDataQueryResult> queryReportData(ReportDataQueryObject queryObject) {
        Boolean mainTable;
        List<Long> reportIdS;
        Boolean effectFlag;
        ReportPlanType reportPlanType;
        List<Long> reportPeriodIds;
        Long reportPeriodId;
        List<Long> reportOrgIds;
        Long reportOrgId;
        Long orgTemplateId;
        Long templateId;
        List<Integer> versionList;
        List<Long> idList;
        List<Dimension> dimList = queryObject.getDimIdList();
        List<List<Object>> dimValList = queryObject.getDimValList();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        if (!CollectionUtils.isEmpty(dimList) && !CollectionUtils.isEmpty(dimValList)) {
            for (int i = 0; i < dimList.size(); ++i) {
                Dimension templateDim = dimList.get(i);
                DimensionType dimType = templateDim.getDimType();
                if (DimensionType.DETAILDIM != dimType) {
                    String propName = ReportHelper.TYPE_MAPPING_MAP.get(dimType.getNumber());
                    if (!EmptyUtil.isNoEmpty((String)propName)) continue;
                    qFilterList.add(new QFilter(String.join((CharSequence)".", "maindimentry", propName), "in", dimValList.get(i)));
                    continue;
                }
                DetailDimType detailDimType = templateDim.getDetailDimType();
                String propName = ReportHelper.TYPE_MAPPING_MAP.get(detailDimType.getNumber());
                if (!EmptyUtil.isNoEmpty((String)propName)) continue;
                qFilterList.add(new QFilter(String.join((CharSequence)".", "detailentry", propName), "in", dimValList.get(i)));
            }
        }
        if (!CollectionUtils.isEmpty(idList = queryObject.getIdList())) {
            qFilterList.add(new QFilter(String.join((CharSequence)".", "maindimentry", "id"), "in", idList));
        }
        if (!CollectionUtils.isEmpty(versionList = queryObject.getVersionList())) {
            qFilterList.add(new QFilter(String.join((CharSequence)".", "maindimentry", "version"), "in", versionList));
        }
        if ((templateId = queryObject.getTemplateId()) != null) {
            qFilterList.add(new QFilter(String.join((CharSequence)".", "templatebak", "id"), "=", (Object)templateId));
        }
        if ((orgTemplateId = queryObject.getOrgTemplateId()) != null) {
            qFilterList.add(new QFilter(String.join((CharSequence)".", "template", "id"), "=", (Object)orgTemplateId));
        }
        if ((reportOrgId = queryObject.getReportOrgId()) != null) {
            qFilterList.add(new QFilter(String.join((CharSequence)".", "reportorg", "id"), "=", (Object)reportOrgId));
        }
        if (!CollectionUtils.isEmpty(reportOrgIds = queryObject.getReportOrgIds())) {
            qFilterList.add(new QFilter(String.join((CharSequence)".", "reportorg", "id"), "in", reportOrgIds));
        }
        if ((reportPeriodId = queryObject.getReportPeriodId()) != null) {
            qFilterList.add(new QFilter(String.join((CharSequence)".", "reportperiod", "id"), "=", (Object)reportPeriodId));
        }
        if (!CollectionUtils.isEmpty(reportPeriodIds = queryObject.getReportPeriodIds())) {
            qFilterList.add(new QFilter(String.join((CharSequence)".", "reportperiod", "id"), "in", reportPeriodIds));
        }
        if (!EmptyUtil.isEmpty((Object)(reportPlanType = queryObject.getReportPlanType()))) {
            qFilterList.add(new QFilter("reportplantype", "=", (Object)reportPlanType.getNumber()));
        }
        if ((effectFlag = queryObject.getEffectFlag()) != null) {
            qFilterList.add(new QFilter(String.join((CharSequence)".", "maindimentry", "effectflag"), "=", (Object)(effectFlag != false ? "1" : "0")));
        }
        if (!CollectionUtils.isEmpty(reportIdS = queryObject.getReportIdS())) {
            qFilterList.add(new QFilter("id", "in", reportIdS));
        }
        if ((mainTable = queryObject.getMainTable()) != null) {
            qFilterList.add(new QFilter(String.join((CharSequence)".", "maindimentry", "maintable"), "=", (Object)(mainTable != false ? "1" : "0")));
        }
        DynamicObject[] simpleInfoArr = TmcDataServiceHelper.load((String)"fpm_report", (String)String.join((CharSequence)",", "id", "template", "bodysys"), (QFilter[])qFilterList.toArray(new QFilter[0]));
        Map<Long, Long> reportIdAndTemplateMap = Arrays.stream(simpleInfoArr).collect(Collectors.toMap(item -> item.getLong("id"), item -> item.getLong("template.id")));
        Map<Long, Long> reportIdAndBodySysMap = Arrays.stream(simpleInfoArr).collect(Collectors.toMap(item -> item.getLong("id"), item -> item.getLong("bodysys.id")));
        DynamicObject[] templateArr = TmcDataServiceHelper.load((Object[])reportIdAndTemplateMap.values().toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fpm_template"));
        HashMap<Long, ReportTemplate> templateMap = new HashMap<Long, ReportTemplate>(templateArr.length);
        for (DynamicObject templateObj : templateArr) {
            ReportTemplate reportTemplate = TemplatePOConverter.convertToTemplate(templateObj);
            templateMap.put(reportTemplate.getId(), reportTemplate);
        }
        Map<Long, List<Dimension>> planDetailMap = new DetailPlanFieldsRepository().getDetailDimensionGroupBySystemId(new HashSet<Long>(reportIdAndBodySysMap.values()));
        Map entryPropMap = FpmHelper.getEntryPropertyS((String)"fpm_report", Arrays.asList("maindimentry", "detailentry"));
        Set entryPropertySet = (Set)entryPropMap.get("maindimentry");
        String idProp = String.join((CharSequence)".", "maindimentry", "id");
        String mainEntryBodySysProp = String.join((CharSequence)".", "maindimentry", "system");
        entryPropertySet.add(idProp);
        entryPropertySet.add("id");
        entryPropertySet.add("planstatus");
        DataSet mainEntryDataSet = QueryServiceHelper.queryDataSet((String)"report.queryMainData", (String)"fpm_report", (String)String.join((CharSequence)",", entryPropertySet), (QFilter[])qFilterList.toArray(new QFilter[0]), (String)"");
        DataSet copyData = mainEntryDataSet.copy();
        HashMap<Long, ReportTemplate> entryIdAndTemplateMap = new HashMap<Long, ReportTemplate>(16);
        HashMap<Long, List<Dimension>> entryIdAndDetailPlanMap = new HashMap<Long, List<Dimension>>(16);
        DataSet mainEntryIdDS = copyData.select(new String[]{idProp, "id", mainEntryBodySysProp});
        while (mainEntryIdDS.hasNext()) {
            Row next = mainEntryIdDS.next();
            Long reportId = next.getLong("id");
            Long currTemplateId = reportIdAndTemplateMap.get(reportId);
            entryIdAndTemplateMap.put(next.getLong(idProp), (ReportTemplate)templateMap.get(currTemplateId));
            entryIdAndDetailPlanMap.put(next.getLong(idProp), planDetailMap.get(next.getLong(mainEntryBodySysProp)));
        }
        Set detailEntryPropertySet = (Set)entryPropMap.get("detailentry");
        String mainEntryId = String.join((CharSequence)".", "detailentry", "maindimdataid");
        DataSet detailEntryDataSet = QueryServiceHelper.queryDataSet((String)"report.queryDetailData", (String)"fpm_report", (String)String.join((CharSequence)",", detailEntryPropertySet), (QFilter[])new QFilter[]{new QFilter(mainEntryId, "in", entryIdAndTemplateMap.keySet())}, (String)"");
        ArrayList allFiledList = new ArrayList(entryPropertySet);
        allFiledList.addAll(detailEntryPropertySet);
        DataSet reportDataDataSet = mainEntryDataSet.join(detailEntryDataSet).on(idProp, mainEntryId).select(allFiledList.toArray(new String[0])).finish();
        return this.convert(reportDataDataSet, entryIdAndTemplateMap, entryIdAndDetailPlanMap);
    }

    @Override
    public List<ReportDataQueryResult> queryRelationData(Long reportId) {
        ReportRepository reportRepository = new ReportRepository();
        List<Long> subReportIdS = reportRepository.querySubReportId(reportId);
        logger.info("\u67e5\u627e\u5173\u8054\u6570\u636e-\u5b50\u8868id\uff0c{}", subReportIdS);
        subReportIdS.add(reportId);
        Long parentId = reportRepository.queryParentReportId(reportId);
        logger.info("\u67e5\u627e\u5173\u8054\u6570\u636e-\u7236\u8868id\uff0c{}", (Object)parentId);
        if (parentId != null) {
            subReportIdS.add(parentId);
        }
        ReportDataQueryObject reportDataQueryObject = new ReportDataQueryObject();
        reportDataQueryObject.setReportIdS(subReportIdS);
        return this.queryReportData(reportDataQueryObject);
    }

    private List<ReportDataQueryResult> convert(DataSet reportDataDataSet, Map<Long, ReportTemplate> entryIdAndTemplateMap, Map<Long, List<Dimension>> entryIdAndDetailPlanMap) {
        ArrayList<ReportDataQueryResult> resultList = new ArrayList<ReportDataQueryResult>(16);
        Map<String, Long> dimMap = new HashMap<String, Long>(16);
        while (reportDataDataSet.hasNext()) {
            Row rowData = reportDataDataSet.next();
            ReportTemplate reportTemplate = entryIdAndTemplateMap.get(rowData.getLong(String.join((CharSequence)".", "maindimentry", "id")));
            List<Dimension> detailDimensions = entryIdAndDetailPlanMap.get(rowData.getLong(String.join((CharSequence)".", "maindimentry", "id")));
            ReportDataQueryResult reportDataQueryResult = new ReportDataQueryResult();
            reportDataQueryResult.setApplyPlanAmt(rowData.getBigDecimal(String.join((CharSequence)".", "maindimentry", "orgplanamt")));
            reportDataQueryResult.setPlanAmt(rowData.getBigDecimal(String.join((CharSequence)".", "maindimentry", "planamt")));
            reportDataQueryResult.setActAmt(rowData.getBigDecimal(String.join((CharSequence)".", "maindimentry", "realamt")));
            reportDataQueryResult.setLockAmt(rowData.getBigDecimal(String.join((CharSequence)".", "maindimentry", "lockamt")));
            reportDataQueryResult.setVersion(rowData.getInteger(String.join((CharSequence)".", "maindimentry", "version")));
            reportDataQueryResult.setSystemId(rowData.getLong(String.join((CharSequence)".", "maindimentry", "system")));
            ArrayList<Long> dimIdList = new ArrayList<Long>(16);
            ArrayList<TemplateDim> dimList = new ArrayList<TemplateDim>(16);
            ArrayList<Object> dimValList = new ArrayList<Object>(16);
            if (reportTemplate.getTemplateUse() == TemplateUseType.SUMMARY && dimMap.isEmpty()) {
                DynamicObjectCollection dimColl = QueryServiceHelper.query((String)"fpm_dimension", (String)"id,basedata", (QFilter[])new QFilter[]{new QFilter("bodysystem", "=", (Object)reportTemplate.getSystemId())});
                dimMap = dimColl.stream().collect(Collectors.toMap(item -> item.getString("basedata"), item -> item.getLong("id")));
            }
            this.dealDimMemberDataOfMainDim(rowData, dimList, dimValList, dimMap, reportTemplate);
            this.dealDimMemberDataOfDetailDim(rowData, dimList, dimIdList, dimValList, reportTemplate, detailDimensions);
            reportDataQueryResult.setDimValList(dimValList);
            String amountUnitStr = rowData.getString(String.join((CharSequence)".", "maindimentry", "amountunit"));
            if (!StringUtils.isEmpty((Object)amountUnitStr)) {
                reportDataQueryResult.setAmountUnit(AmountUnit.getByNumber(amountUnitStr));
            }
            reportDataQueryResult.setDimIdList(dimIdList);
            reportDataQueryResult.setDimList(dimList);
            reportDataQueryResult.setId(rowData.getLong(String.join((CharSequence)".", "maindimentry", "id")));
            reportDataQueryResult.setReportId(rowData.getLong("id"));
            reportDataQueryResult.setReportPeriodId(rowData.getLong(String.join((CharSequence)".", "maindimentry", "entryreportperiod")));
            reportDataQueryResult.setMainTable(rowData.getBoolean(String.join((CharSequence)".", "maindimentry", "maintable")));
            reportDataQueryResult.setRow(rowData.getInteger(String.join((CharSequence)".", "maindimentry", "origindatarow")));
            reportDataQueryResult.setCol(rowData.getInteger(String.join((CharSequence)".", "maindimentry", "origindatacol")));
            resultList.add(reportDataQueryResult);
        }
        return resultList;
    }

    private void dealDimMemberDataOfMainDim(Row rowData, List<TemplateDim> dimList, List<Object> dimValList, Map<String, Long> dimMap, ReportTemplate reportTemplate) {
        List<TemplateDim> allTemplateDim = reportTemplate.getAllTemplateDim();
        Map<String, List<TemplateDim>> templateMainDimMap = allTemplateDim.stream().filter(item -> item.getDimType() != DimensionType.DETAILDIM).collect(Collectors.groupingBy(o -> o.getDimType().getNumber()));
        ReportPoConverter.dealDimMemberDataOfMainDim(rowData, dimList, dimMap, templateMainDimMap, dimValList, reportTemplate);
    }

    private void dealDimMemberDataOfDetailDim(Row rowData, List<TemplateDim> dimList, List<Long> dimIdList, List<Object> dimValList, ReportTemplate reportTemplate, List<Dimension> detailDimList) {
        Set<Map.Entry<String, String>> detailDimEntrySet = DETAILDIM_ENTRY_MAPPING_MAP.entrySet();
        for (Map.Entry<String, String> detailDimEntry : detailDimEntrySet) {
            TemplateDim templateDim;
            String key = detailDimEntry.getKey();
            String widgetSign = detailDimEntry.getValue();
            Object value = rowData.get(widgetSign);
            List<TemplateDim> allTemplateDim = reportTemplate.getAllTemplateDim();
            List dims = allTemplateDim.stream().filter(Objects::nonNull).filter(o -> o.getDimType() == DimensionType.DETAILDIM && o.getDetailDimType().getNumber().equals(key)).collect(Collectors.toList());
            TemplateDim templateDim2 = templateDim = dims == null || dims.size() == 0 ? null : (TemplateDim)dims.get(0);
            if (templateDim == null) continue;
            Dimension dimension = detailDimList.stream().filter(item -> item.getId().equals(templateDim.getDimensionId())).findFirst().get();
            MemberType memberType = dimension.getMemberType();
            if (DetailDimType.isExtraCode(key) && value != null && !StringUtils.isEmpty((Object)value.toString())) {
                if (MemberType.DATE == memberType) {
                    value = new Date(Long.parseLong(value.toString()));
                } else if (MemberType.BASE_DATA == memberType) {
                    value = Long.valueOf(value.toString());
                }
            }
            dimList.add(templateDim);
            dimIdList.add(templateDim.getDimensionId());
            dimValList.add(value);
        }
    }

    static {
        MAINDIM_ENTRY_MAPPING_MAP.put(DimensionType.ORG.getNumber(), String.join((CharSequence)".", "maindimentry", "orgmem"));
        MAINDIM_ENTRY_MAPPING_MAP.put(DimensionType.CURRENCY.getNumber(), String.join((CharSequence)".", "maindimentry", "currencymem"));
        MAINDIM_ENTRY_MAPPING_MAP.put(DimensionType.PERIOD.getNumber(), String.join((CharSequence)".", "maindimentry", "periodmem"));
        MAINDIM_ENTRY_MAPPING_MAP.put(DimensionType.SUBJECTS.getNumber(), String.join((CharSequence)".", "maindimentry", "subjectmem"));
        MAINDIM_ENTRY_MAPPING_MAP.put(DimensionType.COMPANY.getNumber(), String.join((CharSequence)".", "maindimentry", "companymem"));
        MAINDIM_ENTRY_MAPPING_MAP.put(DimensionType.SETTLEMENT_TYPE.getNumber(), String.join((CharSequence)".", "maindimentry", "settletypemem"));
        MAINDIM_ENTRY_MAPPING_MAP.put(DimensionType.CUSTOM.getNumber(), String.join((CharSequence)",", String.join((CharSequence)".", "maindimentry", "extmem1"), String.join((CharSequence)".", "maindimentry", "extmem2"), String.join((CharSequence)".", "maindimentry", "extmem3")));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimType.CONNTERPARTY_TYPE.getNumber(), String.join((CharSequence)".", "detailentry", "opusertype"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimType.COUNTERPARTY_NAME.getNumber(), String.join((CharSequence)".", "detailentry", "opusername"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimType.BANK_CATE.getNumber(), String.join((CharSequence)".", "detailentry", "bankcate"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimType.CONTRACT_NO.getNumber(), String.join((CharSequence)".", "detailentry", "contractno"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimType.CONTRACT_NAME.getNumber(), String.join((CharSequence)".", "detailentry", "contractname"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimType.PLAN_DATE.getNumber(), String.join((CharSequence)".", "detailentry", "plandate"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimType.BANK_ACCOUNT.getNumber(), String.join((CharSequence)".", "detailentry", "bankaccount"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimType.BUSINESS_PARTNER.getNumber(), String.join((CharSequence)".", "detailentry", "businesspartner"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimType.EXTRA_1.getNumber(), String.join((CharSequence)".", "detailentry", "detailext1"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimType.EXTRA_2.getNumber(), String.join((CharSequence)".", "detailentry", "detailext2"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimType.EXTRA_3.getNumber(), String.join((CharSequence)".", "detailentry", "detailext3"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimType.EXTRA_4.getNumber(), String.join((CharSequence)".", "detailentry", "detailext4"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimType.EXTRA_5.getNumber(), String.join((CharSequence)".", "detailentry", "detailext5"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimType.EXTRA_6.getNumber(), String.join((CharSequence)".", "detailentry", "detailext6"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimType.EXTRA_7.getNumber(), String.join((CharSequence)".", "detailentry", "detailext7"));
        DETAILDIM_ENTRY_MAPPING_MAP.put(DetailDimType.EXTRA_8.getNumber(), String.join((CharSequence)".", "detailentry", "detailext8"));
        TYPE_MAPPING_MAP.putAll(MAINDIM_ENTRY_MAPPING_MAP);
        TYPE_MAPPING_MAP.putAll(DETAILDIM_ENTRY_MAPPING_MAP);
        logger = LogFactory.getLog(ReportDataQueryService.class);
    }
}

