/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.query;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class DataMetricMergeCache<T, V> {
    private Map<T, Map<DimensionInfoBean, V>> cache;

    public DataMetricMergeCache() {
        this.cache = new HashMap<T, Map<DimensionInfoBean, V>>(256);
    }

    public DataMetricMergeCache(int size) {
        this.cache = new HashMap<T, Map<DimensionInfoBean, V>>(size);
    }

    public V get(DimensionInfoBean dimensionInfoBean, T group) {
        return this.cache.computeIfAbsent(group, k -> new HashMap(128)).get(dimensionInfoBean);
    }

    public void addCache(DimensionInfoBean dimensionInfoBean, V data, Supplier<T> group) {
        this.cache.computeIfAbsent(group.get(), k -> new HashMap(128)).putIfAbsent(dimensionInfoBean, data);
    }

    public List<V> getAllData() {
        return this.cache.values().stream().map(Map::values).flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

