/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.query;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.IMatchRuleBizBillQueryService;
import kd.tmc.fpm.business.dataproc.query.MatchRuleBizBillQParam;
import kd.tmc.fpm.business.domain.enums.MatchPropType;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.BizProps;
import kd.tmc.fpm.business.domain.model.dimension.DimMemberMapping;
import kd.tmc.fpm.business.domain.model.dimension.MappingInfo;
import kd.tmc.fpm.business.provider.DimMappingBaseDataProvider;

public class MatchRuleBizBillQueryService
implements IMatchRuleBizBillQueryService {
    private static final Log logger = LogFactory.getLog(MatchRuleBizBillQueryService.class);

    @Override
    public List<BillBizInfo> queryBillBizInfoS(MatchRuleBizBillQParam qParam) {
        logger.info("\u53d6\u6570\u89c4\u5219\u67e5\u8be2\u670d\u52a1\uff1a{}", (Object)JSON.toJSONString((Object)qParam));
        String entityType = qParam.getEntityType();
        Map<String, List<Object>> bizPropNameAndVal = qParam.getBizPropNameAndVal();
        Map<String, MatchPropType> bizPropAndPropType = qParam.getBizPropAndPropType();
        Set<String> bizPropSet = bizPropAndPropType.keySet();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityType);
        Map allFields = dataEntityType.getAllFields();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(bizPropNameAndVal.size());
        String baseCondition = qParam.getBaseCondition();
        if (StringUtils.isNotEmpty((String)baseCondition)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)baseCondition, CRCondition.class);
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityType);
            FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, condition.getFilterCondition(), true);
            filterBuilder.buildFilter(true);
            qFilterList.add(filterBuilder.getQFilter());
        }
        ArrayList<DimMemberMapping> dimMemberMappingList = new ArrayList<DimMemberMapping>(qParam.getBizPropAndDimMemberMapping().values());
        DimMappingBaseDataProvider dimMappingBaseDataProvider = new DimMappingBaseDataProvider(dimMemberMappingList, false);
        Consumer<List<QFilter>> bizPropScopeFilter = this.setBizPropScopeFilter(qParam, allFields, dimMappingBaseDataProvider);
        bizPropScopeFilter.accept(qFilterList);
        Consumer<List<QFilter>> assistBizPropScopeFilter = this.setAssistBizPropScopeFilter(qParam, allFields, dimMappingBaseDataProvider);
        assistBizPropScopeFilter.accept(qFilterList);
        qParam.getOtherQueryPropS().addAll(new ArrayList<String>(bizPropSet));
        qParam.getOtherQueryPropS().addAll(qParam.getBizPropAndAssistBizProp().values());
        qParam.getOtherQueryPropS().add("id");
        HashSet<String> queryProps = new HashSet<String>(qParam.getOtherQueryPropS());
        Supplier<Map<String, String>> multiTypeBaseDataMapSupplier = this.multiTypeBaseDataMapSupplier(queryProps, qParam, allFields);
        Map<String, String> muTypeBaseDataMap = multiTypeBaseDataMapSupplier.get();
        DynamicObjectCollection dbDataColl = QueryServiceHelper.query((String)entityType, (String)String.join((CharSequence)",", queryProps), (QFilter[])qFilterList.toArray(new QFilter[0]));
        HashMap<String, Map<Long, String>> muTypeBaseDataValMap = new HashMap<String, Map<Long, String>>(16);
        for (Map.Entry<String, String> next : muTypeBaseDataMap.entrySet()) {
            String key = next.getKey();
            String value = next.getValue();
            Map<String, List<DynamicObject>> typeMap = dbDataColl.stream().collect(Collectors.groupingBy(item -> item.getString(value)));
            for (Map.Entry<String, List<DynamicObject>> currNext : typeMap.entrySet()) {
                String entityKey = currNext.getKey();
                if (StringUtils.isEmpty((String)entityKey)) continue;
                List idList = currNext.getValue().stream().map(item -> item.getLong(key)).collect(Collectors.toList());
                DynamicObjectCollection muTypeColl = QueryServiceHelper.query((String)entityKey, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
                Map<Long, String> muTypeIdAndNameMap = muTypeColl.stream().collect(Collectors.toMap(item -> item.getLong("id"), item -> item.getString("name")));
                muTypeBaseDataValMap.put(entityKey, muTypeIdAndNameMap);
            }
        }
        logger.info("\u53d6\u6570\u89c4\u5219\u67e5\u8be2\u670d\u52a1-\u67e5\u8be2\u5230\u7684\u7ed3\u679c\uff1a{}", (Object)dbDataColl.size());
        ArrayList<BillBizInfo> billBizInfoList = new ArrayList<BillBizInfo>(dbDataColl.size());
        dbDataColl.stream().forEach(item -> {
            BillBizInfo billBizInfo = new BillBizInfo();
            billBizInfo.setEntityType(entityType);
            billBizInfo.setBillId(item.getLong("id"));
            ArrayList<BizProps> bizPropsList = new ArrayList<BizProps>(queryProps.size());
            for (String bizProp : queryProps) {
                BizProps bizProps = new BizProps();
                String[] split = bizProp.split("\\.");
                bizProps.setBizProp(bizProp);
                Object bizVal = null;
                MatchPropType matchPropType = this.getBizPropMatchPropType(bizProp, qParam);
                IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)allFields.get(split[split.length - 1]);
                if (iDataEntityProperty instanceof ItemClassProp) {
                    String itemTypeKey;
                    Map typeMap;
                    ItemClassProp itemClassProp = (ItemClassProp)iDataEntityProperty;
                    Object itemTypeObjKey = item.get(itemClassProp.getTypePropName());
                    if (itemTypeObjKey != null && (typeMap = (Map)muTypeBaseDataValMap.get(itemTypeKey = (String)itemTypeObjKey)) != null) {
                        bizVal = typeMap.get(item.getLong(bizProp));
                    }
                } else {
                    bizVal = iDataEntityProperty instanceof BasedataProp ? (matchPropType == MatchPropType.NUMBER ? item.getString(bizProp + ".number") : item.getString(bizProp + ".name")) : (iDataEntityProperty instanceof DateProp ? item.getDate(bizProp) : item.getString(bizProp));
                }
                bizProps.setValue(bizVal);
                bizPropsList.add(bizProps);
            }
            billBizInfo.setBizProps(bizPropsList);
            billBizInfoList.add(billBizInfo);
        });
        return billBizInfoList;
    }

    private Consumer<List<QFilter>> setBizPropScopeFilter(MatchRuleBizBillQParam qParam, Map<String, IDataEntityProperty> bizBillAllFields, DimMappingBaseDataProvider dimMappingBaseDataProvider) {
        return qFilterList -> {
            for (Map.Entry<String, List<Object>> next : qParam.getBizPropNameAndVal().entrySet()) {
                String bizProp = next.getKey();
                List<Object> bizPropValList = next.getValue();
                MatchPropType matchPropType = qParam.getBizPropAndPropType().get(bizProp);
                String[] split = bizProp.split("\\.");
                IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)bizBillAllFields.get(split[split.length - 1]);
                if (iDataEntityProperty instanceof DateProp) {
                    if (bizPropValList.size() != 2) continue;
                    qFilterList.add(new QFilter(bizProp, ">=", bizPropValList.get(0)));
                    qFilterList.add(new QFilter(bizProp, "<=", bizPropValList.get(1)));
                    continue;
                }
                QFilter qFilter = this.getBizPropFilter(bizProp, bizBillAllFields, matchPropType, bizPropValList);
                DimMemberMapping dimMemberMapping = qParam.getBizPropAndDimMemberMapping().get(bizProp);
                if (Objects.nonNull(dimMemberMapping)) {
                    HashSet bizPropValSet = (HashSet)qFilter.getValue();
                    List<Long> optionalDimMemberIds = qParam.getBizPropDimMemberMappingOptionalValMap().get(bizProp);
                    if (EmptyUtil.isNoEmpty(optionalDimMemberIds)) {
                        HashSet<Long> optionalDimMemberIdSet = new HashSet<Long>(optionalDimMemberIds);
                        dimMemberMapping.getMappings().stream().filter(mappingInfo -> optionalDimMemberIdSet.contains(mappingInfo.getMemberId())).map(MappingInfo::getMainId).map(mainId -> dimMappingBaseDataProvider.getBaseData(dimMemberMapping.getMainEntityType(), mainId).getString(matchPropType.getProp())).forEach(bizPropValSet::add);
                    } else {
                        dimMemberMapping.getMappings().stream().map(MappingInfo::getMainId).map(mainId -> dimMappingBaseDataProvider.getBaseData(dimMemberMapping.getMainEntityType(), mainId).getString(matchPropType.getProp())).forEach(bizPropValSet::add);
                    }
                }
                qFilterList.add(qFilter);
            }
        };
    }

    private Consumer<List<QFilter>> setAssistBizPropScopeFilter(MatchRuleBizBillQParam qParam, Map<String, IDataEntityProperty> bizBillAllFields, DimMappingBaseDataProvider dimMappingBaseDataProvider) {
        return qFilterList -> {
            for (Map.Entry<String, String> next : qParam.getBizPropAndAssistBizProp().entrySet()) {
                List<Object> assistBizPropValList;
                String bizProp = next.getKey();
                String assistBizProp = next.getValue();
                DimMemberMapping dimMemberMapping = qParam.getBizPropAndDimMemberMapping().get(bizProp);
                if (EmptyUtil.isEmpty((String)assistBizProp) || Objects.isNull(dimMemberMapping) || !dimMemberMapping.isAssistEntity()) continue;
                MatchPropType matchPropType = qParam.getBizPropAndPropType().get(bizProp);
                List<Long> optionalDimMemberIds = qParam.getBizPropDimMemberMappingOptionalValMap().get(bizProp);
                if (EmptyUtil.isNoEmpty(optionalDimMemberIds)) {
                    HashSet<Long> optionalDimMemberIdSet = new HashSet<Long>(optionalDimMemberIds);
                    assistBizPropValList = dimMemberMapping.getMappings().stream().filter(mappingInfo -> optionalDimMemberIdSet.contains(mappingInfo.getMemberId())).map(MappingInfo::getAssistId).map(assistId -> dimMappingBaseDataProvider.getBaseData(dimMemberMapping.getAssistEntityType(), assistId).getString(matchPropType.getProp())).collect(Collectors.toList());
                } else {
                    assistBizPropValList = dimMemberMapping.getMappings().stream().map(MappingInfo::getAssistId).map(assistId -> dimMappingBaseDataProvider.getBaseData(dimMemberMapping.getAssistEntityType(), assistId).getString(matchPropType.getProp())).collect(Collectors.toList());
                }
                Optional<QFilter> existQFilter = qFilterList.stream().filter(qFilter -> Objects.equals(qFilter.getProperty(), assistBizProp)).findAny();
                if (existQFilter.isPresent()) {
                    HashSet bizPropValSet = (HashSet)existQFilter.get().getValue();
                    bizPropValSet.addAll(assistBizPropValList);
                    continue;
                }
                qFilterList.add(this.getBizPropFilter(assistBizProp, bizBillAllFields, matchPropType, assistBizPropValList));
            }
        };
    }

    private QFilter getBizPropFilter(String bizProp, Map<String, IDataEntityProperty> bizBillAllFields, MatchPropType matchPropType, List<Object> bizPropValList) {
        String[] split = bizProp.split("\\.");
        IDataEntityProperty iDataEntityProperty = bizBillAllFields.get(split[split.length - 1]);
        if (iDataEntityProperty instanceof BasedataProp) {
            Set bizPropValSet = bizPropValList.stream().map(Object::toString).collect(Collectors.toSet());
            return matchPropType == MatchPropType.NAME ? new QFilter(String.join((CharSequence)".", bizProp, "name"), "in", bizPropValSet) : new QFilter(String.join((CharSequence)".", bizProp, "number"), "in", bizPropValSet);
        }
        if (iDataEntityProperty instanceof DateProp) {
            if (bizPropValList.size() == 2) {
                return new QFilter(bizProp, ">=", bizPropValList.get(0)).and(new QFilter(bizProp, "<=", bizPropValList.get(1)));
            }
        } else {
            Set bizPropValSet = bizPropValList.stream().map(Object::toString).collect(Collectors.toSet());
            return new QFilter(bizProp, "in", bizPropValSet);
        }
        return null;
    }

    private Supplier<Map<String, String>> multiTypeBaseDataMapSupplier(Set<String> queryProps, MatchRuleBizBillQParam qParam, Map<String, IDataEntityProperty> bizBillAllFields) {
        return () -> {
            HashMap<String, String> multiTypeBaseDataMap = new HashMap<String, String>(16);
            ArrayList<String> fieldS = new ArrayList<String>(16);
            for (String otherQueryProp : queryProps) {
                String[] split = otherQueryProp.split("\\.");
                MatchPropType matchPropType = this.getBizPropMatchPropType(otherQueryProp, qParam);
                IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)bizBillAllFields.get(split[split.length - 1]);
                if (iDataEntityProperty instanceof ItemClassProp) {
                    ItemClassProp itemClassProp = (ItemClassProp)iDataEntityProperty;
                    multiTypeBaseDataMap.put(otherQueryProp, itemClassProp.getTypePropName());
                    if (queryProps.contains(itemClassProp.getTypePropName())) continue;
                    fieldS.add(itemClassProp.getTypePropName());
                    continue;
                }
                if (!(iDataEntityProperty instanceof BasedataProp)) continue;
                if (matchPropType == MatchPropType.NUMBER) {
                    fieldS.add(otherQueryProp + ".number");
                    continue;
                }
                fieldS.add(otherQueryProp + ".name");
            }
            queryProps.addAll(fieldS);
            return multiTypeBaseDataMap;
        };
    }

    private MatchPropType getBizPropMatchPropType(String bizProp, MatchRuleBizBillQParam qParam) {
        return qParam.getBizPropAndPropType().computeIfAbsent(bizProp, key -> {
            String associateBizProp = qParam.getBizPropAndAssistBizProp().entrySet().stream().filter(entry -> Objects.equals(entry.getValue(), bizProp)).map(Map.Entry::getKey).findFirst().orElse(null);
            return qParam.getBizPropAndPropType().get(associateBizProp);
        });
    }
}

