/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.query;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.utils.CommonUtils;

public class ReportDataQueryResult
implements Serializable {
    private Long id;
    private Long reportId;
    private List<Long> dimIdList;
    private List<TemplateDim> dimList;
    private List<Object> dimValList;
    private BigDecimal planAmt;
    private BigDecimal actAmt;
    private BigDecimal lockAmt;
    private BigDecimal holdActAmt;
    private BigDecimal holdLockAmt;
    private BigDecimal offsetAmt;
    private BigDecimal applyPlanAmt;
    private BigDecimal reportPlanAmt;
    private BigDecimal originalPlanAmt;
    private BigDecimal planReferenceAmt;
    private Integer version;
    private AmountUnit amountUnit;
    private Long reportPeriodId;
    private boolean mainTable;
    private int row;
    private int col;
    private Map<Long, String> auxiliaryValMap;
    private Object value;
    private Map<Long, Object> metricValMap;
    private ReportStatus reportStatus;
    private List<Long> sourceIdList;
    private Long systemId;
    private boolean smartGelFlag;
    private boolean isAuxiliaryInfo;

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public BigDecimal getBigDecimalValue() {
        if (this.value instanceof BigDecimal) {
            return (BigDecimal)this.value;
        }
        return BigDecimal.ZERO;
    }

    public void putMetricVal(Long metricId, Object val) {
        this.metricValMap.put(metricId, val);
    }

    public Map<Long, Object> getMetricValMap() {
        return this.metricValMap;
    }

    public ReportDataQueryResult() {
        this.metricValMap = new HashMap<Long, Object>(8);
    }

    public ReportDataQueryResult(ReportDataQueryResult result) {
        this.id = result.id;
        this.reportId = result.reportId;
        this.dimIdList = new ArrayList<Long>(result.dimIdList);
        this.dimList = new ArrayList<TemplateDim>(result.dimList);
        this.dimValList = new ArrayList<Object>(result.dimValList);
        this.planAmt = result.planAmt;
        this.actAmt = result.actAmt;
        this.lockAmt = result.lockAmt;
        this.holdActAmt = result.holdActAmt;
        this.holdLockAmt = result.holdLockAmt;
        this.offsetAmt = result.offsetAmt;
        this.applyPlanAmt = result.applyPlanAmt;
        this.reportPlanAmt = result.reportPlanAmt;
        this.originalPlanAmt = result.originalPlanAmt;
        this.planReferenceAmt = result.planReferenceAmt;
        this.version = result.version;
        this.amountUnit = result.amountUnit;
        this.reportPeriodId = result.reportPeriodId;
        this.mainTable = result.mainTable;
        this.row = result.row;
        this.col = result.col;
        this.auxiliaryValMap = result.auxiliaryValMap;
        this.metricValMap = result.metricValMap;
        this.isAuxiliaryInfo = result.isAuxiliaryInfo;
        this.smartGelFlag = result.smartGelFlag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportDataQueryResult that = (ReportDataQueryResult)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean isAuxiliaryInfo() {
        return this.isAuxiliaryInfo;
    }

    public void setAuxiliaryInfo(boolean auxiliaryInfo) {
        this.isAuxiliaryInfo = auxiliaryInfo;
    }

    public List<Long> getDimIdList() {
        return this.dimIdList;
    }

    public void setDimIdList(List<Long> dimIdList) {
        this.dimIdList = dimIdList;
    }

    public List<Object> getDimValList() {
        return this.dimValList;
    }

    public void setDimValList(List<Object> dimValList) {
        this.dimValList = dimValList;
    }

    public BigDecimal getPlanAmt() {
        return this.planAmt;
    }

    public void setPlanAmt(BigDecimal planAmt) {
        this.planAmt = planAmt;
    }

    public BigDecimal getActAmt() {
        return this.actAmt;
    }

    public void setActAmt(BigDecimal actAmt) {
        this.actAmt = actAmt;
    }

    public BigDecimal getLockAmt() {
        return this.lockAmt;
    }

    public void setLockAmt(BigDecimal lockAmt) {
        this.lockAmt = lockAmt;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public AmountUnit getAmountUnit() {
        return this.amountUnit;
    }

    public void setAmountUnit(AmountUnit amountUnit) {
        this.amountUnit = amountUnit;
    }

    public List<TemplateDim> getDimList() {
        return this.dimList;
    }

    public void setDimList(List<TemplateDim> dimList) {
        this.dimList = dimList;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getReportId() {
        return this.reportId;
    }

    public void setReportId(Long reportId) {
        this.reportId = reportId;
    }

    public Long getReportPeriodId() {
        return this.reportPeriodId;
    }

    public void setReportPeriodId(Long reportPeriodId) {
        this.reportPeriodId = reportPeriodId;
    }

    public boolean isMainTable() {
        return this.mainTable;
    }

    public void setMainTable(boolean mainTable) {
        this.mainTable = mainTable;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public int getCol() {
        return this.col;
    }

    public void setCol(int col) {
        this.col = col;
    }

    public BigDecimal getApplyPlanAmt() {
        return this.applyPlanAmt;
    }

    public void setApplyPlanAmt(BigDecimal applyPlanAmt) {
        this.applyPlanAmt = applyPlanAmt;
    }

    public BigDecimal getReportPlanAmt() {
        return this.reportPlanAmt;
    }

    public void setReportPlanAmt(BigDecimal reportPlanAmt) {
        this.reportPlanAmt = reportPlanAmt;
    }

    public BigDecimal getOriginalPlanAmt() {
        return this.originalPlanAmt;
    }

    public void setOriginalPlanAmt(BigDecimal originalPlanAmt) {
        this.originalPlanAmt = originalPlanAmt;
    }

    public BigDecimal getOffsetAmt() {
        return this.offsetAmt;
    }

    public void setOffsetAmt(BigDecimal offsetAmt) {
        this.offsetAmt = offsetAmt;
    }

    public Map<Long, String> getAuxiliaryValMap() {
        return this.auxiliaryValMap;
    }

    public void setAuxiliaryValMap(Map<Long, String> auxiliaryValMap) {
        this.auxiliaryValMap = auxiliaryValMap;
    }

    public void setMetricValMap(Map<Long, Object> metricValMap) {
        this.metricValMap = metricValMap;
    }

    public ReportStatus getReportStatus() {
        return this.reportStatus;
    }

    public void setReportStatus(ReportStatus reportStatus) {
        this.reportStatus = reportStatus;
    }

    public List<Long> getSourceIdList() {
        return this.sourceIdList;
    }

    public void setSourceIdList(List<Long> sourceIdList) {
        this.sourceIdList = sourceIdList;
    }

    public BigDecimal getHoldActAmt() {
        return this.holdActAmt;
    }

    public void setHoldActAmt(BigDecimal holdActAmt) {
        this.holdActAmt = holdActAmt;
    }

    public BigDecimal getHoldLockAmt() {
        return this.holdLockAmt;
    }

    public void setHoldLockAmt(BigDecimal holdLockAmt) {
        this.holdLockAmt = holdLockAmt;
    }

    public Long getSystemId() {
        return this.systemId;
    }

    public void setSystemId(Long systemId) {
        this.systemId = systemId;
    }

    public BigDecimal getPlanReferenceAmt() {
        return this.planReferenceAmt;
    }

    public void setPlanReferenceAmt(BigDecimal planReferenceAmt) {
        this.planReferenceAmt = planReferenceAmt;
    }

    public boolean getSmartGelFlag() {
        return this.smartGelFlag;
    }

    public void setSmartGelFlag(boolean smartGelFlag) {
        this.smartGelFlag = smartGelFlag;
    }

    public void merge(ReportDataQueryResult reportDataQueryResult) {
        this.addPlanAmt(reportDataQueryResult.getPlanAmt());
        this.addActAmt(reportDataQueryResult.getActAmt());
        this.addLockAmt(reportDataQueryResult.getLockAmt());
        this.addReportPlanAmt(reportDataQueryResult.getReportPlanAmt());
        this.addOriginalPlanAmt(reportDataQueryResult.getOriginalPlanAmt());
        this.addPlanReferenceAmt(reportDataQueryResult.getPlanReferenceAmt());
    }

    public void addPlanAmt(BigDecimal planAmt) {
        if (Objects.isNull(this.planAmt)) {
            this.planAmt = BigDecimal.ZERO;
        }
        this.planAmt = this.planAmt.add(CommonUtils.getValueIfNull(planAmt));
    }

    public void addLockAmt(BigDecimal lockAmt) {
        if (Objects.isNull(this.lockAmt)) {
            this.lockAmt = BigDecimal.ZERO;
        }
        this.lockAmt = this.lockAmt.add(CommonUtils.getValueIfNull(lockAmt));
    }

    public void addActAmt(BigDecimal actAmt) {
        if (Objects.isNull(this.actAmt)) {
            this.actAmt = BigDecimal.ZERO;
        }
        this.actAmt = this.actAmt.add(CommonUtils.getValueIfNull(actAmt));
    }

    public void addReportPlanAmt(BigDecimal reportPlanAmt) {
        if (Objects.isNull(this.reportPlanAmt)) {
            this.reportPlanAmt = BigDecimal.ZERO;
        }
        this.reportPlanAmt = this.reportPlanAmt.add(CommonUtils.getValueIfNull(reportPlanAmt));
    }

    public void addOriginalPlanAmt(BigDecimal originalPlanAmt) {
        if (Objects.isNull(this.originalPlanAmt)) {
            this.originalPlanAmt = BigDecimal.ZERO;
        }
        this.originalPlanAmt = this.originalPlanAmt.add(CommonUtils.getValueIfNull(originalPlanAmt));
    }

    public void addPlanReferenceAmt(BigDecimal planReferenceAmt) {
        this.planReferenceAmt = CommonUtils.getValueIfNull(this.planReferenceAmt).add(CommonUtils.getValueIfNull(planReferenceAmt));
    }
}

