/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.query.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.IDimensionCombinationQueryService;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryObject;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryResult;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryService;
import kd.tmc.fpm.business.domain.model.control.DimValueListInfo;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.sumplan.EvalDimensionCombination;
import kd.tmc.fpm.business.domain.model.sumplan.EvalDimensionVal;
import kd.tmc.fpm.business.helper.ReportHelper;

public class DimensionCombinationQueryServiceImpl
implements IDimensionCombinationQueryService {
    private ReportDataQueryService queryService = new ReportDataQueryService();

    @Override
    public List<ReportData> queryReportDataByDimensionCombination(Collection<EvalDimensionCombination> combinationCollections, Consumer<ReportDataQueryObject> consumer, Predicate<EvalDimensionVal> predicate) {
        if (EmptyUtil.isEmpty(combinationCollections)) {
            return Collections.emptyList();
        }
        DimValueListInfo dimValueListInfo = new DimValueListInfo();
        for (EvalDimensionCombination combination : combinationCollections) {
            List<EvalDimensionVal> dimensionValList = combination.getEvalDimensionValList();
            if (EmptyUtil.isEmpty(dimensionValList)) continue;
            dimensionValList.stream().filter(predicate::test).forEach(evalDimensionVal -> {
                Dimension dimension = new Dimension();
                dimension.setId(evalDimensionVal.getDimensionId());
                dimension.setDimType(evalDimensionVal.getDimensionType());
                dimension.setSystemId(combination.getSystemId());
                dimValueListInfo.addDimensionValue(dimension, evalDimensionVal.getValue());
            });
        }
        ReportDataQueryObject reportDataQueryObject = new ReportDataQueryObject();
        reportDataQueryObject.setDimIdList(dimValueListInfo.getDimensionList());
        reportDataQueryObject.setDimValList(dimValueListInfo.getDimValueList());
        reportDataQueryObject.setNeedDimIfValueIsNotEmpty(true);
        if (Objects.nonNull(consumer)) {
            consumer.accept(reportDataQueryObject);
        }
        List<ReportDataQueryResult> reportDataQueryResults = this.queryService.queryReportDataForAllSystem(reportDataQueryObject);
        return ReportHelper.convert(reportDataQueryResults);
    }
}

