/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.save;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.query.IReportDataQueryService;
import kd.tmc.fpm.business.dataproc.query.ReportDataQueryService;
import kd.tmc.fpm.business.dataproc.save.IInOutCollectSaveService;
import kd.tmc.fpm.business.dataproc.save.IReportDataSaveService;
import kd.tmc.fpm.business.dataproc.save.IReportEntrySaveService;
import kd.tmc.fpm.business.dataproc.save.ReportDataSaveObject;
import kd.tmc.fpm.business.dataproc.save.domain.DataSaveResult;
import kd.tmc.fpm.business.dataproc.save.domain.FpmResponse;
import kd.tmc.fpm.business.dataproc.save.domain.ReportDataBatchSaveParam;
import kd.tmc.fpm.business.dataproc.save.impl.ReportDataBatchSaveParamTransferStrategy;
import kd.tmc.fpm.business.dataproc.save.impl.ReportDataBatchSaveParamValidator;
import kd.tmc.fpm.business.dataproc.save.impl.ReportDataBatchUpperSumService;
import kd.tmc.fpm.business.dataproc.save.impl.ReportEntrySaveServiceImpl;
import kd.tmc.fpm.business.dataproc.save.impl.SyncShrekReportDataServiceImpl;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.ReportProcessStatus;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.MetricMember;
import kd.tmc.fpm.business.domain.model.dimension.member.OrgMember;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.sumplan.MainSubReport;
import kd.tmc.fpm.business.domain.model.sumplan.ReportKey;
import kd.tmc.fpm.business.domain.model.sumplan.SumPlanRecord;
import kd.tmc.fpm.business.domain.model.template.ReportTemplate;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.domain.service.IReportService;
import kd.tmc.fpm.business.domain.service.impl.ReportService;
import kd.tmc.fpm.business.helper.ReportHelper;
import kd.tmc.fpm.business.mvc.repository.IDimensionRepository;
import kd.tmc.fpm.business.mvc.repository.IReportRepository;
import kd.tmc.fpm.business.mvc.repository.ISumPlanRepository;
import kd.tmc.fpm.business.mvc.repository.ITemplateRepository;
import kd.tmc.fpm.business.mvc.repository.dto.ReportNeedPropDTO;
import kd.tmc.fpm.business.mvc.repository.impl.DimensionRepository;
import kd.tmc.fpm.business.mvc.repository.impl.ReportRepository;
import kd.tmc.fpm.business.mvc.repository.impl.SumPlanRepository;
import kd.tmc.fpm.business.mvc.repository.impl.TemplateRepository;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.business.utils.MetricValueUtils;
import kd.tmc.fpm.common.enums.MetricMemberTypeEnum;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.impl.FpmTracer;
import kd.tmc.fpm.olap.enums.ShrekSyncStatus;
import kd.tmc.fpm.olap.enums.SyncLogType;
import kd.tmc.fpm.olap.model.ShrekSyncLog;
import kd.tmc.fpm.olap.service.log.SyncLogSaveService;
import kd.tmc.fpm.olap.service.log.impl.SyncLogSaveServiceImpl;

public class ReportDataSaveService
implements IReportDataSaveService {
    private static Log logger = LogFactory.getLog(ReportDataSaveService.class);
    private IReportRepository reportRep = new ReportRepository();
    private ISumPlanRepository sumPlanRep = new SumPlanRepository();
    private ITemplateRepository templateRep = new TemplateRepository();
    private IReportService reportService = new ReportService();
    private IDimensionRepository dimensionRepository = new DimensionRepository();
    private SyncLogSaveService syncLogSaveService = new SyncLogSaveServiceImpl();
    private IReportEntrySaveService reportEntrySaveService = new SyncShrekReportDataServiceImpl(new ReportEntrySaveServiceImpl());
    private IReportDataQueryService reportDataQueryService = new ReportDataQueryService();
    private final IInOutCollectSaveService iInOutCollectSaveService = FpmServiceFactory.getBizService(IInOutCollectSaveService.class);

    @Override
    public FpmOperateResult<Boolean> saveReportData(ReportDataSaveObject saveObject) {
        ReportTemplate template;
        logger.info("\u4fdd\u5b58\u62a5\u8868\u6570\u636e");
        Long reportId = saveObject.getReportId();
        Long reportDataId = saveObject.getReportDataId();
        Long systemId = saveObject.getSystemId();
        Long templateId = saveObject.getTemplateId();
        String templateName = saveObject.getTemplateName();
        Long reportPeriodId = saveObject.getReportPeriodId();
        Long reportOrgId = saveObject.getReportOrgId();
        Long companyId = saveObject.getCompanyId();
        Long entryPeriodId = saveObject.getEntryPeriodId();
        Long subjectId = saveObject.getSubjectId();
        Long settleTypeId = saveObject.getSettleTypeId();
        Long currencyId = saveObject.getCurrencyId();
        FundPlanSystem system = this.dimensionRepository.loadSystem(systemId);
        HashMap<Long, String> dimensionMap = new HashMap<Long, String>(2);
        if (EmptyUtil.isNoEmpty((Long)companyId)) {
            DynamicObject company = TmcDataServiceHelper.loadSingle((Object)companyId, (String)"fpm_member");
            if (EmptyUtil.isEmpty((DynamicObject)company)) {
                return FpmOperateResult.error(String.format(ResManager.loadKDString((String)"\u63a5\u5165\u5931\u8d25\u3002\u7ef4\u5ea6\u4fe1\u606f\u5f02\u5e38\uff0c\u65e0\u6cd5\u5728\u4f53\u7cfb\u4e2d\u627e\u5230\u5bf9\u5e94\u7684\u516c\u53f8\u7ef4\u5ea6\u201c%s\u201d\u3002", (String)"ReportDataSaveService_0", (String)"tmc-fpm-business", (Object[])new Object[0]), companyId));
            }
            dimensionMap.put(companyId, company.getString("name"));
        }
        if (EmptyUtil.isNoEmpty((Long)entryPeriodId)) {
            DynamicObject entryPeriod = TmcDataServiceHelper.loadSingle((Object)entryPeriodId, (String)"fpm_member");
            if (EmptyUtil.isEmpty((DynamicObject)entryPeriod)) {
                return FpmOperateResult.error(String.format(ResManager.loadKDString((String)"\u63a5\u5165\u5931\u8d25\u3002\u7ef4\u5ea6\u4fe1\u606f\u5f02\u5e38\uff0c\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u671f\u95f4\u7ef4\u5ea6\u201c%s\u201d\u3002", (String)"ReportDataSaveService_1", (String)"tmc-fpm-business", (Object[])new Object[0]), entryPeriodId));
            }
            dimensionMap.put(entryPeriodId, entryPeriod.getString("name"));
        }
        if (EmptyUtil.isNoEmpty((Long)subjectId)) {
            DynamicObject subject2 = TmcDataServiceHelper.loadSingle((Object)subjectId, (String)"fpm_member");
            if (EmptyUtil.isEmpty((DynamicObject)subject2)) {
                return FpmOperateResult.error(String.format(ResManager.loadKDString((String)"\u63a5\u5165\u5931\u8d25\u3002\u7ef4\u5ea6\u4fe1\u606f\u5f02\u5e38\uff0c\u65e0\u6cd5\u5728\u4f53\u7cfb\u4e2d\u627e\u5230\u5bf9\u5e94\u7684\u8ba1\u5212\u79d1\u76ee\u7ef4\u5ea6\u201c%s\u201d\u3002", (String)"ReportDataSaveService_2", (String)"tmc-fpm-business", (Object[])new Object[0]), subjectId));
            }
            dimensionMap.put(subjectId, subject2.getString("name"));
        }
        if (EmptyUtil.isNoEmpty((Long)settleTypeId)) {
            DynamicObject settleType = TmcDataServiceHelper.loadSingle((Object)settleTypeId, (String)"fpm_member");
            if (EmptyUtil.isEmpty((DynamicObject)settleType)) {
                return FpmOperateResult.error(String.format(ResManager.loadKDString((String)"\u63a5\u5165\u5931\u8d25\u3002\u7ef4\u5ea6\u4fe1\u606f\u5f02\u5e38\uff0c\u65e0\u6cd5\u5728\u4f53\u7cfb\u4e2d\u627e\u5230\u5bf9\u5e94\u7684\u7ed3\u7b97\u7ef4\u5ea6\u201c%s\u201d\u3002", (String)"ReportDataSaveService_3", (String)"tmc-fpm-business", (Object[])new Object[0]), settleTypeId));
            }
            dimensionMap.put(settleTypeId, settleType.getString("name"));
        }
        if (EmptyUtil.isNoEmpty((Long)currencyId)) {
            DynamicObject currency = TmcDataServiceHelper.loadSingle((Object)currencyId, (String)"fpm_member");
            if (EmptyUtil.isEmpty((DynamicObject)currency)) {
                return FpmOperateResult.error(String.format(ResManager.loadKDString((String)"\u63a5\u5165\u5931\u8d25\u3002\u7ef4\u5ea6\u4fe1\u606f\u5f02\u5e38\uff0c\u4f53\u7cfb\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u5e01\u79cd\u7ef4\u5ea6\u201c%s\u201d\u3002", (String)"ReportDataSaveService_4", (String)"tmc-fpm-business", (Object[])new Object[0]), currencyId));
            }
            dimensionMap.put(currencyId, currency.getString("name"));
        }
        if (reportId == null) {
            if (templateId == null && EmptyUtil.isEmpty((String)templateName)) {
                return FpmOperateResult.error(ResManager.loadKDString((String)"\u6a21\u677fID\u548c\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"ReportDataSaveService_5", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
            if (systemId == null || reportPeriodId == null || reportOrgId == null) {
                return FpmOperateResult.error(ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u5355\u636eID\u548c\u4f53\u7cfb\u3001\u6a21\u677f\u3001\u7f16\u62a5\u4e3b\u4f53\u3001\u7f16\u62a5\u671f\u95f4\u3002", (String)"ReportDataSaveService_6", (String)"tmc-fpm-business", (Object[])new Object[0]));
            }
        }
        Report report = null;
        SumPlanRecord sumPlanRecord = null;
        if (reportId != null) {
            HashSet<Long> reportIds = new HashSet<Long>(1);
            reportIds.add(reportId);
            List<Report> reportList = this.getReport(reportIds, t -> t.setNeedTemplate(true));
            if (EmptyUtil.isNoEmpty(reportList)) {
                report = reportList.get(0);
            }
            if (EmptyUtil.isEmpty((Object)report)) {
                sumPlanRecord = this.sumPlanRep.load(reportId);
            }
        } else {
            List<Report> reportList;
            if (templateId == null) {
                ReportTemplate template2 = this.templateRep.loadTemplate(templateName);
                if (EmptyUtil.isEmpty((Object)template2)) {
                    return FpmOperateResult.error(ResManager.loadKDString((String)"\u6a21\u677f\u540d\u79f0\u4e0d\u5b58\u5728\u3002", (String)"ReportDataSaveService_7", (String)"tmc-fpm-business", (Object[])new Object[0]));
                }
                templateId = template2.getId();
            }
            if (EmptyUtil.isNoEmpty(reportList = this.loadReport(systemId, templateId, reportPeriodId, reportOrgId, t -> t.setNeedTemplate(true)))) {
                report = reportList.get(0);
            }
        }
        if (EmptyUtil.isEmpty(report) && EmptyUtil.isEmpty(sumPlanRecord)) {
            return FpmOperateResult.error(ResManager.loadKDString((String)"\u8ba1\u5212\u7f16\u5236\u548c\u6c47\u603b\u7f16\u5236\u5747\u65e0\u6cd5\u4f7f\u7528\u3002", (String)"ReportDataSaveService_8", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        List<ReportDataSaveObject.MetricMember> metricMembers = saveObject.getMetricMembers();
        if (EmptyUtil.isEmpty(metricMembers)) {
            return FpmOperateResult.error(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5ea6\u91cf\u503c\u5217\u8868\u201d\u3002", (String)"ReportDataSaveService_9", (String)"tmc-fpm-business", (Object[])new Object[0]));
        }
        Map sysMetricMemberMap = system.getMainDimensionByDimType(DimensionType.METRIC).getAllDimMemberList(MetricMember.class).stream().filter(DimMember::isEnable).collect(Collectors.toMap(c1 -> c1.getNumber(), Function.identity(), (a, b) -> a));
        StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u5ea6\u91cf\u503c\uff1a", (String)"ReportDataSaveService_10", (String)"tmc-fpm-business", (Object[])new Object[0]));
        StringBuilder notAllowUpdateField = new StringBuilder();
        for (ReportDataSaveObject.MetricMember metricMember : metricMembers) {
            MetricMember sysMetricMember = (MetricMember)sysMetricMemberMap.get(metricMember.getNumber());
            if (EmptyUtil.isEmpty((Object)sysMetricMember)) {
                return FpmOperateResult.error(String.format(ResManager.loadKDString((String)"\u5ea6\u91cf\u503c\u201c%s\u201d\u4e0d\u5b58\u5728\u3002", (String)"ReportDataSaveService_11", (String)"tmc-fpm-business", (Object[])new Object[0]), metricMember.getName()));
            }
            metricMember.setMetrictype(sysMetricMember.getMetricType().getValue());
            metricMember.setTemplateMetricType(sysMetricMember.getTemplateMetricType());
            sb.append(String.format("\u3010%s\u3011", sysMetricMember.getName()));
            if (Arrays.asList(TemplateMetricType.PLANREFERENCEAMT, TemplateMetricType.REPORTPLANAMT, TemplateMetricType.ORIGINALPLANAMT).contains(sysMetricMember.getTemplateMetricType())) {
                notAllowUpdateField.append(String.format("\u3010%s\u3011", metricMember.getName()));
            }
            if (EmptyUtil.isNoEmpty((Object)report) && MetricMemberTypeEnum.BASE != sysMetricMember.getMetricType()) {
                return FpmOperateResult.error(String.format(ResManager.loadKDString((String)"\u6570\u636e\u63a5\u5165\u5931\u8d25\u3002\u5ea6\u91cf\u503c\uff1a%s\u7684\u5ea6\u91cf\u7c7b\u578b\u4e0d\u662f\u57fa\u7840\u5ea6\u91cf\uff0c\u65e0\u6cd5\u63a5\u5165\u8ba1\u5212\u8868\u3002", (String)"ReportDataSaveService_15", (String)"tmc-fpm-business", (Object[])new Object[0]), metricMember.getName()));
            }
            if (!EmptyUtil.isNoEmpty((Object)sumPlanRecord) || MetricMemberTypeEnum.BASE != sysMetricMember.getMetricType()) continue;
            return FpmOperateResult.error(String.format(ResManager.loadKDString((String)"\u6570\u636e\u63a5\u5165\u5931\u8d25\u3002\u6c47\u603b\u5904\u7406\u5355\u636e\u4e0d\u652f\u6301\u63a5\u53e3\u66f4\u65b0%s\u7684\u6570\u636e\u3002", (String)"ReportDataSaveService_16", (String)"tmc-fpm-business", (Object[])new Object[0]), metricMember.getName()));
        }
        if (EmptyUtil.isNotBlank((CharSequence)notAllowUpdateField)) {
            return FpmOperateResult.error(String.format(ResManager.loadKDString((String)"\u63a5\u5165\u5931\u8d25\u3002%s\u8bb0\u5f55\u4e0d\u652f\u6301\u5199\u5165\u66f4\u65b0\u3002", (String)"ReportDataSaveService_17", (String)"tmc-fpm-business", (Object[])new Object[0]), notAllowUpdateField));
        }
        if (sumPlanRecord != null && EmptyUtil.isNoEmpty(sumPlanRecord.getSumPlanReportList())) {
            report = sumPlanRecord.getSumPlanReportList().get(0);
        }
        List subjects = null;
        if (report != null && (template = report.getTemplate()) != null) {
            subjects = template.getAccountSettings().stream().filter(subject -> EmptyUtil.isEmpty(subject.getChildren())).collect(Collectors.toList());
        }
        if (subjectId != null) {
            Optional<TemplateAccountSetting> settingOptional = Optional.empty();
            if (subjects != null) {
                settingOptional = subjects.stream().filter(c -> subjectId.equals(c.getAccountMemId())).findFirst();
            }
            if (!settingOptional.isPresent()) {
                return FpmOperateResult.error(String.format(ResManager.loadKDString((String)"\u63a5\u5165\u5931\u8d25\u3002\u4ec5\u652f\u6301\u901a\u8fc7\u63a5\u53e3\u66f4\u65b0\u53f6\u5b50\u8282\u70b9\u7684\u7ef4\u5ea6\u7ec4\u5408\u4e0b\u7684%s\u8bb0\u5f55\u3002", (String)"ReportDataSaveService_18", (String)"tmc-fpm-business", (Object[])new Object[0]), sb));
            }
        }
        if (report != null) {
            for (ReportDataSaveObject.MetricMember metricMember : metricMembers) {
                if (!MetricMemberTypeEnum.BASE.getValue().equals(metricMember.getMetrictype())) continue;
                if (TemplateMetricType.PLANAMT == metricMember.getTemplateMetricType() && ReportProcessStatus.SAVE != report.getProcessStatus()) {
                    return FpmOperateResult.error(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u7f16\u5236\u5355\u636e\u201c%1$s\u201d\u4e3a\u975e\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u652f\u6301\u63a5\u53e3\u5199\u5165\u201c\u8ba1\u5212\u989d\u5ea6\u201d\u6570\u636e\u3002", (String)"ReportDataSaveService_20", (String)"tmc-fpm-business", (Object[])new Object[0]), report.getNumber()));
                }
                if (!Arrays.asList(TemplateMetricType.LOCKAMT, TemplateMetricType.ACTMAT).contains(metricMember.getTemplateMetricType()) || ReportStatus.DISABLE != report.getReportStatus()) continue;
                return FpmOperateResult.error(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u7f16\u5236\u5355\u636e\u201c%1$s\u201d\u975e\u751f\u6548\u72b6\u6001\uff0c\u4e0d\u652f\u6301\u63a5\u53e3\u5199\u5165\u201c\u9884\u5360\u7528\u989d\u5ea6\u201d\u201c\u5df2\u6267\u884c\u989d\u5ea6\u201d\u6570\u636e\u3002", (String)"ReportDataSaveService_23", (String)"tmc-fpm-business", (Object[])new Object[0]), report.getNumber()));
            }
            FpmOperateResult<Boolean> dimensionSb = this.updateReportDataAmt(reportDataId, companyId, entryPeriodId, subjectId, settleTypeId, currencyId, dimensionMap, report, metricMembers);
            if (dimensionSb != null) {
                return dimensionSb;
            }
        }
        return FpmOperateResult.success(true);
    }

    private FpmOperateResult<Boolean> updateReportDataAmt(Long reportDataId, Long companyId, Long entryPeriodId, Long subjectId, Long settleTypeId, Long currencyId, Map<Long, String> dimensionMap, Report report, List<ReportDataSaveObject.MetricMember> metricMembers) {
        HashSet<Long> reportIds = new HashSet<Long>(1);
        reportIds.add(report.getId());
        List<Report> reportList = this.getReport(reportIds, t -> {
            t.setNeedTemplate(true);
            t.setNeedCompanyMember(true);
            t.setNeedPeriodMember(true);
        });
        FundPlanSystem system = this.dimensionRepository.loadSystem(report.getSystemId());
        List<MainSubReport> mainSubReportList = this.groupMainSubReport(reportList);
        for (MainSubReport mainSubReport : mainSubReportList) {
            List<Report> reports = this.reportRep.loadReport(mainSubReport.getReportIds());
            Map reportMap = reports.stream().collect(Collectors.toMap(Report::getId, Function.identity()));
            Report mainReport = (Report)reportMap.get(mainSubReport.getMainReport().getId());
            List<Report> childReports = mainSubReport.getChildReports();
            if (EmptyUtil.isEmpty(childReports)) {
                logger.info("\u4e3b\u8868\u3010{} {}\u3011\u6ca1\u6709\u6838\u5b9a\u5b50\u8868\u6570\u636e", (Object)mainReport.getNumber(), (Object)mainReport.getName());
            }
            boolean needSaveMain = false;
            for (Report childReport : childReports) {
                Report subReport = (Report)reportMap.get(childReport.getId());
                this.reportService.subSubData(mainReport, subReport, system);
                List<ReportData> updatedReportDataList = this.updateReportData(companyId, entryPeriodId, subjectId, settleTypeId, currencyId, subReport, reportDataId, metricMembers);
                if (EmptyUtil.isEmpty(updatedReportDataList)) {
                    logger.info("\u5b50\u8868\u3010{} {}\u3011\u6570\u636e\u6ca1\u6709\u53d1\u751f\u6539\u53d8", (Object)subReport.getNumber(), (Object)subReport.getName());
                    continue;
                }
                this.reportService.calcFormulaData(subReport, system, updatedReportDataList);
                this.reportService.reBuildReportData(subReport);
                this.reportService.sumSubData(mainReport, subReport, system);
                this.reportRep.saveReport(subReport);
                needSaveMain = true;
            }
            List<ReportData> updatedReportDataList = this.updateReportData(companyId, entryPeriodId, subjectId, settleTypeId, currencyId, mainReport, reportDataId, metricMembers);
            if (EmptyUtil.isNoEmpty(updatedReportDataList)) {
                logger.info("\u4e3b\u8868\u3010{} {}\u3011\u6570\u636e\u53d1\u751f\u6539\u53d8\uff0c\u6539\u53d8\u6570\u636e\uff1a\u3010{}\u3011", new Object[]{mainReport.getNumber(), mainReport.getName(), updatedReportDataList.stream().collect(Collectors.toMap(ReportData::getId, ReportData::getOriginalPlanAmt))});
                needSaveMain = true;
            }
            if (!needSaveMain) {
                StringBuilder dimensionSb = new StringBuilder();
                dimensionMap.forEach((t, u) -> {
                    dimensionSb.append((String)u);
                    dimensionSb.append("/");
                });
                return FpmOperateResult.error(String.format(ResManager.loadKDString((String)"\u6570\u636e\u63a5\u5165\u5931\u8d25\u3002\u65e0\u6cd5\u5728\u8ba1\u5212\u8868\u4e2d\u627e\u5230\u5bf9\u5e94\u7ef4\u5ea6\u7ec4\u5408\u201c%s\u201d\u4e0b\u7684\u8bb0\u5f55\uff0c\u65e0\u6cd5\u6267\u884c\u5199\u5165\u3002", (String)"ReportDataSaveService_24", (String)"tmc-fpm-business", (Object[])new Object[0]), dimensionSb));
            }
            this.reportService.calcFormulaData(mainReport, system);
            this.reportService.reBuildReportData(mainReport);
            this.reportRep.saveReport(mainReport);
        }
        return null;
    }

    private void setReportDataAmt(List<ReportDataSaveObject.MetricMember> metricMembers, ReportData reportData) {
        for (ReportDataSaveObject.MetricMember metricMember : metricMembers) {
            if (!MetricMemberTypeEnum.BASE.getValue().equals(metricMember.getMetrictype())) continue;
            MetricValueUtils.setMetricValue(metricMember.getTemplateMetricType(), reportData, metricMember.getPlanAmt());
        }
    }

    private List<ReportData> updateReportData(Long companyId, Long entryPeriodId, Long subjectId, Long settleTypeId, Long currencyId, Report report, Long reportDataId, List<ReportDataSaveObject.MetricMember> metricMembers) {
        ArrayList<ReportData> updatedReportDataList = new ArrayList<ReportData>(64);
        List<ReportData> reportDataList = report.getReportDataList();
        if (reportDataId != null) {
            Optional<ReportData> first = report.getReportDataList().stream().filter(item -> item.getId().equals(reportDataId)).findFirst();
            if (first.isPresent()) {
                this.setReportDataAmt(metricMembers, first.get());
                updatedReportDataList.add(first.get());
            }
        } else {
            for (ReportData reportData : reportDataList) {
                boolean companyExists = false;
                boolean entryPeriodExists = false;
                boolean subjectExists = false;
                boolean settleTypeExists = false;
                boolean currencyExists = false;
                Object companyDimVal = reportData.getDimValByDimType(DimensionType.COMPANY, null);
                Object periodVal = reportData.getDimValByDimType(DimensionType.PERIOD, null);
                Object subjectVal = reportData.getDimValByDimType(DimensionType.SUBJECTS, null);
                Object settlementVal = reportData.getDimValByDimType(DimensionType.SETTLEMENT_TYPE, null);
                Object currencyVal = reportData.getDimValByDimType(DimensionType.CURRENCY, null);
                if (companyId != null) {
                    if (companyId.equals(companyDimVal)) {
                        companyExists = true;
                    }
                } else {
                    companyExists = true;
                }
                if (entryPeriodId != null) {
                    if (entryPeriodId.equals(periodVal)) {
                        entryPeriodExists = true;
                    }
                } else {
                    entryPeriodExists = true;
                }
                if (subjectId != null) {
                    if (subjectId.equals(subjectVal)) {
                        subjectExists = true;
                    }
                } else {
                    subjectExists = true;
                }
                if (settleTypeId != null) {
                    if (settleTypeId.equals(settlementVal)) {
                        settleTypeExists = true;
                    }
                } else {
                    settleTypeExists = true;
                }
                if (currencyId != null) {
                    if (currencyId.equals(currencyVal)) {
                        currencyExists = true;
                    }
                } else {
                    currencyExists = true;
                }
                if (!companyExists || !entryPeriodExists || !subjectExists || !settleTypeExists || !currencyExists) continue;
                this.setReportDataAmt(metricMembers, reportData);
                updatedReportDataList.add(reportData);
            }
        }
        return updatedReportDataList;
    }

    public List<MainSubReport> groupMainSubReport(List<Report> reportList) {
        MainSubReport mainSubReport;
        Map<Boolean, List<Report>> groupMainSubReportMap = reportList.stream().collect(Collectors.groupingBy(r -> r.getTemplate().isMainTable()));
        List subReportList = groupMainSubReportMap.getOrDefault(Boolean.FALSE, Collections.emptyList());
        List mainReportList = groupMainSubReportMap.getOrDefault(Boolean.TRUE, Collections.emptyList());
        Map<Long, List<Report>> groupBySubTemReportMap = subReportList.stream().collect(Collectors.groupingBy(r -> r.getTemplate().getId()));
        ArrayList<MainSubReport> mainSubReportList = new ArrayList<MainSubReport>(8);
        for (Report mainReport : mainReportList) {
            ReportTemplate mainTemplate = mainReport.getTemplate();
            List<OrgMember> mainReportOrgList = mainReport.getCompanyMemberList();
            List<TemplateAccountSetting> accountSettings = mainTemplate.getAccountSettings();
            Set childTemplateIds = accountSettings.stream().filter(as -> as.getInputType() == ReportInputType.DETAIL_INPUT && EmptyUtil.isNoEmpty((Long)as.getChildTemplateId())).map(TemplateAccountSetting::getChildTemplateId).collect(Collectors.toSet());
            mainSubReport = new MainSubReport(mainReport);
            for (Long childTemplateId : childTemplateIds) {
                if (!groupBySubTemReportMap.containsKey(childTemplateId)) {
                    logger.info("\u5bf9\u67e5\u8be2\u5230\u7684\u5b50\u8868\u6309\u6a21\u677f\u5206\u7ec4:{}\u540e\u6ca1\u6709\u627e\u5230\u5b50\u6a21\u677f\uff1a{}", new Object[]{groupBySubTemReportMap, groupBySubTemReportMap.keySet(), childTemplateId});
                    continue;
                }
                List<Report> subReports = groupBySubTemReportMap.get(childTemplateId);
                logger.info("\u4e3b\u8868\uff1a{},\u627e\u5230\u5b50\u6a21\u677f:{}\u4e0b\u7684\u53ef\u80fd\u5b50\u8868:{}", new Object[]{mainReport.getNumber(), childTemplateId, subReports.stream().map(Report::getNumber).collect(Collectors.joining(";"))});
                Iterator<Report> iterator = subReports.iterator();
                while (iterator.hasNext()) {
                    Report next = iterator.next();
                    List<OrgMember> subReportOrgList = next.getCompanyMemberList();
                    if (!EmptyUtil.isNoEmpty(mainReportOrgList) || !EmptyUtil.isNoEmpty(subReportOrgList)) continue;
                    logger.info("\u4e3b\u8868\uff1a{}\uff0c\u7f16\u62a5\u4e3b\u4f53\uff1a{}\uff0c\u5b50\u8868\uff1a{}\uff0c\u7f16\u62a5\u4e3b\u4f53\uff1a{}", new Object[]{mainReport.getNumber(), mainReportOrgList.get(0).getName(), next.getNumber(), subReportOrgList.get(0).getName()});
                    if (!Objects.equals(mainReportOrgList.get(0).getId(), subReportOrgList.get(0).getId())) continue;
                    mainSubReport.addChildReport(next);
                    logger.info("\u4e3b\u8868\uff1a{}\uff0c\u627e\u5230\u5b50\u8868\uff1a{}", (Object)mainReport.getNumber(), (Object)next.getNumber());
                    iterator.remove();
                    subReportList.remove(next);
                }
                if (!EmptyUtil.isEmpty(subReports)) continue;
                groupBySubTemReportMap.remove(childTemplateId);
            }
            mainSubReportList.add(mainSubReport);
        }
        if (EmptyUtil.isEmpty(subReportList)) {
            return mainSubReportList;
        }
        HashMap<ReportKey, MainSubReport> mainSubReportMap = new HashMap<ReportKey, MainSubReport>(16);
        for (Report subReport : subReportList) {
            logger.info("\u5f00\u59cb\u4e3a\u5b50\u8868\uff1a{}\u67e5\u627e\u4e3b\u8868", (Object)subReport.getNumber());
            List<OrgMember> companyMemberList = subReport.getCompanyMemberList();
            if (EmptyUtil.isEmpty(companyMemberList)) continue;
            Long orgId = companyMemberList.get(0).getId();
            ReportKey reportKey = new ReportKey(orgId, subReport.getPeriodMemberList().get(0).getId(), subReport.getParentTemplateId());
            mainSubReport = mainSubReportMap.computeIfAbsent(reportKey, k -> new MainSubReport(this.reportRep.queryParentReport(reportKey.getOrgId(), reportKey.getPeriodId(), reportKey.getTemplateId())));
            if (Objects.isNull(mainSubReport.getMainReport())) {
                mainSubReportMap.remove(reportKey);
                continue;
            }
            logger.info("\u5b50\u8868\uff1a{}\uff0c\u627e\u5230\u4e3b\u8868\uff1a{}", (Object)subReport.getNumber(), (Object)mainSubReport.getMainReport().getNumber());
            mainSubReport.addChildReport(subReport);
        }
        mainSubReportList.addAll(mainSubReportMap.values());
        return mainSubReportList;
    }

    public List<Report> loadReport(Long systemId, Long templateId, Long reportPeriodId, Long reportOrgId, Consumer<ReportNeedPropDTO> consumer) {
        QFilter qFilter = new QFilter("bodysys", "=", (Object)systemId);
        qFilter.and("templatebak", "=", (Object)templateId);
        qFilter.and("reportperiod", "=", (Object)reportPeriodId);
        qFilter.and("reportorg", "=", (Object)reportOrgId);
        DynamicObject report = TmcDataServiceHelper.loadSingle((String)"fpm_report", (String)"id", (QFilter[])new QFilter[]{qFilter});
        HashSet<Long> reportIds = new HashSet<Long>(1);
        reportIds.add(report.getLong("id"));
        return this.getReport(reportIds, consumer);
    }

    private List<Report> getReport(Set<Long> reportIds, Consumer<ReportNeedPropDTO> consumer) {
        ReportNeedPropDTO reportNeedPropDTO = new ReportNeedPropDTO();
        if (EmptyUtil.isNoEmpty(consumer)) {
            consumer.accept(reportNeedPropDTO);
        }
        return this.reportRep.loadSimpleReport(reportIds, reportNeedPropDTO);
    }

    @Override
    public FpmOperateResult<Boolean> saveReportData(Report report) {
        try (IFpmTraceSpan span = FpmTracer.get().createSpan(ReportDataSaveService.class.getSimpleName());){
            span.addTag("Get Report");
            List<ReportData> reportDataList = report.getReportDataList();
            span.addTag("Set id");
            this.setIdIfNeed(reportDataList);
            span.addTag("load dbData");
            DynamicObject reportPO = TmcDataServiceHelper.loadSingle((Object)report.getId(), (String)"fpm_report");
            span.addTag("Handling differences");
            this.reportEntrySaveService.updateReportHead(report, reportPO);
            DataSaveResult dataSaveResult = this.reportEntrySaveService.saveOrUpdateReportData(reportDataList, reportPO);
            this.reportEntrySaveService.saveOrUpdateRemarkEntry(reportDataList, dataSaveResult, reportPO);
            this.reportEntrySaveService.saveOrUpdateSourceIdEntry(reportDataList, dataSaveResult, reportPO);
            this.iInOutCollectSaveService.saveOrUpdateReportRelation(new ArrayList<Long>(dataSaveResult.getSourceIdAndIdMap().keySet()), dataSaveResult);
            this.reportRep.save(reportPO);
            FpmOperateResult<Boolean> fpmOperateResult = FpmOperateResult.success(true);
            return fpmOperateResult;
        }
    }

    @Override
    public void updateReport(Report report) {
        List<ReportData> reportDataList = report.getReportDataList();
        this.setIdIfNeed(reportDataList);
        DynamicObject reportPO = TmcDataServiceHelper.loadSingle((Object)report.getId(), (String)"fpm_report");
        this.reportEntrySaveService.updateReportHead(report, reportPO);
        DataSaveResult dataSaveResult = this.reportEntrySaveService.saveOrUpdateReportData(reportDataList, reportPO);
        this.reportEntrySaveService.saveOrUpdateRemarkEntry(reportDataList, dataSaveResult, reportPO);
        this.reportEntrySaveService.saveOrUpdateSourceIdEntry(reportDataList, dataSaveResult, reportPO);
        this.reportRep.save(reportPO);
    }

    @Override
    public void batchUpdateReport(List<Report> report) {
        report.forEach(this::updateReport);
    }

    @Override
    public void saveReportData(List<ReportData> reportDataList, Long systemId) {
        List<ReportData> existsReportDataList;
        if (EmptyUtil.isEmpty(reportDataList)) {
            return;
        }
        int count = 0;
        HashSet<Long> reportDataIds = new HashSet<Long>(reportDataList.size() / 2);
        for (ReportData reportData : reportDataList) {
            if (EmptyUtil.isEmpty((Long)reportData.getId())) {
                ++count;
                continue;
            }
            reportDataIds.add(reportData.getId());
        }
        if (EmptyUtil.isNoEmpty(reportDataIds) && EmptyUtil.isNoEmpty(existsReportDataList = this.reportDataQueryService.queryReportData(t -> t.setIdList(new ArrayList<Long>(reportDataIds))))) {
            Set existsReportDataIds = existsReportDataList.stream().map(ReportData::getId).collect(Collectors.toSet());
            List<ReportData> updateReportDataList = reportDataList.stream().filter(rd -> existsReportDataIds.contains(rd.getId())).collect(Collectors.toList());
            this.reportEntrySaveService.updateReportData(updateReportDataList, systemId);
            reportDataList.removeAll(updateReportDataList);
        }
        if (EmptyUtil.isEmpty(reportDataList)) {
            return;
        }
        Deque<Long> batchGenerateIds = CommonUtils.batchGenerateIds(count);
        for (ReportData reportData : reportDataList) {
            if (!EmptyUtil.isEmpty((Long)reportData.getId())) continue;
            reportData.setId(batchGenerateIds.poll());
        }
        this.reportEntrySaveService.saveReportData(reportDataList, systemId);
    }

    @Override
    public FpmOperateResult<Boolean> batchSaveReportData(List<Report> reportList) {
        try (IFpmTraceSpan span = FpmTracer.get().createSpan(ReportDataSaveService.class.getSimpleName());){
            ArrayList reportPOList = new ArrayList();
            span.addTag("load dbData");
            Set<Object> reportIdList = reportList.stream().map(Report::getId).collect(Collectors.toSet());
            DynamicObject[] reportPOArray = TmcDataServiceHelper.load((Object[])reportIdList.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fpm_report"));
            Map reportPOMapById = Arrays.stream(reportPOArray).collect(Collectors.toMap(k -> (Long)k.getPkValue(), Function.identity()));
            reportList.forEach(report -> {
                span.addTag("Get Report");
                List<ReportData> reportDataList = report.getReportDataList();
                span.addTag("Set id");
                this.setIdIfNeed(reportDataList);
                DynamicObject reportPO = (DynamicObject)reportPOMapById.get(report.getId());
                span.addTag("Handling differences");
                this.reportEntrySaveService.updateReportHead((Report)report, reportPO);
                DataSaveResult dataSaveResult = this.reportEntrySaveService.saveOrUpdateReportData(reportDataList, reportPO);
                this.reportEntrySaveService.saveOrUpdateRemarkEntry(reportDataList, dataSaveResult, reportPO);
                this.reportEntrySaveService.saveOrUpdateSourceIdEntry(reportDataList, dataSaveResult, reportPO);
                reportPOList.add(reportPO);
            });
            SaveServiceHelper.save((DynamicObject[])reportPOList.toArray(new DynamicObject[0]));
            FpmOperateResult<Boolean> fpmOperateResult = FpmOperateResult.success(true);
            return fpmOperateResult;
        }
    }

    private void setIdIfNeed(List<ReportData> reportDataList) {
        List nullIdList = reportDataList.stream().filter(item -> item.getId() == null).collect(Collectors.toList());
        int count = nullIdList.size();
        LinkedList<Long> idQueue = new LinkedList<Long>();
        if (count > 0) {
            long[] idArr;
            for (long id : idArr = DB.genGlobalLongIds((int)count)) {
                idQueue.offer(id);
            }
        }
        for (ReportData reportData : nullIdList) {
            reportData.setId((Long)idQueue.poll());
            reportData.setDirty(true);
        }
    }

    @Override
    public FpmResponse<Void> batchSaveReportData(ReportDataBatchSaveParam saveParam) {
        try (IFpmTraceSpan span = FpmTracer.get().createSpan(ReportDataSaveService.class.getSimpleName());){
            span.addTag("param validate");
            ReportDataBatchSaveParamValidator validator = new ReportDataBatchSaveParamValidator();
            validator.process(saveParam);
            if (!validator.getResult().isSuccess()) {
                FpmResponse<Void> fpmResponse = validator.getResult();
                return fpmResponse;
            }
            span.addTag("param transfer and save db");
            ReportDataBatchSaveParamTransferStrategy transferStrategy = new ReportDataBatchSaveParamTransferStrategy();
            transferStrategy.process(saveParam);
            if (!transferStrategy.getResult().isSuccess()) {
                FpmResponse<Void> fpmResponse = transferStrategy.getResult();
                return fpmResponse;
            }
            Report report = transferStrategy.getReport();
            FundPlanSystem fundPlanSystem = transferStrategy.getFundPlanSystem();
            span.addTag("data write");
            Set templateMetricTypeSet = saveParam.getBatchSaveData().stream().map(data -> data.getMetricMembers()).flatMap(Collection::stream).map(member -> member.getTemplateMetricType()).collect(Collectors.toSet());
            List<MetricMember> metricMembers = fundPlanSystem.getMainDimensionByDimType(DimensionType.METRIC).getAllDimMemberList().stream().map(member -> (MetricMember)member).filter(metricMember -> templateMetricTypeSet.contains(metricMember.getTemplateMetricType())).collect(Collectors.toList());
            try (TXHandle tx = TX.required();){
                try {
                    this.saveReport4BatchSaveReportData(report, fundPlanSystem);
                    span.addTag("report upper sum");
                    ReportDataBatchUpperSumService planingReportUpperSumDealService = new ReportDataBatchUpperSumService(report, fundPlanSystem, metricMembers);
                    planingReportUpperSumDealService.upperSum();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    tx.markRollback();
                }
            }
            FpmResponse<Object> fpmResponse = FpmResponse.success(null);
            return fpmResponse;
        }
    }

    private void saveReport4BatchSaveReportData(Report report, FundPlanSystem system) {
        this.reportService.calculateReport(report, system);
        this.reportService.reBuildReportData(report, system);
        ReportHelper.checkReportDataAmt(report);
        FpmOperateResult<Boolean> saveResult = this.saveReportData(report);
        if (!saveResult.isSuccess()) {
            throw new KDBizException(String.join((CharSequence)",", saveResult.getMessageList()));
        }
        ((SyncShrekReportDataServiceImpl)this.reportEntrySaveService).syncReport(report.getId());
    }

    private static void setSyncLog(Long systemId, Set<Long> ids, List<ShrekSyncLog> logList, SyncLogType logType) {
        for (Long id : ids) {
            ShrekSyncLog log = new ShrekSyncLog();
            log.setSystemId(systemId);
            log.setEntityId(id);
            log.setEntityName("fpm_report");
            log.setLogType(logType);
            log.setSyncStatus(ShrekSyncStatus.WAIT_SYNC);
            logList.add(log);
        }
    }
}

