/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.save.domain;

import java.util.List;
import java.util.Objects;
import kd.bos.db.DBRoute;
import kd.tmc.fbp.common.constant.DBRouteConst;

public class SqlEntity<T> {
    private String entityName;
    private String updateFields;
    private String conditionFields;
    private List<T> entityList;
    private DBRoute dbRoute;
    private boolean needCondition = true;

    public SqlEntity() {
    }

    public SqlEntity(String entityName, String updateFields, String conditionFields, List<T> entityList, DBRoute dbRoute, boolean needCondition) {
        this.entityName = entityName;
        this.updateFields = updateFields;
        this.conditionFields = conditionFields;
        this.entityList = entityList;
        this.dbRoute = dbRoute;
        this.needCondition = needCondition;
    }

    public static <T> SqlEntityBuilder<T> builder() {
        return new SqlEntityBuilder();
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public String getUpdateFields() {
        return this.updateFields;
    }

    public void setUpdateFields(String updateFields) {
        this.updateFields = updateFields;
    }

    public String getConditionFields() {
        return this.conditionFields;
    }

    public void setConditionFields(String conditionFields) {
        this.conditionFields = conditionFields;
    }

    public List<T> getEntityList() {
        return this.entityList;
    }

    public void setEntityList(List<T> entityList) {
        this.entityList = entityList;
    }

    public DBRoute getDbRoute() {
        if (Objects.isNull(this.dbRoute)) {
            this.dbRoute = DBRouteConst.TMC;
        }
        return this.dbRoute;
    }

    public void setDbRoute(DBRoute dbRoute) {
        this.dbRoute = dbRoute;
    }

    public boolean isNeedCondition() {
        return this.needCondition;
    }

    public void setNeedCondition(boolean needCondition) {
        this.needCondition = needCondition;
    }

    public static class SqlEntityBuilder<T> {
        private String entityName;
        private String updateFields;
        private String conditionFields;
        private List<T> entityList;
        private DBRoute dbRoute;
        private boolean needCondition = true;

        public SqlEntityBuilder<T> entityName(String entityName) {
            this.entityName = entityName;
            return this;
        }

        public SqlEntityBuilder<T> updateFields(String updateFields) {
            this.updateFields = updateFields;
            return this;
        }

        public SqlEntityBuilder<T> conditionFields(String conditionFields) {
            this.conditionFields = conditionFields;
            return this;
        }

        public SqlEntityBuilder<T> entityList(List<T> entityList) {
            this.entityList = entityList;
            return this;
        }

        public SqlEntityBuilder<T> dbRoute(DBRoute dbRoute) {
            this.dbRoute = dbRoute;
            return this;
        }

        public SqlEntityBuilder<T> needCondition(boolean needCondition) {
            this.needCondition = needCondition;
            return this;
        }

        public SqlEntity<T> build() {
            return new SqlEntity<T>(this.entityName, this.updateFields, this.conditionFields, this.entityList, this.dbRoute, this.needCondition);
        }
    }
}

