/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.save.impl;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.save.domain.FpmResponse;
import kd.tmc.fpm.business.dataproc.save.domain.ReportDataBatchSaveObject;
import kd.tmc.fpm.business.dataproc.save.domain.ReportDataBatchSaveParam;
import kd.tmc.fpm.business.domain.enums.FpmErrorCodeEnum;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.enums.TemplateUseType;

public class ReportDataBatchSaveParamValidator {
    private FpmResponse<Void> result;
    private static final int BATCH_DATA_MAX_SIZE = 1000;

    public void process(ReportDataBatchSaveParam saveParam) {
        if (!this.validateMustInputParam(saveParam)) {
            this.result = FpmResponse.error(FpmErrorCodeEnum.REQUEST_PARAM_ERROR);
            return;
        }
        if (saveParam.getBatchSaveData().size() > 1000) {
            this.result = FpmResponse.error(FpmErrorCodeEnum.SAVE_DATA_OVERSIZE);
            return;
        }
        if (!this.reportOrgMappingSystemIfNeed(saveParam)) {
            this.result = FpmResponse.error(FpmErrorCodeEnum.REPORT_ORG_NO_MAPPING_SYSTEM);
            return;
        }
        if (!this.reportOrgMappingTemplateIfNeed(saveParam)) {
            this.result = FpmResponse.error(FpmErrorCodeEnum.REPORT_ORG_NO_MAPPING_SYSTEM);
            return;
        }
        if (!this.validateMetricMember(saveParam)) {
            this.result = FpmResponse.error(FpmErrorCodeEnum.INVALID_METRIC_MEMBER);
            return;
        }
        this.result = FpmResponse.success(null);
    }

    public FpmResponse<Void> getResult() {
        return this.result;
    }

    private boolean validateMustInputParam(ReportDataBatchSaveParam saveParam) {
        if (EmptyUtil.isEmpty((String)saveParam.getReportPeriodCode()) || EmptyUtil.isEmpty((String)saveParam.getReportOrgCode()) || EmptyUtil.isEmpty(saveParam.getBatchSaveData())) {
            return false;
        }
        List<ReportDataBatchSaveObject> batchSaveData = saveParam.getBatchSaveData();
        Predicate<ReportDataBatchSaveObject> currencyPredicate = saveObject -> EmptyUtil.isEmpty((String)saveObject.getCurrencyCode());
        currencyPredicate.or(saveObject -> EmptyUtil.isEmpty((String)saveObject.getSubjectCode())).or(saveObject -> EmptyUtil.isEmpty((String)saveObject.getEntryPeriodCode())).or(saveObject -> EmptyUtil.isEmpty(saveObject.getMetricMembers()) || saveObject.getMetricMembers().stream().anyMatch(metricMember -> Objects.isNull(metricMember.getTemplateMetricType()) || Objects.isNull(metricMember.getAmount())));
        Optional<ReportDataBatchSaveObject> loseMustInputParamData = batchSaveData.stream().filter(currencyPredicate).findAny();
        return !loseMustInputParamData.isPresent();
    }

    private boolean reportOrgMappingSystemIfNeed(ReportDataBatchSaveParam saveParam) {
        if (EmptyUtil.isNoEmpty((String)saveParam.getSystemCode())) {
            return true;
        }
        QFilter qFilter = new QFilter("number", "=", (Object)saveParam.getReportOrgCode());
        String bodySystemNumberProp = String.join((CharSequence)".", "bodysystem", "number");
        DynamicObjectCollection reportOrgDyColl = QueryServiceHelper.query((String)"fpm_member", (String)String.join((CharSequence)",", "id", bodySystemNumberProp), (QFilter[])qFilter.toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)reportOrgDyColl) || reportOrgDyColl.size() > 1) {
            return false;
        }
        saveParam.setSystemCode(((DynamicObject)reportOrgDyColl.get(0)).getString(bodySystemNumberProp));
        return true;
    }

    private boolean reportOrgMappingTemplateIfNeed(ReportDataBatchSaveParam saveParam) {
        if (EmptyUtil.isNoEmpty((String)saveParam.getTemplateCode())) {
            return true;
        }
        QFilter qFilter = new QFilter("number", "=", (Object)saveParam.getReportOrgCode()).and(String.join((CharSequence)".", "bodysystem", "number"), "=", (Object)saveParam.getSystemCode());
        List reportOrgIds = QueryServiceHelper.queryPrimaryKeys((String)"fpm_member", (QFilter[])qFilter.toArray(), null, (int)-1);
        if (EmptyUtil.isEmpty((Collection)reportOrgIds) || reportOrgIds.size() > 1) {
            return false;
        }
        QFilter templateFilter = new QFilter("user.fbasedataid", "=", reportOrgIds.get(0)).and("templateuses", "=", (Object)TemplateUseType.PLANING.getNumber()).and("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
        DynamicObjectCollection templateDyColl = QueryServiceHelper.query((String)"fpm_template", (String)"number", (QFilter[])templateFilter.toArray());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)templateDyColl) || templateDyColl.size() > 1) {
            return false;
        }
        saveParam.setTemplateCode(((DynamicObject)templateDyColl.get(0)).getString("number"));
        return true;
    }

    private boolean validateMetricMember(ReportDataBatchSaveParam saveParam) {
        Predicate<ReportDataBatchSaveObject.MetricMember> metricMemberPredicate = metricMember -> metricMember.getTemplateMetricType() != TemplateMetricType.PLANAMT && metricMember.getTemplateMetricType() != TemplateMetricType.PLANREFERENCEAMT && metricMember.getTemplateMetricType() != TemplateMetricType.LOCKAMT && metricMember.getTemplateMetricType() != TemplateMetricType.ACTMAT && metricMember.getTemplateMetricType() != TemplateMetricType.REPORTPLANAMT && metricMember.getTemplateMetricType() != TemplateMetricType.ORIGINALPLANAMT;
        Optional<ReportDataBatchSaveObject.MetricMember> invalidMetricMemberOp = saveParam.getBatchSaveData().stream().map(saveData -> saveData.getMetricMembers()).flatMap(Collection::stream).filter(metricMemberPredicate).findAny();
        return !invalidMetricMemberOp.isPresent();
    }
}

