/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.save.impl;

import com.google.common.base.Functions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.dataproc.save.IReportEntrySaveService;
import kd.tmc.fpm.business.dataproc.save.domain.DataSaveResult;
import kd.tmc.fpm.business.dataproc.save.domain.UpdateResult;
import kd.tmc.fpm.business.domain.enums.ReportStatus;
import kd.tmc.fpm.business.domain.model.index.BitMap;
import kd.tmc.fpm.business.domain.model.report.EntryReportData;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportDataWrapper;
import kd.tmc.fpm.business.domain.model.sumplan.AuxiliaryReportData;
import kd.tmc.fpm.business.domain.model.sumplan.DetailEntryReportData;
import kd.tmc.fpm.business.domain.model.sumplan.MainEntryReportData;
import kd.tmc.fpm.business.domain.model.sumplan.SourceIdEntryData;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.converter.utils.ConverterUtils;
import kd.tmc.fpm.business.mvc.service.DataParamFillBack;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.common.enums.ReportPlanChangeStatusEnum;
import kd.tmc.fpm.common.utils.FpmAssertUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class ReportEntrySaveServiceImpl
implements IReportEntrySaveService {
    private IDataSaveService dataSaveService = FpmServiceFactory.getBizService(IDataSaveService.class);
    private static final Log logger = LogFactory.getLog(ReportEntrySaveServiceImpl.class);

    @Override
    public void updateReportHead(Report report, DynamicObject reportDy) {
        FpmAssertUtil.isNotNull((Object)report, (String)"report is null");
        if (!reportDy.getBoolean("initflag") && report.getInitFlag() != null) {
            reportDy.set("initflag", (Object)report.getInitFlag());
        }
        reportDy.set("zeroreport", (Object)report.isZeroReport());
        if (report.getInformantErId() != null) {
            reportDy.set("informant", (Object)report.getInformantErId());
        }
        if (report.getChangeStatus() != null) {
            reportDy.set("changestatus", (Object)ReportPlanChangeStatusEnum.valueOf((String)report.getChangeStatus().name()).getValue());
        } else {
            reportDy.set("changestatus", (Object)ReportPlanChangeStatusEnum.UNCHANGE.getValue());
        }
        ReportStatus reportStatus = report.getReportStatus();
        if (reportStatus != null) {
            reportDy.set("planstatus", (Object)reportStatus.getVal());
        }
    }

    @Override
    public void saveReportData(List<ReportData> reportDataList, Long systemId) {
        if (EmptyUtil.isEmpty(reportDataList)) {
            return;
        }
        ArrayList<MainEntryReportData> mainEntryReportDataList = new ArrayList<MainEntryReportData>(reportDataList.size());
        ArrayList<DetailEntryReportData> detailEntryReportDataList = new ArrayList<DetailEntryReportData>(reportDataList.size());
        HashSet<Long> reportIds = new HashSet<Long>(2);
        for (ReportData reportData : reportDataList) {
            reportIds.add(reportData.getReportId());
            if (reportIds.size() > 1) break;
            MainEntryReportData mainEntryReportData = new MainEntryReportData(reportData);
            mainEntryReportData.setSystemId(systemId);
            mainEntryReportDataList.add(mainEntryReportData);
            mainEntryReportData.setId(reportData.getId());
            DetailEntryReportData detailEntryReportData = new DetailEntryReportData(reportData);
            detailEntryReportData.setId(reportData.getId());
            detailEntryReportData.setSystemId(systemId);
            detailEntryReportDataList.add(detailEntryReportData);
        }
        if (reportIds.size() > 1) {
            throw new KDBizException("reportDataList should from the same Report!");
        }
        Long reportId = (Long)reportIds.iterator().next();
        this.dataSaveService.saveEntryDataThrow(mainEntryReportDataList, reportId);
        this.dataSaveService.saveEntryDataThrow(detailEntryReportDataList, reportId);
    }

    @Override
    public void updateReportData(List<ReportData> reportDataList, Long systemId) {
        ArrayList<MainEntryReportData> mainEntryReportDataList = new ArrayList<MainEntryReportData>(reportDataList.size());
        for (ReportData reportData : reportDataList) {
            MainEntryReportData mainEntryReportData = new MainEntryReportData(reportData);
            mainEntryReportData.setId(reportData.getId());
            mainEntryReportData.setSystemId(systemId);
            mainEntryReportDataList.add(mainEntryReportData);
        }
        FpmOperateResult<UpdateResult> result = this.dataSaveService.updateEntityList(mainEntryReportDataList, set -> {
            set.add("planamt");
            set.add("orgplanamt");
            set.add("reportplanamt");
            set.add("lockamt");
            set.add("realamt");
            set.add("planreferenceamt");
            set.add("offsetamt");
        });
        if (!result.isSuccess()) {
            throw new KDBizException(String.join((CharSequence)",", Optional.ofNullable(result.getMessageList()).orElseGet(Collections::emptyList)));
        }
        UpdateResult data = result.getData();
        if (data.getUpdateCount() != reportDataList.size()) {
            throw new KDBizException("update failed! failed count:" + data.getFailedIndexList().size());
        }
    }

    @Override
    public DataSaveResult saveOrUpdateReportData(List<ReportData> reportDataList, DynamicObject reportDy) {
        DataSaveResult dataSaveResult = new DataSaveResult();
        this.doUpdateReportData(reportDataList, reportDy, dataSaveResult);
        this.doSave(reportDataList, reportDy, dataSaveResult);
        return dataSaveResult;
    }

    @Override
    public void saveOrUpdateRemarkEntry(List<ReportData> reportDataList, DataSaveResult dataSaveResult, DynamicObject reportDy) {
        DynamicObjectCollection auxEntry = reportDy.getDynamicObjectCollection("auxentry");
        auxEntry.removeIf(entry -> dataSaveResult.containsDeleteId(entry.getLong("aux_reportdataid")));
        Map auxReportDataMapMap = auxEntry.stream().collect(Collectors.groupingBy(d -> d.getLong("aux_reportdataid"), Collectors.toMap(d -> (Long)d.getDynamicObject("aux_bdtype").getPkValue(), Function.identity())));
        for (ReportData reportData : reportDataList) {
            DynamicObject dynamicObject;
            Map<Long, String> auxiliaryValMap;
            Boolean dirty;
            if (!reportData.isAuxiliaryInfo() || Objects.isNull(dirty = reportData.isDirty()) || !dirty.booleanValue() || MapUtils.isEmpty(auxiliaryValMap = reportData.getAuxiliaryValMap())) continue;
            Long reportDataId = reportData.getId();
            Map auxMap = auxReportDataMapMap.getOrDefault(reportDataId, Collections.emptyMap());
            if (MapUtils.isNotEmpty(auxMap)) {
                for (Map.Entry<Object, Object> entry2 : auxMap.entrySet()) {
                    dynamicObject = (DynamicObject)entry2.getValue();
                    Long key = (Long)entry2.getKey();
                    String value = auxiliaryValMap.getOrDefault(key, "");
                    dynamicObject.set("aux_content", (Object)value);
                }
                continue;
            }
            for (Map.Entry<Object, Object> entry3 : auxiliaryValMap.entrySet()) {
                dynamicObject = auxEntry.addNew();
                dynamicObject.set("aux_reportdataid", (Object)reportDataId);
                dynamicObject.set("aux_bdtype", entry3.getKey());
                dynamicObject.set("aux_content", entry3.getValue());
            }
        }
    }

    @Override
    public void saveOrUpdateSourceIdEntry(List<ReportData> reportDataList, DataSaveResult dataSaveResult, DynamicObject reportDy) {
        DynamicObjectCollection sourceIdSaveEntry = reportDy.getDynamicObjectCollection("sourceidentry");
        sourceIdSaveEntry.removeIf(entry -> {
            boolean deleteFlag = dataSaveResult.containsDeleteId(entry.getLong("rdi_reportdataid"));
            if (deleteFlag) {
                dataSaveResult.addSourceIdAndIdMapping(entry.getLong("sourcedocid"), entry.getLong("rdi_reportdataid"));
            }
            return deleteFlag;
        });
        Map sourceIdEntryDataMap = sourceIdSaveEntry.stream().collect(Collectors.groupingBy(d -> d.getLong("rdi_reportdataid"), Collectors.toMap(d -> d.getLong("sourcedocid"), Function.identity())));
        for (ReportData reportData : reportDataList) {
            Boolean dirty = reportData.isDirty();
            if (Objects.isNull(dirty) || !dirty.booleanValue()) continue;
            Long reportDataId = reportData.getId();
            List<Long> sourceIdList = reportData.getSourceIdList();
            Map sourceIdEntryMap = sourceIdEntryDataMap.getOrDefault(reportDataId, Collections.emptyMap());
            if (EmptyUtil.isEmpty(sourceIdList)) continue;
            for (Long sourceId : sourceIdList) {
                if (sourceIdEntryMap.containsKey(sourceId)) continue;
                DynamicObject dynamicObject = sourceIdSaveEntry.addNew();
                dynamicObject.set("rdi_reportdataid", (Object)reportDataId);
                dynamicObject.set("sourcedocid", (Object)sourceId);
                dataSaveResult.addSourceIdAndIdMapping(sourceId, reportDataId);
            }
        }
    }

    @Override
    public void saveSourceIdEntry(List<ReportData> reportDataList) {
        ArrayList sourceIdEntryDataList = new ArrayList(reportDataList.size());
        HashSet<Long> reportIds = new HashSet<Long>(2);
        for (ReportData reportData : reportDataList) {
            List<Long> sourceIdList = reportData.getSourceIdList();
            if (EmptyUtil.isEmpty(sourceIdList)) continue;
            reportIds.add(reportData.getReportId());
            if (reportIds.size() > 1) break;
            sourceIdEntryDataList.addAll(sourceIdList.stream().map(sourceId -> new SourceIdEntryData(reportData.getReportId(), reportData.getId(), (Long)sourceId)).collect(Collectors.toList()));
        }
        if (reportIds.size() > 1) {
            throw new KDBizException("reportDataList should from the same Report!");
        }
        this.dataSaveService.saveEntryDataThrow(sourceIdEntryDataList, reportIds.iterator().next());
    }

    @Override
    public UpdateResult updateReportData(List<ReportData> reportDataList, Long systemId, String sql, DataParamFillBack<ReportData, List<Object>> biConsumer) {
        return this.updateReportData(reportDataList, systemId, () -> sql, biConsumer);
    }

    @Override
    public UpdateResult updateReportData(List<ReportData> reportDataList, Long systemId, IDataSaveService.SqlInfo sqlInfo, DataParamFillBack<ReportData, List<Object>> biConsumer) {
        return this.dataSaveService.updateBySqlInfo(sqlInfo, reportDataList, biConsumer);
    }

    private void doSave(List<ReportData> reportDataList, DynamicObject reportDy, DataSaveResult dataSaveResult) {
        DynamicObjectCollection mainEntry = reportDy.getDynamicObjectCollection("maindimentry");
        DynamicObjectCollection detailDataEntry = reportDy.getDynamicObjectCollection("detailentry");
        Long systemId = reportDy.getLong(String.join((CharSequence)".", "bodysys", "id"));
        for (ReportData reportData : reportDataList) {
            Boolean dirty = reportData.isDirty();
            if (dirty == null) continue;
            Long reportDataId = reportData.getId();
            if (!dirty.booleanValue() || dataSaveResult.containsUpdateId(reportDataId)) continue;
            dataSaveResult.addSaveId(reportDataId);
            EntryReportData entryReportData = new EntryReportData(systemId, reportData);
            DynamicObject newEntry = mainEntry.addNew();
            ConverterUtils.convertWithArgs(DynamicObject.class, entryReportData, newEntry);
            DynamicObject detailEntry = detailDataEntry.addNew();
            ConverterUtils.convertWithArgs(DynamicObject.class, entryReportData, detailEntry);
            if (!CollectionUtils.isNotEmpty(reportData.getSourceIdList())) continue;
            dataSaveResult.addSaveMainData(newEntry);
        }
    }

    private void doUpdateReportData(List<ReportData> reportDataList, DynamicObject reportDy, DataSaveResult dataSaveResult) {
        Map reportDataMap = reportDataList.stream().collect(Collectors.toMap(ReportData::getId, Function.identity()));
        Long systemId = reportDy.getLong(String.join((CharSequence)".", "bodysys", "id"));
        DynamicObjectCollection mainEntry = reportDy.getDynamicObjectCollection("maindimentry");
        DynamicObjectCollection detailDataEntry = reportDy.getDynamicObjectCollection("detailentry");
        Map mainDataIdToDetailEntryMap = detailDataEntry.stream().collect(Collectors.toMap(o -> o.getLong("maindimdataid"), Functions.identity()));
        LinkedList<DynamicObject> waitRemoveEntryList = new LinkedList<DynamicObject>();
        LinkedList<DynamicObject> waitRemoveDetailEntryList = new LinkedList<DynamicObject>();
        for (DynamicObject entry : mainEntry) {
            Long entryId = (Long)entry.getPkValue();
            ReportData reportData = (ReportData)reportDataMap.get(entryId);
            if (Objects.isNull(reportData)) {
                dataSaveResult.addDeleteId((Long)entry.getPkValue());
                waitRemoveEntryList.add(entry);
                DynamicObject detailEntry = (DynamicObject)mainDataIdToDetailEntryMap.get(entryId);
                if (!Objects.nonNull(detailEntry)) continue;
                waitRemoveDetailEntryList.add(detailEntry);
                continue;
            }
            Boolean dirty = reportData.isDirty();
            if (!Objects.nonNull(dirty) || !dirty.booleanValue()) continue;
            dataSaveResult.addUpdateId(reportData.getId());
            DynamicObject detailEntry = (DynamicObject)mainDataIdToDetailEntryMap.get(entryId);
            EntryReportData entryReportData = new EntryReportData(systemId, reportData);
            ConverterUtils.convertWithArgs(DynamicObject.class, entryReportData, entry);
            ConverterUtils.convertWithArgs(DynamicObject.class, entryReportData, detailEntry);
        }
        dataSaveResult.addDeleteMainDataList(waitRemoveEntryList);
        mainEntry.removeAll(waitRemoveEntryList);
        detailDataEntry.removeAll(waitRemoveDetailEntryList);
    }

    @Override
    public void saveOrUpdateAuxiliaryReportDataForFix(List<ReportDataWrapper> reportDataWrapperList) {
        if (EmptyUtil.isEmpty(reportDataWrapperList)) {
            return;
        }
        reportDataWrapperList.removeIf(w -> !w.isAuxiliaryInfo());
        if (EmptyUtil.isEmpty(reportDataWrapperList)) {
            return;
        }
        try (TXHandle required = TX.required();){
            try {
                Map auxiliaryReportDataMap = reportDataWrapperList.stream().collect(Collectors.groupingBy(ReportDataWrapper::isNewData, Collectors.mapping(ReportDataWrapper::getReportData, Collectors.toList())));
                List<ReportData> saveAuxiliaryDataList = auxiliaryReportDataMap.getOrDefault(Boolean.TRUE, Collections.emptyList());
                this.doSaveAuxiliaryReportDataForFix(saveAuxiliaryDataList);
                List<ReportData> updateAuxiliaryDataList = auxiliaryReportDataMap.getOrDefault(Boolean.FALSE, Collections.emptyList());
                this.doUpdateAuxiliaryReportDataForFix(updateAuxiliaryDataList);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                required.markRollback();
                throw e;
            }
        }
    }

    private void doUpdateAuxiliaryReportDataForFix(List<ReportData> updateAuxiliaryDataList) {
        if (EmptyUtil.isEmpty(updateAuxiliaryDataList)) {
            return;
        }
        ArrayList<AuxiliaryReportData> auxiliaryReportDataList = new ArrayList<AuxiliaryReportData>(updateAuxiliaryDataList.size());
        for (ReportData reportData : updateAuxiliaryDataList) {
            Map<Long, String> auxiliaryValMap = reportData.getAuxiliaryValMap();
            if (MapUtils.isEmpty(auxiliaryValMap)) continue;
            for (Map.Entry<Long, String> entry : auxiliaryValMap.entrySet()) {
                auxiliaryReportDataList.add(new AuxiliaryReportData().setReportDataId(reportData.getId()).setReportId(reportData.getReportId()).setAuxiliaryFieldId(entry.getKey()).setContent(entry.getValue()));
            }
        }
        if (EmptyUtil.isEmpty(auxiliaryReportDataList)) {
            return;
        }
        BitMap<Long, Long> bitMap = this.getExistsAuxiliaryInfo(auxiliaryReportDataList);
        if (bitMap == null) {
            this.generateIdAndSave(auxiliaryReportDataList);
            return;
        }
        ArrayList<AuxiliaryReportData> updateAuxiliaryReportDataList = new ArrayList<AuxiliaryReportData>(16);
        ArrayList<AuxiliaryReportData> saveAuxiliaryReportDataList = new ArrayList<AuxiliaryReportData>(16);
        for (AuxiliaryReportData auxiliaryReportData : auxiliaryReportDataList) {
            HashSet<Long> keys = new HashSet<Long>(4);
            keys.add(auxiliaryReportData.getReportId());
            keys.add(auxiliaryReportData.getReportDataId());
            Set<Long> auxIds = bitMap.findSet(keys);
            if (auxIds.contains(auxiliaryReportData.getAuxiliaryFieldId())) {
                updateAuxiliaryReportDataList.add(auxiliaryReportData);
                continue;
            }
            saveAuxiliaryReportDataList.add(auxiliaryReportData);
        }
        this.dataSaveService.updateAndCheckResult(() -> "update t_fpm_report_auxiliary set fcontent=? where fid=? and freportdataid=? and fbdtype=?", updateAuxiliaryReportDataList, (t, d) -> {
            d.add(t.getContent());
            d.add(t.getReportId());
            d.add(t.getReportDataId());
            d.add(t.getAuxiliaryFieldId());
        });
        this.generateIdAndSave(saveAuxiliaryReportDataList);
    }

    private void generateIdAndSave(List<AuxiliaryReportData> saveAuxiliaryReportDataList) {
        if (EmptyUtil.isEmpty(saveAuxiliaryReportDataList)) {
            return;
        }
        Deque<Long> deque = CommonUtils.batchGenerateIds(saveAuxiliaryReportDataList.size());
        saveAuxiliaryReportDataList.forEach(rd -> rd.setId((Long)deque.poll()));
        Map<Long, List<AuxiliaryReportData>> reportAuxMap = saveAuxiliaryReportDataList.stream().collect(Collectors.groupingBy(AuxiliaryReportData::getReportId));
        reportAuxMap.forEach((k, v) -> this.dataSaveService.saveEntryDataThrow(v, k));
    }

    private BitMap<Long, Long> getExistsAuxiliaryInfo(List<AuxiliaryReportData> auxiliaryReportDataList) {
        if (EmptyUtil.isEmpty(auxiliaryReportDataList)) {
            return null;
        }
        HashSet<Long> reportIds = new HashSet<Long>(4);
        HashSet<Long> reportDataIds = new HashSet<Long>(auxiliaryReportDataList.size());
        for (AuxiliaryReportData auxiliaryReportData : auxiliaryReportDataList) {
            reportIds.add(auxiliaryReportData.getReportId());
            reportDataIds.add(auxiliaryReportData.getReportDataId());
        }
        String auxEntryDataIdProp = String.join((CharSequence)".", "auxentry", "aux_reportdataid");
        String auxEntryAuxIdProp = String.join((CharSequence)".", "auxentry", "aux_bdtype");
        String selectFields = String.join((CharSequence)",", "id", auxEntryDataIdProp, auxEntryAuxIdProp);
        QFilter qFilter = new QFilter("id", "in", reportIds).and(auxEntryDataIdProp, "in", reportDataIds);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_report", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)query)) {
            return null;
        }
        BitMap<Long, Long> bitMap = new BitMap<Long, Long>(auxiliaryReportDataList.size());
        for (DynamicObject dynamicObject : query) {
            long reportId = dynamicObject.getLong("id");
            long reportDataId = dynamicObject.getLong(auxEntryDataIdProp);
            long auxId = dynamicObject.getLong(auxEntryAuxIdProp);
            bitMap.addValue(reportId, (Long)auxId);
            bitMap.addValue(reportDataId, (Long)auxId);
        }
        return bitMap;
    }

    private void doSaveAuxiliaryReportDataForFix(List<ReportData> saveAuxiliaryDataList) {
        Integer count = saveAuxiliaryDataList.stream().map(ReportData::getAuxiliaryValMap).filter(MapUtils::isNotEmpty).map(Map::size).reduce(0, Integer::sum);
        Deque<Long> deque = CommonUtils.batchGenerateIds(count);
        ArrayList<MainEntryReportData> mainEntryReportDataList = new ArrayList<MainEntryReportData>(saveAuxiliaryDataList.size());
        ArrayList<DetailEntryReportData> detailEntryReportDataList = new ArrayList<DetailEntryReportData>(saveAuxiliaryDataList.size());
        ArrayList<AuxiliaryReportData> auxiliaryReportDataList = new ArrayList<AuxiliaryReportData>(count);
        for (ReportData reportData : saveAuxiliaryDataList) {
            MainEntryReportData mainEntryReportData = new MainEntryReportData(reportData);
            mainEntryReportData.setSystemId(reportData.getSystemId());
            mainEntryReportDataList.add(mainEntryReportData);
            detailEntryReportDataList.add(new DetailEntryReportData(reportData));
            Map<Long, String> auxiliaryValMap = reportData.getAuxiliaryValMap();
            if (MapUtils.isEmpty(auxiliaryValMap)) continue;
            for (Map.Entry<Long, String> entry : auxiliaryValMap.entrySet()) {
                auxiliaryReportDataList.add(new AuxiliaryReportData().setId(deque.poll()).setReportDataId(reportData.getId()).setReportId(reportData.getReportId()).setAuxiliaryFieldId(entry.getKey()).setContent(entry.getValue()));
            }
        }
        Map<Long, List<MainEntryReportData>> mainEntryReportDataListMap = mainEntryReportDataList.stream().collect(Collectors.groupingBy(ReportData::getReportId));
        Map<Long, List<DetailEntryReportData>> detailEntryReportDataMap = detailEntryReportDataList.stream().collect(Collectors.groupingBy(ReportData::getReportId));
        Map<Long, List<AuxiliaryReportData>> auxiliaryReportDataListMap = auxiliaryReportDataList.stream().collect(Collectors.groupingBy(AuxiliaryReportData::getReportId));
        mainEntryReportDataListMap.forEach((k, v) -> this.dataSaveService.saveEntryDataThrow(v, k));
        detailEntryReportDataMap.forEach((k, v) -> this.dataSaveService.saveEntryDataThrow(v, k));
        auxiliaryReportDataListMap.forEach((k, v) -> this.dataSaveService.saveEntryDataThrow(v, k));
    }
}

