/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.save.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.db.DBRoute;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.dataproc.save.domain.SqlEntity;
import kd.tmc.fpm.business.dataproc.save.domain.UpdateResult;
import kd.tmc.fpm.business.dataproc.save.impl.AbstractShrekSyncService;
import kd.tmc.fpm.business.domain.model.control.ControlAmountCache;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.service.FpmOperateResult;
import kd.tmc.fpm.business.mvc.service.DataParamFillBack;
import kd.tmc.fpm.olap.enums.SyncLogType;
import kd.tmc.fpm.olap.model.ShrekSyncLog;
import org.apache.commons.collections4.MapUtils;

public class SyncShrekReportDataSaveServiceImpl
extends AbstractShrekSyncService
implements IDataSaveService {
    private IDataSaveService dataSaveService;

    public SyncShrekReportDataSaveServiceImpl(IDataSaveService dataSaveService) {
        this.dataSaveService = dataSaveService;
    }

    @Override
    public <T, P> FpmOperateResult<Void> saveEntryData(List<T> dataList, P pkValue) {
        this.syncShrekIfNeed(dataList, SyncLogType.INSERT);
        return this.dataSaveService.saveEntryData(dataList, pkValue);
    }

    @Override
    public <T, P> FpmOperateResult<Void> saveEntryDataThrow(List<T> dataList, P pkValue) {
        this.syncShrekIfNeed(dataList, SyncLogType.INSERT);
        return this.dataSaveService.saveEntryDataThrow(dataList, pkValue);
    }

    @Override
    public <T, P> FpmOperateResult<Void> saveEntryData(DBRoute dbRoute, List<T> dataList, P pkValue, boolean throwException) {
        this.syncShrekIfNeed(dataList, SyncLogType.INSERT);
        return this.dataSaveService.saveEntryData(dbRoute, dataList, pkValue, throwException);
    }

    @Override
    public <T> FpmOperateResult<Void> saveEntity(T entity) {
        this.syncShrekIfNeed(Collections.singletonList(entity), SyncLogType.INSERT);
        return this.dataSaveService.saveEntity(entity);
    }

    @Override
    public <T> FpmOperateResult<Void> saveEntityList(List<T> dataList) {
        this.syncShrekIfNeed(dataList, SyncLogType.INSERT);
        return this.dataSaveService.saveEntityList(dataList);
    }

    @Override
    public <T> FpmOperateResult<Void> saveEntityList(DBRoute dbRoute, List<T> dataList) {
        this.syncShrekIfNeed(dataList, SyncLogType.INSERT);
        return this.dataSaveService.saveEntityList(dbRoute, dataList);
    }

    @Override
    public <T, P> FpmOperateResult<Void> saveEntryDataInTransaction(List<T> dataList, P pkValue) {
        this.syncShrekIfNeed(dataList, SyncLogType.INSERT);
        return this.dataSaveService.saveEntryDataInTransaction(dataList, pkValue);
    }

    @Override
    public <T, P> FpmOperateResult<Void> saveEntryDataInTransaction(DBRoute dbRoute, List<T> dataList, P pkValue) {
        this.syncShrekIfNeed(dataList, SyncLogType.INSERT);
        return this.dataSaveService.saveEntryDataInTransaction(dbRoute, dataList, pkValue);
    }

    @Override
    public <T> FpmOperateResult<UpdateResult> updateEntity(T entity, Consumer<Set<String>> propConsumer) {
        this.syncShrekIfNeed(Collections.singletonList(entity), SyncLogType.UPDATE);
        return this.dataSaveService.updateEntity(entity, propConsumer);
    }

    @Override
    public <T> FpmOperateResult<UpdateResult> updateEntityList(List<T> entity, Consumer<Set<String>> propConsumer) {
        this.syncShrekIfNeed(entity, SyncLogType.UPDATE);
        return this.dataSaveService.updateEntityList(entity, propConsumer);
    }

    @Override
    public <T> FpmOperateResult<UpdateResult> updateEntityList(DBRoute dbRoute, List<T> entity, Consumer<Set<String>> propConsumer) {
        this.syncShrekIfNeed(entity, SyncLogType.UPDATE);
        return this.dataSaveService.updateEntityList(dbRoute, entity, propConsumer);
    }

    @Override
    public <T> FpmOperateResult<UpdateResult> update(SqlEntity<T> sqlEntity, DataParamFillBack<T, List<Object>> biConsumer) {
        this.syncShrekIfNeed(sqlEntity.getEntityList(), SyncLogType.UPDATE);
        return this.dataSaveService.update(sqlEntity, biConsumer);
    }

    @Override
    public <T> FpmOperateResult<UpdateResult> update(IDataSaveService.Constants constants, List<T> entityList, DataParamFillBack<T, List<Object>> biConsumer) {
        this.syncShrekIfNeed(entityList, SyncLogType.UPDATE);
        return this.dataSaveService.update(constants, entityList, biConsumer);
    }

    @Override
    public <T> void updateAndCheckResult(IDataSaveService.Constants constants, List<T> entityList, DataParamFillBack<T, List<Object>> biConsumer) {
        this.syncShrekIfNeed(entityList, SyncLogType.UPDATE);
        this.dataSaveService.updateAndCheckResult(constants, entityList, biConsumer);
    }

    @Override
    public <T> void updateAndCheckResult(IDataSaveService.SqlInfo sqlInfo, List<T> entityList, DataParamFillBack<T, List<Object>> biConsumer) {
        this.syncShrekIfNeed(entityList, SyncLogType.UPDATE);
        this.dataSaveService.updateAndCheckResult(sqlInfo, entityList, biConsumer);
    }

    @Override
    public <T> FpmOperateResult<UpdateResult> updateSingle(IDataSaveService.Constants constants, T entity, DataParamFillBack<T, List<Object>> biConsumer) {
        this.syncShrekIfNeed(Collections.singletonList(entity), SyncLogType.UPDATE);
        return this.dataSaveService.updateSingle(constants, entity, biConsumer);
    }

    @Override
    public <T> FpmOperateResult<UpdateResult> updateInTransaction(SqlEntity<T> sqlEntity, DataParamFillBack<T, List<Object>> biConsumer) {
        this.syncShrekIfNeed(sqlEntity.getEntityList(), SyncLogType.UPDATE);
        return this.dataSaveService.updateInTransaction(sqlEntity, biConsumer);
    }

    @Override
    public <T> FpmOperateResult<UpdateResult> updateInTransaction(IDataSaveService.Constants constants, List<T> entityList, DataParamFillBack<T, List<Object>> biConsumer) {
        this.syncShrekIfNeed(entityList, SyncLogType.UPDATE);
        return this.dataSaveService.updateInTransaction(constants, entityList, biConsumer);
    }

    @Override
    public <T> UpdateResult updateBySqlInfo(IDataSaveService.SqlInfo sqlInfo, List<T> entityList, DataParamFillBack<T, List<Object>> biConsumer) {
        this.syncShrekIfNeed(entityList, SyncLogType.UPDATE);
        return this.dataSaveService.updateBySqlInfo(sqlInfo, entityList, biConsumer);
    }

    @Override
    public void batchExecuteSize(int size) {
        this.dataSaveService.batchExecuteSize(size);
    }

    private <T> void syncShrekIfNeed(List<T> dataList, SyncLogType syncLogType) {
        if (!this.isOpen()) {
            return;
        }
        if (EmptyUtil.isEmpty(dataList)) {
            return;
        }
        logger.info("\u540c\u6b65\u66f4\u65b0\u5230\u591a\u7ef4start");
        T t = dataList.get(0);
        List<Object> syncInfoList = Collections.emptyList();
        if (t instanceof ReportData) {
            syncInfoList = SyncInfo.getInstance0(dataList.stream().map(ReportData.class::cast).collect(Collectors.toList()), syncLogType);
        }
        if (t instanceof ControlAmountCache.AmountInfo) {
            syncInfoList = SyncInfo.getInstance(dataList.stream().map(ControlAmountCache.AmountInfo.class::cast).collect(Collectors.toList()), syncLogType);
        }
        if (EmptyUtil.isEmpty(syncInfoList)) {
            logger.info("end");
            return;
        }
        List logList = syncInfoList.stream().map(this::getShrekSyncLogList).flatMap(Collection::stream).collect(Collectors.toList());
        this.syncLogSaveService.create(logList);
        logger.info("\u540c\u6b65\u66f4\u65b0\u5230\u591a\u7ef4end\uff1a{}", (Object)logList.size());
        syncInfoList.stream().map(SyncInfo::getSystemId).forEach(this::addSyncDataListener);
    }

    public List<ShrekSyncLog> getShrekSyncLogList(SyncInfo syncInfo) {
        ArrayList<ShrekSyncLog> shrekSyncLogList = new ArrayList<ShrekSyncLog>(syncInfo.dataIds.size());
        this.setSyncLog(syncInfo.systemId, syncInfo.dataIds, shrekSyncLogList, syncInfo.syncLogType);
        logger.info("\u5f85\u540c\u6b65\u7684\u4f53\u7cfb\uff1a{}\uff0c\u5f85\u540c\u6b65\u7684\u6570\u636e\uff1a{}\uff0c\u540c\u6b65\u7c7b\u578b\uff1a{}", new Object[]{syncInfo.systemId, syncInfo.dataIds, syncInfo.syncLogType});
        return shrekSyncLogList;
    }

    static class SyncInfo {
        private Long systemId;
        private Set<Long> dataIds;
        private SyncLogType syncLogType;

        public SyncInfo(Long systemId, Set<Long> dataIds, SyncLogType syncLogType) {
            this.systemId = systemId;
            this.dataIds = dataIds;
            this.syncLogType = syncLogType;
        }

        public Long getSystemId() {
            return this.systemId;
        }

        public void setSystemId(Long systemId) {
            this.systemId = systemId;
        }

        public Set<Long> getDataIds() {
            return this.dataIds;
        }

        public void setDataIds(Set<Long> dataIds) {
            this.dataIds = dataIds;
        }

        public SyncLogType getSyncLogType() {
            return this.syncLogType;
        }

        public void setSyncLogType(SyncLogType syncLogType) {
            this.syncLogType = syncLogType;
        }

        public static List<SyncInfo> getInstance0(List<ReportData> reportDataList, SyncLogType syncLogType) {
            if (EmptyUtil.isEmpty(reportDataList)) {
                return Collections.emptyList();
            }
            Map<Long, Set<Long>> systemDataIdMap = reportDataList.stream().collect(Collectors.groupingBy(ReportData::getSystemId, Collectors.mapping(ReportData::getId, Collectors.toSet())));
            return SyncInfo.getInstance(systemDataIdMap, syncLogType);
        }

        public static List<SyncInfo> getInstance(List<ControlAmountCache.AmountInfo> amountInfoList, SyncLogType syncLogType) {
            if (EmptyUtil.isEmpty(amountInfoList)) {
                return Collections.emptyList();
            }
            Map<Long, Set<Long>> systemDataIdMap = amountInfoList.stream().collect(Collectors.groupingBy(ControlAmountCache.AmountInfo::getSystemId, Collectors.mapping(ControlAmountCache.AmountInfo::getReportDataId, Collectors.toSet())));
            return SyncInfo.getInstance(systemDataIdMap, syncLogType);
        }

        public static List<SyncInfo> getInstance(Map<Long, Set<Long>> systemDataIdMap, SyncLogType syncLogType) {
            if (MapUtils.isEmpty(systemDataIdMap)) {
                return Collections.emptyList();
            }
            ArrayList<SyncInfo> syncInfos = new ArrayList<SyncInfo>(systemDataIdMap.size());
            for (Map.Entry<Long, Set<Long>> entry : systemDataIdMap.entrySet()) {
                SyncInfo syncInfo = new SyncInfo(entry.getKey(), entry.getValue(), syncLogType);
                syncInfos.add(syncInfo);
            }
            return syncInfos;
        }
    }
}

