/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.dataproc.save.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.dataproc.save.IDataSaveService;
import kd.tmc.fpm.business.dataproc.save.IReportEntrySaveService;
import kd.tmc.fpm.business.dataproc.save.ISyncShrekReportDataService;
import kd.tmc.fpm.business.dataproc.save.domain.DataSaveResult;
import kd.tmc.fpm.business.dataproc.save.domain.UpdateResult;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.mvc.service.DataParamFillBack;
import kd.tmc.fpm.business.servicefactory.FpmServiceFactory;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.common.helper.FpmGlobalConfigHelper;
import kd.tmc.fpm.olap.command.ShrekCommand;
import kd.tmc.fpm.olap.command.ShrekSyncReportDataCommand;
import kd.tmc.fpm.olap.command.executor.ShrekExecutor;
import kd.tmc.fpm.olap.enums.ShrekSyncStatus;
import kd.tmc.fpm.olap.enums.SyncLogType;
import kd.tmc.fpm.olap.model.ShrekSyncLog;
import kd.tmc.fpm.olap.service.log.SyncLogSaveService;

public class SyncShrekReportDataServiceImpl
implements IReportEntrySaveService,
ISyncShrekReportDataService {
    private static final Log logger = LogFactory.getLog(SyncShrekReportDataServiceImpl.class);
    private IReportEntrySaveService reportEntrySaveService;
    private SyncLogSaveService syncLogSaveService;

    public SyncShrekReportDataServiceImpl(IReportEntrySaveService reportEntrySaveService) {
        this.reportEntrySaveService = reportEntrySaveService;
        this.syncLogSaveService = FpmServiceFactory.getBizService(SyncLogSaveService.class);
    }

    public SyncShrekReportDataServiceImpl() {
        this.reportEntrySaveService = new EmptyReportEntrySaveService();
        this.syncLogSaveService = FpmServiceFactory.getBizService(SyncLogSaveService.class);
    }

    @Override
    public void updateReportHead(Report report, DynamicObject reportDy) {
        this.reportEntrySaveService.updateReportHead(report, reportDy);
    }

    @Override
    public void saveReportData(List<ReportData> reportDataList, Long systemId) {
        this.reportEntrySaveService.saveReportData(reportDataList, systemId);
        if (!FpmGlobalConfigHelper.getBooleanConfigByKey((String)"startmutilsync")) {
            return;
        }
        ArrayList<ShrekSyncLog> logList = new ArrayList<ShrekSyncLog>(reportDataList.size());
        Set<Long> reportDataId = reportDataList.stream().filter(ReportData::isMainTable).map(ReportData::getId).collect(Collectors.toSet());
        logger.info("\u4fdd\u5b58\u7f16\u5236\u6570\u636e\uff0c\u5f00\u59cb\u540c\u6b65\u5230\u591a\u7ef4\u6570\u636e\u5e93\uff0c\u540c\u6b65\u4f53\u7cfb\uff1a{},\u540c\u6b65\u7f16\u5236\u6570\u636eid\uff1a{}", (Object)systemId, reportDataId);
        SyncShrekReportDataServiceImpl.setSyncLog(systemId, reportDataId, logList, SyncLogType.INSERT);
        this.syncLogSaveService.create(logList);
        this.addSyncDataListener(systemId);
    }

    @Override
    public void updateReportData(List<ReportData> reportDataList, Long systemId) {
        this.reportEntrySaveService.updateReportData(reportDataList, systemId);
        if (!FpmGlobalConfigHelper.getBooleanConfigByKey((String)"startmutilsync")) {
            return;
        }
        ArrayList<ShrekSyncLog> logList = new ArrayList<ShrekSyncLog>(reportDataList.size());
        Set<Long> reportDataIds = reportDataList.stream().filter(ReportData::isMainTable).map(ReportData::getId).collect(Collectors.toSet());
        SyncShrekReportDataServiceImpl.setSyncLog(systemId, reportDataIds, logList, SyncLogType.UPDATE);
        logger.info("\u66f4\u65b0\u7f16\u5236\u6570\u636e\uff0c\u5f00\u59cb\u540c\u6b65\u5230\u591a\u7ef4\u6570\u636e\u5e93\uff0c\u540c\u6b65\u4f53\u7cfb\uff1a{},\u540c\u6b65\u7f16\u5236\u6570\u636eid\uff1a{}", (Object)systemId, reportDataIds);
        this.syncLogSaveService.create(logList);
        this.addSyncDataListener(systemId);
    }

    @Override
    public DataSaveResult saveOrUpdateReportData(List<ReportData> reportDataList, DynamicObject reportDy) {
        return CommonUtils.inTransaction(() -> {
            DataSaveResult dataSaveResult = this.reportEntrySaveService.saveOrUpdateReportData(reportDataList, reportDy);
            if (!FpmGlobalConfigHelper.getBooleanConfigByKey((String)"startmutilsync")) {
                return dataSaveResult;
            }
            Long systemId = reportDy.getLong(String.join((CharSequence)".", "bodysys", "id"));
            ArrayList<ShrekSyncLog> logList = new ArrayList<ShrekSyncLog>(reportDataList.size());
            Set reportDataIds = reportDataList.stream().filter(ReportData::isMainTable).map(ReportData::getId).collect(Collectors.toSet());
            Set<Long> saveReportDataIds = dataSaveResult.getSaveIds().stream().filter(reportDataIds::contains).collect(Collectors.toSet());
            logger.info("\u4fdd\u5b58\u6216\u66f4\u65b0\u62a5\u8868\uff0c\u5f00\u59cb\u540c\u6b65\u5230\u591a\u7ef4\u6570\u636e\u5e93\uff0c\u540c\u6b65\u4f53\u7cfb\uff1a{},\u540c\u6b65\u4fdd\u5b58\u7684\u7f16\u5236\u6570\u636eid\uff1a{}", (Object)systemId, saveReportDataIds);
            SyncShrekReportDataServiceImpl.setSyncLog(systemId, saveReportDataIds, logList, SyncLogType.INSERT);
            Set<Long> updateReportDataIds = dataSaveResult.getUpdateIds().stream().filter(reportDataIds::contains).collect(Collectors.toSet());
            logger.info("\u4fdd\u5b58\u6216\u66f4\u65b0\u62a5\u8868\uff0c\u5f00\u59cb\u540c\u6b65\u5230\u591a\u7ef4\u6570\u636e\u5e93\uff0c\u540c\u6b65\u4f53\u7cfb\uff1a{},\u540c\u6b65\u66f4\u65b0\u7684\u7f16\u5236\u6570\u636eid\uff1a{}", (Object)systemId, updateReportDataIds);
            SyncShrekReportDataServiceImpl.setSyncLog(systemId, updateReportDataIds, logList, SyncLogType.UPDATE);
            Set deleteReportDataIds = dataSaveResult.getDeleteIds().stream().filter(reportDataIds::contains).collect(Collectors.toSet());
            logger.info("\u4fdd\u5b58\u6216\u66f4\u65b0\u62a5\u8868\uff0c\u5f00\u59cb\u540c\u6b65\u5230\u591a\u7ef4\u6570\u636e\u5e93\uff0c\u540c\u6b65\u4f53\u7cfb\uff1a{},\u540c\u6b65\u5220\u9664\u7684\u7f16\u5236\u6570\u636eid\uff1a{}", (Object)systemId, deleteReportDataIds);
            SyncShrekReportDataServiceImpl.setSyncLog(systemId, saveReportDataIds, logList, SyncLogType.DELETE);
            if (EmptyUtil.isEmpty(logList)) {
                return dataSaveResult;
            }
            this.syncLogSaveService.create(logList);
            this.addSyncDataListener(systemId);
            return dataSaveResult;
        });
    }

    @Override
    public void saveOrUpdateRemarkEntry(List<ReportData> reportDataList, DataSaveResult dataSaveResult, DynamicObject reportDy) {
        this.reportEntrySaveService.saveOrUpdateRemarkEntry(reportDataList, dataSaveResult, reportDy);
    }

    @Override
    public void saveOrUpdateSourceIdEntry(List<ReportData> reportDataList, DataSaveResult dataSaveResult, DynamicObject reportDy) {
        this.reportEntrySaveService.saveOrUpdateSourceIdEntry(reportDataList, dataSaveResult, reportDy);
    }

    @Override
    public void saveSourceIdEntry(List<ReportData> reportDataList) {
        this.reportEntrySaveService.saveSourceIdEntry(reportDataList);
    }

    @Override
    public UpdateResult updateReportData(List<ReportData> reportDataList, Long systemId, String sql, DataParamFillBack<ReportData, List<Object>> biConsumer) {
        return this.updateReportData(reportDataList, systemId, () -> sql, biConsumer);
    }

    @Override
    public UpdateResult updateReportData(List<ReportData> reportDataList, Long systemId, IDataSaveService.SqlInfo sqlInfo, DataParamFillBack<ReportData, List<Object>> biConsumer) {
        return CommonUtils.inTransaction(() -> {
            UpdateResult result = this.reportEntrySaveService.updateReportData(reportDataList, systemId, sqlInfo, biConsumer);
            if (!FpmGlobalConfigHelper.getBooleanConfigByKey((String)"startmutilsync")) {
                return result;
            }
            ArrayList<ShrekSyncLog> logList = new ArrayList<ShrekSyncLog>(reportDataList.size());
            SyncShrekReportDataServiceImpl.setSyncLog(systemId, reportDataList.stream().filter(ReportData::isMainTable).map(ReportData::getId).collect(Collectors.toSet()), logList, SyncLogType.UPDATE);
            this.syncLogSaveService.create(logList);
            if (EmptyUtil.isEmpty(logList)) {
                return result;
            }
            this.addSyncDataListener(systemId);
            return result;
        });
    }

    private static void setSyncLog(Long systemId, Set<Long> ids, List<ShrekSyncLog> logList, SyncLogType logType) {
        for (Long id : ids) {
            ShrekSyncLog log = new ShrekSyncLog();
            log.setSystemId(systemId);
            log.setEntityId(id);
            log.setEntityName("fpm_report");
            log.setLogType(logType);
            log.setSyncStatus(ShrekSyncStatus.WAIT_SYNC);
            logList.add(log);
        }
    }

    private void addSyncDataListener(final Long systemId) {
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onCommitted() {
                try (TXHandle ignored = TX.requiresNew();){
                    SyncShrekReportDataServiceImpl.this.sync(systemId);
                }
            }
        });
    }

    private void sync(Long systemId) {
        ShrekSyncReportDataCommand syncReportDataCommand = new ShrekSyncReportDataCommand();
        syncReportDataCommand.setSystemId(systemId);
        ShrekExecutor.execute((ShrekCommand)syncReportDataCommand);
    }

    @Override
    public void syncReport(Long reportId) {
        this.syncReport(Collections.singletonList(reportId));
    }

    @Override
    public void syncReport(Collection<Long> reportIds) {
        Set bodySysIds;
        if (EmptyUtil.isEmpty(reportIds)) {
            return;
        }
        if (!FpmGlobalConfigHelper.getBooleanConfigByKey((String)"startmutilsync")) {
            logger.info("\u672a\u542f\u52a8\u591a\u7ef4\u540c\u6b65\u529f\u80fd\uff0c\u505c\u6b62\u540c\u6b65.");
            return;
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"fpm_report", (String)"bodysys", (QFilter[])new QFilter[]{new QFilter("id", "in", reportIds)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)query)) {
            logger.warn("\u7f16\u5236\u8868\uff1a{}\u5bf9\u5e94\u7684\u4f53\u7cfb\u4e3a\u7a7a", reportIds);
        }
        if ((bodySysIds = query.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet())).size() > 1) {
            logger.error("\u7f16\u5236\u8868\uff1a{}\u6765\u81ea\u591a\u4e2a\u4e0d\u540c\u7684\u4f53\u7cfb", bodySysIds);
            return;
        }
        String systemProp = String.join((CharSequence)".", "maindimentry", "system", "id");
        String selectFields = String.join((CharSequence)",", "maindimentry.id", systemProp);
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"fpm_report", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", reportIds).and("maindimentry.maintable", "=", (Object)"1")});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)dynamicObjectCollection)) {
            return;
        }
        DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(0);
        Long systemId = dynamicObject.getLong(systemProp);
        Set<Long> reportDataIds = dynamicObjectCollection.stream().map(dy -> dy.getLong("maindimentry.id")).filter(EmptyUtil::isNoEmpty).collect(Collectors.toSet());
        ArrayList<ShrekSyncLog> logList = new ArrayList<ShrekSyncLog>(dynamicObjectCollection.size());
        Consumer<SyncLogType> logCallback = this.createLogs(systemId, reportIds, reportDataIds, logList);
        if (TX.inTX()) {
            this.addSyncReportListener(systemId, logCallback);
        } else {
            logCallback.accept(SyncLogType.UPDATE);
            this.sync(systemId);
        }
    }

    private void addSyncReportListener(final Long systemId, final Consumer<SyncLogType> logCallback) {
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void preCommit() {
                try (TXHandle ignored = TX.requiresNew();){
                    logCallback.accept(SyncLogType.DELETE);
                    SyncShrekReportDataServiceImpl.this.sync(systemId);
                }
            }

            public void onCommitted() {
                try (TXHandle ignored = TX.requiresNew();){
                    logCallback.accept(SyncLogType.UPDATE);
                    SyncShrekReportDataServiceImpl.this.sync(systemId);
                }
            }
        });
    }

    private Consumer<SyncLogType> createLogs(Long systemId, Collection<Long> reportIds, Set<Long> reportDataIds, List<ShrekSyncLog> logList) {
        return type -> {
            SyncShrekReportDataServiceImpl.setSyncLog(systemId, reportDataIds, logList, type);
            this.syncLogSaveService.create(logList);
            logger.info("\u540c\u6b65\u62a5\u8868\u6570\u636e\u5230\u591a\u7ef4\uff0c\u62a5\u8868id\uff1a{},\u540c\u6b65\u6570\u636e\u6761\u6570\uff1a{}", (Object)reportIds, (Object)logList.size());
        };
    }

    static class EmptyReportEntrySaveService
    implements IReportEntrySaveService {
        EmptyReportEntrySaveService() {
        }

        @Override
        public void updateReportHead(Report report, DynamicObject reportDy) {
        }

        @Override
        public void saveReportData(List<ReportData> reportDataList, Long systemId) {
        }

        @Override
        public void updateReportData(List<ReportData> reportDataList, Long systemId) {
        }

        @Override
        public DataSaveResult saveOrUpdateReportData(List<ReportData> reportDataList, DynamicObject reportDy) {
            return null;
        }

        @Override
        public void saveOrUpdateRemarkEntry(List<ReportData> reportDataList, DataSaveResult dataSaveResult, DynamicObject reportDy) {
        }

        @Override
        public void saveOrUpdateSourceIdEntry(List<ReportData> reportDataList, DataSaveResult dataSaveResult, DynamicObject reportDy) {
        }

        @Override
        public void saveSourceIdEntry(List<ReportData> reportDataList) {
        }

        @Override
        public UpdateResult updateReportData(List<ReportData> reportDataList, Long systemId, String sql, DataParamFillBack<ReportData, List<Object>> biConsumer) {
            return new UpdateResult();
        }

        @Override
        public UpdateResult updateReportData(List<ReportData> reportDataList, Long systemId, IDataSaveService.SqlInfo sqlInfo, DataParamFillBack<ReportData, List<Object>> biConsumer) {
            return new UpdateResult();
        }
    }
}

