/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.enums;

import java.util.Arrays;
import java.util.List;
import kd.tmc.fbp.common.enums.MultiLangEnumBridge;
import kd.tmc.fpm.common.enums.AmountUnitEnum;

public enum AmountUnit {
    ONE("one", new MultiLangEnumBridge("\u5143", "AmountUnit_0", "tmc-fpm-business")),
    THOUSAND("thousand", new MultiLangEnumBridge("\u5343\u5143", "AmountUnit_1", "tmc-fpm-business")),
    TEN_THOUSAND("ten_thousand", new MultiLangEnumBridge("\u4e07\u5143", "AmountUnit_2", "tmc-fpm-business")),
    MILLION("million", new MultiLangEnumBridge("\u767e\u4e07\u5143", "AmountUnit_3", "tmc-fpm-business")),
    HUNDRED_MILLION("hundred_million", new MultiLangEnumBridge("\u4ebf\u5143", "AmountUnit_4", "tmc-fpm-business")),
    FROMPARENT("fromparent", new MultiLangEnumBridge("\u6cbf\u7528\u4e3b\u8868", "AmountUnit_5", "tmc-fpm-business"));

    private String number;
    private MultiLangEnumBridge name;

    private AmountUnit(String number, MultiLangEnumBridge name) {
        this.number = number;
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name.loadKDString();
    }

    public static AmountUnit getByNumber(String number) {
        return Arrays.stream(AmountUnit.values()).filter(a -> a.number.equalsIgnoreCase(number)).findFirst().orElse(null);
    }

    public static AmountUnitEnum convert(AmountUnit unit) {
        AmountUnitEnum amountUnit = null;
        switch (unit) {
            case ONE: {
                amountUnit = AmountUnitEnum.ONE;
                break;
            }
            case MILLION: {
                amountUnit = AmountUnitEnum.MILLION;
                break;
            }
            case THOUSAND: {
                amountUnit = AmountUnitEnum.THOUSAND;
                break;
            }
            case TEN_THOUSAND: {
                amountUnit = AmountUnitEnum.TEN_THOUSAND;
                break;
            }
            case HUNDRED_MILLION: {
                amountUnit = AmountUnitEnum.HUNDRED_MILLION;
                break;
            }
        }
        return amountUnit;
    }

    public static AmountUnit convert(AmountUnitEnum amountUnitEnum) {
        AmountUnit amountUnit = null;
        switch (amountUnitEnum) {
            case ONE: {
                amountUnit = ONE;
                break;
            }
            case MILLION: {
                amountUnit = MILLION;
                break;
            }
            case THOUSAND: {
                amountUnit = THOUSAND;
                break;
            }
            case TEN_THOUSAND: {
                amountUnit = TEN_THOUSAND;
                break;
            }
            case HUNDRED_MILLION: {
                amountUnit = HUNDRED_MILLION;
                break;
            }
        }
        return amountUnit;
    }

    public static List<String> getAmountUnitList() {
        return Arrays.asList(ONE.getNumber(), MILLION.getNumber(), THOUSAND.getNumber(), TEN_THOUSAND.getNumber(), HUNDRED_MILLION.getNumber());
    }
}

