/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.enums;

public enum AnalysisReportType {
    MULTI("MULTI"),
    POSITION("POSITION"),
    PLANEXECANALYS("PLANEXECANALYS"),
    SYNTHESIS("SYNTHESIS"),
    LINK_SEARCH_ANALYSE("LINK_SEARCH_ANALYSE");

    private String number;

    private AnalysisReportType(String number) {
        this.number = number;
    }

    public String getNumber() {
        return this.number;
    }

    public static AnalysisReportType getByNumber(String number) {
        for (AnalysisReportType mt : AnalysisReportType.values()) {
            if (!number.equalsIgnoreCase(mt.getNumber())) continue;
            return mt;
        }
        return null;
    }

    public boolean isMulti() {
        return this == MULTI;
    }

    public boolean isPosition() {
        return this == POSITION;
    }

    public boolean isExecuteAnalysis() {
        return this == PLANEXECANALYS;
    }

    public boolean isSynthesisAnalysis() {
        return this == SYNTHESIS;
    }

    public boolean isLinkSearchAnalyse() {
        return this == LINK_SEARCH_ANALYSE;
    }

    public boolean isFixedAnalysis() {
        return this == MULTI || this == POSITION || this == PLANEXECANALYS;
    }

    public boolean needSaveTemplate() {
        return this.isExecuteAnalysis() || this.isSynthesisAnalysis();
    }
}

