/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.enums;

import java.util.Date;
import java.util.Objects;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.IMatch;
import kd.tmc.fpm.business.domain.enums.ITypeEnum;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import kd.tmc.fpm.common.helper.StringHelper;

public enum ControlMatchType implements IMatch,
ITypeEnum
{
    EQUALS("EQUALS"){

        @Override
        public boolean match(String source, Object target) {
            return Objects.equals(StringHelper.getStringValue((Object)source), StringHelper.trimIfString((Object)target));
        }
    }
    ,
    CONTAIN("CONTAIN"){

        @Override
        public boolean match(String source, Object target) {
            return this.doMatch(source, target);
        }

        private boolean doMatch(String source, Object target) {
            if (EmptyUtil.isEmpty((String)source)) {
                return false;
            }
            if (target instanceof PeriodMember) {
                PeriodMember periodMember = (PeriodMember)target;
                Date date = DateUtils.stringToDate((String)StringHelper.getStringValue((Object)source), (String)"yyyy-MM-dd");
                if (date == null) {
                    return false;
                }
                Date startDate = periodMember.getStartDate();
                Date endDate = periodMember.getEndDate();
                if (Objects.isNull(startDate) || Objects.isNull(endDate)) {
                    return false;
                }
                startDate = DateUtils.stringToDate((String)DateUtils.formatString((Date)startDate, (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd");
                endDate = DateUtils.stringToDate((String)DateUtils.formatString((Date)endDate, (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd");
                if (date.before(startDate)) {
                    return false;
                }
                return !date.after(endDate);
            }
            return StringHelper.getStringValue((Object)target).contains(StringHelper.getStringValue((Object)source));
        }
    };

    private String number;

    private ControlMatchType(String number) {
        this.number = number;
    }

    @Override
    public String getNumber() {
        return this.number;
    }

    public static ControlMatchType getByNumber(String number) {
        for (ControlMatchType type : ControlMatchType.values()) {
            if (!number.equalsIgnoreCase(type.getNumber())) continue;
            return type;
        }
        return null;
    }
}

