/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.formula;

import java.math.BigDecimal;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.FormulaException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.AmountUnit;
import kd.tmc.fpm.business.domain.enums.TemplateMetricType;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.spread.formula.FormulaOperationVal;
import kd.tmc.fpm.business.spread.formula.FormulaOperatorSymbol;
import kd.tmc.fpm.business.spread.formula.IFormulaOperator;
import kd.tmc.fpm.business.spread.formula.impl.DAGNode;
import kd.tmc.fpm.business.spread.formula.impl.DAGNodeVisitListener;
import kd.tmc.fpm.business.utils.MetricValueUtils;
import kd.tmc.fpm.common.bean.FpmContext;
import kd.tmc.fpm.common.enums.AmountUnitEnum;
import kd.tmc.fpm.common.helper.AmountCurrencyRateHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CalculateReportDataValVisitListener
implements DAGNodeVisitListener<Long> {
    private static final Log logger = LogFactory.getLog(CalculateReportDataValVisitListener.class);
    private Set<ReportData> reCalcValSet = new HashSet<ReportData>(16);
    private Map<Long, ReportData> reportDataMap;
    private Map<Long, Formula> formulaMap;
    private EnumSet<TemplateMetricType> metricSet;

    private CalculateReportDataValVisitListener() {
    }

    public CalculateReportDataValVisitListener(Map<Long, ReportData> reportDataMap, Map<Long, Formula> formulaMap) {
        this();
        this.reportDataMap = reportDataMap;
        this.formulaMap = formulaMap;
        this.metricSet = Objects.isNull(FpmContext.get().get("dimMetric")) ? null : (EnumSet)FpmContext.get().get("dimMetric");
    }

    @Override
    public void visit(DAGNode<Long> node) {
        Long reportDataId = node.getVal();
        ReportData reportData = this.reportDataMap.get(reportDataId);
        Formula formula = this.formulaMap.get(reportDataId);
        if (formula == null || reportData == null) {
            return;
        }
        if (!CollectionUtils.isEmpty(this.metricSet)) {
            AmountUnit amountUnit = reportData.getAmountUnit();
            for (TemplateMetricType templateMetricType : this.metricSet) {
                switch (templateMetricType) {
                    case PLANAMT: {
                        reportData.setPlanAmt(this.calculate(formula, ReportData::getPlanAmt, amountUnit));
                        reportData.setDirty(Boolean.TRUE);
                        break;
                    }
                    case ACTMAT: {
                        reportData.setActAmt(this.calculate(formula, ReportData::getActAmt, amountUnit));
                        reportData.setDirty(Boolean.TRUE);
                        break;
                    }
                    case LOCKAMT: {
                        reportData.setLockAmt(this.calculate(formula, ReportData::getLockAmt, amountUnit));
                        reportData.setDirty(Boolean.TRUE);
                        break;
                    }
                    case REPORTPLANAMT: {
                        reportData.setReportPlanAmt(this.calculate(formula, ReportData::getReportPlanAmt, amountUnit));
                        reportData.setDirty(Boolean.TRUE);
                        break;
                    }
                    case ORIGINALPLANAMT: {
                        reportData.setOriginalPlanAmt(this.calculate(formula, ReportData::getOriginalPlanAmt, amountUnit));
                        reportData.setDirty(Boolean.TRUE);
                        break;
                    }
                    case PLANREFERENCEAMT: {
                        reportData.setPlanReferenceAmt(this.calculate(formula, ReportData::getPlanReferenceAmt, amountUnit));
                        reportData.setDirty(Boolean.TRUE);
                        break;
                    }
                }
            }
        } else {
            this.calculateAllMetricAmount(formula, reportData);
        }
        this.reCalcValSet.add(reportData);
    }

    private void calculateAllMetricAmount(Formula formula, ReportData reportData) {
        AmountUnit amountUnit = reportData.getAmountUnit();
        reportData.setPlanAmt(this.calculate(formula, ReportData::getPlanAmt, amountUnit));
        reportData.setActAmt(this.calculate(formula, ReportData::getActAmt, amountUnit));
        reportData.setLockAmt(this.calculate(formula, ReportData::getLockAmt, amountUnit));
        reportData.setReportPlanAmt(this.calculate(formula, ReportData::getReportPlanAmt, amountUnit));
        reportData.setOriginalPlanAmt(this.calculate(formula, ReportData::getOriginalPlanAmt, amountUnit));
        reportData.setPlanReferenceAmt(this.calculate(formula, ReportData::getPlanReferenceAmt, amountUnit));
        reportData.setDirty(Boolean.TRUE);
    }

    public Set<ReportData> getReCalcValSet() {
        return this.reCalcValSet;
    }

    private BigDecimal calculate(Formula formula, Function<ReportData, BigDecimal> amtFunction, AmountUnit targetUnit) {
        Object result;
        StringBuilder sb = new StringBuilder();
        Deque<IFormulaOperator> rightOperators = formula.getOperator();
        int idx = 0;
        HashMap<String, BigDecimal> variableMap = new HashMap<String, BigDecimal>(rightOperators.size());
        for (IFormulaOperator rightOperator : rightOperators) {
            if (rightOperator instanceof FormulaOperationVal) {
                String symbol = "x" + idx++;
                sb.append(symbol);
                FormulaOperationVal formulaOp = (FormulaOperationVal)rightOperator;
                String id = formulaOp.getName();
                if (StringUtils.isEmpty((CharSequence)id)) {
                    variableMap.put(symbol, BigDecimal.ZERO);
                    continue;
                }
                ReportData reportData = this.reportDataMap.get(Long.valueOf(id));
                if (Objects.isNull(reportData)) {
                    variableMap.put(symbol, BigDecimal.ZERO);
                    continue;
                }
                BigDecimal amt = amtFunction.apply(reportData);
                BigDecimal convertUnitAmt = AmountCurrencyRateHelper.convertAmt((BigDecimal)amt, (AmountUnitEnum)AmountUnit.convert(reportData.getAmountUnit()), (AmountUnitEnum)AmountUnit.convert(targetUnit));
                variableMap.put(symbol, convertUnitAmt);
                continue;
            }
            if (!(rightOperator instanceof FormulaOperatorSymbol)) continue;
            FormulaOperatorSymbol formulaOperatorSymbol = (FormulaOperatorSymbol)rightOperator;
            String opSymbol = formulaOperatorSymbol.getOpSymbol().getSymbol();
            sb.append(opSymbol);
        }
        String amtExpressScript = sb.toString().trim().replace(" ", "");
        if (EmptyUtil.isEmpty((String)amtExpressScript)) {
            return BigDecimal.ZERO;
        }
        String script = MetricValueUtils.handleNum(amtExpressScript);
        Expr expr = FormulaEngine.parseFormula((String)script);
        try {
            result = FormulaEngine.execExcelFormula((Expr)expr, variableMap);
        }
        catch (Throwable ex) {
            if (ex instanceof ArithmeticException) {
                result = BigDecimal.ZERO;
            }
            if (ex instanceof FormulaException) {
                result = BigDecimal.ZERO;
            }
            throw new KDBizException(ex.getMessage());
        }
        return new BigDecimal(result.toString());
    }
}

