/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.formula;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.formula.CalculateReportDataValVisitListener;
import kd.tmc.fpm.business.domain.formula.IReportFormulaManager;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.report.ReportDataSource;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.spread.formula.FormulaOperationVal;
import kd.tmc.fpm.business.spread.formula.IDAGManager;
import kd.tmc.fpm.business.spread.formula.IDAGVisit;
import kd.tmc.fpm.business.spread.formula.impl.DAGEdge;
import kd.tmc.fpm.business.spread.formula.impl.DAGManager;
import kd.tmc.fpm.business.spread.formula.impl.DAGNode;
import kd.tmc.fpm.business.spread.formula.impl.DAGVisit;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;

public class ReportFormulaManager
implements IReportFormulaManager<ReportData> {
    private IDAGManager<Long> dagManager;
    private IDAGVisit<Long> dagVisit;
    private Map<Long, Formula> formulaMap;
    private Map<Long, ReportData> reportDataMap;
    private boolean visitAll;

    public ReportFormulaManager() {
    }

    public ReportFormulaManager(ReportDataSource report, Map<Long, Formula> formulaMap, boolean isVisitAll) {
        this.initManager(report, formulaMap);
        this.visitAll = isVisitAll;
        this.visitAll();
    }

    private void initManager(ReportDataSource report, Map<Long, Formula> formulaMap) {
        this.dagManager = new DAGManager<Long>();
        this.reportDataMap = report.getReportDataList().stream().filter(o -> o.getId() != null).collect(Collectors.toMap(ReportData::getId, Function.identity()));
        this.formulaMap = formulaMap;
        this.initDAGManager(formulaMap);
    }

    private void visitAll() {
        if (this.visitAll) {
            CalculateReportDataValVisitListener listener = new CalculateReportDataValVisitListener(this.reportDataMap, this.formulaMap);
            this.dagVisit.addNodeVisitListener(listener);
            Collection<DAGNode<Long>> nodeList = this.dagManager.getVertexMap().values();
            for (DAGNode<Long> node : nodeList) {
                this.dagVisit.visitNode(node, false);
            }
        }
    }

    @Override
    public List<ReportData> updateData(ReportData updateVal) {
        ArrayList<ReportData> updateValList = new ArrayList<ReportData>(1);
        updateValList.add(updateVal);
        return this.updateData((List<ReportData>)updateValList);
    }

    @Override
    public List<ReportData> updateData(List<ReportData> updateValList) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan("reportformulamanager_updatedata_method");){
            span.addTag("reportformulamanager_updatedata_method_step1");
            this.dagVisit = new DAGVisit<Long>(this.dagManager);
            span.addTag("reportformulamanager_updatedata_method_step2");
            for (ReportData updateVal : updateValList) {
                ReportData reportData = this.reportDataMap.get(updateVal.getId());
                if (reportData == null) continue;
                reportData.setActAmt(updateVal.getActAmt());
                reportData.setLockAmt(updateVal.getLockAmt());
                reportData.setPlanAmt(updateVal.getPlanAmt());
            }
            span.addTag("reportformulamanager_updatedata_method_step3");
            CalculateReportDataValVisitListener listener = new CalculateReportDataValVisitListener(this.reportDataMap, this.formulaMap);
            this.dagVisit.addNodeVisitListener(listener);
            for (ReportData updateVal : updateValList) {
                DAGNode<Long> changeNode = this.dagManager.get(updateVal.getId());
                if (changeNode == null) continue;
                this.dagVisit.orderVisitNode(changeNode);
            }
            ArrayList<ReportData> arrayList = new ArrayList<ReportData>(listener.getReCalcValSet());
            return arrayList;
        }
    }

    private void initDAGManager(Map<Long, Formula> formulaMap) {
        for (Map.Entry<Long, Formula> formulaEntry : formulaMap.entrySet()) {
            if (!this.reportDataMap.containsKey(formulaEntry.getKey())) continue;
            this.initDAGRelation(formulaEntry.getValue());
        }
        this.dagVisit = new DAGVisit<Long>(this.dagManager);
    }

    private void initDAGRelation(Formula formula) {
        FormulaOperationVal leftOperation = formula.getLeftVal();
        List<FormulaOperationVal> rightOperationLst = formula.getRightValList();
        String leftOperationName = leftOperation.getName();
        DAGNode<Long> leftNode = this.dagManager.get(Long.valueOf(leftOperationName));
        for (FormulaOperationVal formulaOperation : rightOperationLst) {
            DAGNode<Long> rightNode = this.dagManager.get(Long.valueOf(formulaOperation.getName()));
            DAGEdge<Long> nodesEdge = new DAGEdge<Long>(rightNode);
            leftNode.addEdge(nodesEdge);
        }
    }

    public static void updateAllData(ReportDataSource report, Map<Long, Formula> formulaMap) {
        ReportFormulaManager manager = new ReportFormulaManager();
        manager.initManager(report, formulaMap);
        manager.setVisitAll(true);
        manager.visitAll();
    }

    public boolean isVisitAll() {
        return this.visitAll;
    }

    public void setVisitAll(boolean visitAll) {
        this.visitAll = visitAll;
    }
}

