/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.formula;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.formula.CalcTreeNodeVisitListener;
import kd.tmc.fpm.business.domain.formula.CollectTreeNodeVisitListener;
import kd.tmc.fpm.business.domain.formula.IReportFormulaManager;
import kd.tmc.fpm.business.domain.model.index.node.TreeNode;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.spread.formula.FormulaOperationValUp;
import kd.tmc.fpm.business.spread.formula.IDAGManager;
import kd.tmc.fpm.business.spread.formula.IDAGVisit;
import kd.tmc.fpm.business.spread.formula.IFormulaOperator;
import kd.tmc.fpm.business.spread.formula.impl.DAGEdge;
import kd.tmc.fpm.business.spread.formula.impl.DAGManager;
import kd.tmc.fpm.business.spread.formula.impl.DAGNode;
import kd.tmc.fpm.business.spread.formula.impl.DAGVisit;
import kd.tmc.fpm.common.trace.IFpmTraceSpan;
import kd.tmc.fpm.common.trace.IFpmTracer;
import org.apache.commons.collections.CollectionUtils;

public class ReportTreeNodeFormulaManager
implements IReportFormulaManager<TreeNode> {
    private IDAGManager<TreeNode> dagManager = new DAGManager<TreeNode>();
    private IDAGVisit<TreeNode> dagVisit;
    private List<Formula> formulaList;
    private Map<TreeNode, Formula> formulaMap;

    public ReportTreeNodeFormulaManager(List<Formula> formulaList) {
        this.formulaList = formulaList;
        this.formulaMap = formulaList.stream().collect(Collectors.toMap(item -> (TreeNode)item.getLeftValUp().getName(), Function.identity()));
        this.initDAGManager();
    }

    @Override
    @Deprecated
    public List<TreeNode> findEffectData(List<TreeNode> sourceDataList) {
        this.dagVisit = new DAGVisit<TreeNode>(this.dagManager);
        CollectTreeNodeVisitListener listener = new CollectTreeNodeVisitListener();
        this.dagVisit.addNodeVisitListener(listener);
        HashSet<TreeNode> reCalcValSet = new HashSet<TreeNode>(16);
        for (TreeNode treeNode : sourceDataList) {
            DAGNode<TreeNode> changeNode = this.dagManager.get(treeNode);
            reCalcValSet.add(treeNode);
            if (changeNode == null) continue;
            this.dagVisit.orderVisitNode(changeNode);
        }
        reCalcValSet.addAll(listener.getReCalcValSet());
        this.fillRelateNode(reCalcValSet, new HashSet<TreeNode>(sourceDataList));
        return new ArrayList<TreeNode>(reCalcValSet);
    }

    private void fillRelateNode(Set<TreeNode> relateNodes, Set<TreeNode> sourceDataSet) {
        List<TreeNode> sourceNodes = this.getOrderRelateNodeList(relateNodes);
        Map<TreeNode, DAGNode<TreeNode>> vertexMap = this.dagManager.getVertexMap();
        for (TreeNode treeNode : sourceNodes) {
            DAGNode<TreeNode> treeNodeDAGNode = vertexMap.get(treeNode);
            if (EmptyUtil.isEmpty(treeNodeDAGNode)) continue;
            this.doFillRelateNode(relateNodes, treeNodeDAGNode, sourceDataSet);
        }
    }

    private List<TreeNode> getOrderRelateNodeList(Set<TreeNode> relateNodes) {
        List<DAGNode<TreeNode>> orderedList = this.dagManager.getOrderedList();
        HashMap<TreeNode, Integer> orderMap = new HashMap<TreeNode, Integer>(orderedList.size());
        for (int i = 0; i < orderedList.size(); ++i) {
            orderMap.putIfAbsent(orderedList.get(i).getVal(), i);
        }
        return relateNodes.stream().sorted(Comparator.comparing(treeNode -> orderMap.getOrDefault(treeNode, 0))).collect(Collectors.toList());
    }

    private void doFillRelateNode(Set<TreeNode> relateTreeNode, DAGNode<TreeNode> treeNodeDAGNode, Set<TreeNode> sourceDataSet) {
        TreeNode treeNodeDAGNodeVal = treeNodeDAGNode.getVal();
        relateTreeNode.add(treeNodeDAGNodeVal);
        sourceDataSet.add(treeNodeDAGNodeVal);
        Set<DAGEdge<TreeNode>> edges = treeNodeDAGNode.getEdges();
        if (EmptyUtil.isEmpty(edges)) {
            return;
        }
        List treeNodeList = edges.stream().map(DAGEdge::getDestNode).map(DAGNode::getVal).filter(sourceDataSet::contains).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(treeNodeList)) {
            return;
        }
        for (DAGEdge<TreeNode> edge : edges) {
            DAGNode<TreeNode> destNode = edge.getDestNode();
            this.doFillRelateNode(relateTreeNode, destNode, sourceDataSet);
        }
    }

    @Override
    public List<TreeNode> updateData(TreeNode updateVal) {
        ArrayList<TreeNode> updateValList = new ArrayList<TreeNode>(1);
        updateValList.add(updateVal);
        return this.updateData((List<TreeNode>)updateValList);
    }

    @Override
    public List<TreeNode> updateData(List<TreeNode> updateValList) {
        try (IFpmTraceSpan span = IFpmTracer.getInstance().createSpan("ReportTreeNodeFormulaManager_updateData_method");){
            span.addTag("ReportTreeNodeFormulaManager_updateData_method_step1");
            this.dagVisit = new DAGVisit<TreeNode>(this.dagManager);
            CalcTreeNodeVisitListener listener = new CalcTreeNodeVisitListener(this.formulaMap);
            span.addTag("ReportTreeNodeFormulaManager_updateData_method_step2-3");
            this.dagVisit.addNodeVisitListener(listener);
            span.addTag("ReportTreeNodeFormulaManager_updateData_method_step2");
            for (TreeNode updateVal : updateValList) {
                span.addTag("ReportTreeNodeFormulaManager_updateData_method_step2-1");
                DAGNode<TreeNode> changeNode = this.dagManager.get(updateVal);
                if (changeNode == null) continue;
                span.addTag("ReportTreeNodeFormulaManager_updateData_method_step2-2");
                this.dagVisit.orderVisitNode(changeNode, true);
            }
            ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>(listener.getReCalcValSet());
            return arrayList;
        }
    }

    private void initDAGManager() {
        for (Formula formula : this.formulaList) {
            FormulaOperationValUp leftOperation = formula.getLeftValUp();
            List<IFormulaOperator> rightOperationLst = formula.getRightValListS();
            for (IFormulaOperator formulaOperation : rightOperationLst) {
                FormulaOperationValUp valUp = (FormulaOperationValUp)formulaOperation;
                this.dagManager.get((TreeNode)leftOperation.getName()).addEdge(new DAGEdge<TreeNode>(this.dagManager.get((TreeNode)valUp.getName())));
            }
        }
        this.dagVisit = new DAGVisit<TreeNode>(this.dagManager);
    }
}

