/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.formula;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.ReportInputType;
import kd.tmc.fpm.business.domain.enums.ReportPlanType;
import kd.tmc.fpm.business.domain.formula.IReportFormulaManager;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.FundPlanSystem;
import kd.tmc.fpm.business.domain.model.dimension.member.AccountMember;
import kd.tmc.fpm.business.domain.model.report.Report;
import kd.tmc.fpm.business.domain.model.template.TemplateAccountSetting;
import kd.tmc.fpm.business.helper.FormulaHelper;
import kd.tmc.fpm.business.spread.formula.Formula;
import kd.tmc.fpm.business.spread.formula.FormulaOperationVal;
import kd.tmc.fpm.business.spread.formula.IDAGManager;
import kd.tmc.fpm.business.spread.formula.IDAGVisit;
import kd.tmc.fpm.business.spread.formula.impl.DAGEdge;
import kd.tmc.fpm.business.spread.formula.impl.DAGManager;
import kd.tmc.fpm.business.spread.formula.impl.DAGNode;
import kd.tmc.fpm.business.spread.formula.impl.DAGNodeVisitListener;
import kd.tmc.fpm.business.spread.formula.impl.DAGVisit;
import org.apache.commons.collections.CollectionUtils;

public class SubjectFindReportTreeNodeFormulaManager
implements IReportFormulaManager<Long> {
    private Report report;
    private FundPlanSystem system;
    private IDAGManager<Long> dagManager;
    private IDAGVisit<Long> dagVisit;
    private List<Formula> formulaList;
    private Dimension subjectDim;

    public SubjectFindReportTreeNodeFormulaManager(Report report, FundPlanSystem system) {
        this.report = report;
        this.system = system;
        this.init();
    }

    private void init() {
        this.initDim();
        this.initFormulaInfo();
        this.initDagManager();
    }

    private void initFormulaInfo() {
        List<TemplateAccountSetting> accountSettings = this.report.getTemplate().getAccountSettings();
        if (ReportPlanType.REPORTPLAN == this.report.getReportPlanType()) {
            accountSettings = accountSettings.stream().filter(Objects::nonNull).filter(item -> ReportInputType.SUMMARY == item.getInputType() || ReportInputType.FORMULA == item.getInputType()).collect(Collectors.toList());
        }
        this.formulaList = new ArrayList<Formula>(accountSettings.size());
        for (TemplateAccountSetting targetAcctSetting : accountSettings) {
            AccountMember currentMember;
            Formula formulaInfo = targetAcctSetting.buildFormulaInfo();
            if (formulaInfo == null && (formulaInfo = FormulaHelper.parseSubject(currentMember = this.subjectDim.getDimMemberById(targetAcctSetting.getAccountMemId(), AccountMember.class))) == null) continue;
            this.formulaList.add(formulaInfo);
        }
    }

    private void initDagManager() {
        this.dagManager = new DAGManager<Long>();
        for (Formula formula : this.formulaList) {
            FormulaOperationVal leftVal = formula.getLeftVal();
            if (Objects.isNull(leftVal)) continue;
            List<FormulaOperationVal> rightValList = formula.getRightValList();
            DAGNode<Long> leftNode = this.dagManager.get(Long.valueOf(leftVal.getName()));
            for (FormulaOperationVal formulaOperation : rightValList) {
                if (Objects.isNull(formulaOperation.getName())) continue;
                DAGEdge<Long> rightNode = new DAGEdge<Long>(this.dagManager.get(Long.valueOf(formulaOperation.getName())));
                leftNode.addEdge(rightNode);
            }
        }
        this.dagVisit = new DAGVisit<Long>(this.dagManager);
    }

    private void initDim() {
        this.subjectDim = this.system.getMainDimensionByDimType(DimensionType.SUBJECTS);
    }

    @Override
    public List<Long> updateData(Long updateVal) {
        return this.findSubjectId(Collections.singletonList(updateVal));
    }

    @Override
    public List<Long> updateData(List<Long> updateValList) {
        return this.findSubjectId(updateValList);
    }

    @Override
    public List<Long> findEffectData(List<Long> sourceSubjects) {
        return this.findSubjectId(sourceSubjects);
    }

    @Override
    public List<Long> findEffectData(Set<Long> sourceSubjects) {
        return this.findSubjectId(new ArrayList<Long>(sourceSubjects));
    }

    private List<Long> findSubjectId(List<Long> sourceSubjects) {
        if (CollectionUtils.isEmpty(sourceSubjects)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        this.dagVisit = new DAGVisit<Long>(this.dagManager);
        HashSet<Long> effectiveSubjectsIds = new HashSet<Long>(sourceSubjects.size() * 2);
        DAGNodeVisitListener listener = node -> effectiveSubjectsIds.add((Long)node.getVal());
        this.dagVisit.addNodeVisitListener(listener);
        for (Long subjectMemId : sourceSubjects) {
            DAGNode<Long> changeNode = this.dagManager.get(subjectMemId);
            if (changeNode == null) continue;
            this.dagVisit.orderVisitNode(changeNode);
        }
        this.fillRelateNode(effectiveSubjectsIds, new HashSet<Long>(sourceSubjects));
        return new ArrayList<Long>(effectiveSubjectsIds);
    }

    private void fillRelateNode(Set<Long> relateNodes, Set<Long> sourceDataSet) {
        List<Long> sourceNodes = this.getOrderRelateNodeList(relateNodes);
        Map<Long, DAGNode<Long>> vertexMap = this.dagManager.getVertexMap();
        for (Long treeNode : sourceNodes) {
            DAGNode<Long> treeNodeDAGNode = vertexMap.get(treeNode);
            if (EmptyUtil.isEmpty(treeNodeDAGNode)) continue;
            this.doFillRelateNode(relateNodes, treeNodeDAGNode, sourceDataSet);
        }
    }

    private List<Long> getOrderRelateNodeList(Set<Long> relateNodes) {
        List<DAGNode<Long>> orderedList = this.dagManager.getOrderedList();
        HashMap<Long, Integer> orderMap = new HashMap<Long, Integer>(orderedList.size());
        for (int i = 0; i < orderedList.size(); ++i) {
            orderMap.putIfAbsent(orderedList.get(i).getVal(), i);
        }
        return relateNodes.stream().sorted(Comparator.comparing(treeNode -> orderMap.getOrDefault(treeNode, 0))).collect(Collectors.toList());
    }

    private void doFillRelateNode(Set<Long> relateTreeNode, DAGNode<Long> treeNodeDAGNode, Set<Long> sourceDataSet) {
        Long treeNodeDAGNodeVal = treeNodeDAGNode.getVal();
        relateTreeNode.add(treeNodeDAGNodeVal);
        sourceDataSet.add(treeNodeDAGNodeVal);
        Set<DAGEdge<Long>> edges = treeNodeDAGNode.getEdges();
        if (EmptyUtil.isEmpty(edges)) {
            return;
        }
        List treeNodeList = edges.stream().map(DAGEdge::getDestNode).map(DAGNode::getVal).filter(sourceDataSet::contains).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(treeNodeList)) {
            for (DAGEdge<Long> edge : edges) {
                DAGNode<Long> destNode = edge.getDestNode();
                if (EmptyUtil.isEmpty(destNode) || EmptyUtil.isEmpty((Long)destNode.getVal())) continue;
                relateTreeNode.add(destNode.getVal());
                sourceDataSet.add(destNode.getVal());
            }
            return;
        }
        for (DAGEdge<Long> edge : edges) {
            DAGNode<Long> destNode = edge.getDestNode();
            this.doFillRelateNode(relateTreeNode, destNode, sourceDataSet);
        }
    }
}

