/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.control;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.report.ReportData;

public class ControlCoefficientInfo {
    private static final Log logger = LogFactory.getLog(ControlCoefficientInfo.class);
    private Long reportDataId;
    private BigDecimal controlCoefficient;
    private BigDecimal calculateData;
    private List<ReportData> reportDataList;
    private Set<Long> reportDataIds;
    private boolean calculate;
    private boolean needCalculate;

    public ControlCoefficientInfo(Long reportDataId, BigDecimal controlCoefficient) {
        this(reportDataId, controlCoefficient, null, false);
    }

    public ControlCoefficientInfo(Long reportDataId, BigDecimal controlCoefficient, boolean needCalculate) {
        this(reportDataId, controlCoefficient, null, needCalculate);
    }

    public ControlCoefficientInfo(Long reportDataId, BigDecimal controlCoefficient, List<ReportData> reportDataList) {
        this(reportDataId, controlCoefficient, reportDataList, true);
    }

    public ControlCoefficientInfo(Long reportDataId, BigDecimal controlCoefficient, List<ReportData> reportDataList, boolean needCalculate) {
        this.reportDataId = reportDataId;
        this.controlCoefficient = controlCoefficient;
        this.reportDataList = new ArrayList<ReportData>(4);
        this.reportDataIds = new HashSet<Long>(256);
        this.needCalculate = needCalculate;
        if (EmptyUtil.isEmpty(reportDataList)) {
            return;
        }
        reportDataList.forEach(this::addReportData);
    }

    private void addReportData(ReportData reportData) {
        if (!this.reportDataIds.add(reportData.getId())) {
            return;
        }
        this.reportDataList.add(reportData);
    }

    public BigDecimal getControlCoefficient() {
        return this.controlCoefficient;
    }

    public void setControlCoefficient(BigDecimal controlCoefficient) {
        this.controlCoefficient = controlCoefficient;
    }

    public BigDecimal getCalculateData(boolean reCalculate) {
        if (reCalculate) {
            this.calculate = false;
        }
        if (this.calculate) {
            return this.calculateData;
        }
        this.calculateData();
        return this.calculateData;
    }

    public BigDecimal getCalculateData() {
        if (this.calculate) {
            return this.calculateData;
        }
        this.calculateData();
        return this.calculateData;
    }

    public void calculateData() {
        this.calculate = true;
        if (!this.needCalculate) {
            logger.info("\u7f16\u5236\u6570\u636eid:{},\u4e0d\u9700\u8981\u8ba1\u7b97\uff0c\u76f4\u63a5\u8fd4\u56de\u7cfb\u6570\uff1a{}", new Object[]{this.reportDataId, this.controlCoefficient, this.controlCoefficient.toPlainString()});
            this.calculateData = this.controlCoefficient;
            return;
        }
        if (EmptyUtil.isEmpty(this.reportDataList)) {
            logger.info("\u7f16\u5236\u6570\u636eid:{},\u53c2\u4e0e\u8ba1\u7b97\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u76f4\u63a5\u8fd4\u56de\u7cfb\u6570:{}", (Object)this.reportDataId, (Object)this.controlCoefficient.toPlainString());
            this.calculateData = this.controlCoefficient;
            return;
        }
        BigDecimal reduce = this.reportDataList.stream().map(ReportData::getPlanAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.calculateData = reduce.multiply(this.controlCoefficient).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
        logger.info("\u7f16\u5236\u6570\u636eid:{},\u53c2\u4e0e\u8ba1\u7b97\u7684\u7f16\u5236\u6570\u636eid\uff1a{}\uff0c\u53c2\u4e0e\u8ba1\u7b97\u7684\u603b\u8ba1\u5212\u989d\u5ea6\uff1a{} * \u63a7\u5236\u7cfb\u6570\uff1a{} = {}", new Object[]{this.reportDataId, this.reportDataIds, reduce.toPlainString(), this.controlCoefficient.toPlainString(), this.calculateData.toPlainString()});
    }

    public void setCalculateData(BigDecimal calculateData) {
        this.calculateData = calculateData;
    }

    public List<ReportData> getReportDataList() {
        return this.reportDataList;
    }

    public void setReportDataList(List<ReportData> reportDataList) {
        this.reportDataList = reportDataList;
    }

    public Long getReportDataId() {
        return this.reportDataId;
    }

    public void setReportDataId(Long reportDataId) {
        this.reportDataId = reportDataId;
    }
}

