/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.control;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.ControlStrategy;
import kd.tmc.fpm.business.domain.model.control.ControlStrategyDetail;
import kd.tmc.fpm.business.domain.model.control.DetailControlInfo;
import kd.tmc.fpm.business.mvc.service.context.ControlContext;
import kd.tmc.fpm.business.mvc.service.params.ControlExecuteParam;

public class ControlStrategyDetailControlInfo {
    private ControlContext controlContext;
    private Map<Long, DetailControlInfo> detailControlInfoMap;

    public ControlStrategyDetailControlInfo(ControlContext controlContext) {
        this.controlContext = controlContext;
        this.detailControlInfoMap = new HashMap<Long, DetailControlInfo>(16);
    }

    public DetailControlInfo getDetailControlInfo(ControlExecuteParam controlExecuteParam) {
        ControlStrategy controlStrategy = this.controlContext.getControlStrategy(controlExecuteParam.getSystemId(), controlExecuteParam.getReportTypeId(), controlExecuteParam.getReportOrgId());
        return this.getDetailControlInfo(controlStrategy);
    }

    public DetailControlInfo getDetailControlInfo(ControlStrategy controlStrategy) {
        if (Objects.isNull(controlStrategy)) {
            return null;
        }
        return this.detailControlInfoMap.computeIfAbsent(controlStrategy.getId(), k -> {
            DetailControlInfo detailControlInfo = new DetailControlInfo(controlStrategy);
            List<ControlStrategyDetail> controlStrategyDetails = controlStrategy.getControlStrategyDetails();
            for (ControlStrategyDetail controlStrategyDetail : controlStrategyDetails) {
                Set<Long> optionalDimIds;
                List<ControlStrategyDetail.DetailControlBasis> detailControlBasisList = controlStrategyDetail.getDetailControlBasisList();
                if (EmptyUtil.isEmpty(detailControlBasisList)) continue;
                Map dimensionTypeSetMap = detailControlBasisList.stream().collect(Collectors.groupingBy(detailControlBasis -> detailControlBasis.getDimensionType().isDetailDim(), Collectors.mapping(ControlStrategyDetail.DetailControlBasis::getDimensionId, Collectors.toSet())));
                Long subjectId = controlStrategyDetail.getSubjectId();
                Set<Long> set = dimensionTypeSetMap.get(Boolean.TRUE);
                if (EmptyUtil.isNoEmpty(set)) {
                    detailControlInfo.addDetailDims(set, subjectId);
                }
                if (!EmptyUtil.isNoEmpty(optionalDimIds = dimensionTypeSetMap.get(Boolean.FALSE))) continue;
                detailControlInfo.addOptionalDims(optionalDimIds, subjectId);
            }
            return detailControlInfo;
        });
    }
}

