/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;

public class ControlTraceIdInfo {
    private List<Long> controlTraceIdList = new ArrayList<Long>(16);
    private Map<Long, BillControlTraceIdInfo> billControlTraceIdInfoMap = new HashMap<Long, BillControlTraceIdInfo>(16);

    public boolean needDoubleCheck() {
        return this.billControlTraceIdInfoMap.values().stream().filter(BillControlTraceIdInfo::isFirst).findFirst().isPresent();
    }

    public List<BillBizInfo> getControlTraceIdFirstBizBillInfoList() {
        return this.billControlTraceIdInfoMap.values().stream().filter(BillControlTraceIdInfo::isFirst).map(BillControlTraceIdInfo::getBillBizInfo).collect(Collectors.toList());
    }

    public List<Long> getFirstGenControlTraceIds() {
        return this.billControlTraceIdInfoMap.values().stream().filter(BillControlTraceIdInfo::isFirst).map(BillControlTraceIdInfo::getControlTraceId).distinct().collect(Collectors.toList());
    }

    public void addControlTraceId(Long controlTraceId, BillBizInfo billBizInfo, boolean first) {
        this.controlTraceIdList.add(controlTraceId);
        BillControlTraceIdInfo billControlTraceIdInfo = new BillControlTraceIdInfo();
        billControlTraceIdInfo.setControlTraceId(controlTraceId);
        billControlTraceIdInfo.setBillBizInfo(billBizInfo);
        billControlTraceIdInfo.setFirst(first);
        this.billControlTraceIdInfoMap.putIfAbsent(billBizInfo.getBillId(), billControlTraceIdInfo);
    }

    public List<BillControlTraceIdInfo> getBillControlTraceIdInfoList() {
        return new ArrayList<BillControlTraceIdInfo>(this.billControlTraceIdInfoMap.values());
    }

    public List<Long> getControlTraceIdList() {
        return this.controlTraceIdList;
    }

    public Map<Long, Long> getBillTraceIdMap() {
        return this.billControlTraceIdInfoMap.values().stream().collect(Collectors.toMap(b -> b.getBillBizInfo().getBillId(), b -> b.getControlTraceId(), (a, b) -> a));
    }

    public BillControlTraceIdInfo getBillControlTraceIdInfo(Long billId) {
        return this.billControlTraceIdInfoMap.get(billId);
    }

    public static class BillControlTraceIdInfo {
        private BillBizInfo billBizInfo;
        private Long controlTraceId;
        private boolean first;

        public BillBizInfo getBillBizInfo() {
            return this.billBizInfo;
        }

        public void setBillBizInfo(BillBizInfo billBizInfo) {
            this.billBizInfo = billBizInfo;
        }

        public Long getControlTraceId() {
            return this.controlTraceId;
        }

        public void setControlTraceId(Long controlTraceId) {
            this.controlTraceId = controlTraceId;
        }

        public boolean isFirst() {
            return this.first;
        }

        public void setFirst(boolean first) {
            this.first = first;
        }
    }
}

