/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.control;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.PlanExecuteOpType;
import kd.tmc.fpm.business.domain.enums.PlanExecuteStatus;
import kd.tmc.fpm.business.domain.model.control.BillBizInfo;
import kd.tmc.fpm.business.domain.model.control.ControlTraceInfo;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.sumplan.EvalDimensionCombination;
import kd.tmc.fpm.business.domain.model.sumplan.EvalDimensionVal;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.business.utils.CommonUtils;
import kd.tmc.fpm.business.utils.LogHelper;
import kd.tmc.fpm.common.utils.NumberUtils;
import org.apache.commons.collections4.MapUtils;

public class ControlTracePlanRecordSort {
    private static final Log logger = LogFactory.getLog(ControlTracePlanRecordSort.class);
    private Long billId;
    private String entityType;
    private final Map<Long, Map<EvalDimensionCombination, DimensionCombinationGroup>> dimensionCombinationGroupMap;
    private Map<Long, PlanExecuteRecord> recordCache;
    private final Map<PlanExecuteOpType, PlanExecuteRecordIndex> planExecuteOpTypeListMap;
    private ControlTracePlanRecordSort next;
    private ControlTracePlanRecordSort tail;
    private long size;
    private final Map<Long, List<PlanExecuteRecord>> relateRecordCache;
    private final Map<Long, List<PlanExecuteRecord>> originalRecordCache;

    private ControlTracePlanRecordSort() {
        this(64);
    }

    private ControlTracePlanRecordSort(int size) {
        this.dimensionCombinationGroupMap = new HashMap<Long, Map<EvalDimensionCombination, DimensionCombinationGroup>>(size / 10);
        this.recordCache = new HashMap<Long, PlanExecuteRecord>(size);
        this.planExecuteOpTypeListMap = new HashMap<PlanExecuteOpType, PlanExecuteRecordIndex>(size / 8);
        this.originalRecordCache = new HashMap<Long, List<PlanExecuteRecord>>(size / 4);
        this.relateRecordCache = new HashMap<Long, List<PlanExecuteRecord>>(size / 4);
        this.tail = this;
        ++this.size;
    }

    public void addPlanExecuteRecord(PlanExecuteRecord planExecuteRecord) {
        Long relateRecordId;
        if (Objects.isNull(planExecuteRecord)) {
            return;
        }
        this.recordCache.putIfAbsent(planExecuteRecord.getId(), planExecuteRecord);
        if (Objects.isNull(planExecuteRecord.getReportData())) {
            return;
        }
        PlanExecuteStatus executeStatus = planExecuteRecord.getExecuteStatus();
        if (executeStatus == PlanExecuteStatus.FAILURE) {
            return;
        }
        if (executeStatus == PlanExecuteStatus.INITIALIZE) {
            return;
        }
        if (planExecuteRecord.getDeleteStatus().booleanValue()) {
            return;
        }
        if (planExecuteRecord.isTempConsume()) {
            return;
        }
        Long originalRecordId = planExecuteRecord.getOriginalRecordId();
        if (EmptyUtil.isNoEmpty((Long)originalRecordId)) {
            List originalPlanExecuteRecordList = this.originalRecordCache.computeIfAbsent(originalRecordId, k -> new ArrayList(10));
            originalPlanExecuteRecordList.add(planExecuteRecord);
        }
        if (EmptyUtil.isNoEmpty((Long)(relateRecordId = planExecuteRecord.getRelateRecordId()))) {
            List relatePlanExecuteRecordList = this.relateRecordCache.computeIfAbsent(relateRecordId, k -> new ArrayList(10));
            relatePlanExecuteRecordList.add(planExecuteRecord);
        }
        PlanExecuteOpType executeOpType = planExecuteRecord.getExecuteOpType();
        PlanExecuteRecordIndex planExecuteRecordIndex = this.planExecuteOpTypeListMap.computeIfAbsent(executeOpType, k -> new PlanExecuteRecordIndex());
        planExecuteRecordIndex.addPlanExecuteRecord(planExecuteRecord);
        if (!executeOpType.isOccupy()) {
            return;
        }
        EvalDimensionCombination dimensionCombination = ControlTracePlanRecordSort.getDimensionCombination(planExecuteRecord);
        if (dimensionCombination == null) {
            return;
        }
        Map dimensionCombinationGroupMap = this.dimensionCombinationGroupMap.computeIfAbsent(planExecuteRecord.getReportTypeId(), k -> new HashMap(16));
        DimensionCombinationGroup dimensionCombinationGroup = dimensionCombinationGroupMap.computeIfAbsent(dimensionCombination, k -> new DimensionCombinationGroup(dimensionCombination));
        dimensionCombinationGroup.addPlanExecuteRecord(planExecuteRecord);
    }

    public List<PlanExecuteRecord> getRecordListByOriginalRecordId(Long originalRecordId) {
        ArrayList<PlanExecuteRecord> originalRecordList = new ArrayList<PlanExecuteRecord>(64);
        Iterator<ControlTracePlanRecordSort> iterator = this.iterator();
        while (iterator.hasNext()) {
            ControlTracePlanRecordSort next = iterator.next();
            originalRecordList.addAll(next.originalRecordCache.getOrDefault(originalRecordId, Collections.emptyList()));
        }
        return originalRecordList;
    }

    public List<PlanExecuteRecord> getRecordListByOriginalRecordId(Long originalRecordId, BillBizInfo billBizInfo) {
        return new ArrayList<PlanExecuteRecord>(this.getControlTracePlanRecordSort((BillBizInfo)billBizInfo).originalRecordCache.getOrDefault(originalRecordId, Collections.emptyList()));
    }

    public List<PlanExecuteRecord> getRecordListByRelateRecordId(Long relateRecordId) {
        logger.info("getRecordListByRelateRecordId");
        ArrayList<PlanExecuteRecord> relateRecordList = new ArrayList<PlanExecuteRecord>(64);
        Iterator<ControlTracePlanRecordSort> iterator = this.iterator();
        while (iterator.hasNext()) {
            ControlTracePlanRecordSort next = iterator.next();
            relateRecordList.addAll(next.relateRecordCache.getOrDefault(relateRecordId, Collections.emptyList()));
        }
        logger.info("getRecordListByRelateRecordId result size :{}", (Object)relateRecordList.size());
        return relateRecordList;
    }

    public void addNext(ControlTracePlanRecordSort controlTracePlanRecordSort) {
        this.tail.next = controlTracePlanRecordSort;
        this.tail = controlTracePlanRecordSort;
        ++this.size;
    }

    public void markConsumed(PlanExecuteRecord planExecuteRecord) {
        planExecuteRecord.markTempConsume();
        this.updateRecord(planExecuteRecord);
    }

    public Collection<PlanExecuteRecord> getCurrentByExecuteOp(PlanExecuteOpType planExecuteOpType, PlanExecuteRecord current) {
        BillBizInfo billBizInfo = current.getBillBizInfo();
        return this.getPlanExecuteRecords(planExecuteOpType, billBizInfo);
    }

    public Collection<PlanExecuteRecord> getPlanExecuteRecords(PlanExecuteOpType planExecuteOpType, BillBizInfo billBizInfo) {
        Iterator<ControlTracePlanRecordSort> iterator = this.iterator();
        while (iterator.hasNext()) {
            ControlTracePlanRecordSort next = iterator.next();
            if (!Objects.equals(next.billId, billBizInfo.getBillId()) || !Objects.equals(next.entityType, billBizInfo.getEntityType())) continue;
            PlanExecuteRecordIndex planExecuteRecordIndex = next.planExecuteOpTypeListMap.getOrDefault(planExecuteOpType, new PlanExecuteRecordIndex());
            return planExecuteRecordIndex.getPlanExecuteRecords();
        }
        return Collections.emptyList();
    }

    public Map<PlanExecuteOpType, Collection<PlanExecuteRecord>> getUpperByExecuteOps(PlanExecuteRecord current, PlanExecuteOpType ... planExecuteOpType) {
        if (planExecuteOpType == null) {
            return Collections.emptyMap();
        }
        HashMap<PlanExecuteOpType, Collection<PlanExecuteRecord>> map = new HashMap<PlanExecuteOpType, Collection<PlanExecuteRecord>>(planExecuteOpType.length);
        for (PlanExecuteOpType executeOpType : planExecuteOpType) {
            map.putIfAbsent(executeOpType, this.getUpperByExecuteOp(executeOpType, current, false));
        }
        return map;
    }

    public Collection<PlanExecuteRecord> getUpperByExecuteOp(PlanExecuteOpType planExecuteOpType, PlanExecuteRecord current) {
        return this.getUpperByExecuteOp(planExecuteOpType, current, true);
    }

    public Collection<PlanExecuteRecord> getUpperByExecuteOp(PlanExecuteOpType planExecuteOpType, PlanExecuteRecord current, boolean filterCurrent) {
        BillBizInfo billBizInfo = current.getBillBizInfo();
        Iterator<ControlTracePlanRecordSort> iterator = this.iterator();
        ArrayList<PlanExecuteRecord> planExecuteRecordList = new ArrayList<PlanExecuteRecord>(64);
        while (iterator.hasNext()) {
            ControlTracePlanRecordSort next = iterator.next();
            if (filterCurrent && Objects.equals(billBizInfo.getEntityType(), next.entityType)) continue;
            PlanExecuteRecordIndex planExecuteRecordIndex = next.planExecuteOpTypeListMap.getOrDefault(planExecuteOpType, new PlanExecuteRecordIndex());
            planExecuteRecordList.addAll(planExecuteRecordIndex.getPlanExecuteRecords());
        }
        return CommonUtils.getDistinctList(planExecuteRecordList, PlanExecuteRecord::getId);
    }

    public Map<PlanExecuteOpType, Collection<PlanExecuteRecord>> getCurrentByExecuteOps(PlanExecuteRecord current, PlanExecuteOpType ... planExecuteOpTypes) {
        HashMap<PlanExecuteOpType, Collection<PlanExecuteRecord>> map = new HashMap<PlanExecuteOpType, Collection<PlanExecuteRecord>>(planExecuteOpTypes.length);
        for (PlanExecuteOpType planExecuteOpType : planExecuteOpTypes) {
            map.put(planExecuteOpType, this.getCurrentByExecuteOp(planExecuteOpType, current));
        }
        return map;
    }

    public PlanExecuteRecord getById(Long id) {
        Iterator<ControlTracePlanRecordSort> iterator = this.iterator();
        while (iterator.hasNext()) {
            ControlTracePlanRecordSort next = iterator.next();
            PlanExecuteRecord planExecuteRecord = next.recordCache.get(id);
            if (!Objects.nonNull(planExecuteRecord)) continue;
            return planExecuteRecord;
        }
        return null;
    }

    public int getSceneType(PlanExecuteRecord current) {
        if (!this.hasOccupy(current)) {
            return 0;
        }
        Collection<PlanExecuteRecord> upperByExecuteOp = this.getUpperByExecuteOp(current.getExecuteOpType(), current);
        if (EmptyUtil.isNoEmpty(upperByExecuteOp)) {
            return 3;
        }
        Collection<PlanExecuteRecord> currentByExecuteOp = this.getCurrentByExecuteOp(current.getExecuteOpType(), current);
        Optional<PlanExecuteRecord> any = currentByExecuteOp.stream().filter(p -> !Objects.equals(p.getBizOpName(), current.getBizOpName())).findAny();
        return any.isPresent() ? 2 : 1;
    }

    public PlanExecuteRecord getSuitRecord(PlanExecuteRecord current, AtomicBoolean sameDim) {
        return this.getSuitRecord(current, sameDim, 0, LogHelper.get(ControlTracePlanRecordSort.class));
    }

    public PlanExecuteRecord getSuitRecord(PlanExecuteRecord current, AtomicBoolean sameDim, int deep, LogHelper logHelper) {
        if (!this.hasOccupy(current)) {
            return null;
        }
        PlanExecuteRecord suitRecord = null;
        Iterator<ControlTracePlanRecordSort> iterator = this.iterator();
        while (suitRecord == null && iterator.hasNext()) {
            ControlTracePlanRecordSort next = iterator.next();
            suitRecord = this.getSuitRecord(next, current, sameDim);
        }
        if (suitRecord != null && !NumberUtils.equals((BigDecimal)suitRecord.getBeforeReleaseAmt(), (BigDecimal)suitRecord.getUnReleaseAmt())) {
            logHelper.logger("before update suitRecord:%s, BeforeReleaseAmt:%s,UnReleaseAmt:%s", suitRecord, suitRecord.getBeforeReleaseAmt(), suitRecord.getUnReleaseAmt());
            if (deep > 100) {
                logHelper.error();
                throw new KDBizException("The number of recursive calls is greater than 20.");
            }
            this.updateRecord(suitRecord);
            logHelper.logger("after update suitRecord:%s, BeforeReleaseAmt:%s,UnReleaseAmt:%s", suitRecord, suitRecord.getBeforeReleaseAmt(), suitRecord.getUnReleaseAmt());
            suitRecord = this.getSuitRecord(current, sameDim, ++deep, logHelper);
        }
        return suitRecord;
    }

    public boolean isEmpty() {
        if (MapUtils.isNotEmpty(this.recordCache)) {
            return false;
        }
        if (this.size == 1L && MapUtils.isEmpty(this.recordCache)) {
            return true;
        }
        ControlTracePlanRecordSort that = this;
        while (Objects.nonNull(that = that.next)) {
            if (!MapUtils.isNotEmpty(that.recordCache)) continue;
            return false;
        }
        return true;
    }

    private PlanExecuteRecord getSuitRecord(ControlTracePlanRecordSort controlTracePlanRecordSort, PlanExecuteRecord current, AtomicBoolean sameDim) {
        if (MapUtils.isEmpty(controlTracePlanRecordSort.dimensionCombinationGroupMap)) {
            return null;
        }
        EvalDimensionCombination dimensionCombination = ControlTracePlanRecordSort.getDimensionCombination(current);
        Map<EvalDimensionCombination, DimensionCombinationGroup> reportTypeDimensionCombinationGroupMap = controlTracePlanRecordSort.dimensionCombinationGroupMap.get(current.getReportTypeId());
        if (MapUtils.isEmpty(reportTypeDimensionCombinationGroupMap)) {
            return null;
        }
        DimensionCombinationGroup dimensionCombinationGroup = reportTypeDimensionCombinationGroupMap.get(dimensionCombination);
        if (Objects.isNull(dimensionCombinationGroup) || dimensionCombinationGroup.isEmpty()) {
            sameDim.set(false);
            Optional<DimensionCombinationGroup> first = reportTypeDimensionCombinationGroupMap.values().stream().filter(val -> !val.isEmpty()).findFirst();
            return first.map(combinationGroup -> combinationGroup.getSuitRecord(current, false)).orElse(null);
        }
        sameDim.set(true);
        return dimensionCombinationGroup.getSuitRecord(current, true);
    }

    public void updateRecord(PlanExecuteRecord planExecuteRecord) {
        Map<EvalDimensionCombination, DimensionCombinationGroup> dimensionCombinationGroupMap;
        BillBizInfo billBizInfo = planExecuteRecord.getBillBizInfo();
        ControlTracePlanRecordSort that = this.getControlTracePlanRecordSort(billBizInfo);
        that.updateRelateAndOriginalCache(planExecuteRecord);
        PlanExecuteOpType executeOpType = planExecuteRecord.getExecuteOpType();
        PlanExecuteRecordIndex planExecuteRecordIndex = that.planExecuteOpTypeListMap.get(executeOpType);
        if (EmptyUtil.isNoEmpty((Object)planExecuteRecordIndex)) {
            planExecuteRecordIndex.updateRecord(planExecuteRecord);
        }
        if (MapUtils.isEmpty(dimensionCombinationGroupMap = that.dimensionCombinationGroupMap.get(planExecuteRecord.getReportTypeId()))) {
            return;
        }
        EvalDimensionCombination dimensionCombination = ControlTracePlanRecordSort.getDimensionCombination(planExecuteRecord);
        DimensionCombinationGroup dimensionCombinationGroup = dimensionCombinationGroupMap.get(dimensionCombination);
        if (Objects.isNull(dimensionCombinationGroup)) {
            return;
        }
        dimensionCombinationGroup.updateRecord(planExecuteRecord);
    }

    private ControlTracePlanRecordSort getControlTracePlanRecordSort(BillBizInfo billBizInfo) {
        Iterator<ControlTracePlanRecordSort> iterator = this.iterator();
        ControlTracePlanRecordSort that = new ControlTracePlanRecordSort(16);
        while (iterator.hasNext()) {
            that = iterator.next();
            if (!Objects.equals(billBizInfo.getBillId(), that.billId) || !Objects.equals(billBizInfo.getEntityType(), that.entityType)) continue;
            break;
        }
        return that;
    }

    private void updateRelateAndOriginalCache(PlanExecuteRecord planExecuteRecord) {
        this.updateOriginalCache(planExecuteRecord);
        this.updateRelateCache(planExecuteRecord);
    }

    private void updateOriginalCache(PlanExecuteRecord planExecuteRecord) {
        Long originalRecordId = planExecuteRecord.getOriginalRecordId();
        if (EmptyUtil.isEmpty((Long)originalRecordId)) {
            return;
        }
        List<PlanExecuteRecord> planExecuteRecordList = this.originalRecordCache.get(originalRecordId);
        if (EmptyUtil.isEmpty(planExecuteRecordList)) {
            this.originalRecordCache.remove(originalRecordId);
            return;
        }
        if (planExecuteRecord.getDeleteStatus().booleanValue()) {
            planExecuteRecordList.remove(planExecuteRecord);
        }
        if (planExecuteRecord.isTempConsume()) {
            planExecuteRecordList.remove(planExecuteRecord);
        }
    }

    private void updateRelateCache(PlanExecuteRecord planExecuteRecord) {
        Long relateRecordId = planExecuteRecord.getRelateRecordId();
        if (EmptyUtil.isEmpty((Long)relateRecordId)) {
            return;
        }
        List<PlanExecuteRecord> planExecuteRecordList = this.relateRecordCache.get(relateRecordId);
        if (EmptyUtil.isEmpty(planExecuteRecordList)) {
            this.relateRecordCache.remove(relateRecordId);
            return;
        }
        if (planExecuteRecord.getDeleteStatus().booleanValue()) {
            planExecuteRecordList.remove(planExecuteRecord);
        }
        if (planExecuteRecord.isTempConsume()) {
            planExecuteRecordList.remove(planExecuteRecord);
        }
    }

    public boolean hasOccupy(PlanExecuteRecord currentPlanExecuteRecord) {
        Iterator<ControlTracePlanRecordSort> iterator = this.iterator();
        while (iterator.hasNext()) {
            ControlTracePlanRecordSort next = iterator.next();
            Map<EvalDimensionCombination, DimensionCombinationGroup> dimensionCombinationGroupMap = next.dimensionCombinationGroupMap.get(currentPlanExecuteRecord.getReportTypeId());
            if (!MapUtils.isNotEmpty(dimensionCombinationGroupMap)) continue;
            return true;
        }
        return false;
    }

    public Iterator<ControlTracePlanRecordSort> iterator() {
        return new ControlTracePlanRecordSortIterator(this);
    }

    public static ControlTracePlanRecordSort getInstance(ControlTraceInfo controlTraceInfo) {
        logger.info("single init start....");
        if (controlTraceInfo == null) {
            return new ControlTracePlanRecordSort();
        }
        List<PlanExecuteRecord> executeRecordList = controlTraceInfo.getExecuteRecordList();
        ControlTracePlanRecordSort controlTracePlanRecordSort = new ControlTracePlanRecordSort(executeRecordList.size());
        controlTracePlanRecordSort.billId = controlTraceInfo.getBillId();
        controlTracePlanRecordSort.entityType = controlTraceInfo.getEntityType();
        executeRecordList.forEach(controlTracePlanRecordSort::addPlanExecuteRecord);
        logger.info("single init end....");
        return controlTracePlanRecordSort;
    }

    public static ControlTracePlanRecordSort getInstanceByList(List<ControlTraceInfo> traceInfoList) {
        logger.info("batch init start....");
        ControlTracePlanRecordSort controlTracePlanRecordSort = null;
        for (ControlTraceInfo controlTraceInfo : traceInfoList) {
            if (controlTracePlanRecordSort == null) {
                controlTracePlanRecordSort = ControlTracePlanRecordSort.getInstance(controlTraceInfo);
                continue;
            }
            ControlTracePlanRecordSort next = ControlTracePlanRecordSort.getInstance(controlTraceInfo);
            controlTracePlanRecordSort.addNext(next);
        }
        logger.info("batch init end....");
        return controlTracePlanRecordSort;
    }

    public static EvalDimensionCombination getDimensionCombination(PlanExecuteRecord planExecuteRecord) {
        ReportData reportData = planExecuteRecord.getReportData();
        if (EmptyUtil.isEmpty((Object)reportData)) {
            return null;
        }
        List<TemplateDim> dimList = reportData.getDimList();
        List<Object> dimValList = reportData.getDimValList();
        EvalDimensionCombination evalDimensionCombination = new EvalDimensionCombination(reportData.getSystemId());
        for (int i = 0; i < dimList.size(); ++i) {
            Object value;
            TemplateDim templateDim = dimList.get(i);
            if (templateDim.getDimType().isDetailDim() || EmptyUtil.isEmpty((Object)(value = dimValList.get(i)))) continue;
            evalDimensionCombination.addEvalDimensionVal(new EvalDimensionVal(templateDim.getDimensionId(), templateDim.getDimType(), value));
        }
        evalDimensionCombination.freeze();
        return evalDimensionCombination;
    }

    static class ControlTracePlanRecordSortIterator
    implements Iterator<ControlTracePlanRecordSort> {
        private ControlTracePlanRecordSort next;

        ControlTracePlanRecordSortIterator(ControlTracePlanRecordSort controlTracePlanRecordSort) {
            this.next = controlTracePlanRecordSort;
        }

        @Override
        public boolean hasNext() {
            return Objects.nonNull(this.next);
        }

        @Override
        public ControlTracePlanRecordSort next() {
            ControlTracePlanRecordSort lastReturned = this.next;
            this.next = this.next.next;
            return lastReturned;
        }
    }

    static class PlanExecuteRecordIndex {
        private final LinkedHashMap<Long, PlanExecuteRecord> planExecuteRecordMap;

        public PlanExecuteRecordIndex() {
            this(16);
        }

        public PlanExecuteRecordIndex(int size) {
            this.planExecuteRecordMap = new LinkedHashMap(size);
        }

        public void addPlanExecuteRecord(PlanExecuteRecord planExecuteRecord) {
            this.planExecuteRecordMap.put(planExecuteRecord.getId(), planExecuteRecord);
        }

        public Collection<PlanExecuteRecord> getPlanExecuteRecords() {
            return new ArrayList<PlanExecuteRecord>(this.planExecuteRecordMap.values());
        }

        public void updateRecord(PlanExecuteRecord planExecuteRecord) {
            if (planExecuteRecord.getDeleteStatus().booleanValue()) {
                this.planExecuteRecordMap.remove(planExecuteRecord.getId());
            }
            if (planExecuteRecord.isTempConsume()) {
                this.planExecuteRecordMap.remove(planExecuteRecord.getId());
            }
        }
    }

    static class OccupyRecordSortCache {
        private TreeMap<BigDecimal, TreeSet<PlanExecuteRecord>> amountCache = new TreeMap();
        private PlanExecuteOpType planExecuteOpType;

        public void addPlanExecuteRecord(PlanExecuteRecord planExecuteRecord) {
            if (planExecuteRecord.getUnReleaseAmt().compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            planExecuteRecord.setBeforeReleaseAmt(planExecuteRecord.getUnReleaseAmt());
            TreeSet sortPlanExecuteRecords = this.amountCache.computeIfAbsent(planExecuteRecord.getBeforeReleaseAmt(), k -> new TreeSet((o1, o2) -> o1.getExecuteDate().getTime() - o2.getExecuteDate().getTime() == 0L ? 1 : (int)(o2.getExecuteDate().getTime() - o1.getExecuteDate().getTime())));
            sortPlanExecuteRecords.add(planExecuteRecord);
            if (Objects.isNull(this.planExecuteOpType)) {
                this.planExecuteOpType = planExecuteRecord.getExecuteOpType();
            }
        }

        public PlanExecuteRecord getByCurrent(PlanExecuteRecord current, boolean sameDim) {
            if (!sameDim) {
                return this.getLagerAmountRecord();
            }
            TreeSet<PlanExecuteRecord> planExecuteRecords = this.amountCache.get(current.getActAmount());
            if (EmptyUtil.isNoEmpty(planExecuteRecords)) {
                return planExecuteRecords.first();
            }
            return this.getLagerAmountRecord();
        }

        private PlanExecuteRecord getLagerAmountRecord() {
            while (MapUtils.isNotEmpty(this.amountCache)) {
                Map.Entry<BigDecimal, TreeSet<PlanExecuteRecord>> lastEntry = this.amountCache.lastEntry();
                TreeSet<PlanExecuteRecord> planExecuteRecords = lastEntry.getValue();
                if (EmptyUtil.isEmpty(planExecuteRecords)) {
                    this.amountCache.remove(lastEntry.getKey());
                    continue;
                }
                return planExecuteRecords.first();
            }
            return null;
        }

        public void delete(PlanExecuteRecord planExecuteRecord) {
            TreeSet<PlanExecuteRecord> planExecuteRecords = this.amountCache.get(planExecuteRecord.getBeforeReleaseAmt());
            if (EmptyUtil.isEmpty(planExecuteRecords)) {
                return;
            }
            planExecuteRecords.remove(planExecuteRecord);
        }

        public void updateRecord(PlanExecuteRecord planExecuteRecord) {
            BigDecimal unReleaseAmt = planExecuteRecord.getUnReleaseAmt();
            BigDecimal beforeReleaseAmt = planExecuteRecord.getBeforeReleaseAmt();
            TreeSet<PlanExecuteRecord> planExecuteRecords = this.amountCache.get(beforeReleaseAmt);
            if (unReleaseAmt.compareTo(beforeReleaseAmt) == 0) {
                return;
            }
            if (EmptyUtil.isNoEmpty(planExecuteRecords)) {
                planExecuteRecords.removeIf(p -> Objects.equals(p.getId(), planExecuteRecord.getId()));
            }
            if (EmptyUtil.isEmpty(planExecuteRecords)) {
                this.amountCache.remove(beforeReleaseAmt);
            }
            if (unReleaseAmt.compareTo(BigDecimal.ZERO) == 0) {
                return;
            }
            this.addPlanExecuteRecord(planExecuteRecord);
        }

        public boolean isEmpty() {
            return MapUtils.isEmpty(this.amountCache) || this.amountCache.values().isEmpty();
        }
    }

    static class DimensionCombinationGroup {
        private final EvalDimensionCombination evalDimensionCombination;
        private final OccupyRecordSortCache occupyRecordSortCache;

        public EvalDimensionCombination getEvalDimensionCombination() {
            return this.evalDimensionCombination;
        }

        public DimensionCombinationGroup(EvalDimensionCombination evalDimensionCombination) {
            this.evalDimensionCombination = evalDimensionCombination;
            this.occupyRecordSortCache = new OccupyRecordSortCache();
        }

        public void addPlanExecuteRecord(PlanExecuteRecord planExecuteRecord) {
            PlanExecuteOpType executeOpType = planExecuteRecord.getExecuteOpType();
            if (Objects.isNull(executeOpType)) {
                return;
            }
            if (!executeOpType.isOccupy()) {
                return;
            }
            this.occupyRecordSortCache.addPlanExecuteRecord(planExecuteRecord);
        }

        public PlanExecuteRecord getSuitRecord(PlanExecuteRecord current, boolean sameDim) {
            if (this.occupyRecordSortCache.isEmpty()) {
                return null;
            }
            return this.occupyRecordSortCache.getByCurrent(current, sameDim);
        }

        public void updateRecord(PlanExecuteRecord planExecuteRecord) {
            if (!planExecuteRecord.getExecuteOpType().isOccupy()) {
                return;
            }
            if (planExecuteRecord.getDeleteStatus().booleanValue()) {
                this.occupyRecordSortCache.delete(planExecuteRecord);
                return;
            }
            this.occupyRecordSortCache.updateRecord(planExecuteRecord);
        }

        public boolean isEmpty() {
            return this.occupyRecordSortCache.isEmpty();
        }
    }
}

