/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.control;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.model.control.ControlAmountCache;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;

public class ControlUpdateInfo {
    private List<PlanExecuteRecord> savePlanExecuteRecordList = new ArrayList<PlanExecuteRecord>(16);
    private List<PlanExecuteRecord> updatePlanExecuteRecordList = new ArrayList<PlanExecuteRecord>(16);
    private List<ControlAmountCache.AmountInfo> updateAmountInfoList = new ArrayList<ControlAmountCache.AmountInfo>(64);
    private Set<Long> updateDataIds = new HashSet<Long>(32);

    public void addSavePlanExecuteRecord(PlanExecuteRecord planExecuteRecord) {
        if (!this.updateDataIds.add(planExecuteRecord.getId())) {
            return;
        }
        this.savePlanExecuteRecordList.add(planExecuteRecord);
    }

    public boolean addUpdatePlanExecuteRecord(PlanExecuteRecord planExecuteRecord) {
        if (!this.updateDataIds.add(planExecuteRecord.getId())) {
            return false;
        }
        this.updatePlanExecuteRecordList.add(planExecuteRecord);
        return true;
    }

    public void addUpdateAmountInfo(ControlAmountCache.AmountInfo amountInfo) {
        this.updateAmountInfoList.add(amountInfo);
    }

    public void addAllUpdateAmountInfo(List<ControlAmountCache.AmountInfo> amountInfoList) {
        this.updateAmountInfoList.addAll(amountInfoList);
    }

    public List<PlanExecuteRecord> getSavePlanExecuteRecordList() {
        return this.savePlanExecuteRecordList;
    }

    public List<PlanExecuteRecord> getUpdatePlanExecuteRecordList() {
        this.updatePlanExecuteRecordList.sort(Comparator.comparing(PlanExecuteRecord::getId));
        return this.updatePlanExecuteRecordList;
    }

    public List<ControlAmountCache.AmountInfo> getUpdateAmountInfoList() {
        return this.updateAmountInfoList;
    }

    public boolean isEmpty() {
        return EmptyUtil.isEmpty(this.updateDataIds);
    }

    public String toString() {
        return "ControlUpdateInfo{savePlanExecuteRecordList=" + this.savePlanExecuteRecordList + ", updatePlanExecuteRecordList=" + this.updatePlanExecuteRecordList + ", updateAmountInfoList=" + this.updateAmountInfoList + '}';
    }
}

