/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.control;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.tmc.fpm.business.domain.model.control.PlanExecuteRecord;

public class RelateRecord {
    private BigDecimal realAmount = BigDecimal.ZERO;
    private List<PlanExecuteRecord> relateRecordList = new ArrayList<PlanExecuteRecord>(8);
    private PlanExecuteRecord originalRecord;

    public RelateRecord(PlanExecuteRecord relateRecord, PlanExecuteRecord originalRecord) {
        this.originalRecord = originalRecord;
        this.addRelateRecord(relateRecord);
    }

    public final void addRelateRecord(PlanExecuteRecord planExecuteRecord) {
        if (Objects.isNull(planExecuteRecord)) {
            return;
        }
        Long id = this.originalRecord.getId();
        if (id.equals(planExecuteRecord.getOriginalRecordId())) {
            this.relateRecordList.add(planExecuteRecord);
            this.realAmount = this.realAmount.add(planExecuteRecord.getActAmount());
        }
    }

    public PlanExecuteRecord getOriginalRecord() {
        return this.originalRecord;
    }

    public void setOriginalRecord(PlanExecuteRecord originalRecord) {
        this.originalRecord = originalRecord;
    }

    public List<PlanExecuteRecord> getRelateRecordList() {
        return this.relateRecordList;
    }

    public BigDecimal getRealAmount() {
        return this.realAmount;
    }

    public String toString() {
        return "RelateRecord{realAmount=" + this.realAmount + ", relateRecordList=" + this.relateRecordList + ", originalRecord=" + this.originalRecord + '}';
    }
}

