/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.dimension;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.util.CollectionUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DetailDimType;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.MemberType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;

public class Dimension
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String name;
    private String number;
    private Long systemId;
    private DimensionType dimType;
    private DetailDimType detailDimType;
    private MemberType memberType;
    private List<DimMember> memberList;
    private List<String> memberValList;
    private boolean mustInput;
    private boolean visible;
    private String baseDataType;
    private String dimensionRel;
    private String shrekKey;

    public <T extends DimMember> T getDimMemberByDimId(Class<T> dimClz, Long dimId) {
        return (T)((DimMember)dimClz.cast(this.getAllDimMemberList().stream().filter(o -> dimId.equals(o.getId())).findFirst().orElse(null)));
    }

    public List<Long> getDimMemberIds() {
        if (EmptyUtil.isEmpty(this.memberList)) {
            return new ArrayList<Long>(0);
        }
        return this.memberList.stream().map(DimMember::getId).collect(Collectors.toList());
    }

    public List<Long> getMemberSourceIds() {
        if (EmptyUtil.isEmpty(this.memberList)) {
            return new ArrayList<Long>(0);
        }
        return this.memberList.stream().map(DimMember::getSourceId).collect(Collectors.toList());
    }

    public <T extends DimMember> List<T> getMemberList(Class<T> dimClz) {
        if (EmptyUtil.isEmpty(this.memberList)) {
            return new ArrayList(0);
        }
        return this.memberList.stream().map(dimClz::cast).collect(Collectors.toList());
    }

    public List<DimMember> getAllDimMemberList() {
        ArrayList<DimMember> allDimMemberList = new ArrayList<DimMember>();
        if (EmptyUtil.isEmpty(this.memberList)) {
            return allDimMemberList;
        }
        for (DimMember dimMember : this.memberList) {
            allDimMemberList.add(dimMember);
            allDimMemberList.addAll(dimMember.getAllChildMember());
        }
        return allDimMemberList;
    }

    public <T extends DimMember> List<T> getAllDimMemberList(Class<T> tClass) {
        ArrayList allDimMemberList = new ArrayList(16);
        if (EmptyUtil.isEmpty(this.memberList)) {
            return allDimMemberList;
        }
        for (DimMember dimMember : this.memberList) {
            allDimMemberList.add(tClass.cast(dimMember));
            List<DimMember> allChildMember = dimMember.getAllChildMember();
            if (CollectionUtils.isEmpty(allChildMember)) continue;
            List castList = allChildMember.stream().map(tClass::cast).collect(Collectors.toList());
            allDimMemberList.addAll(castList);
        }
        return allDimMemberList;
    }

    public DimMember getDimMemberById(Long memberId) {
        List<DimMember> allDimMemberList = this.getAllDimMemberList();
        if (EmptyUtil.isEmpty(allDimMemberList)) {
            return null;
        }
        return allDimMemberList.stream().filter(Objects::nonNull).filter(member -> member.getId().compareTo(memberId) == 0).findFirst().orElseGet(() -> null);
    }

    public <T extends DimMember> T getDimMemberById(Long memberId, Class<T> dimClz) {
        DimMember dimMemberById = this.getDimMemberById(memberId);
        if (Objects.isNull(dimMemberById)) {
            return null;
        }
        return (T)((DimMember)dimClz.cast(dimMemberById));
    }

    public boolean isFixedDim() {
        return DimensionType.ORG == this.dimType || DimensionType.CURRENCY == this.dimType || DimensionType.PERIOD == this.dimType || DimensionType.SUBJECTS == this.dimType;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Long getSystemId() {
        return this.systemId;
    }

    public void setSystemId(Long systemId) {
        this.systemId = systemId;
    }

    public DimensionType getDimType() {
        return this.dimType;
    }

    public void setDimType(DimensionType dimType) {
        this.dimType = dimType;
    }

    public DetailDimType getDetailDimType() {
        return this.detailDimType;
    }

    public void setDetailDimType(DetailDimType detailDimType) {
        this.detailDimType = detailDimType;
    }

    public MemberType getMemberType() {
        return this.memberType;
    }

    public void setMemberType(MemberType memberType) {
        this.memberType = memberType;
    }

    public List<DimMember> getMemberList() {
        return this.memberList;
    }

    public void setMemberList(List<DimMember> memberList) {
        this.memberList = memberList;
    }

    public List<String> getMemberValList() {
        return this.memberValList;
    }

    public void setMemberValList(List<String> memberValList) {
        this.memberValList = memberValList;
    }

    public boolean isMustInput() {
        return this.mustInput;
    }

    public void setMustInput(boolean mustInput) {
        this.mustInput = mustInput;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String getBaseDataType() {
        return this.baseDataType;
    }

    public void setBaseDataType(String baseDataType) {
        this.baseDataType = baseDataType;
    }

    public String getShrekKey() {
        return this.shrekKey;
    }

    public void setShrekKey(String shrekKey) {
        this.shrekKey = shrekKey;
    }

    public String getDimensionRel() {
        return this.dimensionRel;
    }

    public void setDimensionRel(String dimensionRel) {
        this.dimensionRel = dimensionRel;
    }

    public Dimension copy() {
        Dimension dimension = new Dimension();
        dimension.setId(this.id);
        dimension.setShrekKey(this.shrekKey);
        dimension.setMemberList(new ArrayList<DimMember>(2));
        dimension.setDimType(this.getDimType());
        dimension.setDetailDimType(this.detailDimType);
        dimension.setNumber(this.number);
        dimension.setMemberType(this.memberType);
        dimension.setMustInput(this.mustInput);
        dimension.setName(this.name);
        dimension.setSystemId(this.systemId);
        dimension.setVisible(this.visible);
        dimension.setBaseDataType(this.baseDataType);
        return dimension;
    }

    public String toString() {
        return "Dimension{id=" + this.id + ", name='" + this.name + '\'' + ", number='" + this.number + '\'' + ", systemId=" + this.systemId + ", dimType=" + (Objects.isNull((Object)this.dimType) ? "" : this.dimType.getNumber()) + ", detailDimType=" + (Objects.isNull((Object)this.detailDimType) ? "" : this.detailDimType.getNumber()) + ", mustInput=" + this.mustInput + ", visible=" + this.visible + '}';
    }
}

