/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.index;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.index.node.MapNode;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;
import kd.tmc.fpm.common.bean.DimensionInfoBean;

public class ReportDataIndexQueryMap<T> {
    private Map<Long, MapNode> dimensionMap;
    private Map<T, Integer> dataIdToIdxMap;
    private List<T> dataIdList;
    private final int dataCnt;

    public ReportDataIndexQueryMap(int dataCnt) {
        this.dataCnt = dataCnt;
        this.dimensionMap = new HashMap<Long, MapNode>(8);
        this.dataIdToIdxMap = new HashMap<T, Integer>(dataCnt);
        this.dataIdList = new ArrayList<T>(dataCnt);
    }

    public void addData(List<TemplateDim> dimList, List<Object> dimValList, T dataId) {
        for (int i = 0; i < dimList.size(); ++i) {
            TemplateDim dim = dimList.get(i);
            Long dimensionId = dim.getDimensionId();
            if (dim.getDimType() == DimensionType.DETAILDIM) continue;
            Long memberId = (Long)dimValList.get(i);
            this.addData(dimensionId, memberId, dataId);
        }
    }

    public void addData(Long dimensionId, Long memberId, T dataId) {
        MapNode mapNode = this.dimensionMap.computeIfAbsent(dimensionId, o -> new MapNode(this.dataCnt));
        Integer idx = this.dataIdToIdxMap.get(dataId);
        if (idx == null) {
            this.dataIdList.add(dataId);
            idx = this.dataIdList.size() - 1;
            this.dataIdToIdxMap.put(dataId, idx);
        }
        mapNode.addData(memberId, idx);
    }

    public long getCardinality() {
        long cnt = 0L;
        for (MapNode value : this.dimensionMap.values()) {
            for (BitSet bitSet : value.getDimAndMemberMap().values()) {
                cnt += (long)bitSet.cardinality();
            }
        }
        return cnt;
    }

    public long getDataReportDataCnt() {
        return this.dataIdList.size();
    }

    public List<Long> listDimensionId() {
        return new ArrayList<Long>(this.dimensionMap.keySet());
    }

    public T find(DimensionInfoBean dimensionInfo) {
        BitSet bitSet = this.combine(dimensionInfo);
        if (bitSet == null) {
            return null;
        }
        int idx = bitSet.nextSetBit(0);
        if (idx != -1) {
            return this.dataIdList.get(idx);
        }
        return null;
    }

    public List<T> findList(DimensionInfoBean dimensionInfo) {
        BitSet bitSet = this.combine(dimensionInfo);
        int idx = 0;
        LinkedList<T> resultList = new LinkedList<T>();
        if (bitSet == null) {
            return resultList;
        }
        int i = bitSet.nextSetBit(idx);
        while (i >= 0) {
            T data = this.dataIdList.get(i);
            resultList.add(data);
            i = bitSet.nextSetBit(i + 1);
        }
        return resultList;
    }

    private BitSet combine(DimensionInfoBean dimensionInfo) {
        BitSet bitSet = new BitSet(this.dataCnt);
        for (int i = 0; i < dimensionInfo.getDimensionIdList().size(); ++i) {
            Long dimensionId = (Long)dimensionInfo.getDimensionIdList().get(i);
            Long memberId = Long.valueOf(dimensionInfo.getMemberIdList().get(i).toString());
            MapNode node = this.dimensionMap.get(dimensionId);
            if (node == null) {
                return null;
            }
            BitSet curBitSet = node.getDimAndMemberMap().get(memberId);
            if (curBitSet == null) {
                return null;
            }
            if (i == 0) {
                bitSet.or(curBitSet);
                continue;
            }
            bitSet.and(curBitSet);
        }
        return bitSet;
    }
}

