/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.index.generate;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.index.ReportDataIndexQueryMap;
import kd.tmc.fpm.business.domain.model.report.ReportData;
import kd.tmc.fpm.business.domain.model.template.TemplateDim;

public class DimensionIndexMapGenerator {
    public static ReportDataIndexQueryMap<Long> build(List<ReportData> reportDataList) {
        reportDataList = reportDataList.stream().filter(Objects::nonNull).filter(ReportData::isAuxiliaryInfo).collect(Collectors.toList());
        return DimensionIndexMapGenerator.buildQueryMap(reportDataList);
    }

    public static ReportDataIndexQueryMap<Long> buildQueryMap(List<ReportData> reportDataList) {
        ReportDataIndexQueryMap<Long> map = new ReportDataIndexQueryMap<Long>(reportDataList.size());
        for (ReportData reportData : reportDataList) {
            for (int i = 0; i < reportData.getDimList().size(); ++i) {
                TemplateDim dim = reportData.getDimList().get(i);
                Long dimensionId = dim.getDimensionId();
                if (dim.getDimType() == DimensionType.DETAILDIM) continue;
                Long memberId = (Long)reportData.getDimValList().get(i);
                map.addData(dimensionId, memberId, reportData.getId());
            }
        }
        return map;
    }
}

