/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.index.generate.bean;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.dimension.Dimension;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.index.generate.bean.MemberInfo;

public class DimensionInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long dimensionId;
    private DimensionType dimType;
    private List<MemberInfo> memberList;

    public DimensionInfo() {
    }

    public DimensionInfo(Dimension dimension) {
        this.dimensionId = dimension.getId();
        this.dimType = dimension.getDimType();
        this.memberList = new LinkedList<MemberInfo>();
        if (dimension.getMemberList() != null) {
            for (DimMember member : dimension.getMemberList()) {
                MemberInfo memberInfo = MemberInfo.buildMember(member, null);
                this.memberList.add(memberInfo);
            }
        }
    }

    public List<MemberInfo> getAllDimMemberList() {
        LinkedList<MemberInfo> allDimMemberList = new LinkedList<MemberInfo>();
        if (EmptyUtil.isEmpty(this.memberList)) {
            return allDimMemberList;
        }
        for (MemberInfo dimMember : this.memberList) {
            allDimMemberList.add(dimMember);
            allDimMemberList.addAll(dimMember.getAllChildMember());
        }
        return allDimMemberList;
    }

    public Long getDimensionId() {
        return this.dimensionId;
    }

    public void setDimensionId(Long dimensionId) {
        this.dimensionId = dimensionId;
    }

    public DimensionType getDimType() {
        return this.dimType;
    }

    public void setDimType(DimensionType dimType) {
        this.dimType = dimType;
    }

    public List<MemberInfo> getMemberList() {
        return this.memberList;
    }

    public void setMemberList(List<MemberInfo> memberList) {
        this.memberList = memberList;
    }
}

