/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.index.generate.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.enums.PeriodType;
import kd.tmc.fpm.business.domain.model.dimension.member.DimMember;
import kd.tmc.fpm.business.domain.model.dimension.member.PeriodMember;
import org.apache.commons.collections.CollectionUtils;

public class MemberInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long memberId;
    private String name;
    private MemberInfo parent;
    private Long dimensionId;
    private DimensionType dimensionType;
    private PeriodType periodType;
    private Long periodTypeId;
    private List<MemberInfo> children;

    public static MemberInfo buildMember(DimMember member) {
        return MemberInfo.buildMember(member, null);
    }

    public static MemberInfo buildMember(DimMember member, MemberInfo pMemberInfo) {
        MemberInfo memberInfo = new MemberInfo();
        memberInfo.setMemberId(member.getId());
        memberInfo.setName(member.getName());
        memberInfo.setDimensionId(member.getDimensionId());
        if (member instanceof PeriodMember) {
            memberInfo.setPeriodType(((PeriodMember)member).getPeriodType());
            memberInfo.setPeriodTypeId(((PeriodMember)member).getPeriodTypeId());
        }
        if (pMemberInfo != null) {
            memberInfo.setParent(pMemberInfo);
        }
        LinkedList<MemberInfo> children = new LinkedList<MemberInfo>();
        memberInfo.setChildren(children);
        if (CollectionUtils.isNotEmpty(member.getChildren())) {
            for (DimMember childMember : member.getChildren()) {
                MemberInfo child = MemberInfo.buildMember(childMember, memberInfo);
                children.add(child);
            }
        }
        return memberInfo;
    }

    public List<MemberInfo> getAllChildMember() {
        ArrayList<MemberInfo> allMemberList = new ArrayList<MemberInfo>();
        this.getChildMember(this, allMemberList);
        return allMemberList;
    }

    private void getChildMember(MemberInfo member, List<MemberInfo> outMemberList) {
        if (member != this) {
            outMemberList.add(member);
        }
        if (member.getChildren() == null) {
            return;
        }
        for (MemberInfo child : member.getChildren()) {
            this.getChildMember(child, outMemberList);
        }
    }

    public Long getMemberId() {
        return this.memberId;
    }

    public void setMemberId(Long memberId) {
        this.memberId = memberId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PeriodType getPeriodType() {
        return this.periodType;
    }

    public void setPeriodType(PeriodType periodType) {
        this.periodType = periodType;
    }

    public Long getPeriodTypeId() {
        return this.periodTypeId;
    }

    public void setPeriodTypeId(Long periodTypeId) {
        this.periodTypeId = periodTypeId;
    }

    public MemberInfo getParent() {
        return this.parent;
    }

    public void setParent(MemberInfo parent) {
        this.parent = parent;
    }

    public List<MemberInfo> getChildren() {
        return this.children;
    }

    public void setChildren(List<MemberInfo> children) {
        this.children = children;
    }

    public DimensionType getDimensionType() {
        return this.dimensionType;
    }

    public void setDimensionType(DimensionType dimensionType) {
        this.dimensionType = dimensionType;
    }

    public Long getDimensionId() {
        return this.dimensionId;
    }

    public void setDimensionId(Long dimensionId) {
        this.dimensionId = dimensionId;
    }

    public MemberInfo copy() {
        MemberInfo memberInfo = new MemberInfo();
        memberInfo.setMemberId(this.memberId);
        memberInfo.setChildren(Collections.emptyList());
        memberInfo.setPeriodType(this.periodType);
        memberInfo.setName(this.name);
        memberInfo.setPeriodTypeId(this.periodTypeId);
        memberInfo.setDimensionId(this.dimensionId);
        memberInfo.setDimensionType(this.dimensionType);
        return memberInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemberInfo that = (MemberInfo)o;
        return Objects.equals(this.memberId, that.memberId);
    }

    public int hashCode() {
        return Objects.hash(this.memberId);
    }
}

