/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.fpm.business.domain.model.index.generate.strategy;

import java.util.LinkedList;
import java.util.List;
import kd.tmc.fpm.business.domain.enums.DimensionType;
import kd.tmc.fpm.business.domain.model.index.generate.bean.DimensionInfo;
import kd.tmc.fpm.business.domain.model.index.generate.bean.MemberInfo;
import kd.tmc.fpm.business.domain.model.index.generate.strategy.AbstractTreeStrategy;

public class AggregateIndexTreeGenerateStrategy
extends AbstractTreeStrategy {
    private List<DimensionInfo> dimensionInfos;

    public AggregateIndexTreeGenerateStrategy(List<DimensionInfo> dimensionInfos) {
        super(null);
        this.dimensionInfos = dimensionInfos;
    }

    @Override
    public List<List<DimensionInfo>> getDimensionGroupList() {
        LinkedList<List<DimensionInfo>> groupList = new LinkedList<List<DimensionInfo>>();
        groupList.add(this.dimensionInfos);
        return groupList;
    }

    @Override
    public List<MemberInfo> getDimMemberList(DimensionInfo dimension) {
        List<MemberInfo> memberList = dimension.getMemberList();
        memberList.forEach(item -> item.setDimensionType(dimension.getDimType()));
        return memberList;
    }

    @Override
    public boolean buildSummaryReference() {
        return true;
    }

    @Override
    public boolean isSummaryNode(MemberInfo memberInfo) {
        DimensionType dimensionType = memberInfo.getDimensionType();
        return DimensionType.ORG == dimensionType || DimensionType.PERIOD == dimensionType || DimensionType.SUBJECTS == dimensionType;
    }
}

